/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.unilab.Configuracao;
import jalis.laboratorio.util.parsers.unilab.ExameUnilab;
import jalis.laboratorio.util.parsers.unilab.FaixaEtaria;
import jalis.laboratorio.util.parsers.unilab.Limite;
import jalis.laboratorio.util.parsers.unilab.LinhaResultado;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceImportacaoUnilab {
    public static final String FORMATO = "formato";
    public static final String FORMATACAO = "formatacao";
    public static final String CODIGO_LAYOUT = "codigo-layout";
    public static final String CABECALHO = "cabecalho";
    public static final String FORMATO_TEXTO = "formatotexto";
    public static final String VERSAO = "20060809";
    public static final String LISTA_EXAME_PROCEDIMENTOS = "ListaExameProcedimentos";
    public static final String LISTA_RESULTADOS_PROCEDIMENTOS = "ListaResultadoProcedimentos";
    public static final String TAG_REQUISICOES = "requisicoes";
    public static final String TAG_LISTA_EXAMES = "listaexames";
    public static final String TAG_VERSAO = "versao";
    public static final String TAG_EMISSOR = "emissor";
    public static final String TAG_DATA_GERACAO_ARQUIVO = "datageracaoarquivo";
    public static final String TAG_VIGENCIA_GLOBAL = "vigenciaglobal";
    public static final String TAG_EXAMES = "exames";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_MNEMONICO = "mnemonico";
    public static final String TAG_NOME = "nome";
    public static final String TAG_SEXO = "sexo";
    public static final String TAG_METODO = "metodo";
    public static final String TAG_CODIGO_MTBI = "codigomtbi";
    public static final String TAG_NOME_MTBI = "nomemtbi";
    public static final String TAG_ALTERA_MTBI = "alteramtbi";
    public static final String TAG_VIGENCIA = "vigencia";
    public static final String TAG_PRAZO = "prazo";
    public static final String TAG_AGRUPAMENTO_AMOSTRA = "agrupamentoamostra";
    public static final String TAG_VOLUME_RECOMENDAVEL = "volumerecomendavel";
    public static final String TAG_CONSERVACAO = "conservacao";
    public static final String TAG_TEMPO_JEJUM = "tempodejejum";
    public static final String TAG_INSTRUCOES_PACIENTE = "instrucoespaciente";
    public static final String TAG_INSTRUCOES_SITE = "instrucoessite";
    public static final String TAG_INSTRUCOES_COLETA = "instrucoescoleta";
    public static final String TAG_INSTRUCOES_TRANSPORTE = "instrucoestransporte";
    public static final String TAG_POR_SEXO = "porsexo";
    public static final String TAG_POR_FAIXA_ETARIA = "porfaixaetaria";
    public static final String TAG_AMOSTRA_ADICIONAL = "amostraadicional";
    public static final String TAG_CONFIGURACOES = "configuracoes";
    public static final String TAG_CONFIGURACAO = "configuracao";
    public static final String TAG_DESCRICAO = "descricao";
    public static final String TAG_SEXO_CONF = "sexoconf";
    public static final String TAG_FAIXA_ETARIA = "faixaetaria";
    public static final String TAG_DIAS_INICIO = "diasinicio";
    public static final String TAG_DIAS_FIM = "diasfim";
    public static final String TAG_BLOB = "blob";
    public static final String TAG_LINHAS_DE_RESULTADO = "linhasderesultado";
    public static final String TAG_LINHA_DE_RESULTADO = "linhaderesultado";
    public static final String TAG_RESULTADO = "resultado";
    public static final String TAG_RESULTADOS = "resultados";
    public static final String TAG_VARIAVEL = "variavel";
    public static final String TAG_IMPRESSO = "impresso";
    public static final String TAG_UNIDADE = "unidade";
    public static final String TAG_VALOR_DE_REFERENCIA = "valordereferencia";
    public static final String TAG_TIPO = "tipo";
    public static final String TAG_VALOR_RESULTADO = "valorresultado";
    public static final String TAG_OBRIGATORIO = "obrigatorio";
    public static final String TAG_LIMITES = "limites";
    public static final String TAG_INTEIROS = "inteiros";
    public static final String TAG_DECIMAIS = "decimais";
    public static final String TAG_SUPERIOR = "superior";
    public static final String TAG_INFERIOR = "inferior";
    public static final String TAG_MINIMO = "minimo";
    public static final String TAG_CODIGO_APOIADO = "codigoApoiado";
    public static final String TAG_CODIGO_APOIO = "codigoApoio";
    public static final String TAG_CODIGO = "codigo";
    public static final String EXAMES_EXCLUIDOS = "examesExcluidos";
    public static final String EXAMES_NAO_ENCONTRADOS = "naoEncontrados";
    public static final String TAG_CONVENIO = "convenio";
    public static final String TAG_POSTO_COLETA = "postoColeta";
    public static final String TAG_NUMERO_LOTE = "numerolote";
    public static final String TAG_LOTE_ENVIO = "loteenvio";
    public static final String TAG_DATA_GERACAO_LOTE = "datageracaolote";
    public static final String TAG_NOME_ARQUIVO = "nomearquivo";
    public static final String TAG_PEDIDOS = "pedidos";
    public static final String TAG_PEDIDO = "pedido";
    public static final String TAG_COD_PED_LAB = "codigo";
    public static final String TAG_LIVRE_APOIADO = "livreApoiado";
    public static final String TAG_PACIENTE = "paciente";
    public static final String TAG_COD_PAC_LAB = "codigo";
    public static final String TAG_IDADE = "idade";
    public static final String TAG_DATA_NASC = "dtnasc";
    public static final String TAG_HORA_COLETA = "HoraColeta";
    public static final String TAG_DATA_COLETA = "DataColeta";
    public static final String TAG_CONSERVANTE = "Conservante";
    public static final String TAG_DESC_MAT = "DescMat";
    public static final String TAG_COD_EXM_APOIO = "CodExmApoio";
    public static final String TAG_COD_EXM_LAB = "CodExmLab";
    public static final String TAG_ID_APOIADO = "idapoiado";
    public static final String TAG_DATA_LIBERACAO = "dataliberacao";
    public static final String TAG_NOME_MATERIAL_BIOLOGICO = "nomematerialbiologico";
    public static final String TAG_URGENTE = "urgente";
    public static final String TAG_DATA_HORA_COLETA = "datahoracoleta";
    public static final String TAG_NUMERO_AMOSTRA = "numeroamostra";
    public static final String TAG_LACTANTE = "lactante";
    public static final String TAG_HISTERECTOMIZADA = "histerectomizada";
    public static final String TAG_ALTURA = "altura";
    public static final String TAG_PESO = "peso";
    public static final String TAG_OBS_TECNICA = "obstecnica";
    public static final String TAG_OBSERVACAO = "observacao";
    public static final String TAG_CODIGO_MEDICO = "codigo";
    public static final String TAG_NOME_MEDICO = "nome";
    public static final String TAG_CONSELHO_MEDICO = "conselho";
    public static final String TAG_NUMERO_CONSELHO_MEDICO = "numeronoconselho";
    public static final String TAG_SEXO_MEDICO = "sexo";
    public static final String TAG_MEDICO = "medico";
    public static final String TAG_DUM = "dum";
    public final String FIL_CODIGO = "fil_codigo";
    public final String REQ_CODIGO = "req_codigo";
    public final String REC_KODIGO = "rec_kodigo";
    public final String REQ_DATA = "req_data";
    public final String REQ_IDADE = "req_idade";
    public final String REQ_DUM = "req_dum";
    public final String REQ_PESO = "req_peso";
    public final String REQ_ALTURA = "req_altura";
    public final String REQ_OBSERVACAO = "req_obs";
    public final String PAC_CODIGO = "pac_codigo";
    public final String PAC_DATANASC = "pac_datanasc";
    public final String PAC_SEXO = "pac_sexo";
    public final String PAC_NOME = "pac_nome";
    public final String CODIGO_MATERIAL = "codigoMaterial";
    public final String CODIGO_EXAME = "codigoExame";
    public final String EXA_CODIGO = "exa_codigo";
    public final String EXA_DESCRICAO = "exa_descricao";
    public final String EXR_DATAMATERIAL = "exr_datamaterial";
    public final String MCO_CODIGO = "mco_codigo";
    public final String MED_CODIGO = "med_codigo";
    public final String MED_NOME = "med_nome";
    public final String MED_CRM = "med_crm";
    public final String MED_CONSELHO = "med_conselho";
    public final String MED_UF = "med_uf";
    public final String MED_SEXO = "sexo";

    public Set<ExameUnilab> importarExamesUnilab(File file, int codigoLabExterno, JProgressBar progress, String filialPadrao) throws Exception {
        String xmlExames = StringUtil.lerArquivoTexto(file.getPath());
        Set<ExameUnilab> exaNovos = this.parseFile(file);
        Set<ExameUnilab> exaVelhos = this.getExamesRelacionados(codigoLabExterno, filialPadrao);
        Statement st = Conexao.getStatement();
        if (st != null && exaNovos.size() > 0 && progress != null) {
            progress.setMaximum(exaNovos.size());
            progress.setValue(0);
        }
        ServiceImportacaoUnilab.inserirExamesUnilab(filialPadrao, exaNovos, st, codigoLabExterno, progress);
        Conexao.arquivaSQL();
        exaVelhos.removeAll(exaNovos);
        return exaNovos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document importarXML(File xml) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(xml);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private Set<ExameUnilab> parseFile(File xml) {
        Document doc;
        HashSet<ExameUnilab> mapExames = new HashSet<ExameUnilab>();
        if (xml.getName().toLowerCase().endsWith("xml") && (doc = this.importarXML(xml)) != null) {
            Element raiz = doc.getDocumentElement();
            if (!raiz.getNodeName().equalsIgnoreCase(TAG_LISTA_EXAMES)) {
                return mapExames;
            }
            if (raiz.getNodeName().equalsIgnoreCase(TAG_LISTA_EXAMES)) {
                List<Element> filhos = XMLUtil.getElementosFilhos(raiz);
                for (Element e : filhos) {
                    if (e.getNodeName().equalsIgnoreCase(TAG_VERSAO) || e.getNodeName().equalsIgnoreCase(TAG_EMISSOR) || e.getNodeName().equalsIgnoreCase(TAG_DATA_GERACAO_ARQUIVO) || e.getNodeName().equalsIgnoreCase(TAG_VIGENCIA_GLOBAL) || !e.getNodeName().equalsIgnoreCase(TAG_EXAMES)) continue;
                    List<Element> exames = XMLUtil.getElementosFilhos(e);
                    for (Element exame : exames) {
                        if (!exame.getNodeName().equalsIgnoreCase(TAG_EXAME)) continue;
                        List<Element> campos = XMLUtil.getElementosFilhos(exame);
                        ExameUnilab exameUnilab = this.parseExameUnilab(campos);
                        mapExames.add(exameUnilab);
                    }
                }
            }
        }
        return mapExames;
    }

    private static Map<String, ExameUnilab> exameMap(Set<ExameUnilab> exaNovos) {
        HashMap<String, ExameUnilab> listaExames = new HashMap<String, ExameUnilab>();
        for (ExameUnilab e : exaNovos) {
            listaExames.put(e.getMnemonico() + e.getNomemtbi(), e);
        }
        return listaExames;
    }

    private static void inserirExamesUnilab(String filial, Set<ExameUnilab> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws Exception {
        for (ExameUnilab exameUnilab : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = exameUnilab.getMnemonico();
            Object object = objectArray[1] = !Funcoes.textoVazio(exameUnilab.getCodigoMtbi()) ? exameUnilab.getCodigoMtbi() : "";
            if (IntegracaoLabExternoUtil.existeExame(st, filial, codigoLabExterno, 10, objectArray)) {
                IntegracaoLabExternoUtil.updateExame(st, filial, codigoLabExterno, 10, exameUnilab.getMnemonico(), !Funcoes.textoVazio(exameUnilab.getCodigoMtbi()) ? exameUnilab.getCodigoMtbi() : "", exameUnilab.getNome(), exameUnilab.getXml(), exameUnilab.getNomemtbi());
                continue;
            }
            IntegracaoLabExternoUtil.insertExame(st, filial, codigoLabExterno, 10, exameUnilab.getMnemonico(), !Funcoes.textoVazio(exameUnilab.getCodigoMtbi()) ? exameUnilab.getCodigoMtbi() : "", exameUnilab.getNome(), exameUnilab.getXml(), exameUnilab.getNomemtbi());
        }
    }

    public ExameUnilab parseExameUnilab(List<Element> campos) {
        ExameUnilab exameUnilab = new ExameUnilab();
        for (Element campo : campos) {
            boolean isCData = false;
            if (campo.hasAttribute("cData") && campo.getAttribute("cData").equalsIgnoreCase("sim")) {
                campo.setTextContent(StringUtil.preencheCData(campo.getTextContent(), true));
                isCData = true;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_MNEMONICO)) {
                exameUnilab.setMnemonico(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase("nome")) {
                exameUnilab.setNome(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase("sexo")) {
                exameUnilab.setSexo(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_METODO)) {
                exameUnilab.setMetodo(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_CODIGO_MTBI)) {
                exameUnilab.setCodigoMtbi(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_NOME_MTBI)) {
                exameUnilab.setNomemtbi(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_ALTERA_MTBI)) {
                exameUnilab.setAlteramtbi(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_VIGENCIA)) {
                exameUnilab.setVigencia(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_PRAZO)) {
                if (!Funcoes.isNumeric(campo.getTextContent())) continue;
                exameUnilab.setPrazo(Integer.parseInt(campo.getTextContent()));
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_AGRUPAMENTO_AMOSTRA)) {
                exameUnilab.setAgrupamentoAmostra(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_VOLUME_RECOMENDAVEL)) {
                exameUnilab.setVolumeRecomendavel(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_CONSERVACAO)) {
                exameUnilab.setConservacao(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_TEMPO_JEJUM)) {
                exameUnilab.setTempoDeJejum(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_INSTRUCOES_PACIENTE)) {
                exameUnilab.setInstrucoesPaciente(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_INSTRUCOES_SITE)) {
                exameUnilab.setInstrucoesSite(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_INSTRUCOES_COLETA)) {
                exameUnilab.setInstrucoesColeta(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_INSTRUCOES_TRANSPORTE)) {
                exameUnilab.setInstrucoesTransporte(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_POR_SEXO)) {
                exameUnilab.setPorSexo(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_POR_FAIXA_ETARIA)) {
                exameUnilab.setPorFaixaEtaria(campo.getTextContent(), isCData);
                continue;
            }
            if (campo.getNodeName().equalsIgnoreCase(TAG_AMOSTRA_ADICIONAL)) {
                exameUnilab.setAmostraAdicional(this.parseAmostraAdicional(campo), isCData);
                continue;
            }
            if (!campo.getNodeName().equalsIgnoreCase(TAG_CONFIGURACOES)) continue;
            exameUnilab.setConfiguracoes(this.parseConfiguracoes(campo));
        }
        return exameUnilab;
    }

    private List<Configuracao> parseConfiguracoes(Element campo) {
        ArrayList<Configuracao> configuracoes = new ArrayList<Configuracao>();
        List<Element> filhos = XMLUtil.getElementosFilhos(campo);
        for (Element e : filhos) {
            Configuracao configuracao = new Configuracao();
            if (e.getNodeName().equalsIgnoreCase(TAG_CONFIGURACAO)) {
                List<Element> conf = XMLUtil.getElementosFilhos(e);
                for (Element tag : conf) {
                    if (tag.hasAttribute("cData") && tag.getAttribute("cData").equalsIgnoreCase("sim") && !Funcoes.textoVazio(tag.getTextContent().trim())) {
                        tag.setTextContent(StringUtil.preencheCData(tag.getTextContent(), true));
                    }
                    if (tag.getNodeName().equalsIgnoreCase(TAG_DESCRICAO)) {
                        configuracao.setDescricao(tag.getTextContent());
                        continue;
                    }
                    if (tag.getNodeName().equalsIgnoreCase(TAG_SEXO_CONF)) {
                        configuracao.setSexoConf(tag.getTextContent());
                        continue;
                    }
                    if (tag.getNodeName().equalsIgnoreCase(TAG_FAIXA_ETARIA)) {
                        configuracao.setFaixaEtaria(this.parseFaixaEtaria(tag));
                        continue;
                    }
                    if (!tag.getNodeName().equalsIgnoreCase(TAG_LINHAS_DE_RESULTADO)) continue;
                    configuracao.setLinhasDeResultado(this.parseLinhasResultado(tag));
                }
            }
            configuracoes.add(configuracao);
        }
        return configuracoes;
    }

    public String getUnidadeMedidaVariavel(String variavel) {
        return String.format("%s_%s", variavel, TAG_UNIDADE.toUpperCase());
    }

    private Set<ExameUnilab> getExames(String xmlTabela, int codigoLabExterno) {
        HashSet<ExameUnilab> exames = new HashSet<ExameUnilab>();
        String tabela = StringUtil.getValor(xmlTabela, TAG_LISTA_EXAMES);
        if (!Funcoes.textoVazio(tabela)) {
            for (String exame : StringUtil.getValores(xmlTabela, TAG_EXAME)) {
                ExameUnilab exameUnilab = new ExameUnilab(exame);
                exames.add(exameUnilab);
            }
        }
        return exames;
    }

    private Set<ExameUnilab> getExamesRelacionados(int codigoLabExterno, String filialPadrao) throws SQLException {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder bui = new StringBuilder("select \n");
            bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
            bui.append("from examematcoletalabexterno a \n");
            bui.append("left join labexterno b \n");
            bui.append("  on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
            bui.append("where \n");
            bui.append("  b.fil_codigo = ").append(filialPadrao).append(" and \n");
            bui.append("  b.lae_codigo = ").append(codigoLabExterno);
            bui.append("  and a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
            return ExameUnilab.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
        }
        return new HashSet<ExameUnilab>();
    }

    private List<LinhaResultado> parseLinhasResultado(Element linhas) {
        ArrayList<LinhaResultado> linhasResultado = new ArrayList<LinhaResultado>();
        List<Element> filhos = XMLUtil.getElementosFilhos(linhas);
        for (Element e : filhos) {
            LinhaResultado linha = null;
            if (e.getNodeName().equalsIgnoreCase(TAG_LINHA_DE_RESULTADO)) {
                linha = this.getLinhaResultado(e);
            }
            linhasResultado.add(linha);
        }
        return linhasResultado;
    }

    private LinhaResultado getLinhaResultado(Element e) {
        List<Element> conf = XMLUtil.getElementosFilhos(e);
        LinhaResultado linha = new LinhaResultado();
        for (Element tag : conf) {
            if (tag.getNodeName().equalsIgnoreCase(TAG_VARIAVEL)) {
                linha.setVariavel(tag.getTextContent());
                continue;
            }
            if (tag.getNodeName().equalsIgnoreCase(TAG_DESCRICAO)) {
                linha.setDescricao(tag.getTextContent());
                continue;
            }
            if (tag.getNodeName().equalsIgnoreCase(TAG_UNIDADE)) {
                linha.setUnidade(tag.getTextContent());
                continue;
            }
            if (tag.getNodeName().equalsIgnoreCase(TAG_VALOR_DE_REFERENCIA)) {
                linha.setValorReferencia(tag.getTextContent());
                continue;
            }
            if (tag.getNodeName().equalsIgnoreCase(TAG_OBRIGATORIO)) {
                linha.setObrigatorio(tag.getTextContent());
                continue;
            }
            if (tag.getNodeName().equalsIgnoreCase(TAG_TIPO)) {
                linha.setTipo(tag.getTextContent());
                continue;
            }
            if (tag.getNodeName().equalsIgnoreCase(TAG_LIMITES)) {
                linha.setLimites(this.parseLimites(tag));
                continue;
            }
            if (!tag.getNodeName().equalsIgnoreCase(TAG_VALOR_RESULTADO)) continue;
            linha.setLimites(this.parseLimites(tag));
        }
        return linha;
    }

    private List<Limite> parseLimites(Element tag) {
        return null;
    }

    private FaixaEtaria parseFaixaEtaria(Element tag) {
        List<Element> filhos = XMLUtil.getElementosFilhos(tag);
        FaixaEtaria fe = new FaixaEtaria();
        for (Element e : filhos) {
            if (e.hasAttribute("cData") && e.getAttribute("cData").equalsIgnoreCase("sim") && !Funcoes.textoVazio(e.getTextContent().trim())) {
                e.setTextContent(StringUtil.preencheCData(e.getTextContent(), true));
            }
            if (e.getNodeName().equalsIgnoreCase(TAG_DIAS_INICIO)) {
                fe.setDiasInicio(Integer.parseInt(e.getTextContent()));
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase(TAG_DIAS_FIM)) continue;
            fe.setDiasFim(Integer.parseInt(e.getTextContent()));
        }
        return fe;
    }

    private List<ExameUnilab> parseAmostraAdicional(Element campo) {
        ArrayList<ExameUnilab> amostraAdicionais = new ArrayList<ExameUnilab>();
        List<Element> filhos = XMLUtil.getElementosFilhos(campo);
        for (Element e : filhos) {
            if (!e.getNodeName().equalsIgnoreCase(TAG_EXAME)) continue;
            List<Element> exame = XMLUtil.getElementosFilhos(e);
            amostraAdicionais.add(this.parseExameUnilab(exame));
        }
        return amostraAdicionais;
    }

    private static String montarXMLCamposResultados(String unilabXML) {
        int beginIndex = unilabXML.indexOf("<linhasderesultado>");
        int endIndex = unilabXML.indexOf("</linhasderesultado>") + "</linhasderesultado>".length();
        StringBuilder bui = new StringBuilder(StringUtil.textoDB(unilabXML.substring(beginIndex, endIndex)));
        bui.append('\n');
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            ServiceImportacaoUnilab.carregarXMLBuilder(xml);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "N\u00e3o foi possivel importar linhas de resultado", e.getStackTrace(), "ParserImportacaoUnilab: 220");
        }
        bui.append(StringUtil.textoDB(xml.getXML()));
        return bui.toString();
    }

    protected static void carregarXMLBuilder(XMLStringBuilder xml) throws XMLStringBuilderException {
        String valor = xml.getXML();
        valor = "<![CDATA[" + valor + "]]>";
        xml.escrever(valor);
    }

    public String pegaSexoMedico(String filial, String crm, String uf, String conselho) throws SQLException {
        String[] medicas = new String[]{"Dra.", "Sra.", "Profa. Dra.", "Enfa."};
        String sexo = "M";
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            String abrev;
            StringBuilder bui = new StringBuilder("select med_abrev ");
            bui.append(" from medico \n");
            bui.append(" where \n");
            bui.append("  fil_codigo = ").append(filial).append(" and \n");
            bui.append("  med_crm = '").append(crm).append("' and \n");
            bui.append("  med_uf = '").append(uf).append("' and \n");
            bui.append("  med_conselho = '").append(conselho).append("'");
            ResultSet rs = Conexao.executeQuery(st, SQL + bui.toString());
            if (rs.next() && !Funcoes.textoVazio(abrev = rs.getString("med_abrev")) && ArraysUtil.contem(medicas, abrev.trim())) {
                sexo = "F";
            }
        }
        return sexo;
    }
}

