/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.unilab.ExameUnilab;
import jalis.laboratorio.util.parsers.unilab.ServiceImportacaoUnilab;
import jalis.service.cadastro.exame.LabExternoService;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.util.Set;
import javax.swing.JFileChooser;

public class ImportacaoUnilab
extends AbstractImportadorLabExterno {
    public ImportacaoUnilab(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Unilab a partir de arquivo xml", codigoLabExterno, Protocolo.Unilab);
        this.getButtonImportar().setText("Importar Exames");
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        LabExternoService les = new LabExternoService();
        try {
            String conf = les.xmlConfigEtiquetaHpDirect(Variaveis.filialPadrao, String.valueOf(this.codigoLabExterno));
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Unilab (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                bui.append("Importando exames...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                ServiceImportacaoUnilab siUnilab = new ServiceImportacaoUnilab();
                Set<ExameUnilab> excluidos = siUnilab.importarExamesUnilab(file, this.codigoLabExterno, this.progress, Variaveis.filialPadrao);
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (excluidos != null && excluidos.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram inseridos/atualizados: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (ExameUnilab e : excluidos) {
                        bui.append("\n\t|").append(StringUtil.formatarColuna(e.getMnemonico(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(StringUtil.limpaCdata(e.getNome()), 50, 'c')).append("|");
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                retorno = true;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoAlvaro: 71");
        }
        this.progress.setVisible(false);
        return retorno;
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }
}

