/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.unilab.Configuracao;
import jalis.laboratorio.util.parsers.unilab.LinhaResultado;
import jalis.laboratorio.util.parsers.unilab.ServiceImportacaoUnilab;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExameUnilab {
    private String mnemonico;
    private String codExaJalis = "";
    private String codMatJalis = "";
    public String codLabExterno = "";
    private String nome;
    private String materialDescricao;
    private String exameJalis;
    private String materialJalis;
    private String laboratorioExternoJalis;
    private String xmlJalis;
    private String valorReferencia;
    private String sexo;
    private String metodo;
    private String codigoMtbi = "";
    private String nomemtbi;
    private String alteramtbi;
    private String vigencia;
    private Integer prazo;
    private String agrupamentoAmostra;
    private String volumeRecomendavel;
    private String numeroAmostra;
    private String dataLiberacao;
    private String conservacao;
    private String tempoDeJejum;
    private String instrucoesPaciente;
    private String instrucoesSite;
    private String instrucoesColeta;
    private String instrucoesTransporte;
    private String porSexo;
    private String porFaixaEtaria;
    private List<ExameUnilab> amostraAdicional = new ArrayList<ExameUnilab>();
    private List<Configuracao> configuracoes = new ArrayList<Configuracao>();
    private String requisicao;
    private List<String> listaDesmembrados = new ArrayList<String>();
    private Registro registro;
    private Map<String, Boolean> camposCData = new HashMap<String, Boolean>();

    public ExameUnilab(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.codExaJalis = res.getString("exa_codigo");
        this.codMatJalis = res.getString("mco_codigo");
        this.codLabExterno = res.getString("lae_codigo");
        this.carregarXMLExame(res.getString("ele_xmllabexterno"));
    }

    public String getSexo() {
        return this.sexo;
    }

    public void setSexo(String sexo, boolean isCData) {
        this.camposCData.put("sexo", isCData);
        this.sexo = sexo;
    }

    public String getMetodo() {
        return this.metodo;
    }

    public void setMetodo(String metodo, boolean isCData) {
        this.camposCData.put("metodo", isCData);
        this.removerCData(metodo, isCData);
        this.metodo = metodo;
    }

    public String getCodigoMtbi() {
        return this.codigoMtbi;
    }

    public void setCodigoMtbi(String codigoMtbi, boolean isCData) {
        this.camposCData.put("codigomtbi", isCData);
        this.removerCData(codigoMtbi, isCData);
        this.codigoMtbi = codigoMtbi;
    }

    public String getNomemtbi() {
        return this.nomemtbi;
    }

    public void setNomemtbi(String nomemtbi, boolean isCData) {
        this.camposCData.put("nomemtbi", isCData);
        this.nomemtbi = this.removerCData(nomemtbi, isCData);
    }

    public String getAlteramtbi() {
        return this.alteramtbi;
    }

    public void setAlteramtbi(String alteramtbi, boolean isCData) {
        this.camposCData.put("alteramtbi", isCData);
        this.alteramtbi = this.removerCData(alteramtbi, isCData);
    }

    public String getVigencia() {
        return this.vigencia;
    }

    public void setVigencia(String vigencia, boolean isCData) {
        this.camposCData.put("vigencia", isCData);
        this.vigencia = this.removerCData(vigencia, isCData);
    }

    public Integer getPrazo() {
        return this.prazo;
    }

    public void setPrazo(Integer prazo) {
        this.prazo = prazo;
    }

    public String getAgrupamentoAmostra() {
        return this.agrupamentoAmostra;
    }

    public void setAgrupamentoAmostra(String agrupamentoAmostra, boolean isCData) {
        this.camposCData.put("agrupamentoamostra", isCData);
        this.agrupamentoAmostra = this.removerCData(agrupamentoAmostra, isCData);
    }

    public String getVolumeRecomendavel() {
        return this.volumeRecomendavel;
    }

    public void setVolumeRecomendavel(String volumeRecomendavel, boolean isCData) {
        this.camposCData.put("volumerecomendavel", isCData);
        this.volumeRecomendavel = this.removerCData(volumeRecomendavel, isCData);
    }

    public String getConservacao() {
        return this.conservacao;
    }

    public void setConservacao(String conservacao, boolean isCData) {
        this.camposCData.put("conservacao", isCData);
        this.conservacao = this.removerCData(conservacao, isCData);
    }

    public String getTempoDeJejum() {
        return this.tempoDeJejum;
    }

    public void setTempoDeJejum(String tempoDeJejum, boolean isCData) {
        this.camposCData.put("tempodejejum", isCData);
        this.tempoDeJejum = this.removerCData(tempoDeJejum, isCData);
    }

    public String getInstrucoesPaciente() {
        return this.instrucoesPaciente;
    }

    public void setInstrucoesPaciente(String instrucoesPaciente, boolean isCData) {
        this.camposCData.put("instrucoespaciente", isCData);
        this.instrucoesPaciente = this.removerCData(instrucoesPaciente, isCData);
    }

    public String getInstrucoesSite() {
        return this.instrucoesSite;
    }

    public void setInstrucoesSite(String instrucoesSite, boolean isCData) {
        this.camposCData.put("instrucoessite", isCData);
        this.instrucoesSite = this.removerCData(instrucoesSite, isCData);
    }

    public String getInstrucoesColeta() {
        return this.instrucoesColeta;
    }

    public void setInstrucoesColeta(String instrucoesColeta, boolean isCData) {
        this.camposCData.put("instrucoescoleta", isCData);
        this.instrucoesColeta = this.removerCData(instrucoesColeta, isCData);
    }

    public String getInstrucoesTransporte() {
        return this.instrucoesTransporte;
    }

    public void setInstrucoesTransporte(String instrucoesTransporte, boolean isCData) {
        this.camposCData.put("instrucoestransporte", isCData);
        this.instrucoesTransporte = this.removerCData(instrucoesTransporte, isCData);
    }

    public String getPorSexo() {
        return this.porSexo;
    }

    public void setPorSexo(String porSexo, boolean isCData) {
        this.camposCData.put("porsexo", isCData);
        this.porSexo = this.removerCData(porSexo, isCData);
    }

    public String getPorFaixaEtaria() {
        return this.porFaixaEtaria;
    }

    public void setPorFaixaEtaria(String porFaixaEtaria, boolean isCData) {
        this.camposCData.put("porfaixaetaria", isCData);
        this.porFaixaEtaria = this.removerCData(porFaixaEtaria, isCData);
    }

    public List<ExameUnilab> getAmostraAdicional() {
        return this.amostraAdicional;
    }

    public void setAmostraAdicional(List<ExameUnilab> amostraAdicional, boolean isCData) {
        this.camposCData.put("amostraadicional", isCData);
        this.amostraAdicional = amostraAdicional;
    }

    public List<Configuracao> getConfiguracoes() {
        return this.configuracoes;
    }

    public void setConfiguracoes(List<Configuracao> configuracoes) {
        this.configuracoes = configuracoes;
    }

    public String getRequisicao() {
        return this.requisicao;
    }

    public void setRequisicao(String requisicao) {
        this.requisicao = requisicao;
    }

    public String getMnemonico() {
        return this.mnemonico;
    }

    public void setNome(String nome, boolean isCData) {
        this.camposCData.put("nome", isCData);
        this.nome = this.removerCData(nome, isCData);
    }

    public ExameUnilab() {
    }

    public ExameUnilab(String xml) {
        this.carregarXMLExame(xml);
    }

    public String getCodigo() {
        return this.mnemonico;
    }

    public void setMnemonico(String mnemonico, boolean isCData) {
        this.camposCData.put("mnemonico", isCData);
        this.mnemonico = this.removerCData(mnemonico, isCData);
    }

    public String getNome() {
        return this.nome;
    }

    public void setv(String nome) {
        this.nome = nome;
    }

    public String getMaterialDescricao() {
        return this.materialDescricao;
    }

    public void setMaterialDescricao(String materialDescricao) {
        this.materialDescricao = materialDescricao;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public String getLaboratorioExternoJalis() {
        return this.laboratorioExternoJalis;
    }

    public void setLaboratorioExternoJalis(String laboratorioExternoJalis) {
        this.laboratorioExternoJalis = laboratorioExternoJalis;
    }

    public String getXmlJalis() {
        return this.xmlJalis;
    }

    public void setXmlJalis(String xmlJalis) {
        this.xmlJalis = xmlJalis;
    }

    public String getValorReferencia() {
        return this.valorReferencia;
    }

    public void setValorReferencia(String valorReferencia) {
        this.valorReferencia = valorReferencia;
    }

    public List<String> getListaDesmembrados() {
        return this.listaDesmembrados;
    }

    public void setListaDesmembrados(List<String> listaDesmembrados) {
        this.listaDesmembrados = listaDesmembrados;
    }

    public String getNumeroAmostra() {
        return this.numeroAmostra;
    }

    public void setNumeroAmostra(String numeroAmostra) {
        this.numeroAmostra = numeroAmostra;
    }

    public String getDataLiberacao() {
        return this.dataLiberacao;
    }

    public void setDataLiberacao(String dataLiberacao) {
        this.dataLiberacao = dataLiberacao;
    }

    public Registro getRegistro() {
        return this.registro;
    }

    public void setRegistro(Registro registro) {
        this.registro = registro;
    }

    public static Set<ExameUnilab> getExames(Integer filial, Integer codigoLaboratorio) throws SQLException {
        StringBuilder bui = new StringBuilder("select ");
        bui.append(" unl_xml from examesunilab ");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and lae_codigo = ").append(codigoLaboratorio);
        bui.append(" order by unl_codigoexame ");
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, bui);
        HashSet<ExameUnilab> exames = new HashSet<ExameUnilab>();
        while (res.next()) {
            exames.add(new ExameUnilab(res.getString("unl_xml")));
        }
        Conexao.fecharStatement(st);
        return exames;
    }

    public static ExameUnilab getExame(String filial, String codigoLaboratorio, String codExame, String codMaterial) throws SQLException {
        StringBuilder bui = new StringBuilder("select");
        bui.append(" unl_xml from examesunilab ");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and lae_codigo = ").append(codigoLaboratorio);
        bui.append(" and unl_codigoexame = ").append(DBUtil.bdText(codExame));
        if (!Funcoes.textoVazio(codMaterial)) {
            bui.append(" and unl_codigomaterial = ").append(DBUtil.bdText(codMaterial));
        }
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, bui);
        ExameUnilab exame = null;
        if (res.next()) {
            exame = new ExameUnilab(res.getString("unl_xml"));
        }
        Conexao.fecharStatement(st);
        return exame;
    }

    public static Set<ExameUnilab> getExames(String codigoLaboratorio) throws SQLException {
        StringBuilder bui = new StringBuilder("select * ");
        bui.append(" from examesunilab ");
        bui.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append(" and lae_codigo = ").append(codigoLaboratorio);
        bui.append(" order by unl_codigoexame ");
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, bui);
        HashSet<ExameUnilab> exames = new HashSet<ExameUnilab>();
        while (res.next()) {
            ExameUnilab exa = new ExameUnilab();
            exa.setMnemonico(res.getString("unl_codigoexame"), false);
            exa.setNome(res.getString("unl_descricaoexame"), false);
            exa.setNomemtbi(res.getString("unl_descricaomaterial"), false);
            exa.setXmlJalis(res.getString("unl_xml"));
            exames.add(exa);
        }
        Conexao.fecharStatement(st);
        return exames;
    }

    public static ExameUnilab novaInstancia(String xml) {
        Funcoes.validarNaoNull(xml, "xml");
        ExameUnilab exa = new ExameUnilab(xml);
        return exa;
    }

    public static ExameUnilab novaInstanciaExame(String xml) {
        ServiceImportacaoUnilab siu = new ServiceImportacaoUnilab();
        Funcoes.validarNaoNull(xml, "xml");
        ExameUnilab exameUnilab = null;
        try {
            Element raiz;
            Document doc = XMLUtil.analisarXMLString(xml);
            if (doc != null && (raiz = doc.getDocumentElement()).getNodeName().equalsIgnoreCase(Protocolo.Unilab.name())) {
                List<Element> filhos = XMLUtil.getElementosFilhos(raiz);
                for (Element e : filhos) {
                    if (!e.getNodeName().equalsIgnoreCase("exame")) continue;
                    List<Element> campos = XMLUtil.getElementosFilhos(e);
                    exameUnilab = siu.parseExameUnilab(campos);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel importar o resultado.\n" + e.getMessage(), e.getStackTrace());
        }
        return exameUnilab;
    }

    public void carregarXMLExame(String xml) {
        if (xml != null) {
            ExameUnilab e = ExameUnilab.novaInstanciaExame(xml);
            this.mnemonico = e.getMnemonico();
            this.nome = e.getNome();
            this.metodo = e.getMetodo();
            this.nomemtbi = e.getNomemtbi();
            this.codigoMtbi = e.getCodigoMtbi();
            this.setXmlJalis(e.getXml());
        }
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorUnilab = StringUtil.getValor(xml, Protocolo.Unilab.name());
        return valorUnilab != null && valorUnilab.trim().length() > 0 && (valorExame = StringUtil.getValor(valorUnilab, "exame")) != null && valorExame.trim().length() > 0;
    }

    public static Set<ExameUnilab> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameUnilab> list = new HashSet<ExameUnilab>();
        if (res.first()) {
            do {
                list.add(new ExameUnilab(res));
            } while (res.next());
        }
        return list;
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            ServiceImportacaoUnilab siu = new ServiceImportacaoUnilab();
            xml.abrir(Protocolo.Unilab.name());
            xml.abrir("exame");
            xml.escrever("mnemonico", this.getMnemonico());
            xml.escrever("nome", StringUtil.textoDB(this.getNome()));
            xml.escrever("metodo", StringUtil.textoDB(this.getMetodo()), this.adicionaAtributosCData("metodo"));
            xml.escrever("nomemtbi", this.getNomemtbi(), this.adicionaAtributosCData("nomemtbi"));
            xml.escrever("codigomtbi", this.getCodigoMtbi(), this.adicionaAtributosCData("codigomtbi"));
            xml.escrever("vigencia", this.getVigencia(), this.adicionaAtributosCData("vigencia"));
            xml.escrever("tempodejejum", this.getTempoDeJejum(), this.adicionaAtributosCData("tempodejejum"));
            if (this.configuracoes.size() > 0) {
                xml.abrir("configuracoes");
                for (Configuracao conf : this.configuracoes) {
                    xml.abrir("configuracao");
                    if (conf.getLinhasDeResultado().size() > 0) {
                        xml.escrever("descricao", conf.getDescricao());
                        xml.escrever("sexoconf", conf.getSexoConf());
                        xml.abrir("faixaetaria");
                        xml.escrever("diasinicio", conf.getFaixaEtaria().getDiasInicio().toString());
                        xml.escrever("diasfim", conf.getFaixaEtaria().getDiasFim().toString());
                        xml.fechar("faixaetaria");
                        xml.abrir("linhasderesultado");
                        for (LinhaResultado l : conf.getLinhasDeResultado()) {
                            xml.abrir("linhaderesultado");
                            xml.escrever("variavel", l.getVariavel());
                            xml.escrever("descricao", l.getDescricao());
                            xml.escrever("unidade", l.getUnidade());
                            xml.escrever("valordereferencia", l.getValorReferencia());
                            xml.escrever("tipo", l.getTipo());
                            xml.escrever("obrigatorio", l.getObrigatorio());
                            xml.fechar("linhaderesultado");
                        }
                        xml.fechar("linhasderesultado");
                    }
                    xml.fechar("configuracao");
                }
                xml.fechar("configuracoes");
            }
            xml.fechar("exame");
            xml.fechar(Protocolo.Unilab.name());
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUnilab: 291");
        }
        return xml.getXML();
    }

    private Map<String, String> adicionaAtributosCData(String tag) {
        HashMap<String, String> atributos = new HashMap<String, String>();
        if (this.camposCData.containsKey(tag)) {
            atributos.put("cData", this.camposCData.get(tag) != false ? "sim" : "n\u00e3o");
        }
        return atributos;
    }

    private String removerCData(String valor, boolean isCData) {
        return !isCData ? StringUtil.limpaCdata(valor) : valor;
    }

    public void setCodExaJalis(String codExaJalis) {
        this.codExaJalis = codExaJalis;
    }

    public String getCodExaJalis() {
        return this.codExaJalis;
    }

    public void setCodMatJalis(String codMatJalis) {
        this.codMatJalis = codMatJalis;
    }

    public String getCodMatJalis() {
        return this.codMatJalis;
    }
}

