/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.DialogoCamposImportacaoSelecionavel;
import jalis.laboratorio.util.parsers.unilab.Configuracao;
import jalis.laboratorio.util.parsers.unilab.LinhaResultado;
import jalis.laboratorio.util.parsers.unilab.ServiceImportacaoUnilab;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class DialogoCamposImportacaoUnilab
extends DialogoCamposImportacaoSelecionavel {
    private String campoSelecionado = "";
    private JTabbedPane abaCampos;
    private HashMap<String, String[]> campos;
    private ServiceImportacaoUnilab siu;

    public static DialogoCamposImportacaoUnilab novaInstancia(Object pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        if (pai instanceof Frame) {
            return new DialogoCamposImportacaoUnilab((Frame)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        if (pai instanceof Dialog) {
            return new DialogoCamposImportacaoUnilab((Dialog)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        return null;
    }

    public DialogoCamposImportacaoUnilab(Frame pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. Unilab", camposImportacao, listaExamesDesmLabExterno);
    }

    public DialogoCamposImportacaoUnilab(Dialog pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. Unilab", camposImportacao, listaExamesDesmLabExterno);
    }

    @Override
    public void iniciar(Object camposImportacao) {
        this.modelo = new ModeloGridTable(new String[]{"Linha", "Descri\u00e7\u00e3o", "Configura\u00e7\u00e3o", "Sexo", "Dias Ini.", "Dias Fim", "Obrig.", "Tipo", "Unidade"});
        this.table = ComponenteFactory.novoJTable((TableModel)this.modelo, 0, 0, 0, 35, 55, 55, 40, 35, 0);
        this.scroll = new JScrollPane(this.table);
        this.siu = new ServiceImportacaoUnilab();
        this.getPanelCentral().setLayout(new BorderLayout());
        if (this.listaExamesDesmLabExterno != null && !this.listaExamesDesmLabExterno.isEmpty()) {
            for (CamposImportacao campo : this.listaExamesDesmLabExterno) {
                this.comboDesm.addItem(campo.getCodigoExame());
                this.mapTabs.put(campo.getCodigoExame(), campo);
            }
            this.carregaCamposImportacao(((CamposImportacao)this.listaExamesDesmLabExterno.get(0)).getCamposImportacao());
            this.getComboDesm().setBorder(new TitledBorder("Desmembramento"));
            this.getPanelCentral().add((Component)this.comboDesm, "North");
        } else {
            this.carregaCamposImportacao(camposImportacao);
        }
        this.comboDesm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CamposImportacao campo = DialogoCamposImportacaoUnilab.this.getMapTabs().get(DialogoCamposImportacaoUnilab.this.getComboDesm().getSelectedItem());
                DialogoCamposImportacaoUnilab.this.carregaCamposImportacao(campo.getCamposImportacao());
            }
        });
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.setSize(new Dimension(800, 500));
        ScreenUtil.centralizar(this);
    }

    private void carregaCamposImportacao(Object camposImportacao) {
        this.modelo.clear();
        List linhas = (List)camposImportacao;
        Object[] linha = new String[]{"", "Nenhum", "", "", "", "", "", "", ""};
        this.modelo.addLine(linha);
        linha = new String[9];
        linha[0] = "metodo".toUpperCase();
        linha[1] = "Metodologia do exame";
        linha[2] = "";
        linha[3] = "";
        linha[4] = "";
        linha[5] = "";
        linha[6] = "";
        linha[7] = "";
        linha[8] = "";
        this.modelo.addLine(linha);
        for (Configuracao conf : linhas) {
            for (LinhaResultado linhaRes : conf.getLinhasDeResultado()) {
                linha = new String[9];
                linha[0] = linhaRes.getVariavel();
                linha[1] = linhaRes.getDescricao();
                linha[2] = conf.getDescricao();
                linha[3] = conf.getSexoConf();
                if (conf.getFaixaEtaria() != null) {
                    linha[4] = conf.getFaixaEtaria().getDiasInicio().toString();
                    linha[5] = conf.getFaixaEtaria().getDiasFim().toString();
                } else {
                    linha[4] = "";
                    linha[5] = "";
                }
                linha[6] = linhaRes.getObrigatorio();
                linha[7] = linhaRes.getTipo();
                linha[8] = linhaRes.getUnidade();
                this.modelo.addLine(linha);
                if (!Funcoes.textoVazio(linhaRes.getUnidade()) || !linhaRes.getTipo().equalsIgnoreCase("N")) continue;
                linha = new String[]{this.siu.getUnidadeMedidaVariavel(linhaRes.getVariavel()), "Unidade de medida " + linhaRes.getDescricao(), conf.getDescricao(), conf.getSexoConf(), "", "", linhaRes.getObrigatorio(), "", ""};
                this.modelo.addLine(linha);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(true);
    }

    @Override
    public boolean getOK() {
        return this.ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCampoSelecionado(String campoSelecionado) {
        if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("@") && campoSelecionado.contains("#")) {
            try (Scanner scanner = null;){
                scanner = new Scanner(campoSelecionado).useDelimiter("\\@");
                campoSelecionado = scanner.next();
            }
            try {
                scanner = new Scanner(scanner.next()).useDelimiter("\\#");
                String exameDesmSelecionado = scanner.next();
                String materialPaiDesm = scanner.next();
                this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("#")) {
            String exameDesmSelecionado = campoSelecionado.split("#")[1];
            campoSelecionado = campoSelecionado.split("#")[0].trim();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.getValueAt(i, 0).toString().equalsIgnoreCase(campoSelecionado)) continue;
            this.table.setRowSelectionInterval(i, i);
        }
    }
}

