/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.unilab.ExameUnilab;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorUnilab
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String MATERIAL = "material";
    private static final String OBJ_EXAME_UNILAB = "objExameUnilab";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 100, 0, 70);
    private JTextField textLocalizar = new JTextField();
    private ModeloResultSet modLinhasResultados = new ModeloResultSet("C\u00f3digo", "codigo", "Descri\u00e7\u00e3o", "descricao");
    private JTable tableLinhasResultados = ComponenteFactory.novoJTable((TableModel)this.modLinhasResultados, null, 75, 0, 150);
    private JScrollPane scrollLinhasResultados = new JScrollPane(this.tableLinhasResultados);
    private String xmlSelecionado = "";

    public ConfiguradorUnilab(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Unilab", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorUnilab(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Unilab", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorUnilab(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorUnilab(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameUnilab.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameUnilab exa = new ExameUnilab(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.getCodigo().equals(reg.getValor(COD_EXA))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.length() > 0) {
            ExameUnilab exa = new ExameUnilab(xml);
            return exa.getNome();
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            ExameUnilab exa = new ExameUnilab(xml);
            return exa.getMnemonico() + "|" + exa.getMaterialJalis() + "|1";
        }
        return "";
    }

    public static ConfiguradorUnilab novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorUnilab((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorUnilab((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.scrollLinhasResultados.setPreferredSize(new Dimension(650, 100));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Linhas Resultados", (Component)this.scrollLinhasResultados, null, null, null, null), "South");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorUnilab.this.modExa.filtrar(ConfiguradorUnilab.DESC_EXA, ConfiguradorUnilab.this.textLocalizar.getText());
                if (ConfiguradorUnilab.this.modExa.getRowCount() > 0) {
                    ConfiguradorUnilab.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorUnilab.this.tableExa.hasFocus() && (row = ConfiguradorUnilab.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorUnilab.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorUnilab.this.tableExa.scrollRectToVisible(ConfiguradorUnilab.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorUnilab.this.tableExa.hasFocus() && (row = ConfiguradorUnilab.this.tableExa.getSelectedRow()) < ConfiguradorUnilab.this.tableExa.getRowCount() - 1) {
                    ConfiguradorUnilab.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorUnilab.this.tableExa.scrollRectToVisible(ConfiguradorUnilab.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        try {
            for (ExameUnilab exame : ExameUnilab.getExames(this.getCodigoLabExterno())) {
                Registro reg = new Registro();
                reg.setValor(COD_EXA, exame.getMnemonico());
                reg.setValor(DESC_EXA, exame.getNome());
                reg.setValor(MATERIAL, exame.getNomemtbi());
                reg.setValor(OBJ_EXAME_UNILAB, exame);
                this.modExa.addRegistro(reg);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public boolean acaoOk() {
        ExameUnilab exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        try {
            if (this.atualizarXMLSelecionado()) {
                return true;
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return false;
    }

    private boolean atualizarXMLSelecionado() throws SQLException {
        ExameUnilab exa = this.getExameSelecionado();
        if (null != exa) {
            exa = ExameUnilab.getExame(Variaveis.filialPadrao, this.getCodigoLabExterno(), exa.getCodigo(), exa.getCodigoMtbi());
            this.xmlSelecionado = exa.getXml();
            return true;
        }
        return false;
    }

    private ExameUnilab getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameUnilab)reg.getValor(OBJ_EXAME_UNILAB);
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.atualizarLinhasResultados((ExameUnilab)reg.getValor(OBJ_EXAME_UNILAB));
        }
    }

    private void atualizarLinhasResultados(ExameUnilab exame) {
        this.modLinhasResultados.limpar();
    }
}

