/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.unilab.ServiceImportacaoUnilab;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ConfiguradorProtocoloUnilab
extends AbstractConfiguradorProtocolo {
    private TTextField textPostoColeta = ComponenteFactory.novoTTextField(2, 1, this);
    private ServiceImportacaoUnilab siu = new ServiceImportacaoUnilab();

    public static ConfiguradorProtocoloUnilab novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloUnilab((Frame)pai, "Configurador Unilab", codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloUnilab((Dialog)pai, "Configurador Unilab", codigoLabExterno);
        }
        return null;
    }

    public ConfiguradorProtocoloUnilab(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    public ConfiguradorProtocoloUnilab(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    private void montarTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(85, 20));
        JLabel labelEmpresa = ComponenteFactory.novoJLabel("Conv\u00eanio:", new Dimension(85, 20));
        JLabel labelPostoColeta = ComponenteFactory.novoJLabel("Posto Coleta:", new Dimension(85, 20));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        this.getPanelCentral().add((Component)labelEmpresa, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelLote, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelPostoColeta, cons);
        ++cons.gridx;
        cons.gridy = 0;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.textLote.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.textLote, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.textPostoColeta, cons);
        this.setSize(new Dimension(240, 170));
        this.setLocationRelativeTo(this.getParent());
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<").append(Protocolo.Unilab.toString()).append(">");
        bui.append(StringUtil.getTag("convenio", this.textCodigo.getText()));
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        bui.append(StringUtil.getTag("postoColeta", this.textPostoColeta.getText()));
        return bui.append("</").append(Protocolo.Unilab.toString()).append(">").toString();
    }

    @Override
    public boolean acaoOk() {
        return !Funcoes.textoVazio(this.textCodigo) && !Funcoes.textoVazio(this.textLote) && !Funcoes.textoVazio(this.textPostoColeta);
    }

    @Override
    public int getNumeroLote() {
        if (Funcoes.textoVazio(this.textLote)) {
            return 0;
        }
        return Integer.parseInt(this.textLote.getText());
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, Protocolo.Unilab.toString());
            this.textCodigo.setText(StringUtil.getValor(xml, "convenio"));
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
            this.textPostoColeta.setText(StringUtil.getValor(xml, "postoColeta"));
        }
    }
}

