/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab.resultado;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardini;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ImportacaoResultadoSyslab
extends AbstractImportadorResultadoLabExterno {
    public static final String TAG_COD_LAB = "CodLab";
    public static final String TAG_COD_LOTE_LAB = "CodLoteLab";
    public static final String TAG_PROTOCOLO = "Protocolo";
    public static final String TAG_ID = "ID";
    public static final String TAG_CONSULTA = "Consulta";
    public static final String TAG_SOLICITA_RESULTADO = "SolicitaResultado";
    public static final String TAG_SOLICITA_LOTE = "SolicitaLote";
    public static final String TAG_OPERACAO = "Operacao";
    public static final String TAG_ACAO = "Acao";
    public static final String TAG_DATA_INICIAL = "DataInicial";
    public static final String TAG_HORA_INICIAL = "HoraInicial";
    public static final String TAG_DATA_FINAL = "DataFinal";
    public static final String TAG_HORA_FINAL = "HoraFinal";
    public static final String TAG_GRAFICO = "Grafico";
    public static final String TAG_UNIDADE_VALOR = "UnidadeNoValor";
    public static final String TAG_DADOS_CONSTANTES = "DadosConstantes";
    private JButton buttonImportarWebService;
    private static String ULTIMO_SQL = "";
    private static final String FORMATO = "formato";
    private static final String FORMATACAO = "formatacao";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATO_TEXTO = "formatotexto";
    private static final String ELEMENTO_REGISTRO = "Registro";
    private static final String ELEMENTO_PEDIDOS = "Pedidos";
    private static final String PEDIDOS = "Pedidos";
    private static final String CODIGO_PEDIDO_APOIO = "CodigoPedidoApoio";
    private static final String ELEMENTO_EXAMES = "Exames";
    private static final String CODIGO = "Codigo";
    private static final String CODIGO_EXAME = "codigoExame";
    private static final String RESULTADO = "Resultado";
    private static final String RESULTADOS = "Resultados";
    private static final String MneCAMPO = "MneCampo";
    private static final String MneEXAME = "MneExame";
    private static final String UNIDADE = "Unidade";
    private static final String TXT_REFERENCIA = "TxtReferencia";
    private static final SimpleDateFormat dataSyslab = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dataUsuario = new SimpleDateFormat("dd/MM/yyyy");
    private ModeloGridTable modeloRelatorio;
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;
    private LaboratorioExterno labExterno;
    private JButton buttonImprimir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportacaoResultadoSyslab(int codigoLabExterno) {
        Statement st;
        block4: {
            super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. Syslab a partir de arquivo XML", codigoLabExterno, Protocolo.Syslab, new JPanel(new FlowLayout(2)));
            this.buttonImportarWebService = ComponenteFactory.novoJButton("Importar Webservice", 'W', this);
            this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
            this.conferirAutomatico = false;
            this.codigoUsuarioConferenciaAutomatica = null;
            this.labExterno = null;
            this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
            this.getPanelAdicional().add(this.buttonImprimir);
            this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSyslab (122)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        try {
            ElementoHPardini res;
            this.setTextoInformacoes("");
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Syslab (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0 && (res = ParserResultadoHPardini.analisarXMLHPardini(chooser.getSelectedFile())) != null) {
                if (!res.getNome().equals(ELEMENTO_REGISTRO)) {
                    this.setTextoInformacoes("O arquivo \"" + chooser.getSelectedFile().getPath() + "\" n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                    return;
                }
                this.importarResultados(res.getFilhos("Pedido"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoSyslab: 35");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importarResultados(List<ElementoHPardini> pedidos) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st != null) {
            try {
                String req_codigo;
                String fil_codigo;
                this.progress.setValue(0);
                this.progress.setMaximum(pedidos.size());
                this.progress.setVisible(true);
                block6: for (ElementoHPardini pedido : pedidos) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    for (ElementoHPardini superExame : pedido.getFilhos("Exame")) {
                        if (pedido.getFilho(ELEMENTO_EXAMES) == null) {
                            this.setTextoInformacoes("Nenhum resultado encontrado no arquivo.\n", false);
                            continue block6;
                        }
                        if (Funcoes.textoVazio(pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor())) {
                            String codigoPedidoApoio = pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor();
                            this.setTextoInformacoes("Nenhuma requisi\u00e7\u00e3o encontrada para o codigo apoio:\n " + codigoPedidoApoio, false);
                            continue block6;
                        }
                        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                        if (pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().length() != tamTubo) {
                            this.setTextoInformacoes("C\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor() + "\n", false);
                            continue block6;
                        }
                        if (!Funcoes.isNumeric(pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor()) || pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().contains(".") || pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().contains(",")) {
                            this.setTextoInformacoes("Requisi\u00e7\u00e3o: " + pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor() + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o\n", false);
                            continue block6;
                        }
                        fil_codigo = pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().substring(0, ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().substring(ParametrosGerais.getDigitosTuboFilial());
                        Object multiguias = null;
                        LinkedList<Registro> listaRegistros = this.processarPaiFilhos(st, pedido, superExame, fil_codigo, req_codigo, false);
                        if (listaRegistros == null || listaRegistros.isEmpty()) {
                            String[] exameJalis = new String[2];
                            exameJalis = superExame.getFilho(MneEXAME).getValor().split("[|]");
                            this.setTextoInformacoes("Exame n\u00e3o encontrado: Filial: " + fil_codigo + " Requisi\u00e7\u00e3o: " + req_codigo + " Exame: " + exameJalis[0] + "\n", false);
                            continue;
                        }
                        for (Registro reg : listaRegistros) {
                            boolean salvoParcial;
                            if (reg == null) continue;
                            if (this.exameJaLancado(reg)) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.JA_LANCADO, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                continue;
                            }
                            if (!this.exameColetado(reg) && reg != null && !reg.getString("exr_situacao").equals("P")) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_MATERIAL, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                continue;
                            }
                            if (!this.exameRelacionado(reg)) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_RELACIONAMENTO, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento\n", false);
                                continue;
                            }
                            if (reg.getValor("examePai") != null) {
                                reg.setValor("exa_codigo", reg.getString("examePai"));
                                reg.setValor("mco_codigo", reg.getString("materialPai"));
                            }
                            Registro formatacao = (salvoParcial = reg.getString("exr_situacao").equals("P")) ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
                            StringBuilder resultadoAtual = new StringBuilder();
                            Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                            String campo = "";
                            String valor = "";
                            String valorReferencia = "";
                            String unidade = "";
                            for (ElementoHPardini result : superExame.getFilhos(RESULTADO)) {
                                String exaDesmb = reg.getString("exa_kodigo");
                                String mcoDesmb = reg.getString("mco_kodigo");
                                campo = result.getFilho(MneCAMPO).getValor();
                                valor = result.getFilho(RESULTADO).getValor();
                                valorReferencia = result.getFilho(TXT_REFERENCIA).getValor();
                                unidade = result.getFilho(UNIDADE).getValor();
                                if (!Funcoes.textoVazio(exaDesmb)) {
                                    campo = campo + "@" + exaDesmb + "#" + mcoDesmb;
                                    if (!Funcoes.textoVazio(valorReferencia)) {
                                        dados.put("TxtReferencia@" + exaDesmb + "#" + mcoDesmb, valorReferencia);
                                    }
                                    if (!Funcoes.textoVazio(unidade)) {
                                        dados.put("Unidade@" + exaDesmb + "#" + mcoDesmb, unidade);
                                    }
                                }
                                if (!Funcoes.textoVazio(valorReferencia)) {
                                    dados.put(TXT_REFERENCIA, valorReferencia);
                                }
                                if (!Funcoes.textoVazio(unidade)) {
                                    dados.put(UNIDADE, unidade);
                                }
                                dados.put(campo, valor);
                            }
                            Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                            Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                            if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                                historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                            }
                            dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                            Resultado res = new Resultado(null, formatacao.getString(FORMATO), dados, null, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, resultadoAtual.toString());
                            res.atualizarComponentes();
                            if (!res.verificarCondicao()) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.CONDICAO_INSATISFEITA, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita\n", false);
                                continue;
                            }
                            boolean completo = true;
                            if (reg.getBoolean("exa_salvaparcial")) {
                                completo = res.resultadoCompleto(true);
                            }
                            String novaSituacao = completo ? "L" : "P";
                            String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                            Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                            boolean marcarConferido = false;
                            if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                                int verificacao = res.verificarValidacao();
                                boolean bl = marcarConferido = verificacao == 1;
                                if (!marcarConferido && verificacao != 2) {
                                    this.adicionarAoModeloRelatorio(superExame, Situacao.VALIDACAO_INSATISFEITA, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                    this.setTextoInformacoes("O resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : "") + "\n", false);
                                }
                            }
                            if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor())) {
                                this.inserirDadosRequisicao(st, this.codigoLabExterno, pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor(), reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                            }
                            boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                            boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                            this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                            if (this.exportarBaseWeb(reg)) {
                                Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                                this.exportarParaWeb(st, this.getCodigoBaseWeb(reg.getString("fil_codigo")), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                                if (ExportaWeb.isGerarPdfResultado(st2, reg.getString("fil_codigo"))) {
                                    ExportaWeb.enviarResultadoPDF(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), this.getCodigoBaseWeb(reg.getString("fil_codigo")));
                                }
                            }
                            this.adicionarAoModeloRelatorio(superExame, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                            Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                            Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                            this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                            this.atualizarPaginaOrdemExameWeb(st, reg);
                            this.editarRequisicaoExportaFiliais(reg);
                            this.atualizarSituacaoExameInterfaceamento(st, reg);
                            this.setTextoInformacoes("Resultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE)) + "\n", false);
                        }
                    }
                }
                block10: for (ElementoHPardini pedido : pedidos) {
                    for (ElementoHPardini superExame : pedido.getFilhos("Exame")) {
                        if (pedido.getFilho(CODIGO_PEDIDO_APOIO) == null || Funcoes.textoVazio(pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor())) continue;
                        if (pedido.getFilho(ELEMENTO_EXAMES) == null) continue block10;
                        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                        if (pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().length() != tamTubo || !Funcoes.isNumeric(pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor()) || pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().contains(".") || pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().contains(",")) continue;
                        fil_codigo = pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().substring(0, ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = pedido.getFilho(CODIGO_PEDIDO_APOIO).getValor().substring(ParametrosGerais.getDigitosTuboFilial());
                        this.processarPaiFilhos(st, pedido, superExame, fil_codigo, req_codigo, true);
                    }
                }
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > -1);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoSyslab: 114");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
        }
        this.progress.setVisible(false);
    }

    private LinkedList<Registro> processarPaiFilhos(Statement st, ElementoHPardini pedido, ElementoHPardini exResultado, String fil_codigo, String req_codigo, boolean isLogEmailSMS) throws Exception {
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        Registro registro = new Registro();
        Integer[] multiguias = null;
        boolean agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias;
        multiguias = agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true) : new Integer[]{Integer.parseInt(req_codigo)};
        for (Integer multiguia : multiguias) {
            ExameDesmembrado pai;
            String exameSysLab = exResultado.getFilho(MneEXAME).getValor();
            String[] exameJalis = new String[2];
            registro = this.localizarRequisicao(fil_codigo, multiguia.toString(), exameSysLab);
            if (registro == null) continue;
            exameJalis[0] = registro.getString("exa_codigo");
            exameJalis[1] = registro.getString("mco_codigo");
            if (!Funcoes.textoVazio(registro.getString("exa_kodigo"))) {
                exameJalis[0] = registro.getString("exa_kodigo");
                exameJalis[1] = registro.getString("mco_kodigo");
            }
            String codigoJalis = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            List<Registro> exameSeparado = this.localizarExameRequisicao(fil_codigo, multiguia.toString(), exameJalis[0], exameJalis[1]);
            if (exameSeparado != null && !exameSeparado.isEmpty()) {
                for (Registro r : exameSeparado) {
                    retorno.add(r);
                    if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(r.getString("fil_codigo"), r.getString("req_codigo"), Conexao.getStatement())) {
                        SMSUtil.criaLogSmsComDadosRequisicao(r.getString("fil_codigo"), r.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                    }
                    if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(r.getString("fil_codigo"), r.getString("req_codigo"), Conexao.getStatement())) {
                        EmailUtil.criaLogEmail(r.getString("fil_codigo"), r.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                    }
                    if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(r.getString("fil_codigo"), r.getString("req_codigo"), Conexao.getStatement())) {
                        PushUtil.criaLogPushComDadosRequisicao(r.getString("fil_codigo"), r.getString("req_codigo"), TipoPush.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                    }
                    if (!isLogEmailSMS || !this.conferirAutomatico || Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(r.getString("fil_codigo"), r.getString("req_codigo"), Conexao.getStatement())) continue;
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(r.getString("fil_codigo"), r.getString("req_codigo"), TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
            }
            if ((pai = this.getExamesDesmembrados(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exameJalis[0], exameJalis[1])) == null) continue;
            String codigoJalisTemp = exameJalis[0];
            List<Registro> listaExame = this.localizarExameRequisicao(fil_codigo, multiguia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()));
            if (listaExame == null) continue;
            for (int i = 0; i < listaExame.size(); ++i) {
                Registro reg = listaExame.get(i);
                if (reg == null || !pai.getFilhos().get(0).getCodigoExame().equals(reg.getString("exa_kodigo"))) continue;
                reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                reg.setValor("mco_codigo", pai.getFilhos().get(0).getCodigomaterial());
                reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                reg.setValor("examePai", pai.getCodigoExame());
                reg.setValor("materialPai", pai.getCodigomaterial());
                retorno.add(reg);
                if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                    SMSUtil.criaLogSmsComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
                if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                    EmailUtil.criaLogEmail(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                }
                if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                    PushUtil.criaLogPushComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoPush.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
                if (!isLogEmailSMS || !this.conferirAutomatico || Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) continue;
                WhatsAppUtil.criaLogWhatsappComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
            }
        }
        return retorno;
    }

    private Registro localizarRequisicao(String filial, String requisicao, String exameSysLab) throws SQLException {
        Registro reg = null;
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder sql = this.getSqlLocalizaExame(filial, requisicao, "", "");
            ULTIMO_SQL = sql.toString();
            ResultSet res = Conexao.executeQuery(st, ULTIMO_SQL);
            while (res.next()) {
                ExameDesmembrado exDesm;
                String xml = res.getString("ele_xmllabexterno");
                String exaDesmb = "";
                if (!Funcoes.textoVazio(res.getString("exa_kodigo")) && (exDesm = this.getExamesDesmembrados(filial, requisicao, res.getString("lae_codigo"), res.getString("exa_kodigo"), res.getString("mco_kodigo"))) != null) {
                    xml = exDesm.getFilhos().get(0).getXmlLabExterno();
                    exaDesmb = res.getString("exa_kodigo");
                }
                if ((Funcoes.textoVazio(xml) || !StringUtil.getValor(xml, CODIGO_EXAME).equals(exameSysLab)) && !exaDesmb.equals(exameSysLab)) continue;
                reg = new Registro(res);
                reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(filial, res.getString("con_codigo"), res.getString("des_codigo")));
                reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(filial, reg.getString(CODIGO_LAYOUT)));
                Registro formatacao = new Registro();
                formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
                formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                reg.setValor(FORMATACAO, formatacao);
                break;
            }
        }
        return reg;
    }

    protected StringBuilder getSqlLocalizaExame(String fil, String req, String exa, String mco) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, b.exa_codigo, b.mco_codigo, b.exr_situacao, ");
        sql.append(" pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, coalesce(g.met_codigo, b.met_codigo) as met_codigo, ");
        sql.append(" c.pac_idade,c.pac_anomes, b.exr_datamaterial, d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, ");
        sql.append(" a.req_integracaohospital, desm.exa_kodigo, desm.mco_kodigo, f.lae_codigo, a.req_guia, b.exr_codautorizacao, b.exr_solicitadotiss ");
        sql.append(" from requisicao a ");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
        sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo ");
        sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo ");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo and f.usr_codestorno is null and f.ler_datahoraestorno is null");
        sql.append(" left join loteexternoexamerequisicaodesm desm on b.fil_codigo = desm.fil_kodigo and b.req_codigo = desm.req_codigo and b.exa_codigo = desm.exa_codigo and b.mco_codigo = desm.mco_codigo ");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' ");
        sql.append(" where a.fil_codigo = ").append(fil);
        sql.append(" and a.req_codigo = ").append(req);
        if (!Funcoes.textoVazio(exa) && !Funcoes.textoVazio(mco)) {
            sql.append(" and b.exa_codigo = '").append(exa).append("'");
            sql.append(" and b.mco_codigo = ").append(mco);
        }
        sql.append(" and a.req_excluida = false ");
        sql.append(" and b.exr_excluido = false ");
        return sql;
    }

    private List<Registro> localizarExameRequisicao(String filial, String requisicao, String exame, String material) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder sql = this.getSqlLocalizaExame(filial, requisicao, exame, material);
            ULTIMO_SQL = sql.toString();
            ResultSet res = Conexao.executeQuery(st, ULTIMO_SQL);
            ArrayList<Registro> listaExameRequisicao = new ArrayList<Registro>();
            if (res.next()) {
                do {
                    Registro reg = new Registro(res);
                    reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(filial, res.getString("con_codigo"), res.getString("des_codigo")));
                    reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(filial, reg.getString(CODIGO_LAYOUT)));
                    Registro formatacao = new Registro();
                    formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
                    formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                    reg.setValor(FORMATACAO, formatacao);
                    listaExameRequisicao.add(reg);
                } while (res.next());
            } else if (!Funcoes.textoVazio(exame) && !Funcoes.textoVazio(requisicao)) {
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, requisicao, exame, null, Situacao.NAO_LOCALIZADO.descricao);
                return null;
            }
            return listaExameRequisicao;
        }
        return null;
    }

    private boolean exameJaLancado(Registro reg) {
        String sit = reg.getString("exr_situacao");
        return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private synchronized String formataData(String data) throws ParseException {
        return dataUsuario.format(dataSyslab.parse(data));
    }

    private void atualizarPaginaOrdemExameWeb(Statement st, Registro dados) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, dados.getString("fil_codigo"), dados.getString("req_codigo"), Variaveis.codigoBaseWeb);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSyslab (1506)");
        }
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private boolean mesmaVersao(String formato, ElementoHPardini superExame) {
        String versao = StringUtil.getValor(StringUtil.getValor(formato, "exame"), "versaoExameLabExterno");
        versao = versao.substring(0, versao.indexOf("."));
        return superExame.contemFilho("CodFormulario") && superExame.getFilho("CodFormulario").getValor().equalsIgnoreCase(versao);
    }

    /*
     * Exception decompiling
     */
    private boolean mesmaVersaoEstrutura(String formato, ElementoHPardini superExame) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean verificaCDDATA(String campo, String valor, String se) {
        String abre = "<" + campo + ">";
        String fecha = "</" + campo + ">";
        if (valor.toLowerCase().indexOf(abre) >= 0 && valor.toLowerCase().indexOf(fecha) >= 0) {
            se = se + valor.substring(0, valor.toLowerCase().indexOf(abre) + abre.length()) + "<![CDATA[" + valor.substring(valor.toLowerCase().indexOf(abre) + abre.length(), valor.toLowerCase().indexOf(fecha)) + "]]>" + valor.substring(valor.toLowerCase().indexOf(fecha)) + "\n";
            System.out.println(se);
            return true;
        }
        return false;
    }

    private boolean exportarBaseWeb(Registro reg) {
        try {
            Statement st = Conexao.getStatement();
            FilialService filService = new FilialService();
            FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, reg.getString("fil_codigo"));
            if (this.carregouVO(filialVO)) {
                return this.isExportarBaseWeb(filialVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini: 261");
        }
        return false;
    }

    private boolean carregouVO(FilialVO filialVO) {
        return filialVO != null;
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    private void adicionarAoModeloRelatorio(ElementoHPardini superExame, Situacao situacao, String req, String metodo, String exame) {
        ElementoHPardini pedido = superExame.getPai();
        if (pedido != null && pedido.getPai().contemFilho(CODIGO_PEDIDO_APOIO) && pedido.getPai().getFilho(CODIGO_PEDIDO_APOIO).getValor().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() && superExame.contemFilho(MneEXAME)) {
            String exa = exame;
            String mco = metodo;
            String requisicao = pedido.getPai().getFilho(CODIGO_PEDIDO_APOIO).getValor();
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            if (!situacao.equals((Object)Situacao.VERSAO_INCOMPATIVEL)) {
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, req, exa, Integer.parseInt(mco), situacao.descricao);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            if (this.modeloRelatorio.getRowCount() > 0) {
                RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private XMLStringBuilder gerarXML(String codigoID, String codigoConvenio, String dataInicial, String dataFinal, String horaInicial, String horaFinal) throws XMLStringBuilderException, ParseException {
        XMLStringBuilder xml = new XMLStringBuilder(true);
        xml.escreveHeader("1.0", "ISO-8859-1");
        xml.abrir(TAG_CONSULTA);
        xml.escrever(TAG_ID, codigoID);
        xml.escrever(TAG_PROTOCOLO, "1");
        xml.abrir(TAG_SOLICITA_RESULTADO);
        xml.escrever(TAG_COD_LAB, codigoConvenio);
        xml.escrever(TAG_OPERACAO, RESULTADOS);
        xml.escrever(TAG_ACAO, "Mostra");
        xml.escrever(TAG_DATA_INICIAL, Funcoes.formataData("yyyy-MM-dd", dataInicial));
        xml.escrever(TAG_HORA_INICIAL, horaInicial + ":00");
        xml.escrever(TAG_DATA_FINAL, Funcoes.formataData("yyyy-MM-dd", dataFinal));
        xml.escrever(TAG_HORA_FINAL, horaFinal + ":00");
        xml.escrever(TAG_GRAFICO, "0");
        xml.escrever(TAG_UNIDADE_VALOR, "0");
        xml.escrever(TAG_DADOS_CONSTANTES, "0");
        xml.fechar(TAG_SOLICITA_RESULTADO);
        xml.fechar(TAG_CONSULTA);
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirRelatorio() {
        Statement st;
        block5: {
            if (this.modeloRelatorio.getRowCount() <= 0) {
                return;
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioSituacaoLote.getModuloAcesso());
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block5;
                final JDialog dialogo = new JDialog(Laboratorio.getInstancia());
                dialogo.setSize(new Dimension(750, 600));
                dialogo.getContentPane().setLayout(new BorderLayout());
                dialogo.setModal(true);
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        dialogo.dispose();
                    }
                });
                gerador.executar(rs.getString("rel_xml"), this.modeloRelatorio);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ImportacaoResultadoSyslab (715)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, CODIGO_EXAME);
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select sys_xml from examessyslab where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and sys_codexame = '").append(exa).append("'");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("sys_xml", rs.getString("sys_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private String dataHoraAtual(String tipo) {
        if (tipo == TAG_DATA_FINAL) {
            SimpleDateFormat sf = new SimpleDateFormat("dd/MM/yyyy");
            String dataAtual = sf.format(new Date());
            return dataAtual;
        }
        if (tipo == TAG_HORA_FINAL) {
            SimpleDateFormat sf1 = new SimpleDateFormat("HH:mm");
            String horaAtual = sf1.format(new Date());
            return horaAtual;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameDesmembrado getExamesDesmembrados(String filial, String reqCodigo, String laeCodigo, String exaFilho) {
        Statement st;
        block4: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block4;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ");
                buf.append("       ,a.mco_codigo ");
                buf.append("       ,p.ele_xmllabexterno ");
                buf.append("   from examerequisicao a ");
                buf.append("   join examematcoletalabextdesm e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append("   join examematcoletalabexterno p on e.fil_codigo = p.fil_codigo and e.exa_kodigo = p.exa_codigo and e.mco_codigo = p.mco_codigo and e.lae_codigo = p.lae_codigo ");
                buf.append("  where a.fil_codigo = ").append(filial);
                buf.append("    and a.req_codigo  = ").append(reqCodigo);
                buf.append("    and e.exa_kodigo = '").append(exaFilho).append("' ");
                buf.append("    and e.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block4;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"));
                ex.addFilho(new Exame(exaFilho, res.getInt("mco_codigo"), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        SEM_COD_EXM_LAB("XML sem campo CodExmLab"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_MATERIAL("Sem material"),
        SEM_RELACIONAMENTO("Sem relacionamento");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

