/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.syslab.ExameSyslab;
import jalis.laboratorio.util.parsers.syslab.ImportacaoSyslab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;

public class ParserImportacaoSyslab {
    private static final int TAG_MNEMONICO_EXAME = 0;
    private static final int TAG_DESCRICAO_EXAME = 1;
    private static final int TAG_MNEMONICO_MATERIAL = 2;
    private static final int TAG_DESCRICAO_MATERIAL = 3;
    private static final int TAG_COD_FORMULARIO = 4;
    private static final int TAG_DESCRICAO_FORMULARIO = 5;
    private static final int TAG_MNEMONICO_CAMPO = 6;
    private static final int TAG_DESCRICAO_CAMPO = 7;

    public static Map<String, ExameSyslab> importarExamesSyslab(String file, int codigoLabExterno, JProgressBar progress, ImportacaoSyslab telaImportacao) {
        HashMap<String, ExameSyslab> examesNovos = new HashMap<String, ExameSyslab>();
        boolean arquivoResultado = false;
        String[] linhas = file.split("\n");
        ExameSyslab esys = null;
        for (String s : linhas) {
            boolean isExame;
            String[] exame = s.split(";");
            boolean bl = isExame = exame.length > 7 && !Funcoes.textoVazio(exame[0]) && !Funcoes.textoVazio(exame[1]) && !Funcoes.textoVazio(exame[2]) && ((String)exame[0]).length() <= 8;
            if (!isExame) continue;
            String chave = exame[0].trim() + exame[2].trim();
            if (!examesNovos.containsKey(chave)) {
                esys = new ExameSyslab((String)exame[0], (String)exame[1], (String)exame[2], (String)exame[3], (String)exame[4], (String)exame[5]);
                esys.addCampoRelacionamento((String)exame[6], (String)exame[7]);
                examesNovos.put(chave, esys);
                continue;
            }
            ((ExameSyslab)examesNovos.get(chave)).addCampoRelacionamento((String)exame[6], (String)exame[7]);
        }
        HashMap<String, ExameSyslab> examesExcluidos = new HashMap<String, ExameSyslab>();
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                HashSet examesNovosRel;
                Map<String, ExameSyslab> examesAntigosRelac = ParserImportacaoSyslab.examesMap(ParserImportacaoSyslab.getExamesRelacionados(codigoLabExterno));
                Map<String, ExameSyslab> examesAntigos = ParserImportacaoSyslab.loadExamesSyslab(st, codigoLabExterno);
                if (arquivoResultado) {
                    for (String exame : examesNovos.keySet()) {
                        Object ex = (ExameSyslab)examesNovos.get(exame);
                        IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 11, ((ExameSyslab)ex).getCodigoExame());
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoSyslab.inserirExamesSyslab(examesNovos, st, codigoLabExterno, progress, examesAntigos);
                    examesNovosRel = new HashSet(examesNovos.values());
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (Object ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        ExameSyslab exAntigo = examesAntigosRelac.get(((ExameSyslab)ex).getCodigoExame());
                        ((ExameSyslab)ex).setExameJalis(exAntigo.getExameJalis());
                        ((ExameSyslab)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameSyslab)ex).getExameJalis(), Integer.parseInt(((ExameSyslab)ex).getMaterialJalis()), ((ExameSyslab)ex).getXml());
                    }
                } else {
                    IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 11, new Object[0]);
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoSyslab.inserirExamesSyslab(examesNovos, st, codigoLabExterno, progress, examesAntigos);
                    examesNovosRel = new HashSet(examesNovos.values());
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (Object ex : examesNovosRel) {
                        ExameSyslab exAntigo;
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        if ((exAntigo = examesAntigosRelac.get(((ExameSyslab)ex).getCodigoExame().toString() + ((ExameSyslab)ex).getMaterial())) == null) continue;
                        ((ExameSyslab)ex).setExameJalis(exAntigo.getExameJalis());
                        ((ExameSyslab)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                        if (!exAntigo.getMaterial().equals(((ExameSyslab)ex).getMaterial())) {
                            ((ExameSyslab)ex).setMaterial(exAntigo.getMaterial());
                        }
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameSyslab)ex).getExameJalis(), Integer.parseInt(((ExameSyslab)ex).getMaterialJalis()), ((ExameSyslab)ex).getXml().replace("'", ""));
                    }
                    examesExcluidos.putAll(examesAntigos);
                    for (Object ex : examesNovos.keySet()) {
                        if (!examesExcluidos.containsKey(ex)) continue;
                        examesExcluidos.remove(ex);
                    }
                    HashSet<ExameSyslab> examesExcluidosRel = new HashSet<ExameSyslab>(examesAntigosRelac.values());
                    examesExcluidosRel.removeAll(examesNovos.values());
                    for (ExameSyslab ex : examesExcluidosRel) {
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), ex.getXml().replace("'", ""));
                    }
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return examesExcluidos;
    }

    public static List<String> parseLine(String cvsLine, char separators, char customQuote) {
        char[] chars;
        int DEFAULT_SEPARATOR = 44;
        int DEFAULT_QUOTE = 34;
        ArrayList<String> result = new ArrayList<String>();
        if (cvsLine == null || cvsLine.isEmpty()) {
            return result;
        }
        if (customQuote == ' ') {
            customQuote = (char)34;
        }
        if (separators == ' ') {
            separators = (char)44;
        }
        StringBuffer curVal = new StringBuffer();
        boolean inQuotes = false;
        boolean startCollectChar = false;
        boolean doubleQuotesInColumn = false;
        for (char ch : chars = cvsLine.toCharArray()) {
            if (inQuotes) {
                startCollectChar = true;
                if (ch == customQuote) {
                    inQuotes = false;
                    doubleQuotesInColumn = false;
                    continue;
                }
                if (ch == '\"') {
                    if (doubleQuotesInColumn) continue;
                    curVal.append(ch);
                    doubleQuotesInColumn = true;
                    continue;
                }
                curVal.append(ch);
                continue;
            }
            if (ch == customQuote) {
                inQuotes = true;
                if (chars[0] != '\"' && customQuote == '\"') {
                    curVal.append('\"');
                }
                if (!startCollectChar) continue;
                curVal.append('\"');
                continue;
            }
            if (ch == separators) {
                result.add(curVal.toString());
                curVal = new StringBuffer();
                startCollectChar = false;
                continue;
            }
            if (ch == '\r') continue;
            if (ch == '\n') break;
            curVal.append(ch);
        }
        result.add(curVal.toString());
        return result;
    }

    private static Map<String, ExameSyslab> examesMap(Collection<ExameSyslab> exames) {
        HashMap<String, ExameSyslab> examesMap = new HashMap<String, ExameSyslab>();
        for (ExameSyslab ex : exames) {
            examesMap.put(ex.getCodigoExame().toString() + ex.getMaterial(), ex);
        }
        return examesMap;
    }

    private static Map<String, ExameSyslab> loadExamesSyslab(Statement st, int codigoLabExterno) throws SQLException {
        HashMap<String, ExameSyslab> exames = new HashMap<String, ExameSyslab>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct fil_codigo, lae_codigo, sys_codexame, sys_descricaoexame, sys_codmaterial, sys_xml");
        sql.append(" from examessyslab ");
        sql.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append("  and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            exames.put(rs.getString("sys_codexame") + rs.getString("sys_codmaterial"), new ExameSyslab(rs.getString("sys_xml")));
        }
        return exames;
    }

    private static void inserirExamesSyslab(Map<String, ExameSyslab> exames, Statement st, int codigoLabExterno, JProgressBar progress, Map<String, ExameSyslab> examesAnt) throws SQLException, SalvaDadosException {
        for (String mnemonico : exames.keySet()) {
            ExameSyslab exame = exames.get(mnemonico);
            if (Funcoes.textoVazio(exame.getMaterial()) && examesAnt.size() > 0 && examesAnt.get(mnemonico) != null && !Funcoes.textoVazio(examesAnt.get(mnemonico).getMaterial())) {
                exame.setMaterial(examesAnt.get(mnemonico).getMaterial());
            }
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 11, exame.getCodigoExame(), StringUtil.textoDB(exame.getDescricaoExame()), exame.getMaterial(), exame.getXml().replace("'", ""));
        }
    }

    private static Set<ExameSyslab> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno);
                bui.append("  and a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameSyslab.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameSyslab>();
    }

    private static String montarXMLCamposResultados(String ehpXML, ElementoHPardini superExame) {
        int beginIndex = ehpXML.indexOf("<Syslab>");
        int endIndex = ehpXML.indexOf("</Syslab>") + "</Syslab>".length();
        StringBuilder bui = new StringBuilder(StringUtil.textoDB(ehpXML.substring(beginIndex, endIndex)));
        bui.append('\n');
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            ParserImportacaoSyslab.carregarXMLBuilder(xml, superExame);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\nExame: " + superExame.getFilho("CodExmApoio").getValor(), e.getStackTrace(), "ParserImportacaoSyslab: 220");
        }
        bui.append(StringUtil.textoDB(xml.getXML()));
        return bui.toString();
    }

    protected static void carregarXMLBuilder(XMLStringBuilder xml, ElementoHPardini ele) throws XMLStringBuilderException {
        if (!ele.contemFilhos()) {
            String valor = ele.getValor();
            if (ele.getNome().equalsIgnoreCase("descricao") || ele.getNome().equalsIgnoreCase("nota") || ele.getNome().equalsIgnoreCase("observacao") || ele.getNome().equalsIgnoreCase("comentariodopatologista") || ele.getNome().equalsIgnoreCase("metodo") || ele.getNome().equalsIgnoreCase("examenome") || ele.getNome().equalsIgnoreCase("valor") || ele.getNome().equalsIgnoreCase("valorreferencia") || ele.getNome().equalsIgnoreCase("interpretacao")) {
                valor = "<![CDATA[" + valor + "]]>";
            }
            xml.escrever(ele.getNome(), valor, ele.getMapaAtributos());
        } else {
            xml.abrir(ele.getNome(), ele.getMapaAtributos());
            for (ElementoHPardini filho : ele.getFilhos()) {
                ParserImportacaoSyslab.carregarXMLBuilder(xml, filho);
            }
            xml.fechar(ele.getNome());
        }
    }
}

