/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.syslab.ExameSyslab;
import jalis.laboratorio.util.parsers.syslab.ParserImportacaoSyslab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ImportacaoSyslab
extends AbstractImportadorLabExterno {
    private File arquivoExames = null;
    public String configuracoes = null;

    public ImportacaoSyslab(int codigoLabExterno, String configuracoes) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Syslab a partir de arquivo XLS", codigoLabExterno, Protocolo.Syslab);
        this.configuracoes = configuracoes;
    }

    public ImportacaoSyslab(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Syslab a partir de arquivo XLS", codigoLabExterno, Protocolo.Syslab);
        this.getButtonImportar().setText("Importar Exames");
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
    }

    public File lerArquivoExames() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS do Lab. Syslab (*.xls)", "xls"));
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    @Override
    public boolean importarArquivo() {
        boolean retorno = false;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS do Lab. ".concat(this.protocolo.name()).concat(" (*.xls)"), "xls"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = chooser.getSelectedFile();
                String arquivo = ImportacaoSyslab.lerArquivoXls(new FileInputStream(file));
                StringBuilder bui = new StringBuilder();
                this.setTextoInformacoes("");
                this.anexarTextoInformacoes("Importando exames...\n");
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Map<String, ExameSyslab> excluidos = ParserImportacaoSyslab.importarExamesSyslab(arquivo, this.codigoLabExterno, this.progress, this);
                this.anexarTextoInformacoes(bui.append("\nImporta\u00e7\u00e3o conclu\u00edda").toString());
                Thread.sleep(50L);
                if (excluidos.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("+--------+-------------------------------------------------------------------------+\n");
                    bui.append("| CODIGO | DESCRI\u00c7\u00c3O EXAME                                                         |\n");
                    bui.append("+--------+-------------------------------------------------------------------------+");
                    for (String ex : excluidos.keySet()) {
                        bui.append("\n| ").append(StringUtil.formatarColuna(Funcoes.preencheZero(excluidos.get(ex).getCodigoExame(), 6), 7, 'e'));
                        bui.append("| ").append(StringUtil.formatarColuna(excluidos.get(ex).getDescricaoExame(), 73, 'e')).append("|");
                    }
                    bui.append("\n+--------+-------------------------------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                this.progress.setVisible(false);
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel importar arquivo - Lab. ".concat(this.protocolo.name()).concat(" ").concat(e.getMessage()), e.getStackTrace());
        }
        return retorno;
    }

    public static String lerArquivoXls(InputStream input) {
        StringBuilder buf = new StringBuilder();
        try {
            new WorkbookFactory();
            Workbook workbook = WorkbookFactory.create((InputStream)input);
            Sheet sheet = null;
            sheet = workbook.getSheet("TabelaCompleta");
            for (Row row : sheet) {
                Iterator cellIterator = row.cellIterator();
                boolean qt = false;
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    switch (cell.getCellType()) {
                        case 0: {
                            buf.append(cell.getNumericCellValue()).append(";");
                            break;
                        }
                        case 1: {
                            buf.append(cell.getStringCellValue()).append(";");
                        }
                    }
                }
                buf.replace(buf.length() - 1, buf.length(), "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }
}

