/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaHPardini;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.syslab.ExameMaterialSyslab;
import jalis.laboratorio.util.parsers.syslab.ExameSyslab;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class ExportacaoParaSyslab
extends ExportacaoParaHPardini
implements Exportador {
    public static final String TAG_UTILIZAR_MAT_REQUISICAO = "utilizar-mat-requisicao";
    public static final String TAG_MATERIAL_SELECIONADO = "material-selecionado";
    public static final String TAG_CONSERVANTE_SELECIONADO = "conservante-selecionado";
    public static final String TAG_VERSAO = "Versao";
    public static final String TAG_COD_APOIADO = "CodApoiado";
    public static final String TAG_MEDICAMENTOS = "Medicamentos";
    public static final String TAG_CLIENTE = "Cliente";
    public static final String TAG_DATA_NASCIMENTO = "DataNascimento";
    public static final String TAG_MNEMONICO_EXAME = "MnemonicoExame";
    public static final String TAG_MNEMONICO_MATERIAL = "MnemonicoMaterial";
    public static final String TAG_ID_ENVIO = "IdEnvio";
    public static final String TAG_DATA_HORA_ENVIO = "DataHoraEnvio";
    public static final String TAG_CODIGO_PEDIDO_APOIO = "CodigoPedidoApoio";
    public static final String TAG_DATA_HORA_PEDIDO = "DataHoraPedido";
    public static final String TAG_INFO_ADICIONAIS = "InfoAdicionais";
    public static final String TAG_COD_CLIENTE = "CodigoCliente";
    public static final String TAG_IDADE = "Idade";
    public static final String TAG_DATA_HORA_COLETA = "DataHoraColeta";
    private XMLStringBuilder xml = new XMLStringBuilder(true);

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        return this.processa(codigoLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, st, isColetaWeb, arquivar, agruparInterface, agruparMultiguia, digitosTuboFilial, digitosTuboRequisicao);
    }

    private RetornoImpressaoEtiquetas processa(String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<Registro> lista = new ArrayList<Registro>();
        for (Registro requisicao : requisicoes) {
            lista.add(requisicao.clone());
        }
        try {
            for (Registro registro : requisicoes) {
                ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
                ArrayList<String> listExa = new ArrayList<String>();
                int[] arrayMat = new int[listaExames.size()];
                for (Registro exa : listaExames) {
                    listExa.add(exa.getString("exa_codigo"));
                    arrayMat[listExa.size() - 1] = Integer.parseInt(exa.getString("mco_codigo"));
                }
                Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
            }
            String codigoLaboratorio = StringUtil.getValor(configuracaoLabExterno, "codigoLaboratorio");
            this.gerarXML(numeroLote, codigoLaboratorio, requisicoes, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, isColetaWeb, retorno);
            String nomeArquivo = "ENV_" + Funcoes.preencheZero(codigoLaboratorio, 6) + Funcoes.formataData("_yyyyMMddHHmmss", new Date()) + ".xml";
            if (isColetaWeb) {
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(this.xml.getXML());
            } else {
                this.gerarArquivo(this.xml.getXML(), new File(nomeArquivo), reenvio, "Arquivo de exporta\u00e7\u00e3o Syslab (*.xml)");
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception ex) {
            try {
                if (!reenvio) {
                    ExportacaoParaSyslab.removerLote(codigoLabExterno, lista, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ex.getMessage() != null) {
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno(ex.getMessage(), Protocolo.Syslab.getDescricao(), retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), ex.getMessage(), 2);
                }
            }
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private void gerarXML(String numeroLote, String codigoConvenio, List<Registro> requisicoes, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb, RetornoImpressaoEtiquetas retorno) throws XMLStringBuilderException, ParseException {
        this.xml.escreveHeader("1.0", "ISO-8859-1");
        this.xml.abrir("Registro");
        this.xml.escrever(TAG_VERSAO, "1.0");
        this.xml.escrever(TAG_COD_APOIADO, codigoConvenio);
        this.xml.escrever(TAG_ID_ENVIO, numeroLote);
        this.xml.escrever(TAG_DATA_HORA_ENVIO, Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
        requisicoes = ExportacaoParaSyslab.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        for (Registro req : requisicoes) {
            this.criarPedido(req, digitosTuboFilial, digitosTuboRequisicao, st, isColetaWeb, retorno);
        }
        this.xml.fechar("Registro");
    }

    private void criarPedido(Registro req, int digitosTuboFilial, int digitosTuboRequisicao, Statement st, boolean isColetaWeb, RetornoImpressaoEtiquetas retorno) throws XMLStringBuilderException, ParseException {
        this.xml.abrir("Pedido");
        this.xml.escrever(TAG_CODIGO_PEDIDO_APOIO, Funcoes.preencheZero(req.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(req.getString("req_codigo"), digitosTuboRequisicao));
        this.xml.escrever(TAG_DATA_HORA_PEDIDO, Funcoes.formataData("dd/MM/yyyy", req.getDate("req_data")) + " " + req.getString("req_hora"));
        this.xml.escrever(TAG_MEDICAMENTOS, StringUtil.limpaXmlEnvioWebService(ExportacaoParaSyslab.getMedicamento(req.getString("fil_codigo"), req.getString("req_codigo"), st, isColetaWeb, retorno)));
        this.trataCampoObservacao(req);
        String obs = req.getString("req_obs");
        this.xml.escrever(TAG_INFO_ADICIONAIS, obs);
        this.xml.abrir(TAG_CLIENTE);
        this.xml.escrever(TAG_COD_CLIENTE, req.getString("pac_codigo"));
        this.xml.escrever("Nome", StringUtil.limpaXmlEnvioWebService(req.getString("pac_nome")));
        this.xml.escrever("Sexo", req.getString("pac_sexo"));
        this.xml.escrever(TAG_DATA_NASCIMENTO, Funcoes.formataData("dd/MM/yyyy", req.getDate("pac_datanasc")));
        this.xml.escrever(TAG_IDADE, req.getString("req_idade"));
        this.xml.fechar(TAG_CLIENTE);
        List listaExames = (List)req.getValor("listaexames");
        Map<ExameMaterialSyslab, Integer> exaSyslab = null;
        ArrayList<String> listaExamesAdicionados = new ArrayList<String>();
        for (Registro exa : listaExames) {
            String key = exa.getString("exa_codigo") + exa.getString("mco_codigo");
            if (listaExamesAdicionados.contains(key)) continue;
            List listaExamesDesmembrados = (List)exa.getValor("listaexames");
            if (listaExamesDesmembrados != null && !listaExamesDesmembrados.isEmpty()) {
                for (Registro desm : listaExamesDesmembrados) {
                    exaSyslab = this.carregarExamesSyslab(listaExamesDesmembrados);
                    key = desm.getString("exa_codigo") + desm.getString("mco_codigo");
                    if (listaExamesAdicionados.contains(key)) continue;
                    this.gravarDadosExame(desm);
                    listaExamesAdicionados.add(key);
                }
                continue;
            }
            exaSyslab = this.carregarExamesSyslab(listaExames);
            this.gravarDadosExame(exa);
            listaExamesAdicionados.add(key);
        }
        this.xml.fechar("Pedido");
    }

    private void gravarDadosExame(Registro exa) throws XMLStringBuilderException, ParseException {
        this.xml.abrir("Exame");
        this.xml.escrever(TAG_MNEMONICO_EXAME, exa.getString("codigoExame"));
        this.xml.escrever(TAG_MNEMONICO_MATERIAL, exa.getString("codigoMaterial"));
        this.xml.escrever(TAG_DATA_HORA_COLETA, this.formatar("dd/MM/yyyy HH:mm:ss", exa.getDate("exr_datamaterial")));
        this.xml.fechar("Exame");
    }

    protected Map<ExameMaterialSyslab, Integer> carregarExamesSyslab(List<Registro> exames) {
        HashMap<ExameMaterialSyslab, Integer> map = new HashMap<ExameMaterialSyslab, Integer>();
        for (Registro exa : exames) {
            ExameSyslab esys = ExameSyslab.novaInstancia(exa.getString("ele_xmllabexterno"));
            if (esys != null) {
                exa.setValor("codigoExame", esys.getCodigoExame());
                exa.setValor("codigoMaterial", esys.getMaterial());
            }
            map.put(new ExameMaterialSyslab(esys.getCodigoExame(), esys.getMaterial()), 0);
        }
        return map;
    }

    public static String getMedicamento(String filial, String requisicao, Statement st, boolean isColetaWeb, RetornoImpressaoEtiquetas retorno) {
        String medicamento = "N\u00e3o usa";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" select mto_descricao \n");
                bui.append("   from medicamentos m \n");
                bui.append(" left join requisicaomedicamento rm on rm.fil_codigo = m.fil_codigo and rm.mto_codigo = m.mto_codigo ");
                bui.append("  where rm.fil_codigo = ").append(filial).append(" and \n");
                bui.append("  rm.req_codigo = '").append(requisicao).append("'");
                ResultSet res = st.executeQuery(bui.toString());
                if (res.next()) {
                    medicamento = res.getString("mto_descricao");
                }
            }
            catch (SQLException e) {
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno(e.getMessage(), Protocolo.Syslab.getDescricao(), retorno);
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return medicamento;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void trataCampoObservacao(Registro req) {
        String observacao = req.getValor("req_obs", String.class);
        if (!Funcoes.textoVazio(observacao)) {
            observacao = StringUtil.removerAcentos(observacao).replaceAll("[^a-zA-Z1-9: ]", "");
            req.setValor("req_obs", observacao);
        }
    }
}

