/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.syslab.CampoSyslab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExameSyslab {
    public static final String TAG_PROTOCOLO = "syslab";
    public static final String TAG_CODIGO_EXAME = "codigoExame";
    public static final String TAG_DESCRICAO_EXAME = "descricaoExame";
    public static final String TAG_MATERIAL = "material";
    public static final String TAG_DESCRICAO_MATERIAL = "descricaoMaterial";
    public static final String TAG_CAMPOS = "camposExame";
    public static final String TAG_COD_FORMULARIO = "codFormulario";
    public static final String TAG_DESCRICAO_FORMULARIO = "descricaoFormulario";
    public static final String TAG_MNEMONICO_CAMPO = "mnemonicoCampo";
    public static final String TAG_DESCRICAO_CAMPO = "descricaoCampo";
    private Map<String, String> camposRelacionamento;
    private String descricaoExame;
    private String codigoExame;
    private String material;
    private String descricaoMaterial;
    private String codFormulario;
    private String descricaoFormulario;
    private String mnemonicoCampo;
    private String descricaoCampo;
    private List<CampoSyslab> campos;
    private String exameJalis;
    private String materialJalis;
    private String laboratorioExternoJalis;

    public ExameSyslab() {
        this.campos = new ArrayList<CampoSyslab>();
        this.camposRelacionamento = new HashMap<String, String>();
    }

    public ExameSyslab(String codigoExame, String descricaoExame, String material, String descricaoMaterial, String codFormulario, String descricaoFormulario) {
        this.campos = new ArrayList<CampoSyslab>();
        this.camposRelacionamento = new HashMap<String, String>();
        this.codigoExame = codigoExame;
        this.descricaoExame = descricaoExame;
        this.material = material;
        this.descricaoMaterial = descricaoMaterial;
        this.codFormulario = codFormulario;
        this.descricaoFormulario = descricaoFormulario;
    }

    public ExameSyslab(String xml) {
        this.camposRelacionamento = new HashMap<String, String>();
        this.parseXml(xml);
    }

    public String getDescricaoExame() {
        return this.descricaoExame;
    }

    public void setDescricaoExame(String descricaoExame) {
        this.descricaoExame = descricaoExame;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public List<CampoSyslab> getCampos() {
        return Collections.unmodifiableList(this.campos);
    }

    public void limparCampos() {
        this.campos.clear();
    }

    public void addCampo(CampoSyslab campo) {
        this.campos.add(campo);
    }

    public String getLaboratorioExternoJalis() {
        return this.laboratorioExternoJalis;
    }

    public void setLaboratorioExternoJalis(String laboratorioExternoJalis) {
        this.laboratorioExternoJalis = laboratorioExternoJalis;
    }

    public String getCodFormulario() {
        return this.codFormulario;
    }

    public void setCodFormulario(String codFormulario) {
        this.codFormulario = codFormulario;
    }

    public String getDescricaoFormulario() {
        return this.descricaoFormulario;
    }

    public void setDescricaoFormulario(String descricaoFormulario) {
        this.descricaoFormulario = descricaoFormulario;
    }

    public String getMnemonicoCampo() {
        return this.mnemonicoCampo;
    }

    public void setMnemonicoCampo(String mnemonicoCampo) {
        this.mnemonicoCampo = mnemonicoCampo;
    }

    public String getDescricaoCampo() {
        return this.descricaoCampo;
    }

    public void setDescricaoCampo(String descricaoCampo) {
        this.descricaoCampo = descricaoCampo;
    }

    public void setCampos(List<CampoSyslab> campos) {
        this.campos = campos;
    }

    public String getDescricaoMaterial() {
        return this.descricaoMaterial;
    }

    public void setDescricaoMaterial(String descricaoMaterial) {
        this.descricaoMaterial = descricaoMaterial;
    }

    public Map<String, String> getCamposRelacionamento() {
        return this.camposRelacionamento;
    }

    public void addCampoRelacionamento(String campo, String descricao) {
        this.camposRelacionamento.put(campo, descricao);
    }

    public void setCamposRelacionamento(Map<String, String> camposRelacionamento) {
        this.camposRelacionamento = camposRelacionamento;
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_PROTOCOLO);
            xml.escrever(TAG_CODIGO_EXAME, this.getCodigoExame().toString());
            xml.escrever(TAG_DESCRICAO_EXAME, this.getDescricaoExame());
            xml.escrever(TAG_MATERIAL, this.getMaterial());
            xml.escrever(TAG_DESCRICAO_MATERIAL, this.getDescricaoMaterial());
            xml.escrever(TAG_COD_FORMULARIO, this.getCodFormulario());
            xml.escrever(TAG_DESCRICAO_FORMULARIO, this.getDescricaoFormulario());
            xml.escrever(TAG_MNEMONICO_CAMPO, this.getMnemonicoCampo());
            xml.escrever(TAG_DESCRICAO_CAMPO, this.getDescricaoCampo());
            xml.abrir(TAG_CAMPOS);
            if (null != this.camposRelacionamento) {
                for (String campos : this.camposRelacionamento.keySet()) {
                    xml.abrir("campo");
                    xml.escrever(StringUtil.getTag("nome", campos));
                    xml.escrever(StringUtil.getTag("descricao", this.camposRelacionamento.get(campos)));
                    xml.fechar("campo");
                }
                this.camposRelacionamento.clear();
            }
            xml.fechar(TAG_CAMPOS);
            xml.fechar(TAG_PROTOCOLO);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExameSyslab");
        }
        return xml.getXML();
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorSyslab = StringUtil.getValor(xml, TAG_PROTOCOLO);
        return valorSyslab != null && valorSyslab.trim().length() > 0 && (valorExame = StringUtil.getValor(valorSyslab, TAG_CODIGO_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public void atualizaXml(String codigoLabExterno) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("update examessyslab \n");
                bui.append(" set sys_xml = '").append(StringUtil.textoDB(this.getXml())).append("' ");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" \n");
                bui.append(" and  lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append(" and  sys_codexame = '").append(this.getCodigoExame()).append("' ");
                SQL = bui.toString();
                Conexao.executeUpdate(Variaveis.filialPadrao, st, SQL);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
    }

    public static Set<ExameSyslab> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameSyslab> list = new HashSet<ExameSyslab>();
        if (res.first()) {
            do {
                list.add(new ExameSyslab(res));
            } while (res.next());
        }
        return list;
    }

    public static List<ExameSyslab> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameSyslab> exames = new ArrayList<ExameSyslab>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" select * \n");
                bui.append("   from examessyslab \n");
                bui.append("  where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("        lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("  order by sys_codexame ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    ExameSyslab exa = new ExameSyslab(res.getString("sys_xml"));
                    exa.setCodigoExame(res.getString("sys_codexame"));
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return exames;
    }

    public ExameSyslab(ResultSet res) throws SQLException {
        this.campos = new ArrayList<CampoSyslab>();
        this.camposRelacionamento = new HashMap<String, String>();
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.laboratorioExternoJalis = res.getString("lae_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    public void parseXml(String xml) {
        if (xml != null) {
            this.codigoExame = StringUtil.getValor(xml, TAG_CODIGO_EXAME);
            this.descricaoExame = StringUtil.getValor(xml, TAG_DESCRICAO_EXAME);
            this.material = StringUtil.getValor(xml, TAG_MATERIAL);
            this.descricaoMaterial = StringUtil.getValor(xml, TAG_DESCRICAO_MATERIAL);
            this.codFormulario = StringUtil.getValor(xml, TAG_COD_FORMULARIO);
            this.descricaoFormulario = StringUtil.getValor(xml, TAG_DESCRICAO_FORMULARIO);
            this.campos = new ArrayList<CampoSyslab>();
            for (String tag : StringUtil.getValores(xml, "campo")) {
                CampoSyslab campo = new CampoSyslab();
                String nome = StringUtil.getValor(tag, "nome");
                String descricao = StringUtil.getValor(tag, "descricao");
                campo.setCodigo(nome);
                campo.setComentario(descricao);
                campo.setResultado(nome);
                this.addCampoRelacionamento(nome, descricao);
                this.addCampo(campo);
            }
        }
    }

    public static ExameSyslab novaInstancia(String xml) {
        Funcoes.validarNaoNull(xml, "xml");
        ExameSyslab exa = new ExameSyslab();
        exa.parseXml(xml);
        return exa;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExameSyslab)) {
            return false;
        }
        ExameSyslab e = (ExameSyslab)o;
        return e.codigoExame.equals(this.codigoExame);
    }
}

