/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.DialogoCamposImportacaoSelecionavel;
import jalis.laboratorio.util.parsers.unilab.ServiceImportacaoUnilab;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class DialogoCamposImportacaoSyslab
extends DialogoCamposImportacaoSelecionavel {
    private String campoSelecionado = "";
    private JTabbedPane abaCampos;
    private HashMap<String, String[]> campos;
    private ServiceImportacaoUnilab siu;

    public static DialogoCamposImportacaoSyslab novaInstancia(Object pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        if (pai instanceof Frame) {
            return new DialogoCamposImportacaoSyslab((Frame)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        if (pai instanceof Dialog) {
            return new DialogoCamposImportacaoSyslab((Dialog)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        return null;
    }

    public DialogoCamposImportacaoSyslab(Frame pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. Syslab", camposImportacao, listaExamesDesmLabExterno);
    }

    public DialogoCamposImportacaoSyslab(Dialog pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. Syslab", camposImportacao, listaExamesDesmLabExterno);
    }

    @Override
    public void iniciar(Object camposImportacao) {
        this.modelo = new ModeloGridTable(new String[]{"Linha", "Descri\u00e7\u00e3o"});
        this.table = ComponenteFactory.novoJTable((TableModel)this.modelo, 0, 0);
        this.scroll = new JScrollPane(this.table);
        this.getPanelCentral().setLayout(new BorderLayout());
        if (this.listaExamesDesmLabExterno != null && !this.listaExamesDesmLabExterno.isEmpty()) {
            for (CamposImportacao campo : this.listaExamesDesmLabExterno) {
                this.comboDesm.addItem(campo.getCodigoExame());
                this.mapTabs.put(campo.getCodigoExame(), campo);
            }
            this.carregaCamposImportacao(((CamposImportacao)this.listaExamesDesmLabExterno.get(0)).getCamposImportacao());
            this.getComboDesm().setBorder(new TitledBorder("Desmembramento"));
            this.getPanelCentral().add((Component)this.comboDesm, "North");
        } else {
            this.carregaCamposImportacao(camposImportacao);
        }
        this.comboDesm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CamposImportacao campo = DialogoCamposImportacaoSyslab.this.getMapTabs().get(DialogoCamposImportacaoSyslab.this.getComboDesm().getSelectedItem());
                DialogoCamposImportacaoSyslab.this.carregaCamposImportacao(campo.getCamposImportacao());
            }
        });
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.setSize(new Dimension(800, 500));
        ScreenUtil.centralizar(this);
    }

    private void carregaCamposImportacao(Object camposImportacao) {
        this.modelo.clear();
        HashMap linhas = (HashMap)camposImportacao;
        for (String s : linhas.keySet()) {
            Object[] linha = new String[]{s, (String)linhas.get(s)};
            this.modelo.addLine(linha);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(true);
    }

    @Override
    public boolean getOK() {
        return this.ok;
    }

    @Override
    public void setCampoSelecionado(String campoSelecionado) {
        if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("@") && campoSelecionado.contains("#")) {
            Scanner scanner = new Scanner(campoSelecionado).useDelimiter("\\@");
            campoSelecionado = scanner.next();
            scanner = new Scanner(scanner.next()).useDelimiter("\\#");
            String exameDesmSelecionado = scanner.next();
            String materialPaiDesm = scanner.next();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        } else if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("#")) {
            String exameDesmSelecionado = campoSelecionado.split("#")[1];
            campoSelecionado = campoSelecionado.split("#")[0].trim();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.getValueAt(i, 0).toString().equalsIgnoreCase(campoSelecionado)) continue;
            this.table.setRowSelectionInterval(i, i);
        }
    }
}

