/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.syslab.ExameSyslab;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorSyslab
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String MATERIAL_EXAME = "materialExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String OBJ_EXAME_SYSLAB = "objExameSyslab";
    private ModeloResultSet modExa = new ModeloResultSet("Mnem\u00f4nico", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "materialExame");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 80, 0, 80, 50);
    private JTextField textLocalizar = new JTextField();
    private JTextField textMaterial = ComponenteFactory.novoTTextField(8, 3);
    private JTextField textDescricaoFormulario = ComponenteFactory.novoTTextField(50, 3);
    private JPanel panelMaterial = new JPanel();
    private String xmlSelecionado = "";

    public ConfiguradorSyslab(Frame pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorSyslab(Dialog pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorSyslab novaInstancia(Object pai, String codigoLabExterno, String titulo) {
        if (pai instanceof Frame) {
            return new ConfiguradorSyslab((Frame)pai, codigoLabExterno, titulo);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorSyslab((Dialog)pai, codigoLabExterno, titulo);
        }
        return null;
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameSyslab.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameSyslab exa = new ExameSyslab(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                ExameSyslab exame = new ExameSyslab();
                if (reg != null) {
                    exame = (ExameSyslab)reg.getValor(OBJ_EXAME_SYSLAB);
                }
                if (Funcoes.textoVazio(exame.getCodigoExame()) || !exa.getCodigoExame().equals(exame.getCodigoExame()) || !exame.getMaterial().equals(exa.getMaterial())) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.panelMaterial.setPreferredSize(new Dimension(650, 22));
        this.textDescricaoFormulario.setPreferredSize(new Dimension(650, 22));
        this.textDescricaoFormulario.setEditable(false);
        this.panelMaterial = ComponenteFactory.novoJPanelBorderLayout(this.textDescricaoFormulario, null, null, null, ComponenteFactory.novoJLabel("Descri\u00e7\u00e3o: ", 'F', new Dimension(70, 22), this.textDescricaoFormulario));
        this.panelMaterial.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Descri\u00e7\u00e3o formul\u00e1rio", null, null, null, null, (Component)this.panelMaterial), "South");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorSyslab.this.modExa.filtrar(ConfiguradorSyslab.DESC_EXA, ConfiguradorSyslab.this.textLocalizar.getText());
                if (ConfiguradorSyslab.this.modExa.getRowCount() > 0) {
                    ConfiguradorSyslab.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSyslab.this.tableExa.hasFocus() && (row = ConfiguradorSyslab.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorSyslab.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorSyslab.this.tableExa.scrollRectToVisible(ConfiguradorSyslab.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSyslab.this.tableExa.hasFocus() && (row = ConfiguradorSyslab.this.tableExa.getSelectedRow()) < ConfiguradorSyslab.this.tableExa.getRowCount() - 1) {
                    ConfiguradorSyslab.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorSyslab.this.tableExa.scrollRectToVisible(ConfiguradorSyslab.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (ExameSyslab exame : ExameSyslab.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigoExame());
            reg.setValor(DESC_EXA, exame.getDescricaoExame());
            reg.setValor(MATERIAL_EXAME, exame.getDescricaoMaterial());
            reg.setValor(OBJ_EXAME_SYSLAB, exame);
            this.modExa.addRegistro(reg);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.textMaterial.setText(((ExameSyslab)reg.getValor(OBJ_EXAME_SYSLAB)).getDescricaoMaterial());
            this.textDescricaoFormulario.setText(((ExameSyslab)reg.getValor(OBJ_EXAME_SYSLAB)).getDescricaoFormulario());
        }
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameSyslab exa = new ExameSyslab(xml);
            return exa.getCodigoExame() + "|" + exa.getMaterial() + "|";
        }
        return "";
    }

    @Override
    public boolean acaoOk() {
        ExameSyslab exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        ExameSyslab exa = this.getExameSelecionado();
        if (exa != null) {
            this.xmlSelecionado = exa.getXml();
            return true;
        }
        return false;
    }

    private ExameSyslab getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameSyslab)reg.getValor(OBJ_EXAME_SYSLAB);
        }
        return null;
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            ExameSyslab exa = new ExameSyslab(xml);
            return exa.getDescricaoExame();
        }
        return "";
    }
}

