/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.syslab;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ConfiguradorProtocoloSyslab
extends AbstractConfiguradorProtocolo {
    private TTextField textCodigoLaboratorio = ComponenteFactory.novoTTextField(10, 1, this);
    public static final String TAG_CODIGO_LABORATORIO = "codigoLaboratorio";

    public static ConfiguradorProtocoloSyslab novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloSyslab((Frame)pai, "Configurador Syslab", codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloSyslab((Dialog)pai, "Configurador Syslab", codigoLabExterno);
        }
        return null;
    }

    public ConfiguradorProtocoloSyslab(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    public ConfiguradorProtocoloSyslab(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    private void montarTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(179, 20));
        JLabel labelCodigoLaboratorio = ComponenteFactory.novoJLabel(" C\u00f3digo do laborat\u00f3rio (apoiado):", new Dimension(210, 20));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        this.getPanelCentral().add((Component)labelLote, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelCodigoLaboratorio, cons);
        ++cons.gridx;
        cons.gridy = 0;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.getPanelCentral().add((Component)this.textLote, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.textCodigoLaboratorio, cons);
        this.setSize(new Dimension(350, 160));
        this.setLocationRelativeTo(this.getParent());
        ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<").append(Protocolo.Syslab.toString()).append(">");
        bui.append(StringUtil.getTag(TAG_CODIGO_LABORATORIO, this.textCodigoLaboratorio.getText()));
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        return bui.append("</").append(Protocolo.Syslab.toString()).append(">").toString();
    }

    @Override
    public boolean acaoOk() {
        return !Funcoes.textoVazio(this.textCodigoLaboratorio) && !Funcoes.textoVazio(this.textLote);
    }

    @Override
    public int getNumeroLote() {
        if (Funcoes.textoVazio(this.textLote)) {
            return 0;
        }
        return Integer.parseInt(this.textLote.getText());
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, Protocolo.Syslab.toString());
            this.textCodigoLaboratorio.setText(StringUtil.getValor(xml, TAG_CODIGO_LABORATORIO));
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
        }
    }
}

