/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucaov2;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.db2.ParserImportacaoDB;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParseImportacaoSolucaoV2
extends ParserImportacaoDB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    @Override
    public Map<String, Registro> parseXml(JFileChooser chooser, int codigoLabExterno) {
        Document doc = this.analisarXML(chooser.getSelectedFile());
        if (doc == null) {
            return null;
        }
        Element raiz = doc.getDocumentElement();
        return ParseImportacaoSolucaoV2.parse(XMLUtil.getElementosFilhos(raiz), codigoLabExterno);
    }

    public static Map<String, Registro> parse(List<Element> elements, int codigoLabExterno) {
        HashMap<String, Registro> examesCadastro = new HashMap<String, Registro>();
        for (Element exame : elements) {
            if (!exame.getNodeName().equalsIgnoreCase("exame")) continue;
            HashMap<String, Registro> parametrosCadastro = new HashMap<String, Registro>();
            ArrayList<Registro> parametrosRegiaoColeta = new ArrayList<Registro>();
            List<Element> fields = XMLUtil.getElementosFilhos(exame);
            Registro reg = new Registro();
            for (Element field : fields) {
                Registro parametro;
                if (field.getNodeName().equalsIgnoreCase("cd_exame")) {
                    reg.setValor("cd_exame", field.getTextContent());
                    reg.setValor("cd_db", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("cd_db")) {
                    reg.setValor("cd_db", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("ds_exame")) {
                    reg.setValor("ds_exame", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("sinonimo")) {
                    reg.setValor("sinonimo", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("metodologia")) {
                    reg.setValor("metodologia", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("material")) {
                    reg.setValor("material", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("volume_obrigatorio")) {
                    reg.setValor("volume_obrigatorio", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("peso_e_altura_obrigatorio")) {
                    reg.setValor("peso_e_altura_obrigatorio", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("peso_obrigatorio")) {
                    reg.setValor("peso_obrigatorio", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("altura_obrigatorio")) {
                    reg.setValor("altura_obrigatorio", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("data_alteracao_laudo")) {
                    reg.setValor("data_alteracao_laudo", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("alterar_Material")) {
                    reg.setValor("alterar_Material", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("texto_padrao")) {
                    reg.setValor("texto_padrao", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("parametro")) {
                    parametro = new Registro();
                    ParseImportacaoSolucaoV2.getAtributo(field, parametro, "sequencia");
                    ParseImportacaoSolucaoV2.getAtributo(field, parametro, "cd_parametro");
                    ParseImportacaoSolucaoV2.getAtributo(field, parametro, "ds_parametro");
                    ParseImportacaoSolucaoV2.getAtributo(field, parametro, "unidade");
                    ParseImportacaoSolucaoV2.getAtributo(field, parametro, "tipo");
                    ParseImportacaoSolucaoV2.getAtributo(field, parametro, "metodologia_parametro");
                    ParseImportacaoSolucaoV2.getAtributo(field, parametro, "possui_vr");
                    if (field.hasChildNodes()) {
                        List<Element> parametrosFilho = XMLUtil.getElementosFilhos(field);
                        for (Element param : parametrosFilho) {
                            if (param.getNodeName().equalsIgnoreCase("texto_padrao")) {
                                parametro.setValor("texto_padrao", param.getTextContent());
                                continue;
                            }
                            if (!param.getNodeName().equalsIgnoreCase("valorReferencia")) continue;
                            Registro valorReferencia = new Registro();
                            ParseImportacaoSolucaoV2.getAtributo(param, valorReferencia, "cd_exame");
                            ParseImportacaoSolucaoV2.getAtributo(param, valorReferencia, "cd_db");
                            ParseImportacaoSolucaoV2.getAtributo(param, valorReferencia, "cd_parametro");
                            ParseImportacaoSolucaoV2.getAtributo(param, valorReferencia, "data");
                            ParseImportacaoSolucaoV2.getAtributo(param, valorReferencia, "sexo");
                            ParseImportacaoSolucaoV2.getAtributo(param, valorReferencia, "idade");
                            ParseImportacaoSolucaoV2.getAtributo(param, valorReferencia, "idade_dias");
                            if (param.hasChildNodes()) {
                                List<Element> valoresReferencia = XMLUtil.getElementosFilhos(param);
                                StringBuilder valoresRef = new StringBuilder();
                                for (Element vlrRef : valoresReferencia) {
                                    if (!vlrRef.getNodeName().equalsIgnoreCase("valorReferencia") || Funcoes.textoVazio(vlrRef.getTextContent())) continue;
                                    valoresRef.append(vlrRef.getTextContent()).append("\n");
                                }
                                valorReferencia.setValor("valorRef", valoresRef.toString());
                            }
                            parametro.setValor("valorReferencia", valorReferencia);
                        }
                    }
                    parametrosCadastro.put(parametro.getString("sequencia"), parametro);
                    continue;
                }
                if (!field.getNodeName().equalsIgnoreCase("REGIAO_COLETA")) continue;
                parametro = new Registro();
                ParseImportacaoSolucaoV2.getAtributo(field, parametro, "CD_REGIAO_COLETA");
                ParseImportacaoSolucaoV2.getAtributo(field, parametro, "DS_REGIAO_COLETA");
                parametrosRegiaoColeta.add(parametro);
            }
            reg.setValor("parametro", parametrosCadastro);
            reg.setValor("REGIOES_COLETA", parametrosRegiaoColeta);
            examesCadastro.put(reg.getString("cd_db"), reg);
        }
        return examesCadastro;
    }
}

