/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucaov2;

import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.db2.ImportacaoDB;
import jalis.laboratorio.util.parsers.solucaov2.ParseImportacaoSolucaoV2;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.util.Map;
import javax.swing.JFileChooser;

public class ImportacaoSolucao
extends ImportacaoDB {
    public ImportacaoSolucao(int codigoLabExterno) {
        super(codigoLabExterno, "Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Solu\u00e7\u00e3o v2", Protocolo.SolucaoV2);
    }

    @Override
    public boolean importarArquivo() {
        boolean retorno = true;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS/XML do Lab. " + this.protocolo.getCodigo() + " (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                StringBuilder bui = new StringBuilder();
                bui.append("Importando exames...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Map<String, Registro> excluidos = new ParseImportacaoSolucaoV2().importarExamesDB(chooser, this.codigoLabExterno, this.progress);
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (!excluidos.isEmpty()) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (Registro e : excluidos.values()) {
                        bui.append("\n\t|").append(StringUtil.formatarColuna(e.getString("cd_exame"), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getString("material"), 50, 'c')).append("|");
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoDB: 67");
        }
        this.progress.setVisible(false);
        return retorno;
    }
}

