/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucaov2;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.alvaro.ConfiguradorProtocoloAlvaro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;

public class ConfiguradorProtocoloSolucao
extends ConfiguradorProtocoloAlvaro {
    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloSolucao((Frame)pai, "Laborat\u00f3rio Solu\u00e7\u00e3o V2", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloSolucao((Dialog)pai, "Laborat\u00f3rio Solu\u00e7\u00e3o V2", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloSolucao(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
    }

    public ConfiguradorProtocoloSolucao(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
    }

    @Override
    public void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Lote atual:", new Dimension(85, 20)), cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(new Dimension(120, 20));
        this.textLote.setMinimumSize(new Dimension(120, 20));
        this.textLote.setText("0");
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(85, 20)), cons);
        cons.gridx = 1;
        this.textCodigo.setPreferredSize(new Dimension(120, 20));
        this.textCodigo.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Chave:", new Dimension(85, 20)), cons);
        cons.gridx = 1;
        this.textChave.setPreferredSize(new Dimension(120, 20));
        this.textChave.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.textChave, cons);
        this.pack();
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLote);
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<solucao>");
        bui.append(StringUtil.getTag("codigoLote", this.textLote.getText()));
        bui.append(StringUtil.getTag("codigoProtocolo", this.textCodigo.getText()));
        bui.append(StringUtil.getTag("chave", this.textChave.getText()));
        return bui.append("</solucao>").toString();
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textChave.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado uma chave v\u00e1lida", 2);
            ScreenUtil.requisitarFoco(this.textChave);
        } else if (!this.textCodigo.getText().matches("\\d+")) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo v\u00e1lido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
        } else {
            return true;
        }
        return false;
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "solucao");
            this.textLote.setText(StringUtil.getValor(xml, "codigoLote"));
            this.textCodigo.setText(StringUtil.getValor(xml, "codigoProtocolo"));
            this.textChave.setText(StringUtil.getValor(xml, "chave"));
        }
    }
}

