/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucao.resultado;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardiniImpl;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserResultadoSolucao
extends ParserResultadoHPardini {
    public static final String ELEMENTO_EXAMES = "Exames";
    public static final String ELEMENTO_REGISTRO = "Registro";
    public static final String ELEMENTO_LOTE = "Lote";
    public static final String ELEMENTO_COD_EXAME = "CodExame";
    public static final String ELEMENTO_COD_MATERIAL = "CodMaterial";
    public static final String ELEMENTO_COD_AMOSTRA = "CodAmostra";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document analisarXML(File arquivo, ErrorHandler error) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo, error);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document analisarXML(InputStream stream, ErrorHandler error) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(stream, error);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    public static ElementoHPardini analisarXMLSolucao(File arquivoXML) throws ParserResultadoHPardiniException {
        ParserResultadoSolucao parser = new ParserResultadoSolucao();
        return parser.analisar(ParserResultadoSolucao.analisarXML(arquivoXML, ParserResultadoSolucao.getErrorHandler()));
    }

    public static ElementoHPardini analisarXMLSolucao(InputStream inputXML) throws ParserResultadoHPardiniException {
        ParserResultadoSolucao parser = new ParserResultadoSolucao();
        return parser.analisar(ParserResultadoSolucao.analisarXML(inputXML, ParserResultadoSolucao.getErrorHandler()));
    }

    @Override
    protected ElementoHPardini analisar(Document doc) throws ParserResultadoHPardiniException {
        ElementoHPardiniImpl resultado = null;
        if (doc != null) {
            Element raiz = doc.getDocumentElement();
            resultado = new ElementoHPardiniImpl(null, raiz.getNodeName());
            this.carregarAtributosEFilhos(resultado, raiz, XMLUtil.getElementosFilhos(raiz));
        }
        return resultado;
    }

    private void carregarAtributosEFilhos(ElementoHPardiniImpl elePai, Element pai, List<Element> filhos) {
        String atrID;
        String nome = pai.getNodeName();
        Map<String, String> atrs = XMLUtil.getAtributosDoElemento(pai);
        if (this.atrsID.containsKey(nome) && atrs.containsKey(atrID = (String)this.atrsID.get(nome))) {
            elePai.setAtributoID(atrID, atrs.get(atrID));
            atrs.remove(atrID);
        }
        for (String atr : atrs.keySet()) {
            elePai.setAtributo(atr, atrs.get(atr));
        }
        for (Element ele : filhos) {
            ElementoHPardiniImpl filho = this.addFilho(elePai, ele);
            this.carregarAtributosEFilhos(filho, ele, XMLUtil.getElementosFilhos(ele));
        }
    }

    private ElementoHPardiniImpl addFilho(ElementoHPardiniImpl eleHP, Element filho) {
        ElementoHPardiniImpl eleFilho = null;
        eleFilho = XMLUtil.contemElementosFilhos(filho) ? new ElementoHPardiniImpl(eleHP, filho.getNodeName()) : new ElementoHPardiniImpl(eleHP, filho.getNodeName(), filho.getTextContent());
        eleHP.addFilho(eleFilho);
        return eleFilho;
    }

    protected static ErrorHandler getErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Funcoes.mensagem(null, "O XML especificado est\u00e1 incorreto:\n" + exception.getMessage(), 1);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Funcoes.mensagem(null, "O XML especificado est\u00e1 incorreto:\n" + exception.getMessage(), 1);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }
        };
    }
}

