/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucao.resultado;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.laboratorio.util.parsers.solucao.resultado.CamposImportacaoHPardini;
import jalis.laboratorio.util.parsers.solucao.resultado.Elemento;
import jalis.laboratorio.util.parsers.solucao.resultado.ParserElemento;
import jalis.laboratorio.util.parsers.solucao.resultado.ParserResultadoSolucao;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;

public class CamposRelacionamentoSolucaoUtil {
    public static Map<String, Object> getMapCampoValor(Object origem) {
        if (origem != null) {
            Funcoes.validarInstanciaDe(ElementoHPardini.class, origem, "origem");
            ElementoHPardini superExa = (ElementoHPardini)origem;
            if (!superExa.getNome().equals("Exame")) {
                throw new IllegalArgumentException("A origem especificada n\u00e3o \u00e9 um elemento Exame");
            }
            LinkedList<String> ultimosCampo = new LinkedList<String>();
            HashMap<String, Object> mapa = new HashMap<String, Object>();
            CamposRelacionamentoSolucaoUtil.carregarCampos(mapa, superExa, "", ultimosCampo);
            return mapa;
        }
        return null;
    }

    public static void carregarCampos(Map<String, Object> mapa, ElementoHPardini ele, String caminho, List<String> ultimosCampo) {
        String novoCaminho = caminho + CamposRelacionamentoSolucaoUtil.getNomeAtributo(ele);
        if (!ele.contemFilhos()) {
            int x;
            mapa.put(novoCaminho, ele.getValor());
            if ((ele.getNome().equalsIgnoreCase("Valor") || ele.getNome().equalsIgnoreCase("Texto")) && (x = ele.getPai().getFilhos().indexOf(ele)) > 0) {
                mapa.put(ele.getPai().getFilhos().get(x - 1).getValor(), ele.getValor());
                ultimosCampo.add(ele.getPai().getFilhos().get(x - 1).getValor());
            }
            if (ele.getNome().equalsIgnoreCase("Metodo") || ele.getNome().equalsIgnoreCase("UnidadeMedida")) {
                mapa.put(ele.getNome(), ele.getValor());
            }
            if (ele.getNome().equalsIgnoreCase("ValorReferencia")) {
                StringBuilder vRef = new StringBuilder();
                if (mapa.containsKey(ele.getNome())) {
                    vRef.append(mapa.get(ele.getNome())).append("\n");
                }
                vRef.append(ele.getValor());
                mapa.put(ele.getNome(), vRef.toString());
                StringBuilder vRefCampo = new StringBuilder();
                if (mapa.containsKey(ele.getNome() + "_" + ultimosCampo.get(ultimosCampo.size() - 1))) {
                    vRefCampo.append(mapa.get(ele.getNome() + "_" + ultimosCampo.get(ultimosCampo.size() - 1))).append("\n");
                }
                vRefCampo.append(ele.getValor());
                mapa.put(ele.getNome() + "_" + ultimosCampo.get(ultimosCampo.size() - 1), vRefCampo.toString());
            }
        } else {
            novoCaminho = novoCaminho + "|";
            for (ElementoHPardini filho : ele.getFilhos()) {
                CamposRelacionamentoSolucaoUtil.carregarCampos(mapa, filho, novoCaminho, ultimosCampo);
            }
        }
    }

    public static String getStringCaminhoDeCampoSelecionado(ElementoHPardini[] caminho) {
        StringBuilder bui = new StringBuilder();
        for (ElementoHPardini ele : caminho) {
            if (bui.length() > 0) {
                bui.append('|');
            }
            bui.append(CamposRelacionamentoSolucaoUtil.getNomeAtributo(ele));
        }
        return bui.toString();
    }

    private static String getNomeAtributo(ElementoHPardini ele) {
        StringBuilder bui = new StringBuilder(ele.getNome());
        if (ele.contemAtributoID()) {
            bui.append(':');
            bui.append(ele.getNomeAtributoID());
            bui.append('=');
            bui.append(ele.getValorAtributoID());
        }
        return bui.toString();
    }

    public static ElementoHPardini getCampoDoSuperExame(ElementoHPardini superExame, String caminhoDoCampo) {
        Funcoes.validarNaoNull(superExame, "Registro");
        Funcoes.validarNaoNull(caminhoDoCampo, "caminhoDoCampo");
        if (!"Registro".equals(superExame.getNome())) {
            throw new IllegalArgumentException("O par\u00e2metro Registro n\u00e3o \u00e9 o elemento Registro do XML do Solu\u00e7\u00e3o");
        }
        ParserElemento parser = new ParserElemento(caminhoDoCampo);
        return CamposRelacionamentoSolucaoUtil.procurarCampo(superExame, parser.proximoElemento(), parser);
    }

    private static ElementoHPardini procurarCampo(ElementoHPardini eleHP, Elemento candidato, ParserElemento parser) {
        if (CamposRelacionamentoSolucaoUtil.iguais(eleHP, candidato.nome, candidato.idNome, candidato.idValor)) {
            if (!eleHP.contemFilhos()) {
                return eleHP;
            }
            Elemento novoCandidato = parser.proximoElemento();
            for (ElementoHPardini filho : eleHP.getFilhos()) {
                ElementoHPardini encontrado = CamposRelacionamentoSolucaoUtil.procurarCampo(filho, novoCandidato, parser);
                if (encontrado == null) continue;
                return encontrado;
            }
        }
        return null;
    }

    public static boolean iguais(ElementoHPardini elemento, String nomeCampo, String nomeID, String valorID) {
        if (elemento != null && elemento.getNome().equals(nomeCampo)) {
            if (elemento.contemAtributoID()) {
                return elemento.getNomeAtributoID().equals(nomeID) && elemento.getValorAtributoID().equals(valorID);
            }
            return nomeID == null;
        }
        return false;
    }

    public static CamposImportacao carregarCampos(String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Solu\u00e7\u00e3o (*.xml)", "xml"));
        if (chooser.showOpenDialog(Laboratorio.getInstancia()) == 0) {
            try {
                ElementoHPardini raiz = ParserResultadoSolucao.analisarXMLHPardini(chooser.getSelectedFile());
                ElementoHPardini superExame = CamposRelacionamentoSolucaoUtil.localizarSuperExame(raiz, codigoExameLabApoio);
                if (superExame != null) {
                    return new CamposImportacaoHPardini(superExame, codigoExamePai, codigoMaterialPai);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CamposRelacionamentoHPardiniUtil: 93");
            }
        }
        return null;
    }

    private static ElementoHPardini localizarSuperExame(ElementoHPardini ele, String codigoExame) {
        if (ele.getNome().equals("Registro") && ele.contemFilhos() && ele.getFilho("CodExame").getValor().equals(codigoExame)) {
            return ele;
        }
        if (ele.contemFilhos()) {
            for (ElementoHPardini filho : ele.getFilhos()) {
                ElementoHPardini superExame = CamposRelacionamentoSolucaoUtil.localizarSuperExame(filho, codigoExame);
                if (superExame == null) continue;
                return superExame;
            }
        }
        return null;
    }

    public static CamposImportacao carregarCamposAutomaticamente(String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        StringBuilder SQL = new StringBuilder();
        Statement st = Conexao.getStatement();
        if (st != null && codigoLabExterno != null && codigoExameLabApoio != null) {
            try {
                String tmp;
                String mat = codigoExameLabApoio.substring(0, codigoExameLabApoio.indexOf(124));
                String exa = codigoExameLabApoio.substring(codigoExameLabApoio.indexOf(124) + 1, codigoExameLabApoio.lastIndexOf(124));
                StringBuilder sql = new StringBuilder("select eso_xml \n");
                sql.append("from examessolucao \n");
                sql.append("where \n  fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                sql.append("  lae_codigo = ").append(codigoLabExterno).append(" and \n");
                sql.append("  eso_codexame = '").append(exa).append("' and \n");
                sql.append("  eso_codmaterial = '").append(mat).append("'");
                ResultSet res = Conexao.executeQuery(st, SQL.append((CharSequence)sql));
                if (res.next() && (tmp = res.getString("eso_xml")).indexOf("<Registro>") > -1) {
                    tmp = tmp.substring(tmp.indexOf("<Registro>"), tmp.indexOf("</Registro>") + "</Registro>".length());
                    String[] linhas = tmp.split("\n");
                    String se = "";
                    for (String s : linhas) {
                        if (s.toLowerCase().indexOf("![cdata[") >= 0) {
                            se = se + s + "\n";
                            continue;
                        }
                        if (CamposRelacionamentoSolucaoUtil.verificaCDDATA("metodo", s, se) || CamposRelacionamentoSolucaoUtil.verificaCDDATA("descricao", s, se) || CamposRelacionamentoSolucaoUtil.verificaCDDATA("nota", s, se) || CamposRelacionamentoSolucaoUtil.verificaCDDATA("observacao", s, se) || CamposRelacionamentoSolucaoUtil.verificaCDDATA("metodo", s, se) || CamposRelacionamentoSolucaoUtil.verificaCDDATA("examenome", s, se) || CamposRelacionamentoSolucaoUtil.verificaCDDATA("valor", s, se) || CamposRelacionamentoSolucaoUtil.verificaCDDATA("interpretacao", s, se)) continue;
                        se = se + s + "\n";
                    }
                    ElementoHPardini superExame = ParserResultadoSolucao.analisarXMLHPardini(new ByteArrayInputStream((se = new String(se.getBytes("ISO-8859-1"), "UTF-8")).getBytes("ISO-8859-1")));
                    if (superExame != null && superExame.getNome().equals("Registro") && superExame.contemFilho("CodExame") && superExame.getFilho("CodExame").getValor().equals(exa) && superExame.getFilho("CodMaterial").getValor().equals(mat)) {
                        return new CamposImportacaoHPardini(superExame, codigoExamePai, codigoMaterialPai);
                    }
                }
            }
            catch (ParserResultadoHPardiniException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CarregaCamposRelacionamentoSolucao: 22");
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "CarregaCamposRelacionamentoSolucao: 108");
            }
            catch (UnsupportedEncodingException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CarregaCamposRelacionamentoSolucao: 113");
            }
        }
        return null;
    }

    private static boolean verificaCDDATA(String campo, String valor, String xml) {
        String abre = "<" + campo + ">";
        String fecha = "</" + campo + ">";
        if (valor.toLowerCase().indexOf(abre) >= 0 && valor.startsWith(abre)) {
            xml = xml + valor.substring(0, valor.toLowerCase().indexOf(abre) + abre.length()) + "<![CDATA[" + valor.substring(valor.toLowerCase().indexOf(abre) + abre.length(), valor.toLowerCase().indexOf(fecha)) + "]]>" + valor.substring(valor.toLowerCase().indexOf(fecha)) + "\n";
            return true;
        }
        return false;
    }
}

