/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.laboratorio.util.parsers.pardini.ParserImportacaoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;

public class ParserImportacaoSolucao
extends ParserImportacaoHPardini {
    public static String[] getDataHoraGeracao(String xmlTabela) {
        String[] vlrs = new String[]{"", ""};
        if (xmlTabela != null) {
            String tabela = StringUtil.getValor(xmlTabela, "TABELA");
            vlrs[0] = StringUtil.getValor(tabela.equals("") ? xmlTabela : tabela, "DATAGERACAO");
            vlrs[1] = StringUtil.getValor(tabela.equals("") ? xmlTabela : tabela, "HORAGERACAO");
        }
        return vlrs;
    }

    public static Set<ExameHPardini> importarExamesHPardini(String xmlTabela, int codigoLabExterno) {
        return ParserImportacaoSolucao.importarExamesHPardini(xmlTabela, codigoLabExterno, null);
    }

    public static Set<ExameHPardini> importarExamesHPardini(String xmlTabela, int codigoLabExterno, JProgressBar progress) {
        Set<ExameHPardini> exaNovos = ParserImportacaoSolucao.getExames(xmlTabela);
        Set<ExameHPardini> exaVelhos = ParserImportacaoSolucao.getExamesRelacionados(codigoLabExterno);
        Statement st = Conexao.getStatement();
        if (st != null && exaNovos.size() > 0) {
            try {
                if (progress != null) {
                    progress.setMaximum(exaNovos.size());
                    progress.setValue(0);
                }
                StringBuilder bui = new StringBuilder();
                for (ExameHPardini exa : exaVelhos) {
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, exa.codExaJalis, Integer.parseInt(exa.codMatJalis), null);
                }
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 9, new Object[0]);
                HashSet<ExameHPardini> aux = new HashSet<ExameHPardini>(exaVelhos);
                Map<String, ExameHPardini> listaExames = ParserImportacaoSolucao.exameMap(exaNovos);
                aux.retainAll(exaNovos);
                ParserImportacaoSolucao.inserirExamesSolucao(aux, st, codigoLabExterno, progress);
                for (ExameHPardini ep : aux) {
                    bui.setLength(0);
                    StringBuilder xml = new StringBuilder(ep.getXMLExame());
                    ParserImportacaoSolucao.atualizaMaterialAlterado(st, listaExames, ep, xml);
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ep.codExaJalis, Integer.parseInt(ep.codMatJalis), xml.toString());
                }
                HashSet<ExameHPardini> aux2 = new HashSet<ExameHPardini>(exaNovos);
                aux2.removeAll(aux);
                ParserImportacaoSolucao.inserirExamesSolucao(aux2, st, codigoLabExterno, progress);
                Conexao.arquivaSQL();
                exaVelhos.removeAll(exaNovos);
                return exaVelhos;
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImportaExamesSolucao: 133");
            }
        }
        return new HashSet<ExameHPardini>();
    }

    private static void atualizaMaterialAlterado(Statement st, Map<String, ExameHPardini> listaExames, ExameHPardini ep, StringBuilder xml) throws SQLException, SalvaDadosException {
        if (listaExames.containsKey(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()) && !xml.toString().equals(listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getXMLExame()) && !ep.getMateriaisReais().isEmpty() && ep.getMateriaisReais().get(0).getConservantes().size() <= 1) {
            xml.setLength(0);
            xml.append(listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getXMLExame());
            if (!ep.getMateriaisReais().isEmpty() && ep.getMateriaisReais().get(0).getConservantes().size() <= 1 && listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais().size() == 1) {
                StringUtil.setValor(xml, "material-selecionado", listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais().get(0).getDescricaoMatReal());
                if (ep.getMateriaisReais().get(0).getConservantes().size() == 1 && listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais().get(0).getConservantes().size() >= 1) {
                    StringUtil.setValor(xml, "conservante-selecionado", listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais().get(0).getConservantes().get(0));
                }
            }
            IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, Integer.parseInt(ep.codLabExterno), 9, ep.getMnemonicoExame(), ep.getMnemonicoMaterial(), null, listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getXMLDetalhes());
        }
    }

    private static Map<String, ExameHPardini> exameMap(Set<ExameHPardini> exaNovos) {
        HashMap<String, ExameHPardini> listaExames = new HashMap<String, ExameHPardini>();
        for (ExameHPardini e : exaNovos) {
            listaExames.put(e.getMnemonicoExame() + e.getMnemonicoMaterial(), e);
        }
        return listaExames;
    }

    public static List<ElementoHPardini> importarCamposResultadoHPardini(ElementoHPardini resultados, int codigoLabExterno, JProgressBar progress) {
        ArrayList<ElementoHPardini> rejeitados = new ArrayList<ElementoHPardini>();
        Funcoes.validarNaoNull(resultados, "resultados");
        List<ElementoHPardini> superExames = resultados.getFilhos("SuperExame");
        if (progress != null) {
            progress.setMaximum(superExames.size());
        }
        try {
            for (ElementoHPardini superExame : superExames) {
                if (progress != null) {
                    progress.setValue(progress.getValue() + 1);
                }
                ParserImportacaoSolucao.salvarSuperExame(superExame, codigoLabExterno, rejeitados);
            }
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoSolucao: 168");
        }
        catch (SalvaDadosException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoSolucao");
        }
        return rejeitados;
    }

    protected static void salvarSuperExame(ElementoHPardini superExame, int codigoLabExterno, List<ElementoHPardini> rejeitados) throws SQLException, SalvaDadosException {
        Statement st = Conexao.getStatement();
        if (st != null && superExame.contemFilho("CodExame")) {
            String exa = superExame.getFilho("CodExame").getValor();
            String mat = superExame.getFilho("CodMaterial").getValor();
            StringBuilder sql = new StringBuilder("select eso_xml \n");
            sql.append("from examessolucao \n");
            sql.append("where \n  fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
            sql.append("  lae_codigo = ").append(codigoLabExterno).append(" and \n");
            sql.append("  eso_codexame = '").append(exa).append("' and \n");
            sql.append("  eso_codmaterial = '").append(mat).append("'");
            ResultSet res = Conexao.executeQuery(st, sql);
            if (!res.next()) {
                rejeitados.add(superExame);
            } else {
                IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, codigoLabExterno, 9, exa, mat, null, ParserImportacaoSolucao.montarXMLCamposResultados(res.getString("eso_xml"), superExame));
            }
        } else {
            rejeitados.add(superExame);
        }
    }

    private static String montarXMLCamposResultados(String ehpXML, ElementoHPardini superExame) {
        int beginIndex = ehpXML.indexOf("<detalhes>");
        int endIndex = ehpXML.indexOf("</detalhes>") + "</detalhes>".length();
        StringBuilder bui = new StringBuilder(StringUtil.textoDB(ehpXML.substring(beginIndex, endIndex)));
        bui.append('\n');
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            ParserImportacaoSolucao.carregarXMLBuilder(xml, superExame);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\nExame: " + superExame.getFilho("CodExame").getValor(), e.getStackTrace(), "ParserImportacaoSolucao: 220");
        }
        bui.append(StringUtil.textoDB(xml.getXML()));
        return bui.toString();
    }

    protected static void carregarXMLBuilder(XMLStringBuilder xml, ElementoHPardini ele) throws XMLStringBuilderException {
        if (!ele.contemFilhos()) {
            String valor = ele.getValor();
            if (ele.getNome().equalsIgnoreCase("descricao") || ele.getNome().equalsIgnoreCase("nota") || ele.getNome().equalsIgnoreCase("observacao") || ele.getNome().equalsIgnoreCase("comentariodopatologista") || ele.getNome().equalsIgnoreCase("metodo") || ele.getNome().equalsIgnoreCase("examenome") || ele.getNome().equalsIgnoreCase("valor") || ele.getNome().equalsIgnoreCase("valorreferencia") || ele.getNome().equalsIgnoreCase("interpretacao")) {
                valor = "<![CDATA[" + valor + "]]>";
            }
            xml.escrever(ele.getNome(), valor, ele.getMapaAtributos());
        } else {
            xml.abrir(ele.getNome(), ele.getMapaAtributos());
            for (ElementoHPardini filho : ele.getFilhos()) {
                ParserImportacaoSolucao.carregarXMLBuilder(xml, filho);
            }
            xml.fechar(ele.getNome());
        }
    }

    private static void inserirExamesSolucao(Set<ExameHPardini> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SQLException, SalvaDadosException {
        for (ExameHPardini ep : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 9, ep.getMnemonicoExame(), ep.getMnemonicoMaterial(), StringUtil.textoDB(ep.getDescricaoExame()), StringUtil.textoDB(ep.getXMLDetalhes()));
        }
    }

    private static Set<ExameHPardini> getExames(String xmlTabela) {
        HashSet<ExameHPardini> exames = new HashSet<ExameHPardini>();
        String tabela = StringUtil.getValor(xmlTabela, "TABELA");
        if (!tabela.equals("")) {
            for (String exame : StringUtil.getValores(xmlTabela, "EXAME")) {
                String origemAdmissivel = StringUtil.getValor(exame, "ORIGEMADMISSIVEL");
                if (origemAdmissivel != null && !origemAdmissivel.equalsIgnoreCase("TODOS")) continue;
                exames.add(new ExameHPardini(exame, true));
            }
        }
        return exames;
    }

    private static Set<ExameHPardini> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b \n");
                bui.append("  on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  b.lae_codigo = ").append(codigoLabExterno);
                bui.append("  and a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameHPardini.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameHPardini>();
    }

    public static List<ElementoHPardini> importarCamposResultadoSolucao(ElementoHPardini resultados, int codigoLabExterno, JProgressBar progress) {
        ArrayList<ElementoHPardini> rejeitados = new ArrayList<ElementoHPardini>();
        Funcoes.validarNaoNull(resultados, "Exames");
        List<ElementoHPardini> superExames = resultados.getFilhos("Registro");
        if (progress != null) {
            progress.setMaximum(superExames.size());
        }
        try {
            for (ElementoHPardini superExame : superExames) {
                if (progress != null) {
                    progress.setValue(progress.getValue() + 1);
                }
                ParserImportacaoSolucao.salvarSuperExame(superExame, codigoLabExterno, rejeitados);
            }
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoSolucao: 168");
        }
        catch (SalvaDadosException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoSolucao");
        }
        return rejeitados;
    }
}

