/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucao;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.laboratorio.util.parsers.solucao.ParserImportacaoSolucao;
import jalis.laboratorio.util.parsers.solucao.resultado.ParserResultadoSolucao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;

public class ImportacaoSolucao
extends AbstractImportadorLabExterno {
    private JButton buttonImportarCamposResultado = ComponenteFactory.novoJButton("Importar Campos Resultado", 'R', this);

    public ImportacaoSolucao(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Solu\u00e7\u00e3o a partir de arquivo XML", codigoLabExterno, Protocolo.Solucao);
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonImportarCamposResultado, 1);
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportarCamposResultado) {
            this.habilitarBotoes(false);
            new Thread("Thread de Importa\u00e7\u00e3o de Campos de Resultados"){

                @Override
                public void run() {
                    ImportacaoSolucao.this.importarCamposResultado();
                }
            }.start();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
        this.buttonImportarCamposResultado.setEnabled(habilitar);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Solu\u00e7\u00e3o (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                String xmlTabela = StringUtil.lerArquivoTexto(chooser.getSelectedFile().getPath());
                String[] dataHora = ParserImportacaoSolucao.getDataHoraGeracao(xmlTabela);
                Thread.sleep(50L);
                if (dataHora[0].equals("") && dataHora[1].equals("")) {
                    this.setTextoInformacoes("O arquivo \"" + chooser.getSelectedFile().getPath() + "\" \u00e9 inv\u00e1lido.");
                } else {
                    StringBuilder bui = new StringBuilder("Informa\u00e7\u00f5es do arquivo: \n");
                    bui.append("  Data da gera\u00e7\u00e3o: ").append(dataHora[0]).append(" \n");
                    bui.append("  Hora da gera\u00e7\u00e3o: ").append(dataHora[1]).append(" \n\n");
                    bui.append("Importando exames...");
                    this.setTextoInformacoes(bui.toString());
                    Thread.sleep(50L);
                    this.progress.setValue(0);
                    this.progress.setVisible(true);
                    Set<ExameHPardini> excluidos = ParserImportacaoSolucao.importarExamesHPardini(xmlTabela, this.codigoLabExterno, this.progress);
                    bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                    retorno = true;
                    this.setTextoInformacoes(bui.toString());
                    Thread.sleep(50L);
                    if (excluidos.size() > 0) {
                        bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                        bui.append("\t+-----------------+----------------+\n");
                        bui.append("\t|      EXAME      |    MATERIAL    |\n");
                        bui.append("\t+-----------------+----------------+");
                        for (ExameHPardini ep : excluidos) {
                            bui.append("\n\t|").append(StringUtil.formatarColuna(ep.getMnemonicoExame(), 17, 'c'));
                            bui.append("|").append(StringUtil.formatarColuna(ep.getMnemonicoMaterial(), 16, 'c')).append("|");
                        }
                        bui.append("\n\t+-----------------+----------------+");
                        this.setTextoInformacoes(bui.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoSolucao: 103");
        }
        this.progress.setVisible(false);
        return retorno;
    }

    private void importarCamposResultado() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Solucao (*.xml)", "xml"));
        if (chooser.showOpenDialog(this) == 0) {
            this.setTextoInformacoes("Carregando arquivo \"" + chooser.getSelectedFile().getName() + "\"\n");
            String s = "";
            try {
                s = StringUtil.lerArquivoTexto(chooser.getSelectedFile(), "utf-8");
            }
            catch (Exception e1) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel ler o arquivo " + chooser.getSelectedFile() + ".\nMensagem: " + e1.getMessage(), 1);
            }
            try {
                ElementoHPardini resultados = ParserResultadoSolucao.analisarXMLHPardini(new ByteArrayInputStream(s.getBytes()));
                if (resultados == null || !resultados.getNome().equals("Exames")) {
                    this.anexarTextoInformacoes("O arquivo especificado n\u00e3o \u00e9 um XML de campos de resultados do laborat\u00f3rio Solu\u00e7\u00e3o");
                    this.habilitarBotoes(true);
                    return;
                }
                this.progress.setValue(0);
                this.progress.setVisible(true);
                this.anexarTextoInformacoes("Importando campos de resultado...\n");
                List<ElementoHPardini> rejeitados = ParserImportacaoSolucao.importarCamposResultadoSolucao(resultados, this.codigoLabExterno, this.progress);
                this.anexarTextoInformacoes("Importa\u00e7\u00e3o conclu\u00edda.\n");
                if (rejeitados.size() > 0) {
                    this.anexarTextoInformacoes("\nOs campos de resultado dos exames listados abaixo n\u00e3o foram importados, pois\n");
                    this.anexarTextoInformacoes("esses exames ainda n\u00e3o foram importados.\n\n");
                    this.anexarTextoInformacoes("\t+-----------------+----------------+\n");
                    this.anexarTextoInformacoes("\t|      EXAME      |    MATERIAL    |\n");
                    this.anexarTextoInformacoes("\t+-----------------+----------------+");
                    for (ElementoHPardini ele : rejeitados) {
                        String exa = ele.getFilho("CodExame").getValor();
                        String mat = ele.getFilho("CodMaterial").getValor();
                        this.anexarTextoInformacoes("\n\t|");
                        this.anexarTextoInformacoes(StringUtil.formatarColuna(exa, 17, 'c'));
                        this.anexarTextoInformacoes("|");
                        this.anexarTextoInformacoes(StringUtil.formatarColuna(mat, 16, 'c'));
                        this.anexarTextoInformacoes("|");
                    }
                    this.anexarTextoInformacoes("\n\t+-----------------+----------------+");
                }
            }
            catch (ParserResultadoHPardiniException e) {
                this.anexarTextoInformacoes(e.getMessage());
                return;
            }
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
    }
}

