/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucao;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.solucao.resultado.CamposRelacionamentoSolucaoUtil;
import jalis.laboratorio.util.parsers.solucao.resultado.ParserResultadoSolucao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ImportacaoResultadoSolucao
extends AbstractImportadorResultadoLabExterno {
    private static String ULTIMO_SQL = "";
    private static final String FORMATO = "formato";
    private static final String FORMATACAO = "formatacao";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATO_TEXTO = "formatotexto";
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;
    private ModeloGridTable modeloRelatorio;
    private static final SimpleDateFormat dataSolucao = new SimpleDateFormat("MM/dd/yyyy");
    private static final SimpleDateFormat dataUsuario = new SimpleDateFormat("dd/MM/yyyy");
    private JButton buttonImprimir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportacaoResultadoSolucao(int codigoLabExterno) {
        Statement st;
        block4: {
            super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. Solu\u00e7\u00e3o partir de arquivo XML", codigoLabExterno, Protocolo.Solucao, new JPanel(new FlowLayout(2)));
            this.conferirAutomatico = false;
            this.codigoUsuarioConferenciaAutomatica = null;
            this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
            this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
            this.getPanelAdicional().add(this.buttonImprimir);
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSolucao (62)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultado() {
        block8: {
            if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
                return;
            }
            try {
                ElementoHPardini res;
                JFileChooser chooser = ComponenteFactory.novoJFileChooser();
                chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
                chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Solu\u00e7\u00e3o (*.xml)", "xml"));
                if (chooser.showOpenDialog(this) != 0 || (res = ParserResultadoSolucao.analisarXMLSolucao(chooser.getSelectedFile())) == null) break block8;
                StringBuilder str = new StringBuilder();
                if (!res.getNome().equals("Registro")) {
                    this.setTextoInformacoes("O arquivo \"" + chooser.getSelectedFile().getPath() + "\" n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                    return;
                }
                if (res.contemFilho("Lote") && res.getFilho("Lote").contemFilho("ControleDeLote")) {
                    ElementoHPardini aux = res.getFilho("Lote").getFilho("ControleDeLote");
                    str.append("Controle de Lote \n");
                    str.append("  Emissor: ").append(aux.getFilho("Emissor").getValor()).append(" \n");
                    str.append("  Data Emiss\u00e3o: ").append(this.formataData(aux.getFilho("DataEmissao").getValor())).append(" \n");
                    str.append("  Hora Emiss\u00e3o:   ").append(aux.getFilho("HoraEmissao").getValor()).append(" \n");
                    aux = aux.getFilho("Periodo");
                    if (aux != null) {
                        str.append("Per\u00edodo \n");
                        if (aux.getFilho("Emissor") != null) {
                            str.append("  Data Emiss\u00e3o: ").append(this.formataData(aux.getFilho("DataEmissao").getValor())).append(" \n");
                        }
                        if (aux.getFilho("HoraEmissao") != null) {
                            str.append("  Hora Emiss\u00e3o:   ").append(aux.getFilho("HoraEmissao").getValor()).append(" \n");
                        }
                    }
                    this.setTextoInformacoes(str.toString());
                    this.importarResultados(res.getFilho("Lote").getFilhos("Pedido"));
                    break block8;
                }
                this.setTextoInformacoes("O arquivo \"" + chooser.getSelectedFile().getPath() + "\" n\u00e3o possui a tag lote");
                return;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoSolucao: 159");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importarResultados(List<ElementoHPardini> pedidos) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st != null) {
            try {
                Registro reg;
                this.progress.setValue(0);
                this.progress.setMaximum(pedidos.size());
                this.progress.setVisible(true);
                for (ElementoHPardini pedido : pedidos) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    for (ElementoHPardini superExame : pedido.getFilhos("Exame")) {
                        reg = this.localizarExameRequisicao(pedido, superExame);
                        if (reg == null) continue;
                        if (this.isExameJaLancado(reg)) {
                            this.adicionarAoModeloRelatorio(superExame, Situacao.JA_LANCADO, reg);
                            continue;
                        }
                        if (!this.isExameColetado(reg)) {
                            this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_MATERIAL, reg);
                            continue;
                        }
                        if (!this.isExameRelacionado(reg)) {
                            this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_RELACIONAMENTO, reg);
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
                            continue;
                        }
                        boolean salvoParcial = reg.getString("exr_situacao").equals("P");
                        Registro formatacao = salvoParcial ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
                        Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                        dados.putAll(CamposRelacionamentoSolucaoUtil.getMapCampoValor(superExame));
                        Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                        Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                        if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                            historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                        }
                        dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                        Resultado res = new Resultado(formatacao.getString(FORMATO), dados, resAnterior, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"));
                        res.atualizarComponentes();
                        if (!res.verificarCondicao()) {
                            this.adicionarAoModeloRelatorio(superExame, Situacao.CONDICAO_INSATISFEITA, reg);
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                            continue;
                        }
                        boolean completo = true;
                        if (reg.getBoolean("exa_salvaparcial")) {
                            completo = res.resultadoCompleto(true);
                        }
                        String novaSituacao = completo ? "L" : "P";
                        String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                        Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                        boolean marcarConferido = false;
                        if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null) {
                            int verificacao = res.verificarValidacao();
                            boolean bl = marcarConferido = verificacao == 1;
                            if (!marcarConferido && verificacao != 2) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.VALIDACAO_INSATISFEITA, reg);
                                this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                            }
                        }
                        if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), pedido.getFilho("CodAmostra").getValor())) {
                            this.inserirDadosRequisicao(st, this.codigoLabExterno, pedido.getFilho("CodAmostra").getValor(), reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                        }
                        boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                        boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                        this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                        if (this.exportarBaseWeb(reg)) {
                            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                            this.exportarParaWeb(st, this.getCodigoBaseWeb(reg.getString("fil_codigo")), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                            if (ExportaWeb.isGerarPdfResultado(st2, reg.getString("fil_codigo"))) {
                                ExportaWeb.enviarResultadoPDF(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), this.getCodigoBaseWeb(reg.getString("fil_codigo")));
                            }
                        }
                        this.adicionarAoModeloRelatorio(superExame, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE, reg);
                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                        ExportaWeb.atualizaPaginaOrdemExameWeb(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), Variaveis.codigoBaseWeb);
                        this.editarRequisicaoExportaFiliais(reg);
                        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
                        this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE)), false);
                    }
                }
                for (ElementoHPardini pedido : pedidos) {
                    for (ElementoHPardini superExame : pedido.getFilhos("Pedido")) {
                        reg = this.localizarExameRequisicao(pedido, superExame);
                        if (reg == null) continue;
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            SMSUtil.criaLogSmsComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, st, st2);
                        }
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            EmailUtil.criaLogEmail(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                        }
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            PushUtil.criaLogPushComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoPush.RESULTADO, st, st2);
                        }
                        if (!this.conferirAutomatico || Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) continue;
                        WhatsAppUtil.criaLogWhatsappComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoWhatsapp.RESULTADO, st, st2);
                    }
                }
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > -1);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoSolucao: 283");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
        }
        this.progress.setVisible(false);
    }

    private Registro localizarExameRequisicao(ElementoHPardini pedido, ElementoHPardini superExame) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st != null && pedido.contemFilho("CodPedLab")) {
            if (!superExame.contemFilho("CodExame")) {
                this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_COD_EXM_LAB, null);
            } else {
                String req = pedido.getFilho("CodPedLab").getValor();
                if (req.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
                    this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_COD_EXM_LAB, null);
                    return null;
                }
                if (!Funcoes.isNumeric(req) || req.contains(".") || req.contains(",")) {
                    this.setTextoInformacoes("Requisi\u00e7\u00e3o: " + req + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o\n", false);
                    return null;
                }
                String filial = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req = req.substring(ParametrosGerais.getDigitosTuboFilial());
                String exaSolucao = superExame.getFilho("CodExame").getValor();
                String mcoSolucao = superExame.getFilho("CodMaterial").getValor();
                StringBuilder sql = new StringBuilder("select \n");
                sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo,  a.req_idade, a.req_anomes, \n");
                sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, g.met_codigo, \n");
                sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
                sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, \n");
                sql.append("  a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao \n");
                sql.append("from requisicao a \n");
                sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
                sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
                sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
                sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
                sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
                sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo \n");
                sql.append("where \n");
                sql.append("  a.fil_codigo = ").append(filial).append(" and \n");
                sql.append("  a.req_codigo = ").append(req).append(" and \n");
                sql.append("  a.req_excluida = false and b.exr_excluido = false and \n");
                sql.append("  g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' and \n");
                sql.append("  upper(g.ele_xmllabexterno) ilike '%<").append("codigo-exame").append(">").append(exaSolucao.toUpperCase()).append("%' and ");
                sql.append("  upper(g.ele_xmllabexterno) ilike '%<").append("codigo-material").append(">").append(mcoSolucao.toUpperCase()).append("%'");
                ULTIMO_SQL = sql.toString();
                ResultSet res = Conexao.executeQuery(st, ULTIMO_SQL);
                if (res.next()) {
                    Registro reg = new Registro(res);
                    reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(filial, res.getString("con_codigo"), res.getString("des_codigo")));
                    reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(filial, reg.getString(CODIGO_LAYOUT)));
                    Registro formatacao = new Registro();
                    formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
                    formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                    reg.setValor(FORMATACAO, formatacao);
                    return reg;
                }
                this.adicionarAoModeloRelatorio(superExame, Situacao.NAO_LOCALIZADO, null);
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarAoModeloRelatorio(ElementoHPardini superExame, Situacao situacao, Registro exame) {
        ElementoHPardini pedido = superExame.getPai();
        if (pedido != null && pedido.contemFilho("CodPedLab") && pedido.getFilho("CodPedLab").getValor().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() && superExame.contemFilho("CodExame")) {
            String exaSolucao = superExame.getFilho("CodExame").getValor();
            String mcoSolucao = superExame.getFilho("CodMaterial").getValor();
            String requisicao = pedido.getFilho("CodPedLab").getValor();
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            if (exame == null || !exame.possuiCampo("exa_codigo") || !exame.possuiCampo("mco_codigo")) {
                this.setTextoInformacoes(String.format("Requisi\u00e7\u00e3o %s n\u00e3o possui o exame externo %s%s ou exame n\u00e3o relacionado no Jalis ", pedido.getFilho("CodPedLab").getValor(), exaSolucao, mcoSolucao));
                return;
            }
            String exa = exame.getString("exa_codigo");
            String mco = exame.getString("mco_codigo");
            RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, requisicao, exa, Integer.parseInt(mco), situacao.descricao);
        }
    }

    private boolean isExameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "codigo-exame");
                    mco = StringUtil.getValor(xml, "codigo-material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select eso_xml from examessolucao where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and eso_codexame = '").append(exa).append("' and eso_codmaterial = '").append(mco).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("eso_xml", rs.getString("eso_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isExameJaLancado(Registro reg) {
        String sit = reg.getString("exr_situacao");
        return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
    }

    private boolean isExameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private int pegaTipoDias(String tipo) {
        if ("A".equals(tipo)) {
            return 365;
        }
        if ("M".equals(tipo)) {
            return 31;
        }
        return 1;
    }

    private synchronized String formataData(String data) throws ParseException {
        return dataUsuario.format(dataSolucao.parse(data));
    }

    private boolean exportarBaseWeb(Registro reg) {
        try {
            Statement st = Conexao.getStatement();
            FilialService filService = new FilialService();
            FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, reg.getString("fil_codigo"));
            if (this.carregouVO(filialVO)) {
                return this.isExportarBaseWeb(filialVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSolucao: 261");
        }
        return false;
    }

    private boolean carregouVO(FilialVO filialVO) {
        return filialVO != null;
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSolucao (560)");
        }
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        SEM_COD_EXM_LAB("XML sem campo CodExmLab"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_MATERIAL("Sem material"),
        SEM_RELACIONAMENTO("Sem relacionamento");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

