/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucao;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.DialogoCamposImportacaoSelecionavel;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardiniImpl;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class DialogoCamposImportacaoSolucao
extends DialogoCamposImportacaoSelecionavel {
    private String campoSelecionado = "";
    private JTabbedPane abaCampos;
    private HashMap<String, String[]> campos;

    public static DialogoCamposImportacaoSolucao novaInstancia(Object pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        if (pai instanceof Frame) {
            return new DialogoCamposImportacaoSolucao((Frame)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        if (pai instanceof Dialog) {
            return new DialogoCamposImportacaoSolucao((Dialog)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        return null;
    }

    public DialogoCamposImportacaoSolucao(Frame pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. Solu\u00e7\u00e3o", camposImportacao, listaExamesDesmLabExterno);
    }

    public DialogoCamposImportacaoSolucao(Dialog pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. Solu\u00e7\u00e3o", camposImportacao, listaExamesDesmLabExterno);
    }

    @Override
    public void iniciar(Object camposImportacao) {
        this.modelo = new ModeloGridTable(new String[]{"Linha", "Descri\u00e7\u00e3o"});
        this.table = ComponenteFactory.novoJTable((TableModel)this.modelo, 0);
        this.scroll = new JScrollPane(this.table);
        this.getPanelCentral().setLayout(new BorderLayout());
        if (this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty()) {
            for (CamposImportacao campo : this.getListaExamesDesmLabExterno()) {
                this.getComboDesm().addItem(campo.getCodigoExame());
                this.getMapTabs().put(campo.getCodigoExame(), campo);
            }
            this.carregaCampos(this.getListaExamesDesmLabExterno().get(0).getCamposImportacao());
            this.getComboDesm().setBorder(new TitledBorder("Desmembramento"));
            this.getPanelCentral().add((Component)this.getComboDesm(), "North");
        } else {
            this.carregaCampos(camposImportacao);
        }
        this.getComboDesm().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CamposImportacao campo = DialogoCamposImportacaoSolucao.this.getMapTabs().get(DialogoCamposImportacaoSolucao.this.getComboDesm().getSelectedItem());
                DialogoCamposImportacaoSolucao.this.carregaCampos(campo.getCamposImportacao());
            }
        });
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.setSize(new Dimension(800, 500));
        ScreenUtil.centralizar(this);
    }

    private static String getNomeAtributo(ElementoHPardini ele) {
        StringBuilder bui = new StringBuilder(ele.getNome());
        if (ele.contemAtributoID()) {
            bui.append(':');
            bui.append(ele.getNomeAtributoID());
            bui.append('=');
            bui.append(ele.getValorAtributoID());
        }
        return bui.toString();
    }

    private void carregaCampos(Object camposImportacao) {
        this.modelo.clear();
        ElementoHPardiniImpl linhas = (ElementoHPardiniImpl)camposImportacao;
        for (ElementoHPardini el : linhas.getFilhos()) {
            this.getCampo(el, "Exame|");
        }
    }

    private void getCampo(ElementoHPardini el, String no) {
        if (!Funcoes.textoVazio(el.getValor())) {
            Object[] linha = new String[]{el.getNome(), el.getValor()};
            this.modelo.addLine(linha);
        }
        if (el.contemFilhos()) {
            for (ElementoHPardini filho : el.getFilhos()) {
                if (el.getPai().getNome().equalsIgnoreCase("Resultado") && filho.getNome().equalsIgnoreCase("Nome")) {
                    Object[] vref;
                    Object[] linha = new String[]{filho.getValor(), "Campo " + filho.getValor() + " Mascara: " + el.getFilho("MascaraEntrada").getValor()};
                    this.modelo.addLine(linha);
                    if (el.contemFilho("ValorReferencia")) {
                        vref = new String[]{el.getFilhos("ValorReferencia").get(0).getNome() + "_" + filho.getValor(), el.getFilhos("ValorReferencia").get(0).getValor()};
                        this.modelo.addLine(vref);
                    }
                    vref = new String[]{"ValorReferencia", "Valor de ref\u00earencia Bloco"};
                    this.modelo.addLine(vref);
                    continue;
                }
                if (filho.getNome().equalsIgnoreCase("MascaraEntrada") || filho.getNome().equalsIgnoreCase("Descricao") || filho.getNome().equalsIgnoreCase("ValorReferencia")) continue;
                this.getCampo(filho, el.getPai().getNome());
            }
        }
    }

    @Override
    public String getCampoSelecionado() {
        if (this.table.getSelectedRow() > -1) {
            String exameDesmSelecionado;
            String string = exameDesmSelecionado = this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty() ? "@" + this.getComboDesm().getSelectedItem() : "";
            if (this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty()) {
                return this.table.getValueAt(this.table.getSelectedRow(), 0).toString() + exameDesmSelecionado + "#" + this.getMapTabs().get(this.getComboDesm().getSelectedItem().toString()).getMaterialPaiDesm();
            }
            return this.table.getValueAt(this.table.getSelectedRow(), 0).toString() + exameDesmSelecionado;
        }
        return null;
    }

    @Override
    public void setCampoSelecionado(String campoSelecionado) {
        this.campoSelecionado = campoSelecionado;
        if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("@") && campoSelecionado.contains("#")) {
            Scanner scanner = new Scanner(campoSelecionado).useDelimiter("\\@");
            campoSelecionado = scanner.next();
            scanner = new Scanner(scanner.next()).useDelimiter("\\#");
            String exameDesmSelecionado = scanner.next();
            String materialPaiDesm = scanner.next();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        } else if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("#")) {
            String exameDesmSelecionado = campoSelecionado.split("#")[1];
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
            campoSelecionado = campoSelecionado.split("#")[0].trim();
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.getValueAt(i, 0).toString().equalsIgnoreCase(campoSelecionado)) continue;
            this.table.setRowSelectionInterval(i, i);
        }
    }
}

