/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.solucao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.laboratorio.util.parsers.pardini.MatRealHPardini;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorSolucao
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String MATERIAL = "material";
    private static final String DESC_MAT = "descricaoMaterial";
    private static final String CONSERVANTE = "conservante";
    private static final String SELECIONADO = "selecionado";
    private static final String MATERIAL_ESPEC_CONFIGURACAO = "materialUsuario";
    private static final String OBJ_EXAME_SOLUCAO = "objExameSolucao";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    private ModeloResultSet modMatCheck = new ModeloResultSet("Descri\u00e7\u00e3o", "descricaoMaterial", "Conservante", "conservante", "Sel", "selecionado");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, new int[0]);
    private JTable tableMat = new JTable(this.modMatCheck);
    private JCheckBox checkUtilizarMaterialRequisicao = ComponenteFactory.novoJCheckBox("Utilizar material informado na requisi\u00e7\u00e3o", 'U', this);
    private JTextField textMaterial = new JTextField();
    private JLabel labelMaterial = ComponenteFactory.novoJLabel(" Material: ", 'M', new Dimension(70, 22), this.textMaterial);
    private JButton buttonAdicionarMaterial = ComponenteFactory.novoJButton("Adicionar", 'A', this, null, null, false);
    private JPanel panelMaterial = new JPanel();
    private JPanel panelMateriaisReais;
    private JLabel labelObrigatorio = new JLabel("  Obrigat\u00f3rio: ");
    private JLabel labelInfo = ComponenteFactory.novoJLabel("", new Dimension(10, 22));
    private JTextField textLocalizar = new JTextField();
    private String xmlSelecionado = "";
    private String codigoExameLabExterno = "";

    public static ConfiguradorSolucao novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorSolucao((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorSolucao((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            ExameHPardini ehp = ExameHPardini.novaInstancia(xml);
            return ehp.getDescricaoExame();
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameHPardini ehp = ExameHPardini.novaInstancia(xml);
            return ehp.getMnemonicoMaterial() + "|" + ehp.getMnemonicoExame() + "|1";
        }
        return "";
    }

    public ConfiguradorSolucao(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Lab. Solu\u00e7\u00e3o", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorSolucao(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Lab. Solu\u00e7\u00e3o", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorSolucao(Frame pai, String descricao, String codigoLabExterno) {
        super(pai, descricao, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorSolucao(Dialog pai, String descricao, String codigoLabExterno) {
        super(pai, descricao, codigoLabExterno);
        this.iniciar();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.atualizarInformacoesExame((ExameHPardini)reg.getValor(OBJ_EXAME_SOLUCAO));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.checkUtilizarMaterialRequisicao) {
            this.habilitarCamposMaterial(!this.checkUtilizarMaterialRequisicao.isSelected());
            if (this.checkUtilizarMaterialRequisicao.isSelected()) {
                this.textMaterial.setText("");
            }
        } else if (o == this.buttonAdicionarMaterial) {
            ModeloResultSet mod = (ModeloResultSet)this.tableMat.getModel();
            mod.addRegistro(Registro.novoRegistro(new Object[]{DESC_MAT, this.textMaterial.getText(), SELECIONADO, Boolean.TRUE, MATERIAL_ESPEC_CONFIGURACAO, Boolean.TRUE}));
            this.textMaterial.setText("");
            this.atualizarPanelMateriais();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public boolean exigeAltura() {
        return this.contemInfoComp("Altura");
    }

    @Override
    public boolean exigePeso() {
        return this.contemInfoComp("Peso");
    }

    @Override
    public boolean exigeTempoDiurese() {
        return this.contemInfoComp("TempoDiurese");
    }

    @Override
    public boolean exigeVolumeDiurese() {
        return this.contemInfoComp("VolumeDiurese");
    }

    @Override
    public boolean acaoOk() {
        ExameHPardini exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        if (this.tableMat.getModel() == this.modMatCheck && !this.checkUtilizarMaterialRequisicao.isSelected() && !this.modMatCheck.contemValor(SELECIONADO, Boolean.TRUE) && this.modMatCheck.getRowCount() > 0) {
            Funcoes.mensagem(this, "Nenhum material foi selecionado", 1);
            return false;
        }
        this.atualizarXMLSelecionado();
        return true;
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameHPardini.isXmlValido(xml)) {
            Registro reg;
            int i;
            this.xmlSelecionado = xml;
            ExameHPardini ehp = ExameHPardini.novaInstancia(xml);
            for (i = 0; i < this.tableExa.getRowCount(); ++i) {
                reg = this.modExa.getRegistro(i);
                if (reg == null || !ehp.equals(reg.getValor(OBJ_EXAME_SOLUCAO))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
            if (this.tableMat.getModel() == this.modMatCheck) {
                if (ehp.utilizarMatRequisicao()) {
                    this.checkUtilizarMaterialRequisicao.setSelected(true);
                    this.habilitarCamposMaterial(false);
                } else {
                    if (ehp.materialEspecConfiguracao()) {
                        this.modMatCheck.addRegistro(Registro.novoRegistro(new Object[]{DESC_MAT, ehp.getMaterialSelecinado(), SELECIONADO, Boolean.TRUE, MATERIAL_ESPEC_CONFIGURACAO, Boolean.TRUE}));
                    } else {
                        for (i = 0; i < this.modMatCheck.getRowCount(); ++i) {
                            reg = this.modMatCheck.getRegistro(i);
                            if (!reg.contemValor(DESC_MAT, Funcoes.textoVazio(ehp.getMaterialSelecinado()) ? null : "") || !reg.contemValor(CONSERVANTE, Funcoes.textoVazio(ehp.getConservanteSelecionado()) ? null : "")) continue;
                            reg.setValor(SELECIONADO, Boolean.TRUE);
                            break;
                        }
                    }
                    this.modMatCheck.fireTableDataChanged();
                    this.atualizarPanelMateriais();
                }
            }
        }
    }

    private void atualizarXMLSelecionado() {
        ExameHPardini exa = this.getExameSelecionado();
        if (exa != null) {
            exa.setUtilizarMatRequisicao(this.checkUtilizarMaterialRequisicao.isSelected());
            Registro reg = this.modMatCheck.getRegistro(this.modMatCheck.getIndice(SELECIONADO, Boolean.TRUE));
            if (reg != null) {
                exa.setMaterialEspecConfig(reg.getBoolean(MATERIAL_ESPEC_CONFIGURACAO));
                exa.setMaterialSelecionado(reg.getString(DESC_MAT));
                exa.setConservanteSelecionado(reg.getString(CONSERVANTE));
            }
            this.xmlSelecionado = exa.getXMLExame();
            this.codigoExameLabExterno = exa.getMnemonicoMaterial() + "|" + exa.getMnemonicoExame() + "|1";
        }
    }

    private boolean contemInfoComp(String valor) {
        ExameHPardini exa = this.getExameSelecionado();
        if (exa != null) {
            return exa.contemInfoComp(valor);
        }
        return false;
    }

    private String getInformacoes() {
        List<String> msn = Arrays.asList("", "{0}", "{0} e {1}", "{0}, {1} e {2}", "{0}, {1}, {2} e {3}");
        ArrayList<String> itens = new ArrayList<String>();
        ExameHPardini exa = this.getExameSelecionado();
        if (exa != null) {
            if (exa.contemInfoComp("Peso")) {
                itens.add("Peso");
            }
            if (exa.contemInfoComp("Altura")) {
                itens.add("Altura");
            }
            if (exa.contemInfoComp("VolumeDiurese")) {
                itens.add("Volume Diurese");
            }
            if (exa.contemInfoComp("TempoDiurese")) {
                itens.add("Tempo Diurese");
            }
        }
        return MessageFormat.format(msn.get(itens.size()), itens.toArray());
    }

    private ExameHPardini getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameHPardini)reg.getValor(OBJ_EXAME_SOLUCAO);
        }
        return null;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void carregarExames() {
        for (ExameHPardini exame : ConfiguradorSolucao.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getMnemonicoExame());
            reg.setValor(DESC_EXA, exame.getDescricaoExame());
            reg.setValor(MATERIAL, exame.getMnemonicoMaterial());
            reg.setValor(OBJ_EXAME_SOLUCAO, exame);
            this.modExa.addRegistro(reg);
        }
    }

    public static List<ExameHPardini> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameHPardini> exames = new ArrayList<ExameHPardini>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select * \n");
                bui.append("from examessolucao \n");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("      lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("order by eso_descricaoexame");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    ExameHPardini exa = new ExameHPardini(res.getString("eso_xml"), true);
                    exa.setMncExame(res.getString("eso_codexame"));
                    exa.setMncMaterial(res.getString("eso_codmaterial"));
                    exa.setDescExame(res.getString("eso_descricaoexame"));
                    exa.carregarXMLDetalhes(res.getString("eso_xml"));
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ConnfiguradorSolucao: 436");
            }
        }
        return exames;
    }

    private void atualizarInformacoesExame(ExameHPardini exa) {
        this.labelInfo.setText(this.getInformacoes());
        this.labelObrigatorio.setVisible(this.labelInfo.getText().length() > 0);
        ModeloResultSet mod = this.modMatCheck;
        mod.limpar();
        for (MatRealHPardini mat : exa.getMateriaisReais()) {
            if (mat.getConservantes().size() == 0) {
                Registro reg = new Registro();
                reg.setValor(DESC_MAT, mat.getDescricaoMatReal());
                reg.setValor(SELECIONADO, Boolean.FALSE);
                mod.addRegistro(reg);
                continue;
            }
            for (String conservante : mat.getConservantes()) {
                Registro reg = new Registro();
                reg.setValor(DESC_MAT, mat.getDescricaoMatReal());
                reg.setValor(CONSERVANTE, conservante);
                reg.setValor(SELECIONADO, Boolean.FALSE);
                mod.addRegistro(reg);
            }
        }
        this.atualizarTabelaMateriais(mod);
        this.atualizarPanelMateriais();
    }

    private void atualizarTabelaMateriais(ModeloResultSet modelo) {
        this.tableMat.setModel(modelo);
        modelo.fireTableStructureChanged();
        if (modelo == this.modMatCheck) {
            TableColumn col = this.tableMat.getColumnModel().getColumn(2);
            col.setMinWidth(20);
            col.setMaxWidth(20);
        }
        modelo.fireTableDataChanged();
    }

    private void atualizarPanelMateriais() {
        ExameHPardini ehp = this.getExameSelecionado();
        if (ehp != null) {
            if (ehp.getMnemonicoMaterial().equals("DIV")) {
                ModeloResultSet mod = (ModeloResultSet)this.tableMat.getModel();
                if (!this.panelMaterial.isVisible()) {
                    this.checkUtilizarMaterialRequisicao.setSelected(false);
                    this.habilitarCamposMaterial(true);
                }
            } else {
                this.panelMaterial.setVisible(false);
            }
            this.panelMateriaisReais.revalidate();
            this.panelMateriaisReais.repaint();
        }
    }

    private void habilitarCamposMaterial(boolean habilitar) {
        this.labelMaterial.setEnabled(habilitar);
        this.textMaterial.setEnabled(habilitar);
    }

    private void iniciar() {
        this.modMatCheck.setColunaEditavel(SELECIONADO);
        this.modMatCheck.setColunaValorUnico(SELECIONADO, Boolean.TRUE, Boolean.FALSE);
        this.labelObrigatorio.setVisible(false);
        this.labelInfo.setFont(new Font("Arial", 0, 12));
        this.tableMat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Registro reg;
                if (ConfiguradorSolucao.this.tableMat.getModel() == ConfiguradorSolucao.this.modMatCheck && ConfiguradorSolucao.this.tableMat.getSelectedRow() >= 0 && e.getKeyCode() == 127 && (reg = ConfiguradorSolucao.this.modMatCheck.getRegistro(ConfiguradorSolucao.this.tableMat.getSelectedRow())).getBoolean(ConfiguradorSolucao.MATERIAL_ESPEC_CONFIGURACAO)) {
                    ConfiguradorSolucao.this.modMatCheck.removerRegistro(reg);
                    ConfiguradorSolucao.this.modMatCheck.fireTableDataChanged();
                    ConfiguradorSolucao.this.atualizarPanelMateriais();
                }
            }
        });
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        JScrollPane scrollMat = new JScrollPane(this.tableMat);
        scrollMat.setPreferredSize(new Dimension(650, 100));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.panelMateriaisReais = ComponenteFactory.novoJPanelBorderLayout("Materiais Reais", (Component)scrollMat, (Component)this.panelMaterial, null, null, null);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout(this.panelMateriaisReais, ComponenteFactory.novoJPanelBorderLayout("Informa\u00e7\u00f5es", (Component)this.labelInfo, null, null, null, (Component)this.labelObrigatorio), null, null, null), "Center");
        this.configurarTabelas();
        this.montarPanelMaterial();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private void montarPanelMaterial() {
        ScreenUtil.addDocumentListener(this.textMaterial.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorSolucao.this.buttonAdicionarMaterial.setEnabled(ConfiguradorSolucao.this.textMaterial.getText().trim().length() > 0);
            }
        });
        this.panelMaterial.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints(0, 0, 3, 1, 0.5, 0.5, 10, 1, new Insets(0, 1, 0, 1), 0, 0);
        this.panelMaterial.add((Component)this.checkUtilizarMaterialRequisicao, cons);
        cons.weightx = 0.0;
        cons.gridy = 1;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 1, 1, 1);
        this.textMaterial.setPreferredSize(new Dimension(10, 22));
        this.panelMaterial.add((Component)this.labelMaterial, cons);
        cons.weightx = 0.5;
        cons.gridx = 1;
        this.panelMaterial.add((Component)this.textMaterial, cons);
        cons.weightx = 0.0;
        cons.gridx = 2;
        cons.insets = new Insets(0, 0, 1, 1);
        this.buttonAdicionarMaterial.setMargin(new Insets(1, 3, 1, 3));
        this.buttonAdicionarMaterial.setPreferredSize(new Dimension(this.buttonAdicionarMaterial.getPreferredSize().width, 22));
        this.panelMaterial.add((Component)this.buttonAdicionarMaterial, cons);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorSolucao.this.modExa.filtrar(ConfiguradorSolucao.DESC_EXA, ConfiguradorSolucao.this.textLocalizar.getText());
                if (ConfiguradorSolucao.this.modExa.getRowCount() > 0) {
                    ConfiguradorSolucao.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSolucao.this.tableExa.hasFocus() && (row = ConfiguradorSolucao.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorSolucao.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorSolucao.this.tableExa.scrollRectToVisible(ConfiguradorSolucao.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSolucao.this.tableExa.hasFocus() && (row = ConfiguradorSolucao.this.tableExa.getSelectedRow()) < ConfiguradorSolucao.this.tableExa.getRowCount() - 1) {
                    ConfiguradorSolucao.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorSolucao.this.tableExa.scrollRectToVisible(ConfiguradorSolucao.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }
}

