/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab.resultado;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.softlab.resultado.ImportacaoResultadoSoftLabDao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InformaPeriodoImportacaoSoftLab
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Importa\u00e7\u00e3o via Weservice";
    private static final String MSG_VALIDA_FILIAL = "A Filial deve ser informada";
    private static final int ALTURA = 290;
    private static final int LARGURA = 250;
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textFilial = new TTextField(10, 1);
    private TTextField textRequisicao = new TTextField(10, 1);
    private TTextField textLote = new TTextField(20, 1);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonRequisicao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkBoxListagem = new JCheckBox("Liberados");
    private JCheckBox checkBoxPeriodo = new JCheckBox("Periodo: ");
    private JCheckBox checkBoxRequisicao = new JCheckBox("Requisi\u00e7\u00e3o: ");
    private String dataInicial = null;
    private String dataFinal = null;
    private transient ImportacaoResultadoSoftLabDao dao;

    public static InformaPeriodoImportacaoSoftLab novaInstancia(Object pai, ImportacaoResultadoSoftLabDao dao) {
        return pai instanceof Dialog ? new InformaPeriodoImportacaoSoftLab((Dialog)pai, dao) : new InformaPeriodoImportacaoSoftLab((Frame)pai, dao);
    }

    private InformaPeriodoImportacaoSoftLab(Dialog pai, ImportacaoResultadoSoftLabDao dao) {
        super(pai, TITULO);
        this.dao = dao;
        this.construirTela();
    }

    private InformaPeriodoImportacaoSoftLab(Frame pai, ImportacaoResultadoSoftLabDao dao) {
        super(pai, TITULO);
        this.dao = dao;
        this.construirTela();
    }

    private void construirTela() {
        this.setSize(new Dimension(250, 290));
        this.setResizable(false);
        this.setModal(true);
        this.definirTamanhoComponentes();
        this.desabilitarComponentes();
        this.buttonOK.setText("Importar");
        this.textDataInicial.setText(!Funcoes.textoVazio(this.dataInicial) ? this.dataInicial : "");
        this.dataFinal = Funcoes.formataData(new Date());
        this.textDataFinal.setText(this.dataFinal);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        JPanel panelInicial = this.posicionarComponentes();
        JPanel aux = new JPanel(new BorderLayout());
        aux.add((Component)panelInicial, "North");
        panel.add((Component)aux, "West");
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textDataInicial);
        this.adicionarEventos();
        this.habilitarDesabilitarComponentesDataHora(false);
        this.habilitarDesabilitarComponentesRequisicao(false);
    }

    private void definirTamanhoComponentes() {
        int alturaPadrao = 20;
        int larguraText = 100;
        int larguraButton = 20;
        this.textDataInicial.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataInicial.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textLote.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textLote.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.buttonDataInicial.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataInicial.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonRequisicao.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonRequisicao.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonFilial.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonFilial.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
    }

    private void desabilitarComponentes() {
        this.textFilial.setEnabled(false);
        this.textRequisicao.setEnabled(false);
        this.buttonFilial.setEnabled(false);
        this.buttonRequisicao.setEnabled(false);
        this.textLote.setEnabled(false);
        this.checkBoxListagem.setSelected(true);
    }

    private JPanel posicionarComponentes() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.insets = new Insets(1, 1, 0, 0);
        c1.fill = 1;
        c1.anchor = 16;
        panel.add((Component)this.checkBoxListagem, c1);
        ++c1.gridy;
        panel.add((Component)this.checkBoxPeriodo, c1);
        ++c1.gridx;
        panel.add((Component)new JLabel("Data Inicial:"), c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)this.textDataInicial, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonDataInicial, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)new JLabel("Data Final:"), c1);
        c1.insets = new Insets(1, 1, 15, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)this.textDataFinal, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonDataFinal, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 0;
        panel.add((Component)this.checkBoxRequisicao, c1);
        ++c1.gridx;
        panel.add((Component)new JLabel("C\u00f3d. Filial:"), c1);
        ++c1.gridy;
        panel.add((Component)this.textFilial, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonFilial, c1);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)new JLabel("C\u00f3d. Requisi\u00e7\u00e3o:"), c1);
        ++c1.gridy;
        panel.add((Component)this.textRequisicao, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonRequisicao, c1);
        return panel;
    }

    private void adicionarEventos() {
        this.checkBoxListagem.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.checkBoxRequisicao.setSelected(false);
                this.checkBoxPeriodo.setSelected(false);
                this.habilitarDesabilitarComponentesDataHora(false);
                this.habilitarDesabilitarComponentesRequisicao(false);
            }
        });
        this.checkBoxPeriodo.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.checkBoxRequisicao.setSelected(false);
                this.checkBoxListagem.setSelected(false);
                this.habilitarDesabilitarComponentesDataHora(true);
                this.habilitarDesabilitarComponentesRequisicao(false);
            }
        });
        this.checkBoxRequisicao.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.checkBoxPeriodo.setSelected(false);
                this.checkBoxListagem.setSelected(false);
                this.habilitarDesabilitarComponentesDataHora(false);
                this.habilitarDesabilitarComponentesRequisicao(true);
            }
        });
        this.textRequisicao.addActionListener(actionEvent -> {
            if (Funcoes.textoVazio(this.textFilial)) {
                Funcoes.mensagem(this, MSG_VALIDA_FILIAL, 2);
            }
        });
    }

    private void habilitarDesabilitarComponentesDataHora(boolean habilitaComponentes) {
        this.textDataInicial.setText(habilitaComponentes ? this.dataInicial : "");
        this.textDataFinal.setText(habilitaComponentes ? this.dataFinal : "");
        this.textDataInicial.setEnabled(habilitaComponentes);
        this.textDataFinal.setEnabled(habilitaComponentes);
        this.buttonDataFinal.setEnabled(habilitaComponentes);
        this.buttonDataInicial.setEnabled(habilitaComponentes);
    }

    private void habilitarDesabilitarComponentesRequisicao(boolean habilitaComponentes) {
        if (!habilitaComponentes) {
            this.textFilial.setText("");
            this.textRequisicao.setText("");
        } else {
            this.textFilial.setText(Variaveis.filialPadrao);
        }
        this.textFilial.setEnabled(habilitaComponentes);
        this.textRequisicao.setEnabled(habilitaComponentes);
        this.buttonFilial.setEnabled(habilitaComponentes);
        this.buttonRequisicao.setEnabled(habilitaComponentes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
        } else if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonRequisicao) {
            this.buscaRequisicao();
        } else if (e.getSource() == this.buttonOK) {
            if (this.preenchimentoValido()) {
                this.ok = true;
                this.setVisible(false);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void buscaRequisicao() {
        if (!Funcoes.textoVazio(this.textFilial)) {
            Hashtable resultado = Pesquisas.requisicao(Laboratorio.getInstancia(), this.textFilial.getText(), true, false, false);
            if (resultado != null) {
                this.textRequisicao.setText(resultado.get("req_codigo").toString());
            }
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return;
        }
        Funcoes.mensagem(this, "Filial deve ser informada.", 2);
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(Laboratorio.getInstancia(), false);
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private boolean preenchimentoValido() {
        if (this.checkBoxPeriodo.isSelected()) {
            if (Funcoes.textoVazio(this.textDataInicial.getText())) {
                Funcoes.mensagem(this, "Data inicial deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textDataInicial);
                return false;
            }
            if (Funcoes.textoVazio(this.textDataFinal.getText())) {
                Funcoes.mensagem(this, "Data final deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textDataFinal);
                return false;
            }
            int intervalo = Funcoes.diasPorPeriodo(this.textDataInicial.getText(), this.textDataFinal.getText());
            if (intervalo < 0) {
                Funcoes.mensagem(this, "A data final n\u00e3o pode ser menor que a data inicial.", 2);
                ScreenUtil.requisitarFoco(this.textDataFinal);
                return false;
            }
            if (intervalo > 7) {
                Funcoes.mensagem(this, "O per\u00edodo informado, excede a quantidade m\u00e1xima de dias permitida para a Importa\u00e7\u00e3o (7 dias)", 2);
                ScreenUtil.requisitarFoco(this.textDataInicial);
                return false;
            }
        }
        if (this.checkBoxRequisicao.isSelected()) {
            if (Funcoes.textoVazio(this.textFilial.getText())) {
                Funcoes.mensagem(this, "Filial deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textFilial);
                return false;
            }
            if (Funcoes.textoVazio(this.textRequisicao.getText())) {
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textRequisicao);
                return false;
            }
            if (!this.dao.requisicaoValida(this.textFilial.getText(), this.textRequisicao.getText())) {
                Funcoes.mensagem(this, "C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o encontrado", 2);
                ScreenUtil.requisitarFoco(this.textRequisicao);
                return false;
            }
        }
        return true;
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean porPeriodo() {
        return this.checkBoxPeriodo.isSelected();
    }

    public boolean porRequisicao() {
        return this.checkBoxRequisicao.isSelected();
    }

    public String getDataInicial() {
        return this.textDataInicial.getText();
    }

    public String getDataFinal() {
        return this.textDataFinal.getText();
    }

    public String getCodFilial() {
        return this.textFilial.getText();
    }

    public String getCodRequisicao() {
        return this.textRequisicao.getText();
    }

    public boolean porListagem() {
        return this.checkBoxListagem.isSelected();
    }
}

