/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab.resultado;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExternoDao;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.softlab.dto.ExameRequisicaoDTO;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.laboratorio.util.parsers.softlab.resultado.InformaPeriodoImportacaoSoftLab;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ImportacaoResultadoSoftLabDao
extends AbstractImportadorResultadoLabExternoDao {
    private static final String LEQ_SEQUENCIALREQUISICAO = "leq_sequencialrequisicao";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requisicaoValida(String codFilial, String codRequisicao) {
        boolean valida;
        Statement st;
        block4: {
            StringBuilder sql = new StringBuilder(" select req_codigo from requisicao ");
            sql.append(" where fil_codigo = ").append(codFilial);
            sql.append(" and req_codigo = ").append(codRequisicao);
            sql.append(" and req_excluida is not null and req_excluida = false ");
            st = ConexaoTemporaria.getStatement();
            valida = false;
            try {
                ResultSet resultado = st.executeQuery(sql.toString());
                if (!resultado.next()) break block4;
                valida = true;
            }
            catch (SQLException e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return valida;
    }

    public Map<Integer, List<ExameRequisicaoDTO>> pesquisarExamesComLotePorRequisicao(String codFilial, Integer[] multiguias, int codLabExterno) throws SQLException {
        return this.pesquisarExamesComLotePorRequisicao(codFilial, multiguias, codLabExterno, "", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<Integer, List<ExameRequisicaoDTO>> pesquisarExamesComLotePorRequisicao(String codFilial, Integer[] multiguias, int codLabExterno, String exame, Integer material) throws SQLException {
        Statement st = Conexao.getStatement();
        ConcurrentHashMap<Integer, List<ExameRequisicaoDTO>> examesSequencia = new ConcurrentHashMap<Integer, List<ExameRequisicaoDTO>>();
        ArrayList<ExameRequisicaoDTO> exames = new ArrayList<ExameRequisicaoDTO>();
        try {
            ResultSet rs = Conexao.executeQuery(st, this.getSqlPesquisarExameComLotePorRequisicao(codFilial, multiguias, codLabExterno, exame, material));
            int sequencial = -1;
            while (rs.next()) {
                if (sequencial == -1) {
                    sequencial = rs.getInt(LEQ_SEQUENCIALREQUISICAO);
                }
                if (rs.getInt(LEQ_SEQUENCIALREQUISICAO) != sequencial) {
                    examesSequencia.put(sequencial, exames);
                    sequencial = rs.getInt(LEQ_SEQUENCIALREQUISICAO);
                    exames = new ArrayList();
                }
                if (rs.getInt(LEQ_SEQUENCIALREQUISICAO) != sequencial) continue;
                String exaCodigo = rs.getString("exa_codigo");
                Integer mcoCodigo = rs.getInt("mco_codigo");
                if (!Funcoes.textoVazio(rs.getString("exa_kodigo")) && !Funcoes.textoVazio(rs.getString("mco_kodigo"))) {
                    exaCodigo = rs.getString("exa_kodigo");
                    mcoCodigo = rs.getInt("mco_kodigo");
                }
                exames.add(new ExameRequisicaoDTO(exaCodigo, mcoCodigo));
            }
            if (!exames.isEmpty()) {
                examesSequencia.put(sequencial, exames);
            }
            if (st == null) return examesSequencia;
        }
        catch (SQLException sQLException) {
            if (st == null) return examesSequencia;
            Conexao.fecharStatement(st);
            return examesSequencia;
            catch (Throwable throwable) {
                if (st == null) throw throwable;
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return examesSequencia;
    }

    private String getSqlPesquisarExameComLotePorRequisicao(String codFilial, Integer[] multiguias, int codLabExterno, String exame, Integer material) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ler.leq_sequencialrequisicao, leer.exa_codigo, leer.mco_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo ");
        sql.append(" from loteexterno l ");
        sql.append(" left join loteexternorequisicao ler on l.fil_codigo  = ler.fil_codigo and l.lex_codigo = ler.lex_codigo and l.lae_codigo = ler.lae_codigo ");
        sql.append(" left join loteexternoexamerequisicao leer on l.fil_codigo  = leer.fil_codigo and l.lex_codigo = leer.lex_codigo and l.lae_codigo = leer.lae_codigo and ler.req_codigo  = leer.req_codigo ");
        sql.append(" left join loteexternoexamerequisicaodesm ldesm on leer.fil_codigo = ldesm.fil_codigo and leer.fil_kodigo = ldesm.fil_kodigo and leer.lex_codigo = ldesm .lex_codigo and leer.lae_codigo = ldesm.lae_codigo and leer.exa_codigo = ldesm.exa_codigo and leer.mco_codigo = ldesm.mco_codigo ");
        sql.append(" where l.fil_codigo = ").append(codFilial);
        sql.append("   and l.lae_codigo = ").append(codLabExterno);
        sql.append("   and ler.req_codigo in (");
        for (Integer guia : multiguias) {
            sql.append(guia).append(",");
        }
        sql.replace(sql.length() - 1, sql.length(), ") ");
        sql.append(" and (l.lex_dataestorno is null and ler.leq_dataestorno is null and leer.ler_datahoraestorno is null) ");
        if (!Funcoes.textoVazio(exame) && null != material && material > -1) {
            sql.append(" and leer.exa_codigo = ").append(StringUtil.textoDBEscape(exame)).append(" and leer.mco_codigo = ").append(material);
        }
        sql.append(" order by leq_sequencialrequisicao desc ");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSituacaoExameRequisicao(String filial, String requisicao, String exame, Integer material) throws SQLException {
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        String retorno = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" select coalesce(exr_situacao, '') as exr_situacao ");
        sql.append(" from examerequisicao ");
        sql.append(" where fil_codigo = ").append(filial);
        sql.append("   and req_codigo = ").append(requisicao);
        sql.append("   and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
        sql.append("   and mco_codigo = ").append(material);
        sql.append("   and exr_excluido = false ");
        try {
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                retorno = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return retorno;
    }

    public boolean exameRelacionado(Statement st, Registro reg, int codigoLabExterno) {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder();
            sql.append("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            try {
                ResultSet rs = null;
                rs = Conexao.executeQuery(st, sql.toString());
                if (rs.next() && rs.getInt("lae_codigo") == codigoLabExterno) {
                    TipoDeExameDTO exameLabExterno = TipoDeExameDTO.fromJson(rs.getString("ele_xmllabexterno"));
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select sft_json from examessoftlab where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(codigoLabExterno);
                    sqlBuilder.append(" and sft_codexame = '").append(exameLabExterno.getCodigo()).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("sft_json", rs.getString("sft_json"));
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.anularSQL();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameDesmembrado pesquisarExameDesmembradoNoLote(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) throws SQLException {
        Statement st;
        block2: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block2;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ,a.mco_codigo ,p.ele_xmllabexterno, pai.ele_xmllabexterno as xmllabexternopai ");
                buf.append(" from loteexternoexamerequisicaodesm a ");
                buf.append(" left join examematcoletalabexterno p on a.fil_kodigo = p.fil_codigo and a.exa_kodigo = p.exa_codigo and a.mco_kodigo = p.mco_codigo and a.lae_codigo = p.lae_codigo ");
                buf.append(" left join examematcoletalabexterno pai on a.fil_kodigo = pai.fil_codigo and a.exa_codigo = pai.exa_codigo and a.mco_codigo = pai.mco_codigo and a.lae_codigo = pai.lae_codigo ");
                buf.append(" where a.fil_kodigo = ").append(filial);
                buf.append(" and a.req_codigo  = ").append(reqCodigo);
                buf.append(" and a.exa_kodigo = ").append(StringUtil.textoDBEscape(exaFilho));
                buf.append(" and a.mco_kodigo = ").append(mcoFilho);
                buf.append(" and a.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block2;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"), res.getString("xmllabexternopai"));
                ex.addFilho(new Exame(exaFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registro pesquisarExameRequisicao(String codFilial, String codRequisicao, String codExame, String mcoCodigo, String codigoLabExterno) {
        Statement st;
        block4: {
            Registro registro;
            String and = " and ";
            StringBuilder sql = new StringBuilder();
            sql.append(" select a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, ");
            sql.append(" b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, coalesce(g.met_codigo, e.met_codigo) as met_codigo, ");
            sql.append(" c.pac_idade, c.pac_anomes, b.exr_datamaterial, ");
            sql.append(" d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, b.exr_resposta, ");
            sql.append(" a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao, le.lae_configuracao, le.lae_codigo ");
            sql.append(" from requisicao a ");
            sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
            sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo ");
            sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo ");
            sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo ");
            sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' ");
            sql.append(" left join labexterno le on g.fil_codigo = le.fil_codigo and g.lae_codigo = le.lae_codigo ");
            sql.append(" where ");
            sql.append(" a.fil_codigo = ").append(codFilial).append(and);
            sql.append(" a.req_codigo = ").append(codRequisicao).append(and);
            sql.append(" b.exa_codigo = '").append(codExame).append("'").append(and);
            sql.append(" b.mco_codigo = ").append(mcoCodigo).append(and);
            sql.append(" f.lae_codigo = ").append(codigoLabExterno);
            sql.append(" and a.req_excluida = false and b.exr_excluido = false ");
            st = Conexao.getStatement();
            try {
                ResultSet res;
                if (st == null || !(res = Conexao.executeQuery(st, sql.toString())).next()) break block4;
                Registro reg = new Registro(res);
                reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(codFilial, res.getString("con_codigo"), res.getString("des_codigo")));
                reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(codFilial, reg.getString("codigo-layout")));
                Registro formatacao = new Registro();
                formatacao.setValor("formato", reg.getValor("exr_resultado"));
                formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                reg.setValor("formatacao", formatacao);
                registro = reg;
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return registro;
        }
        Conexao.fecharStatement(st);
        return new Registro();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<Integer, List<String>> pesquisarExamesLoteExterno(InformaPeriodoImportacaoSoftLab periodoImportacao, int codLabExterno) throws SQLException {
        ConcurrentHashMap<Integer, List<String>> filialRequisicao = new ConcurrentHashMap<Integer, List<String>>();
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append(" select ler.fil_kodigo as fil_codigo, ler.req_codigo as requisicao ");
        sql.append(" from loteexterno le ");
        sql.append(" left join loteexternorequisicao ler on ");
        sql.append(" le.fil_codigo = ler.fil_codigo and le.lex_codigo = ler.lex_codigo and le.lae_codigo = ler.lae_codigo ");
        sql.append(" left join loteexternoexamerequisicao leer on ");
        sql.append(" ler.fil_codigo = leer.fil_codigo and ler.lex_codigo = leer .lex_codigo and ler.req_codigo = leer.req_codigo and ler.lae_codigo = leer.lae_codigo and ler.fil_kodigo = leer.fil_kodigo ");
        sql.append(" left join loteexternoexamerequisicaodesm ldesm on ");
        sql.append(" leer.fil_codigo = ldesm.fil_codigo and leer.fil_kodigo = ldesm.fil_kodigo and leer.lex_codigo = ldesm.lex_codigo and leer.lae_codigo = ldesm.lae_codigo and leer.exa_codigo = ldesm.exa_codigo and leer.mco_codigo = ldesm.mco_codigo ");
        sql.append(" left join examematcoletalabexterno exame on ");
        sql.append(" leer.fil_kodigo = exame.fil_codigo and leer.exa_codigo = exame.exa_codigo and leer.mco_codigo = exame.mco_codigo and leer.lae_codigo = exame.lae_codigo ");
        sql.append(" left join examematcoletalabexterno exameDesm on ");
        sql.append(" ldesm.fil_kodigo = exameDesm.fil_codigo and ldesm.exa_kodigo = exameDesm.exa_codigo and ldesm.mco_kodigo = exameDesm.mco_codigo ");
        sql.append(" left join examerequisicao er on ");
        sql.append(" leer.fil_kodigo = er.fil_codigo and leer.req_codigo = er.req_codigo and leer.exa_codigo = er.exa_codigo and leer.mco_codigo = er.mco_codigo ");
        sql.append(" where ler.lae_codigo = ").append(codLabExterno);
        sql.append(" and le.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and le.lex_datahora between ' ").append(Funcoes.formataData("yyyy-MM-dd", periodoImportacao.getDataInicial())).append(" 00:00'");
        sql.append(" and ' ").append(Funcoes.formataData("yyyy-MM-dd", periodoImportacao.getDataFinal())).append(" 23:59'");
        sql.append(" and le.lex_dataestorno is null ");
        sql.append(" and le.usr_codestorno is null ");
        sql.append(" and ler.leq_dataestorno is null ");
        sql.append(" and ler.usr_codestorno is null ");
        sql.append(" and leer.ler_datahoraestorno is null ");
        sql.append(" and er.exr_excluido = 'f' ");
        sql.append(" group by ler.fil_kodigo, ler.req_codigo ");
        sql.append(" order by ler.fil_kodigo, ler.req_codigo ");
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, sql);
            Integer filial = 0;
            ArrayList<String> requisicao = new ArrayList<String>();
            while (rs.next()) {
                if (filial == 0) {
                    filial = rs.getInt("fil_codigo");
                }
                if (rs.getInt("fil_codigo") != filial.intValue()) {
                    requisicao.add(rs.getString("requisicao"));
                    requisicao = new ArrayList();
                }
                if (rs.getInt("fil_codigo") != filial.intValue()) continue;
                requisicao.add(rs.getString("requisicao"));
            }
            if (!requisicao.isEmpty()) {
                filialRequisicao.put(filial, requisicao);
            }
            if (st == null) return filialRequisicao;
        }
        catch (SQLException sQLException) {
            if (st == null) return filialRequisicao;
            Conexao.fecharStatement(st);
            return filialRequisicao;
            catch (Throwable throwable) {
                if (st == null) throw throwable;
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return filialRequisicao;
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

