/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab.resultado;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.componente.RtfDigitacao;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.softlab.ComunicacaoSoftLab;
import jalis.laboratorio.util.parsers.softlab.dto.ExameRequisicaoDTO;
import jalis.laboratorio.util.parsers.softlab.dto.FilialRequisicaoDTO;
import jalis.laboratorio.util.parsers.softlab.dto.RespostaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.RetornoConsultaLiberacaoDTO;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.laboratorio.util.parsers.softlab.resultado.ImportacaoResultadoSoftLabDao;
import jalis.laboratorio.util.parsers.softlab.resultado.InformaPeriodoImportacaoSoftLab;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.rtf.RTFEditorKit;
import org.json.JSONObject;
import org.json.XML;

public class ImportacaoResultadoSoftLab
extends AbstractImportadorResultadoLabExterno {
    private static final String TITULO = "Importa\u00e7\u00e3o de resultados";
    private static final String DESCRICAO = "Importa\u00e7\u00e3o de resultados do SoftLab utilizando API da Integra\u00e7\u00e3o";
    private static final String MODULO_ACESSO = "904000201";
    private static final String DIRETORIO_USUARIO = System.getProperty("user.home");
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private boolean conferirAutomatico = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    private InformaPeriodoImportacaoSoftLab periodoImportacao;
    private LabExternoVO labExterno;
    private transient ImportacaoResultadoSoftLabDao dao;
    private Map<String, String> requisicoesEnvioNotificacao = new HashMap<String, String>();

    public ImportacaoResultadoSoftLab(int codigoLabExterno) {
        super(TITULO, DESCRICAO, codigoLabExterno, Protocolo.SoftLab, new JPanel(new FlowLayout(2)));
        this.modeloRelatorio.clear();
        this.buttonImportar.setVisible(false);
        this.buttonImportarWS.setVisible(true);
        this.buttonImportarWS.setEnabled(true);
        this.getPanelAdicional().add(this.buttonImprimir);
        this.dao = new ImportacaoResultadoSoftLabDao();
        try {
            this.labExterno = this.pesquisarPorCodLabExterno(codigoLabExterno);
            if (this.labExterno.getCodigo() != null) {
                this.conferirAutomatico = this.labExterno.getConferirAutomatico();
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(this.labExterno.getCodigoUsuarioConferir()) || Funcoes.textoVazio(this.labExterno.getCodigoUsuarioConferir()) ? null : this.labExterno.getCodigoUsuarioConferir();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSoftLab");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonImportarWS) {
            if (this.periodoImportacaoPreenchido()) {
                this.modeloRelatorio.clear();
                this.buttonImportarWS.setEnabled(false);
                super.actionPerformed(e);
            }
        } else if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean periodoImportacaoPreenchido() {
        this.periodoImportacao = InformaPeriodoImportacaoSoftLab.novaInstancia(this.getTopLevelAncestor(), this.dao);
        this.periodoImportacao.setVisible(true);
        return this.periodoImportacao.isOk();
    }

    @Override
    protected void importarResultadoWs() {
        if (this.periodoImportacao != null) {
            if (this.periodoImportacao.porListagem()) {
                this.importarListagemLiberacao();
            } else if (this.periodoImportacao.porRequisicao()) {
                this.setTextoInformacoes("\nIniciando a importa\u00e7\u00e3o de resultados... ", true);
                this.importarRequisicao(this.periodoImportacao.getCodFilial(), this.periodoImportacao.getCodRequisicao(), null);
            } else if (this.periodoImportacao.porPeriodo()) {
                this.importarPeriodo(this.periodoImportacao);
            }
            this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada!", false);
        }
        this.buttonImportarWS.setEnabled(true);
    }

    private FilialRequisicaoDTO identificaFilialRequisicao(String codigoLis) {
        String[] tmp;
        FilialRequisicaoDTO retorno = null;
        if (!Funcoes.textoVazio(codigoLis) && null != (tmp = codigoLis.split("\\.")) && tmp.length > 0) {
            String codigoSoftlab = Funcoes.preencheZero(tmp[0], ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String filial = codigoSoftlab.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String requisicao = codigoSoftlab.substring(ParametrosGerais.getDigitosTuboFilial());
            retorno = new FilialRequisicaoDTO(filial, requisicao);
        }
        return retorno;
    }

    private ExameRequisicaoDTO identificarExameMaterial(String codigoLis) {
        String[] tmp;
        ExameRequisicaoDTO retorno = null;
        if (!Funcoes.textoVazio(codigoLis) && null != (tmp = codigoLis.split("\\|")) && tmp.length == 2 && Funcoes.isNumeric(tmp[1])) {
            String exame = tmp[0];
            String material = tmp[1];
            retorno = new ExameRequisicaoDTO(exame, Integer.parseInt(material));
        }
        return retorno;
    }

    private void importarListagemLiberacao() {
        block14: {
            this.setTextoInformacoes("\nSolicitando a listagem de resultados liberados no apoio... ", true);
            ComunicacaoSoftLab comunicacao = ComunicacaoSoftLab.getInstancia(this.labExterno.getConfiguracao());
            String pathResultadoExame = "/api/Laudo";
            try {
                RespostaDTO resposta = comunicacao.solicitarLoteLiberado("/api/Laudo");
                if (resposta.getStatusCode() == 200) {
                    this.gravarArquivoNaPastaDoUsuario(resposta.getConteudo().getBytes(), "ListagemLiberados", Funcoes.formataData("ddMMyyyykkmmss", new Date()), "json");
                    ObjectMapper mapper = new ObjectMapper();
                    RetornoConsultaLiberacaoDTO[] exames = null;
                    try {
                        exames = (RetornoConsultaLiberacaoDTO[])mapper.readValue(resposta.getConteudo(), RetornoConsultaLiberacaoDTO[].class);
                        if (null == exames) break block14;
                        if (exames.length > 0) {
                            for (RetornoConsultaLiberacaoDTO exame : exames) {
                                if (!Funcoes.textoVazio(exame.getCodigoExameLis()) && !Funcoes.textoVazio(exame.getCodigoPedidoLis())) {
                                    FilialRequisicaoDTO req = this.identificaFilialRequisicao(exame.getCodigoPedidoLis());
                                    ExameRequisicaoDTO exm = this.identificarExameMaterial(exame.getCodigoExameLis());
                                    if (null != req && null != exm) {
                                        this.importarRequisicao(req.getFilial(), req.getRequisicao(), null, exm.getExame(), exm.getMaterial());
                                        continue;
                                    }
                                    this.setTextoInformacoes("\nFilial/Requisi\u00e7\u00e3o n\u00e3o identificada para " + exame.getCodigoPedidoLis(), false);
                                    continue;
                                }
                                String msg = "";
                                if (Funcoes.textoVazio(exame.getCodigoExameLis())) {
                                    msg = "C\u00f3digo do exame LIS";
                                }
                                if (Funcoes.textoVazio(exame.getCodigoPedidoLis())) {
                                    if (!Funcoes.textoVazio(msg)) {
                                        msg = msg + " ou ";
                                    }
                                    msg = "C\u00f3digo LIS da requisi\u00e7\u00e3o";
                                }
                                msg = msg + " n\u00e3o localizado";
                                this.setTextoInformacoes("\n" + msg, false);
                            }
                            break block14;
                        }
                        this.setTextoInformacoes("\nN\u00e3o h\u00e1 exames para importar na listagem", false);
                    }
                    catch (JsonProcessingException e) {
                        this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel identificar a listagem de exames liberados (" + e.getMessage() + ")", false);
                    }
                    break block14;
                }
                if (resposta.getStatusCode() == 404) {
                    this.setTextoInformacoes("\nN\u00e3o h\u00e1 exames para importar na listagem", false);
                } else {
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel processar a listagem de exames liberados (" + resposta.getStatusCode() + ")", false);
                }
            }
            catch (IOException e) {
                this.setTextoInformacoes("\nFalha ao solicitar a listagem de exames liberados (" + e.getMessage() + ")", false);
            }
        }
    }

    private void importarRequisicao(String codFilial, String codRequisicao, Integer[] multiguias) {
        this.importarRequisicao(codFilial, codRequisicao, multiguias, "", null);
    }

    private boolean exameJaDigitado(String situacao) {
        return situacao != null && (situacao.equals("L") || situacao.equals("C") || situacao.equals("I") || situacao.equals("E"));
    }

    private void importarRequisicao(String codFilial, String codRequisicao, Integer[] multiguias, String codigoExame, Integer codigoMaterial) {
        try {
            if (Funcoes.textoVazio(codRequisicao) && multiguias != null) {
                codRequisicao = String.valueOf(multiguias[0]);
            }
            if (multiguias == null) {
                multiguias = this.verificarRequisicaoMultiguia(codFilial, codRequisicao, this.labExterno.getAgruparmultiguias());
            }
            Map<Integer, List<ExameRequisicaoDTO>> examesSequencia = this.dao.pesquisarExamesComLotePorRequisicao(codFilial, multiguias, this.codigoLabExterno, codigoExame, codigoMaterial);
            ConcurrentHashMap<String, String> resultados = new ConcurrentHashMap<String, String>();
            this.requisicoesEnvioNotificacao = new HashMap<String, String>();
            if (!examesSequencia.isEmpty()) {
                String codPedidoLis = Funcoes.preencheZero(codFilial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(codRequisicao, ParametrosGerais.getDigitosTuboRequisicao());
                this.setTextoInformacoes("\nSolicitando resultados da Requisi\u00e7\u00e3o " + codPedidoLis, false);
                ComunicacaoSoftLab comunicacao = ComunicacaoSoftLab.getInstancia(this.labExterno.getConfiguracao());
                for (Map.Entry<Integer, List<ExameRequisicaoDTO>> entry : examesSequencia.entrySet()) {
                    Integer sequencial = entry.getKey();
                    List<ExameRequisicaoDTO> exames = entry.getValue();
                    for (ExameRequisicaoDTO exame : exames) {
                        RespostaDTO resposta = new RespostaDTO();
                        try {
                            String codPedidoLisGuia = "";
                            ArrayList<RespostaDTO> retornoErroApoio = new ArrayList<RespostaDTO>();
                            for (Integer guia : multiguias) {
                                codPedidoLisGuia = Funcoes.preencheZero(codFilial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(guia, ParametrosGerais.getDigitosTuboRequisicao());
                                String codPedidoLisSequencial = sequencial != 0 ? codPedidoLisGuia + "." + sequencial : codPedidoLisGuia;
                                String situacao = this.dao.getSituacaoExameRequisicao(codFilial, String.valueOf(guia), exame.getExame(), exame.getMaterial());
                                if (!this.exameJaDigitado(situacao)) {
                                    String exameEncoded = URLEncoder.encode(exame.getExameCodificadoParaSoftlab(), "UTF-8");
                                    String pathResultadoExame = "/api/Laudo/rtf?codigoPedidoLis=" + codPedidoLisSequencial + "&codigoExameLis=" + exameEncoded;
                                    resposta = comunicacao.enviarSolicitacao(pathResultadoExame);
                                    if (resposta.getStatusCode() == 200) {
                                        String resultadoEncodado = new String(resposta.getConteudo().getBytes(), StandardCharsets.ISO_8859_1);
                                        if (!resultadoEncodado.endsWith("}")) {
                                            resultadoEncodado = resultadoEncodado.substring(0, resultadoEncodado.length() - 1);
                                        }
                                        resultados.put(exame.getExameCodificadoParaSoftlab(), resultadoEncodado.replace(System.lineSeparator(), ""));
                                        break;
                                    }
                                    retornoErroApoio.add(resposta);
                                    continue;
                                }
                                resposta = new RespostaDTO();
                                resposta.setStatusCode(200);
                                resultados.put(exame.getExameCodificadoParaSoftlab(), "");
                            }
                            this.processarErroImportacaoResultado(codPedidoLis, exame.getExameCodificadoParaSoftlab(), resposta, retornoErroApoio);
                        }
                        catch (Exception e) {
                            this.setTextoInformacoes("\nFalha na comunica\u00e7\u00e3o com SoftLab - " + e.getMessage(), false);
                            this.setTextoInformacoes("\nImporta\u00e7\u00e3o cancelada!", false);
                            return;
                        }
                    }
                }
                if (!resultados.isEmpty()) {
                    for (Map.Entry<Integer, List<ExameRequisicaoDTO>> entry : resultados.entrySet()) {
                        this.gravarArquivoNaPastaDoUsuario(((String)((Object)entry.getValue())).getBytes(), codFilial + "_" + codRequisicao + "_" + (String)((Object)entry.getKey()), codRequisicao, "rtf");
                        this.processarResultado(codFilial, codRequisicao, (String)((Object)entry.getKey()), (String)((Object)entry.getValue()));
                    }
                }
            } else {
                this.setTextoInformacoes(String.format("\nNa requisi\u00e7\u00e3o informada (%s, %s), n\u00e3o h\u00e1 exames que atendam os requisitos de importa\u00e7\u00e3o.", codFilial, codRequisicao), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void gravarArquivoNaPastaDoUsuario(byte[] conteudo, String nomeArquivo, String identificador, String extensao) {
        Path diretorioResultadoSoftLab = Paths.get(DIRETORIO_USUARIO + File.separator + "resultadosSoftLab", new String[0]);
        try {
            Path diretorioRequisicaoSoftLab;
            if (!diretorioResultadoSoftLab.toFile().exists()) {
                Files.createDirectories(diretorioResultadoSoftLab, new FileAttribute[0]);
            }
            if (!(diretorioRequisicaoSoftLab = Paths.get(DIRETORIO_USUARIO + File.separator + "resultadosSoftLab" + File.separator + identificador, new String[0])).toFile().exists()) {
                Files.createDirectories(diretorioRequisicaoSoftLab, new FileAttribute[0]);
            }
            Files.write(Paths.get(diretorioRequisicaoSoftLab.toString() + File.separator + nomeArquivo.replace("|", "_") + "." + extensao, new String[0]), conteudo, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processarErroImportacaoResultado(String codPedidoLis, String exame, RespostaDTO resposta, List<RespostaDTO> retornoErroApoio) {
        if (resposta.getStatusCode() != 200) {
            this.setTextoInformacoes("\nImportando " + exame.substring(0, exame.indexOf("|")) + " da Requisi\u00e7\u00e3o " + codPedidoLis, false);
            for (RespostaDTO retorno : retornoErroApoio) {
                if (retorno.getStatusCode() == 404) continue;
                resposta = retorno;
            }
            this.setTextoInformacoes(" - Retorno do apoio: " + this.processaJsonDeErro(resposta), false);
        }
    }

    private void importarPeriodo(InformaPeriodoImportacaoSoftLab periodoSoftlab) {
        try {
            this.setTextoInformacoes("\nConsultando as requisi\u00e7\u00f5es do Per\u00edodo informado... ", true);
            Map<Integer, List<String>> filialRequisicao = this.dao.pesquisarExamesLoteExterno(periodoSoftlab, this.codigoLabExterno);
            if (!filialRequisicao.isEmpty()) {
                for (Map.Entry<Integer, List<String>> filReq : filialRequisicao.entrySet()) {
                    String filial = String.valueOf(filReq.getKey());
                    List<String> requisicoes = filReq.getValue();
                    this.importar(filial, requisicoes);
                }
            } else {
                this.setTextoInformacoes("\nN\u00e3o h\u00e1 no per\u00edodo informado, requisi\u00e7\u00f5es que atendam os requisitos de importa\u00e7\u00e3o. Importa\u00e7\u00e3o Finalizada!", false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void importar(String filial, List<String> requisicoes) {
        while (!requisicoes.isEmpty()) {
            String req = requisicoes.get(0);
            Object[] multiguias = this.verificarRequisicaoMultiguia(filial, req, this.labExterno.getAgruparmultiguias());
            Arrays.sort(multiguias);
            this.importarRequisicao(filial, null, (Integer[])multiguias);
            this.removeGuiasSolicitadas(requisicoes, (Integer[])multiguias);
            if (!requisicoes.isEmpty()) continue;
            break;
        }
    }

    private void removeGuiasSolicitadas(List<String> requisicoes, Integer[] multiguias) {
        List guiasAManter = requisicoes.stream().filter(guia -> !Arrays.asList(multiguias).contains(Integer.valueOf(guia))).collect(Collectors.toList());
        requisicoes.clear();
        requisicoes.addAll(guiasAManter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processarResultado(String codFilial, String codRequisicao, String exameMaterial, String resultadoSoftLab) {
        Statement st = Conexao.getStatement();
        String codExameJalis = exameMaterial.split("\\|")[0];
        String codMaterialJalis = exameMaterial.split("\\|")[1];
        try {
            Integer[] multiguias = this.verificarRequisicaoMultiguia(codFilial, codRequisicao, this.labExterno.getAgruparmultiguias());
            LinkedList<Registro> listaRegistros = this.carregarExamesPaiEFilhos(st, codFilial, codExameJalis, codMaterialJalis, multiguias);
            if (listaRegistros == null || listaRegistros.isEmpty()) {
                this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o encontrada: " + codFilial + codRequisicao, false);
                return;
            }
            for (Registro reg : listaRegistros) {
                boolean completo;
                Registro formatacao;
                String codExame = this.exameDesmembrado(reg) ? reg.getString("examePai") : reg.getString("exa_codigo");
                String mcoCodigo = this.exameDesmembrado(reg) ? reg.getString("mcoPai") : reg.getString("mco_codigo");
                String codPedidoLis = Funcoes.preencheZero(codFilial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(codRequisicao, ParametrosGerais.getDigitosTuboRequisicao());
                if (this.exameDesmembrado(reg)) {
                    this.setTextoInformacoes("\nImportando " + codExame + " (" + reg.getString("exa_codigo") + ") da Requisi\u00e7\u00e3o " + codPedidoLis, false);
                } else {
                    this.setTextoInformacoes("\nImportando " + codExame + " da Requisi\u00e7\u00e3o " + codPedidoLis, false);
                }
                if (this.possuiErro(st, reg, codFilial, codRequisicao, codExame, codMaterialJalis)) continue;
                String codigoExame = reg.nulo("examePai") ? reg.getString("exa_codigo") : reg.getString("examePai");
                boolean salvoParcial = reg.getString("exr_situacao").equals("P");
                ExameUtil.pegaLayoutIdade(reg.getString("fil_codigo"), Integer.parseInt(reg.getString("req_idade")), reg.getString("req_anomes"), reg.getString("codigo-layout"), codigoExame, Integer.parseInt(reg.getString("mco_codigo")), Integer.parseInt(reg.getString("met_codigo")), "elm_formato", reg);
                Registro formato = new Registro();
                formato.setValor("formato", reg.getValor("formatoPadrao"));
                formato.setValor("met_codigo", reg.getValor("met_codigo"));
                Registro registro = formatacao = salvoParcial ? (Registro)reg.getValor("formatacao") : formato;
                if (formatacao == null || Funcoes.textoVazio(formatacao.getString("formato"))) {
                    this.setTextoInformacoes(" - Erro ao importar: Laudo n\u00e3o encontrado", false);
                    continue;
                }
                Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                String campoImportacao = this.carregarCampoImportacao(formato.getValor("formato").toString(), reg, codMaterialJalis);
                dados.put(campoImportacao, resultadoSoftLab);
                Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                }
                dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                Map<String, Object> resposta = Resultado.getCamposResultado(reg.getString("exr_resposta"));
                Resultado res = new Resultado(formatacao.getString("formato"), dados);
                res = new Resultado(null, formatacao.getString("formato"), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
                res.atualizarComponentes();
                if (!res.verificarCondicao()) {
                    this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA);
                    this.setTextoInformacoes(" - Resultado de " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                    continue;
                }
                Util.gravaAlteracaoExameRequisicao(st, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), codPedidoLis)) {
                    this.inserirDadosRequisicao(st, this.codigoLabExterno, codPedidoLis, reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                String novaSituacao = (completo = this.validaResultadoCompleto(reg, res)) ? "L" : "P";
                String resultado = res.getResultado();
                boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                boolean marcarConferido = false;
                if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                    int verificacao = res.verificarValidacao();
                    boolean bl = marcarConferido = verificacao == 1;
                    if (!marcarConferido && verificacao != 2) {
                        this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                        this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA);
                    }
                }
                if (!reg.nulo("examePai")) {
                    reg.setValor("exa_codigo", reg.getString("examePai"));
                }
                if (!this.isLatin1(resultadoSoftLab)) {
                    this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA);
                    continue;
                }
                this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), this.verificaStatus(completo, marcarConferido));
                if (completo) {
                    Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                    Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                    this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                    this.processaExportarParaWeb(st, reg, formatacao, novaSituacao, resultado);
                }
                this.editarRequisicaoExportaFiliais(reg);
                this.atualizarSituacaoExameInterfaceamento(st, reg);
                DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), codExame, mcoCodigo, 8);
                this.setTextoInformacoes(" - " + this.verificaStatus((boolean)completo, (boolean)marcarConferido).descricao.toUpperCase(), false);
                String filialRequisicao = reg.getString("fil_codigo") + "-" + reg.getString("req_codigo");
                this.requisicoesEnvioNotificacao.put(filialRequisicao, reg.getString("req_codigo"));
            }
            this.enviarNotificacoes(this.requisicoesEnvioNotificacao);
            this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > -1);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.buttonImportarWS.setEnabled(true);
        }
    }

    private boolean validaResultadoCompleto(Registro reg, Resultado res) {
        boolean completo = true;
        if (reg.getBoolean("exa_salvaparcial")) {
            completo = res.resultadoCompleto(true);
        }
        return completo;
    }

    private boolean exameDesmembrado(Registro reg) {
        return !Funcoes.textoVazio(reg.getString("examePai")) && !reg.getString("examePai").equals(reg.getString("exa_codigo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarNotificacoes(Map<String, String> hashMapFilialRequisicao) throws Exception {
        if (!hashMapFilialRequisicao.isEmpty() && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica)) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            String filial = "";
            String requisicao = "";
            try {
                for (Map.Entry<String, String> filReq : hashMapFilialRequisicao.entrySet()) {
                    String[] filialRequisicao = filReq.getKey().split("-");
                    if (filialRequisicao.length <= 1) continue;
                    filial = filialRequisicao[0];
                    requisicao = filialRequisicao[1];
                    this.criarLog(st, st2, filial, requisicao);
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private void criarLog(Statement st, Statement st2, String filial, String requisicao) throws Exception {
        if (!SMSUtil.isBloquearSMSExamePronto(filial, requisicao, st)) {
            SMSUtil.criaLogSmsComDadosRequisicao(filial, requisicao, ExportaSMS.TipoSMS.RESULTADO, st, st2);
        }
        if (!EmailUtil.isBloquearEmailExamePronto(filial, requisicao, st)) {
            EmailUtil.criaLogEmail(filial, requisicao, null, EmailUtil.TipoEmail.RESULTADO, true, st);
        }
        if (!PushUtil.isBloquearPushExamePronto(filial, requisicao, st)) {
            PushUtil.criaLogPushComDadosRequisicao(filial, requisicao, TipoPush.RESULTADO, st, st2);
        }
        if (!WhatsAppUtil.isBloquearWhatsappExamePronto(filial, requisicao, st)) {
            WhatsAppUtil.criaLogWhatsappComDadosRequisicao(filial, requisicao, TipoWhatsapp.RESULTADO, st, st2);
        }
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSoftLab");
        }
    }

    private void processaExportarParaWeb(Statement st, Registro registro, Registro formatacao, String novaSituacao, String resultado) throws Exception {
        if (this.exportarBaseWeb(registro.getString("fil_codigo"))) {
            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st, registro.getString("fil_codigo"), registro.getString("req_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo"), resultado, false);
            this.exportarParaWeb(st, this.getCodigoBaseWeb(registro.getString("fil_codigo")), novaSituacao, registro, mapa, resultado, formatacao.getString("formatotexto"));
            if (ExportaWeb.isGerarPdfResultado(st, registro.getString("fil_codigo"))) {
                ExportaWeb.enviarResultadoPDF(st, registro.getString("fil_codigo"), registro.getString("req_codigo"), this.getCodigoBaseWeb(registro.getString("fil_codigo")));
            }
            ExportaWeb.atualizaPaginaOrdemExameWeb(st, registro.getString("fil_codigo"), registro.getString("req_codigo"), Variaveis.codigoBaseWeb);
        }
    }

    private boolean possuiErro(Statement st, Registro registro, String codFilial, String codRequisicao, String codExame, String codMaterial) {
        if (registro == null) {
            return true;
        }
        if (this.exameLancado(registro)) {
            this.setTextoInformacoes(" - J\u00c1 " + Tipos.tipoSituacaoExame(registro.getString("exr_situacao")).toUpperCase(), false);
            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, codExame, codMaterial, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO);
            return true;
        }
        if (!this.dao.exameRelacionado(st, registro, this.codigoLabExterno)) {
            this.setTextoInformacoes(this.construirMensagemErro("Erro ao importar: Sem Relacionamento"), false);
            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, codExame, codMaterial, AbstractImportadorResultadoLabExterno.Situacao.SEM_RELACIONAMENTO);
            return true;
        }
        return false;
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private String construirMensagemErro(String erro) {
        return String.format(" - %s", erro);
    }

    private String carregarCampoImportacao(String xmlFormato, Registro reg, String codMaterialJalis) {
        List<String> componentes = StringUtil.getListValores(xmlFormato, "componente");
        String campoImportacao = "";
        if (!reg.nulo("examePai")) {
            campoImportacao = this.carregarCampoImportacaoDesmembrado(reg, codMaterialJalis, componentes, campoImportacao);
        } else {
            for (String comp : componentes) {
                if (!comp.contains("jalis.laboratorio.configurador.componente.Rtf")) continue;
                String conteudo = StringUtil.getValor(comp, "campoImportacao");
                campoImportacao = StringUtil.getValor(conteudo, "campo");
                break;
            }
        }
        return campoImportacao;
    }

    private String carregarCampoImportacaoDesmembrado(Registro reg, String codMaterialJalis, List<String> componentes, String campoImportacao) {
        TipoDeExameDTO tipoDeExame = TipoDeExameDTO.fromJson(reg.getString("ele_xmllabexterno"));
        String codExame = tipoDeExame.getCodigo();
        String codigoCampo = codExame + "@" + codExame + "#" + codMaterialJalis;
        for (String comp : componentes) {
            String conteudo;
            if (!comp.contains("jalis.laboratorio.configurador.componente.Rtf") || !codigoCampo.equals(campoImportacao = StringUtil.getValor(conteudo = StringUtil.getValor(comp, "campoImportacao"), "campo"))) continue;
            return campoImportacao;
        }
        return campoImportacao;
    }

    private LinkedList<Registro> carregarExamesPaiEFilhos(Statement st, String codFilial, String codExameJalis, String codMaterialJalis, Integer[] multiguias) throws SQLException {
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        if (!Funcoes.isNumeric(codMaterialJalis)) {
            return retorno;
        }
        for (Integer guia : multiguias) {
            Registro exameSeparado;
            boolean exameLabExterno = LoteExternoExameRequisicaoService.validaExameLabExterno(codFilial, guia.toString(), codExameJalis, codMaterialJalis, codFilial, st);
            if (exameLabExterno && (exameSeparado = this.dao.pesquisarExameRequisicao(st, codFilial, guia.toString(), codExameJalis, codMaterialJalis, this.codigoLabExterno)) != null) {
                retorno.add(exameSeparado);
            }
            this.carregarExamesPaiEFilhosDesmembrados(codFilial, codExameJalis, codMaterialJalis, retorno, guia);
        }
        return retorno;
    }

    private void carregarExamesPaiEFilhosDesmembrados(String codFilial, String codExameJalis, String codMaterialJalis, LinkedList<Registro> retorno, Integer guia) throws SQLException {
        ExameDesmembrado pai = this.dao.pesquisarExameDesmembradoNoLote(codFilial, guia.toString(), String.valueOf(this.codigoLabExterno), codExameJalis, codMaterialJalis);
        if (pai != null) {
            Registro reg;
            Statement st = Conexao.getStatement();
            boolean isExameLabExternoDesm = LoteExternoExameRequisicaoService.validaExameLabExterno(Variaveis.filialPadrao, guia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()), codFilial, st);
            Conexao.fecharStatement(st);
            if (isExameLabExternoDesm && (reg = this.dao.pesquisarExameRequisicao(codFilial, guia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()), String.valueOf(this.labExterno.getCodigo()))).possuiCampo("req_codigo")) {
                reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                reg.setValor("xmllabexternopai", pai.getXmlLabExterno());
                reg.setValor("examePai", pai.getCodigoExame());
                reg.setValor("mcoPai", pai.getCodigomaterial());
                reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                retorno.add(reg);
            }
        }
    }

    private void adicionarAoModeloRelatorio(String filial, String req, String codExame, String codMaterial, AbstractImportadorResultadoLabExterno.Situacao situacao) {
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, req, codExame, Integer.parseInt(codMaterial), situacao.descricao);
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private String processaJsonDeErro(RespostaDTO resposta) {
        String json = resposta.getConteudo();
        String xmlErro = "";
        if (resposta.getConteudo().contains("[") && resposta.getConteudo().contains("]")) {
            json = json.replace("[", "").replace("]", "");
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            xmlErro = StringUtil.getValor(XML.toString((Object)jsonObject), "message");
        }
        catch (Exception e) {
            if (json.contains("\\\"")) {
                json = json.replace("\\\"", "").replace("\"", "");
            }
            xmlErro = json;
        }
        return xmlErro;
    }

    private AbstractImportadorResultadoLabExterno.Situacao verificaStatus(boolean completo, boolean marcarConferido) {
        return completo ? this.marcarConferido(marcarConferido) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE;
    }

    private AbstractImportadorResultadoLabExterno.Situacao marcarConferido(boolean marcarConferido) {
        return marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO;
    }

    private boolean isLatin1(String resultado) throws BadLocationException, IOException {
        JTextPane textPane = new JTextPane();
        RTFEditorKit editorKit = new RTFEditorKit();
        textPane.setContentType("text/rtf");
        textPane.setEditorKit(editorKit);
        textPane.setText("");
        StringReader reader = new StringReader(resultado);
        editorKit.read(reader, textPane.getDocument(), 0);
        for (char c : textPane.getDocument().getText(0, textPane.getDocument().getLength()).toCharArray()) {
            if (c <= '\u00ff' || RtfDigitacao.isCaracterInvalido(c)) continue;
            this.setTextoInformacoes(" - Caractere inv\u00e1lido (\\u" + c + ")", false);
            return false;
        }
        return true;
    }

    @Override
    protected void importarResultado() {
    }

    public static long getModuloAcesso() {
        return Long.valueOf(MODULO_ACESSO);
    }
}

