/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.softlab.ComunicacaoSoftLab;
import jalis.laboratorio.util.parsers.softlab.ExameSoftLab;
import jalis.laboratorio.util.parsers.softlab.ExamesSoftLabDAO;
import jalis.laboratorio.util.parsers.softlab.dto.IdentificacaoSoftLabDTO;
import jalis.laboratorio.util.parsers.softlab.dto.RespostaComFalhaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.RespostaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.model.bean.cadastro.exame.ExameMatColetaLabExternoBean;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.io.File;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ImportacaoSoftLab
extends AbstractImportadorLabExterno {
    private static final int NUM_MAXIMO_TENTATIVAS = 3;
    private static final int QTDE_EXAMES_CARREGADOS_PARA_PERSISTIR = 20;
    private static final String TITULO = "Importa\u00e7\u00e3o de Exames";
    private static final String DESCRICAO = "Importa\u00e7\u00e3o de exames do Lab. SoftLab a partir da API da integra\u00e7\u00e3o";
    private static final String DIRETORIO_USUARIO = System.getProperty("user.home");
    private transient LaboratorioExterno labExterno;
    private transient List<TipoDeExameDTO> examesSemDetalhes;
    private transient List<ExameSoftLab> examesInseridos;
    private transient List<ExameSoftLab> examesExcluidos;
    private transient ExamesSoftLabDAO dao;

    public ImportacaoSoftLab(int codigoLabExterno) {
        super(TITULO, DESCRICAO, codigoLabExterno, Protocolo.SoftLab);
        this.getButtonImportar().setText("Importar Exames");
        this.labExterno = LaboratorioExterno.getLabExterno(String.valueOf(codigoLabExterno));
        this.dao = new ExamesSoftLabDAO();
    }

    private void limparListas() {
        this.examesSemDetalhes = new ArrayList<TipoDeExameDTO>();
        this.examesExcluidos = new ArrayList<ExameSoftLab>();
        this.examesInseridos = new ArrayList<ExameSoftLab>();
    }

    @Override
    protected boolean importarArquivo() {
        this.limparListas();
        boolean importou = false;
        String enderecoAPI = StringUtil.getValor(this.labExterno.configuracao, "enderecoAPI");
        if (Funcoes.textoVazio(enderecoAPI)) {
            Funcoes.mensagem(this, "Configura\u00e7\u00e3o com Lab. externo SoftLab n\u00e3o foi realizada", 1);
            return importou;
        }
        this.setTextoInformacoesAdicionandoEnter("Aguarde enquanto comunicamos com o SoftLab...", true);
        List<TipoDeExameDTO> examesSimplificados = this.carregarExames();
        if (examesSimplificados.isEmpty()) {
            return importou;
        }
        List<ExameSoftLab> examesNoBanco = this.carregarExamesDobanco();
        this.setTextoInformacoesAdicionandoEnter("Lista de exames obtida com sucesso!", false);
        this.setTextoInformacoesAdicionandoEnter("Iniciando a importa\u00e7\u00e3o dos Materiais e demais informa\u00e7\u00f5es", false);
        List<ExameSoftLab> examesAtualizados = this.carregarDadosExames(examesSimplificados);
        if (examesAtualizados.isEmpty()) {
            return importou;
        }
        this.setTextoInformacoesAdicionandoEnter("Iniciando a importa\u00e7\u00e3o dos Materiais e demais informa\u00e7\u00f5es", false);
        for (ExameSoftLab es : examesNoBanco) {
            if (examesAtualizados.contains(es)) continue;
            this.examesExcluidos.add(es);
        }
        this.setTextoInformacoesAdicionandoEnter("Exames importados com sucesso!", false);
        this.excluirExames();
        this.exibirInformacoes(examesNoBanco);
        this.setTextoInformacoesAdicionandoEnter("Atualizando os c\u00f3digos da Tabela de Tempo de Jejum...", false);
        this.carregarTiposDeJejum();
        this.setTextoInformacoesAdicionandoEnter("A importa\u00e7\u00e3o foi conclu\u00edda!", false);
        return true;
    }

    private List<TipoDeExameDTO> carregarExames() {
        RespostaDTO respostaDTO = this.enviarSolicitacaoWebService("/api/tipoDeExame");
        List<TipoDeExameDTO> examesSoftLab = new ArrayList<TipoDeExameDTO>();
        if (respostaDTO.getStatusCode() != 200) {
            this.exibirMensagemFalha(respostaDTO);
            return examesSoftLab;
        }
        if (Funcoes.textoVazio(respostaDTO.getConteudo()) && respostaDTO.getTentativas() >= 3) {
            this.setTextoInformacoesAdicionandoEnter("Importa\u00e7\u00e3o de exames cancelada - n\u00famero m\u00e1ximo de tentativas excedido", false);
            return examesSoftLab;
        }
        try {
            examesSoftLab = (List)new ObjectMapper().readValue(respostaDTO.getConteudo(), (TypeReference)new TypeReference<List<TipoDeExameDTO>>(){});
            if (!examesSoftLab.isEmpty()) {
                this.gravarArquivoNaPastaDoUsuario(respostaDTO.getConteudo().getBytes(), "listaExamesSoftLab_");
            }
        }
        catch (Exception e) {
            this.setTextoInformacoesAdicionandoEnter("Falha ao processar lista de exames recebido do SoftLab - " + e.getMessage(), false);
            return examesSoftLab;
        }
        if (examesSoftLab.isEmpty()) {
            this.setTextoInformacoesAdicionandoEnter("Nenhum item encontrado", false);
        }
        return examesSoftLab;
    }

    private RespostaDTO enviarSolicitacaoWebService(String path) {
        RespostaDTO respostaDTO = new RespostaDTO();
        ComunicacaoSoftLab comunicacaoSoftLab = ComunicacaoSoftLab.getInstancia(this.labExterno.configuracao);
        int tentativas = 0;
        while (respostaDTO.getTentativas() < 3) {
            try {
                respostaDTO = comunicacaoSoftLab.enviarSolicitacao(path);
                if (!Funcoes.textoVazio(respostaDTO.getConteudo())) {
                    break;
                }
            }
            catch (SocketTimeoutException ste) {
                this.setTextoInformacoesAdicionandoEnter("Timeout de comunica\u00e7\u00e3o com Softlab na tentiva num. " + (respostaDTO.getTentativas() + 1) + ". Tentando novamente...", false);
            }
            catch (Exception e) {
                this.setTextoInformacoesAdicionandoEnter("Falha na comunica\u00e7\u00e3o com SoftLab - " + e.getMessage(), false);
                return respostaDTO;
            }
            respostaDTO.setTentativas(tentativas++);
        }
        return respostaDTO;
    }

    private List<ExameSoftLab> carregarDadosExames(List<TipoDeExameDTO> examesSimplificados) {
        Statement st = Conexao.getStatement();
        ArrayList<ExameSoftLab> examesDetalhados = new ArrayList<ExameSoftLab>();
        ArrayList<ExameSoftLab> examesParaPersistir = new ArrayList<ExameSoftLab>();
        for (TipoDeExameDTO exameSoftLab : examesSimplificados) {
            this.setTextoInformacoesAdicionandoEnter("Importando os dados do exame " + exameSoftLab.getCodigo() + " - " + exameSoftLab.getDescricao() + "...", false);
            RespostaDTO resposta = this.enviarSolicitacaoWebService("/api/tipoDeExame/" + exameSoftLab.getCodigo());
            if (resposta.getStatusCode() != 200) {
                this.exibirMensagemFalha(resposta);
                this.examesSemDetalhes.add(exameSoftLab);
                continue;
            }
            try {
                TipoDeExameDTO exameDetalhado = TipoDeExameDTO.fromJson(resposta.getConteudo());
                if (!Funcoes.textoVazio(exameDetalhado.getJsonExameSoftLab())) {
                    this.gravarArquivoNaPastaDoUsuario(resposta.getConteudo().getBytes(), exameDetalhado.getCodigo());
                    ExameSoftLab exameAtualizado = ExameSoftLab.fromTipoDeExameDTO(exameDetalhado, Variaveis.filialPadrao, this.codigoLabExterno);
                    examesDetalhados.add(exameAtualizado);
                    examesParaPersistir.add(exameAtualizado);
                } else {
                    this.examesSemDetalhes.add(exameSoftLab);
                }
            }
            catch (Exception e) {
                this.examesSemDetalhes.add(exameSoftLab);
            }
            if (examesParaPersistir.size() != 20) continue;
            this.persisitrExamesSoftlab(st, examesParaPersistir);
            examesParaPersistir = new ArrayList();
        }
        if (!examesParaPersistir.isEmpty()) {
            this.persisitrExamesSoftlab(st, examesParaPersistir);
            examesParaPersistir.clear();
        }
        Conexao.fecharStatement(st);
        return examesDetalhados;
    }

    private void persisitrExamesSoftlab(Statement st, List<ExameSoftLab> examesParaPersistir) {
        try {
            for (ExameSoftLab es : examesParaPersistir) {
                int comando = this.dao.salvarOuAtualizarExames(st, Variaveis.filialPadrao, this.codigoLabExterno, es);
                if (comando != 2) continue;
                this.examesInseridos.add(es);
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            this.anularSQL();
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar os exames no Banco de Dados" + e.getMessage(), e.getStackTrace());
        }
    }

    private void exibirMensagemFalha(RespostaDTO respostaDTO) {
        StringBuilder mensagemFalha = new StringBuilder("Nenhum item encontrado");
        RespostaComFalhaDTO[] respostasComFalha = null;
        if (respostaDTO.getConteudo().contains("key") && respostaDTO.getConteudo().contains("message")) {
            try {
                respostasComFalha = (RespostaComFalhaDTO[])new ObjectMapper().readValue(respostaDTO.getConteudo(), RespostaComFalhaDTO[].class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!Objects.isNull(respostasComFalha)) {
            mensagemFalha.delete(0, mensagemFalha.length());
            int statusCode = respostaDTO.getStatusCode();
            if (statusCode == 400) {
                mensagemFalha.append("Erro ao processar requisi\u00e7\u00e3o");
            } else if (statusCode == 403) {
                mensagemFalha.append("Acesso negado");
            } else if (statusCode == 500) {
                mensagemFalha.append("Erro interno no servidor");
            }
            mensagemFalha.append(" - ").append(respostasComFalha[0].getKey()).append(" : ").append(respostasComFalha[0].getMessage());
        }
        this.setTextoInformacoesAdicionandoEnter(mensagemFalha.toString(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExameSoftLab> carregarExamesDobanco() {
        Statement st = Conexao.getStatement();
        ArrayList<ExameSoftLab> examesNoBanco = new ArrayList();
        try {
            examesNoBanco = this.dao.pesquisarTodosPorFilialELabExterno(st, Variaveis.filialPadrao, this.codigoLabExterno);
        }
        catch (Exception exception) {
            Conexao.fecharStatement(st);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return examesNoBanco;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excluirExames() {
        if (!this.examesExcluidos.isEmpty()) {
            Statement st = Conexao.getStatement();
            try {
                for (ExameSoftLab es : this.examesExcluidos) {
                    this.dao.excluirExame(st, Variaveis.filialPadrao, this.codigoLabExterno, es.getCodigo());
                }
                this.atualizarExamesRelacionadosExcluidos(st);
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private void atualizarExamesRelacionadosExcluidos(Statement st) throws SQLException, SalvaDadosException {
        List<ExameMatColetaLabExternoBean> examesRelacionados = this.dao.pesquisarExamesRelacionados(st, Variaveis.filialPadrao, this.codigoLabExterno);
        for (ExameMatColetaLabExternoBean exameRelacionado : examesRelacionados) {
            IdentificacaoSoftLabDTO identificacaoSoftLab = IdentificacaoSoftLabDTO.fromJson(exameRelacionado.getXmlLabExterno());
            ExameSoftLab exameSoftLab = new ExameSoftLab(Integer.valueOf(Variaveis.filialPadrao), this.codigoLabExterno, identificacaoSoftLab.getCodigo());
            if (!this.examesExcluidos.contains(exameSoftLab)) continue;
            this.dao.removerRelacionamentoLabExterno(st, Variaveis.filialPadrao, this.codigoLabExterno, exameRelacionado.getExame().getCodigo(), exameRelacionado.getMatColeta().getCodigo());
        }
    }

    private void gravarArquivoNaPastaDoUsuario(byte[] conteudo, String nomeArquivo) {
        String horaMinuto = LocalDateTime.now().format(DateTimeFormatter.ofPattern("ddMMyyyy_HHmm"));
        Path diretorioExamesSoftLab = Paths.get(DIRETORIO_USUARIO + File.separator + "examesSoftLab", new String[0]);
        try {
            if (!diretorioExamesSoftLab.toFile().exists()) {
                Files.createDirectories(diretorioExamesSoftLab, new FileAttribute[0]);
            }
            Files.write(Paths.get(diretorioExamesSoftLab.toString() + File.separator + nomeArquivo + "_" + horaMinuto + ".json", new String[0]), conteudo, new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exibirInformacoes(List<ExameSoftLab> examesNoBanco) {
        if (!this.examesInseridos.isEmpty() && !examesNoBanco.isEmpty()) {
            this.setTextoInformacoesAdicionandoEnter("", false);
            this.setTextoInformacoesAdicionandoEnter(this.getSeparadorInformacoes("EXAMES INCLU\u00cdDOS PELO LABORAT\u00d3RIO DE APOIO"), false);
            for (ExameSoftLab ei : this.examesInseridos) {
                this.setTextoInformacoesAdicionandoEnter(ei.getCodigo() + " - " + ei.getDescricao(), false);
            }
            this.setTextoInformacoesAdicionandoEnter(this.getSeparadorInformacoes(""), false);
        }
        if (!this.examesSemDetalhes.isEmpty()) {
            this.setTextoInformacoesAdicionandoEnter("", false);
            this.setTextoInformacoesAdicionandoEnter(this.getSeparadorInformacoes("EXAMES N\u00c3O DETALHADOS PELO LABORAT\u00d3RIO DE APOIO"), false);
            for (TipoDeExameDTO esd : this.examesSemDetalhes) {
                this.setTextoInformacoesAdicionandoEnter(esd.getCodigo() + " - " + esd.getDescricao(), false);
            }
            this.setTextoInformacoesAdicionandoEnter(this.getSeparadorInformacoes(""), false);
        }
        if (!this.examesExcluidos.isEmpty()) {
            this.setTextoInformacoesAdicionandoEnter("", false);
            this.setTextoInformacoesAdicionandoEnter(this.getSeparadorInformacoes("EXAMES EXCLU\u00cdDOS PELO LABORAT\u00d3RIO DE APOIO"), false);
            for (ExameSoftLab ee : this.examesExcluidos) {
                this.setTextoInformacoesAdicionandoEnter(ee.getCodigo() + " - " + ee.getDescricao(), false);
            }
            this.setTextoInformacoesAdicionandoEnter(this.getSeparadorInformacoes(""), false);
        }
    }

    private String getSeparadorInformacoes(String textoInformativo) {
        int totalPreenchimento = 90;
        int posicaoEscrita = (90 - textoInformativo.length()) / 2;
        String preenchimento = "=";
        int c = 0;
        StringBuilder separador = new StringBuilder();
        while (c < 90) {
            if (c == posicaoEscrita) {
                separador.append(textoInformativo);
                c += textoInformativo.length() == 0 ? 1 : textoInformativo.length();
                continue;
            }
            separador.append("=");
            ++c;
        }
        return separador.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IdentificacaoSoftLabDTO> carregarTiposDeJejum() {
        Statement st;
        List<IdentificacaoSoftLabDTO> tiposDeJejum;
        block6: {
            ComunicacaoSoftLab comunicao = ComunicacaoSoftLab.getInstancia(this.labExterno.configuracao);
            RespostaDTO respostaDTO = this.enviarSolicitacaoWebService("/api/tipoDeJejum");
            tiposDeJejum = new ArrayList<IdentificacaoSoftLabDTO>();
            if (respostaDTO.getStatusCode() != 200) {
                this.exibirMensagemFalha(respostaDTO);
                return tiposDeJejum;
            }
            st = Conexao.getStatement();
            try {
                tiposDeJejum = (List)new ObjectMapper().readValue(respostaDTO.getConteudo(), (TypeReference)new TypeReference<List<IdentificacaoSoftLabDTO>>(){});
                if (tiposDeJejum.isEmpty()) break block6;
                this.gravarArquivoNaPastaDoUsuario(respostaDTO.getConteudo().getBytes(), "listaTempoJejumSoftLab");
                for (IdentificacaoSoftLabDTO tj : tiposDeJejum) {
                    this.dao.salvarOuAtualizarTipoJejum(st, Variaveis.filialPadrao, this.codigoLabExterno, tj);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return tiposDeJejum;
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

