/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.softlab.ExameSoftLab;
import jalis.laboratorio.util.parsers.softlab.ExameSoftlabTipoJejum;
import jalis.laboratorio.util.parsers.softlab.dto.IdentificacaoSoftLabDTO;
import jalis.model.bean.cadastro.exame.ExameMatColetaLabExternoBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.sql.SalvaDados;
import jalis.util.sql.SalvaDadosException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ExamesSoftLabDAO {
    public List<ExameSoftLab> pesquisarTodosPorFilialELabExterno(Statement st, String codFilial, Integer codLabExterno) throws SQLException {
        StringBuilder sql = new StringBuilder("select fil_codigo, lae_codigo, sft_codexame, sft_descricaoexame, sft_abreviacao, sft_json from examessoftlab");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        ResultSet rs = st.executeQuery(sql.toString());
        ArrayList<ExameSoftLab> examesSoftLab = new ArrayList<ExameSoftLab>();
        while (rs.next()) {
            ExameSoftLab exameSoftLab = ExameSoftLab.fromResultSet(rs);
            examesSoftLab.add(exameSoftLab);
        }
        return examesSoftLab;
    }

    public ExameSoftLab pesquisarPorFilialConvenioECodExameSoftLab(Statement st, String codFilial, int codLabExterno, String codExameSoftLab) throws SQLException {
        StringBuilder sql = new StringBuilder("select fil_codigo, lae_codigo, sft_codexame, sft_descricaoexame, sft_abreviacao, sft_json from examessoftlab");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        sql.append(" and sft_codexame = ").append(StringUtil.textoDBEscape(codExameSoftLab));
        ResultSet rs = st.executeQuery(sql.toString());
        ExameSoftLab exameSoftLab = new ExameSoftLab();
        if (rs.next()) {
            exameSoftLab = ExameSoftLab.fromResultSet(rs);
        }
        rs.close();
        return exameSoftLab;
    }

    public int salvarOuAtualizarExames(Statement st, String codFilial, int codLabExterno, ExameSoftLab exameSoftLab) throws SQLException, SalvaDadosException {
        ExameSoftLab exameNoBanco = this.pesquisarPorFilialConvenioECodExameSoftLab(st, codFilial, codLabExterno, exameSoftLab.getCodigo());
        int status = 0;
        SalvaDados salvar = new SalvaDados(IntegracaoLabExternoUtil.TABELAS[17]);
        if (!Funcoes.textoVazio(exameNoBanco.getJson())) {
            salvar.setOperacao(2);
            status = 3;
        } else {
            salvar.setOperacao(0);
            status = 2;
        }
        salvar.adicionaCampo("fil_codigo", 2, false, true, codFilial);
        salvar.adicionaCampo("lae_codigo", 2, false, true, codLabExterno);
        salvar.adicionaCampo("sft_codexame", 0, false, true, exameSoftLab.getCodigo());
        salvar.adicionaCampo("sft_descricaoexame", 0, true, false, exameSoftLab.getDescricao());
        salvar.adicionaCampo("sft_abreviacao", 0, true, false, exameSoftLab.getAbreviacao());
        String json = exameSoftLab.getJson().replace("'", "''");
        salvar.adicionaCampo("sft_json", 0, true, false, json);
        DBUtil.gravaAutoCopia(codFilial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
        return status;
    }

    public void excluirExame(Statement st, String codFilial, int codLabExterno, String codExameSoftLab) throws SQLException, SalvaDadosException {
        SalvaDados salvar = new SalvaDados(IntegracaoLabExternoUtil.TABELAS[17], 1);
        salvar.adicionaCampo("fil_codigo", 2, false, true, codFilial);
        salvar.adicionaCampo("lae_codigo", 2, false, true, codLabExterno);
        salvar.adicionaCampo("sft_codexame", 0, false, true, codExameSoftLab);
        DBUtil.gravaAutoCopia(codFilial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
    }

    public List<ExameMatColetaLabExternoBean> pesquisarExamesRelacionados(Statement st, String codFilial, int codLabExterno) throws SQLException {
        StringBuilder sql = new StringBuilder(" select fil_codigo, exa_codigo, mco_codigo, lae_codigo, ele_xmllabexterno from examematcoletalabexterno");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        ResultSet rs = st.executeQuery(sql.toString());
        ArrayList<ExameMatColetaLabExternoBean> examesRelacionados = new ArrayList<ExameMatColetaLabExternoBean>();
        while (rs.next()) {
            ExameMatColetaLabExternoBean exameMatCol = new ExameMatColetaLabExternoBean();
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            exameMatCol.setFilial(filial);
            ExameVO exame = new ExameVO();
            exame.setCodigo(rs.getString("exa_codigo"));
            exameMatCol.setExame(exame);
            MaterialColetaVO material = new MaterialColetaVO();
            material.setCodigo(rs.getInt("mco_codigo"));
            exameMatCol.setMatColeta(material);
            exameMatCol.setXmlLabExterno(rs.getString("ele_xmllabexterno"));
            examesRelacionados.add(exameMatCol);
        }
        return examesRelacionados;
    }

    public void removerRelacionamentoLabExterno(Statement st, String codFilial, int codLabExterno, String codExame, int codMaterial) throws SQLException, SalvaDadosException {
        SalvaDados salvar = new SalvaDados("examematcoletalabexterno", 2);
        salvar.adicionaCampo("fil_codigo", 2, false, true, codFilial);
        salvar.adicionaCampo("lae_codigo", 2, false, true, codLabExterno);
        salvar.adicionaCampo("exa_codigo", 0, false, true, codExame);
        salvar.adicionaCampo("mco_codigo", 2, false, true, codMaterial);
        salvar.adicionaCampo("ele_xmllabexterno", 0, true, false, "");
        DBUtil.gravaAutoCopia(codFilial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
    }

    public ExameSoftlabTipoJejum pesquisarPorFilialConvenioECodigo(Statement st, String codFilial, int codLabExterno, String codigo) throws SQLException {
        StringBuilder sql = new StringBuilder("select fil_codigo, lae_codigo, sfj_codjejum, sfj_descricaojejum from examessoftlabtipojejum ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        sql.append(" and sfj_codjejum = ").append(codigo);
        ResultSet rs = st.executeQuery(sql.toString());
        ExameSoftlabTipoJejum exameSoftlabTipoJejum = new ExameSoftlabTipoJejum();
        if (rs.next()) {
            exameSoftlabTipoJejum = ExameSoftlabTipoJejum.fromResultSet(rs);
        }
        rs.close();
        return exameSoftlabTipoJejum;
    }

    public void salvarOuAtualizarTipoJejum(Statement st, String codFilial, int codLabExterno, IdentificacaoSoftLabDTO tipoJejum) throws SQLException, SalvaDadosException {
        ExameSoftlabTipoJejum exameSoftlabTipoJejum = this.pesquisarPorFilialConvenioECodigo(st, codFilial, codLabExterno, tipoJejum.getCodigo());
        SalvaDados salvar = new SalvaDados("examessoftlabtipojejum");
        boolean persistir = false;
        if (!Funcoes.textoVazio(exameSoftlabTipoJejum.getDescricao()) && !exameSoftlabTipoJejum.getDescricao().equals(tipoJejum.getDescricao())) {
            salvar.setOperacao(2);
            persistir = true;
        } else if (Funcoes.textoVazio(exameSoftlabTipoJejum.getDescricao())) {
            salvar.setOperacao(0);
            persistir = true;
        }
        if (persistir) {
            salvar.adicionaCampo("fil_codigo", 2, false, true, codFilial);
            salvar.adicionaCampo("lae_codigo", 2, false, true, codLabExterno);
            salvar.adicionaCampo("sfj_codjejum", 0, false, true, tipoJejum.getCodigo());
            salvar.adicionaCampo("sfj_descricaojejum", 0, true, false, tipoJejum.getDescricao());
            DBUtil.gravaAutoCopia(codFilial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
        }
    }
}

