/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ExameSoftLab {
    private int codFilial;
    private int codLabExterno;
    private String codigo;
    private String descricao;
    private String abreviacao;
    private String json;

    public ExameSoftLab() {
    }

    public ExameSoftLab(int codFilial, int codLabExterno, String codigo) {
        this.codFilial = codFilial;
        this.codLabExterno = codLabExterno;
        this.codigo = codigo;
    }

    public int getCodFilial() {
        return this.codFilial;
    }

    public void setCodFilial(int codFilial) {
        this.codFilial = codFilial;
    }

    public int getCodLabExterno() {
        return this.codLabExterno;
    }

    public void setCodLabExterno(int codLabExterno) {
        this.codLabExterno = codLabExterno;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getAbreviacao() {
        return this.abreviacao;
    }

    public void setAbreviacao(String abreviacao) {
        this.abreviacao = abreviacao;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public TipoDeExameDTO getTipoExame() {
        ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
        TipoDeExameDTO dto = new TipoDeExameDTO();
        try {
            dto = (TipoDeExameDTO)mapper.readValue(this.json, TipoDeExameDTO.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dto;
    }

    public static ExameSoftLab fromResultSet(ResultSet rs) throws SQLException {
        ExameSoftLab exameSoftLab = new ExameSoftLab();
        exameSoftLab.setAbreviacao(rs.getString("sft_abreviacao"));
        exameSoftLab.setCodLabExterno(rs.getInt("lae_codigo"));
        exameSoftLab.setCodigo(rs.getString("sft_codexame"));
        exameSoftLab.setCodFilial(rs.getInt("fil_codigo"));
        exameSoftLab.setDescricao(rs.getString("sft_descricaoexame"));
        exameSoftLab.setJson(rs.getString("sft_json"));
        return exameSoftLab;
    }

    public static ExameSoftLab fromTipoDeExameDTO(TipoDeExameDTO dto, String codFilial, int codConvenio) {
        ExameSoftLab exameSoftLab = new ExameSoftLab();
        if (!Objects.isNull(dto) && !Funcoes.textoVazio(dto.getJsonExameSoftLab())) {
            exameSoftLab.setAbreviacao(dto.getAbreviacao());
            exameSoftLab.setCodigo(dto.getCodigo());
            exameSoftLab.setCodLabExterno(codConvenio);
            exameSoftLab.setCodFilial(Integer.valueOf(codFilial));
            exameSoftLab.setDescricao(dto.getDescricao());
            exameSoftLab.setJson(dto.getJsonExameSoftLab());
        }
        return exameSoftLab;
    }

    public int hashCode() {
        return Objects.hash(this.codLabExterno, this.codigo, this.codFilial);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExameSoftLab other = (ExameSoftLab)obj;
        return this.codLabExterno == other.codLabExterno && Objects.equals(this.codigo, other.codigo) && this.codFilial == other.codFilial;
    }

    public static ExameSoftLab fromJson(String json) {
        ExameSoftLab dto = new ExameSoftLab();
        try {
            ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
            dto = (ExameSoftLab)mapper.readValue(json, ExameSoftLab.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ExameSoftLab> getExames(int filial, int codigoLabExterno) {
        LinkedHashSet<ExameSoftLab> exames = new LinkedHashSet<ExameSoftLab>();
        String sql = "select sft_json from examessoftlab where fil_codigo = ? and lae_codigo = ? order by sft_codexame ";
        PreparedStatement prst = Conexao.getPreparedStatement(sql);
        try {
            prst.setInt(1, filial);
            prst.setInt(2, codigoLabExterno);
            try (ResultSet rs = null;){
                rs = prst.executeQuery();
                while (rs.next()) {
                    exames.add(ExameSoftLab.fromJson(rs.getString("sft_json")));
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameSoftLab");
        }
        finally {
            try {
                prst.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return exames;
    }
}

