/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.softlab.ExameSoftLab;
import jalis.laboratorio.util.parsers.softlab.ExamesSoftLabDAO;
import jalis.laboratorio.util.parsers.softlab.dto.CampoDeColetaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.IdentificacaoSoftLabDTO;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ConfiguradorSoftLab
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String TITULO = "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio SoftLab";
    private static final String CODIGO_EXAME_SOFTLAB = "codigoExame";
    private static final String DESCRICAO_EXAME_SOFTLAB = "descricaoExame";
    private static final String OBJETO_EXAME_SOFTLAB = "objetoExame";
    private static final String SELECIONADO = "selecionado";
    private static final String OBJ_CAMPODECOLETA = "campoDeColeta";
    private static final Dimension DIMENSAO_TELA = new Dimension(670, 535);
    private static final int[] COLUNAS_DADOS_ADICIONAIS = new int[]{0, 40};
    private ModeloResultSet modeloExames = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame");
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, (ListSelectionListener)this, 80, 0);
    private JTextField textLocalizar = new JTextField();
    private ModeloResultSet modeloDadosAdicionais = new ModeloResultSet("Dado Adicional", "dadoAdicional", "Sel", "selecionado");
    private JTable tableDadosAdicionais = ComponenteFactory.novoJTable((TableModel)this.modeloDadosAdicionais, null, COLUNAS_DADOS_ADICIONAIS);
    private JScrollPane scrollDadosAdicionais = new JScrollPane(this.tableDadosAdicionais);
    private JComboBox<IdentificacaoSoftLabDTO> comboMaterial = new JComboBox();
    private JTextField textObrigatorio = new JTextField();
    private transient ExamesSoftLabDAO dao = new ExamesSoftLabDAO();
    private transient TipoDeExameDTO tipoDeExameSalvo;

    public static ConfiguradorSoftLab novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorSoftLab((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorSoftLab((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private ConfiguradorSoftLab(Dialog pai, String codigoLabExterno) {
        super(pai, TITULO, codigoLabExterno);
        this.iniciar();
    }

    private ConfiguradorSoftLab(Frame pai, String codigoLabExterno) {
        super(pai, TITULO, codigoLabExterno);
        this.iniciar();
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new BorderLayout());
        JPanel panelSuperior = this.construirPanelSuperior();
        this.getPanelCentral().add((Component)panelSuperior, "North");
        this.modeloDadosAdicionais.setColunaEditavel(SELECIONADO);
        TableColumn col = this.tableDadosAdicionais.getColumnModel().getColumn(1);
        col.setMinWidth(30);
        col.setMaxWidth(30);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Dados Adicionais", (Component)this.scrollDadosAdicionais, null, null, null, null), "Center");
        JPanel panelObrigatorio = this.construirPanelObrigatorio();
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Informa\u00e7\u00f5es", (Component)panelObrigatorio, null, null, null, null), "South");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(DIMENSAO_TELA);
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel construirPanelSuperior() {
        JScrollPane scrollExames = new JScrollPane(this.tableExames);
        scrollExames.setPreferredSize(new Dimension(650, 200));
        JPanel panelSuperior = new JPanel(new BorderLayout());
        panelSuperior.add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExames, (Component)this.construirPanelLocalizar(), null, null), "North");
        JPanel panelMaterial = ComponenteFactory.novoJPanelBorderLayout(this.comboMaterial, null, null, null, ComponenteFactory.novoJLabel("Material:", ' ', new Dimension(70, 22), this.comboMaterial));
        panelMaterial.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        panelSuperior.add((Component)panelMaterial, "Center");
        return panelSuperior;
    }

    private JPanel construirPanelObrigatorio() {
        this.textObrigatorio.setEditable(false);
        JPanel panelObrigatorio = ComponenteFactory.novoJPanelBorderLayout(this.textObrigatorio, null, null, null, ComponenteFactory.novoJLabel("Obrigat\u00f3rio:", ' ', new Dimension(70, 22), this.textObrigatorio));
        panelObrigatorio.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelObrigatorio;
    }

    private JPanel construirPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), () -> {
            this.modeloExames.filtrar(DESCRICAO_EXAME_SOFTLAB, this.textLocalizar.getText());
            if (this.modeloExames.getRowCount() > 0) {
                this.tableExames.setRowSelectionInterval(0, 0);
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void carregarExames() {
        List<ExameSoftLab> examesSoftLab = this.pesquisarExamesSoftLab();
        if (!examesSoftLab.isEmpty()) {
            for (ExameSoftLab es : examesSoftLab) {
                Registro reg = new Registro();
                reg.setValor(CODIGO_EXAME_SOFTLAB, es.getCodigo());
                reg.setValor(DESCRICAO_EXAME_SOFTLAB, es.getDescricao());
                reg.setValor(OBJETO_EXAME_SOFTLAB, es);
                this.modeloExames.addRegistro(reg);
            }
        }
    }

    private List<ExameSoftLab> pesquisarExamesSoftLab() {
        Statement st = Conexao.getStatement();
        ArrayList<ExameSoftLab> examesSoftLab = new ArrayList();
        try {
            examesSoftLab = this.dao.pesquisarTodosPorFilialELabExterno(st, Variaveis.filialPadrao, Integer.valueOf(this.getCodigoLabExterno()));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Falha ao carregar examessoftlab do banco de dados - " + e.getMessage(), e.getStackTrace());
        }
        return examesSoftLab;
    }

    private void configurarTabelas() {
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExames.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSoftLab.this.tableExames.hasFocus() && (row = ConfiguradorSoftLab.this.tableExames.getSelectedRow()) > 0) {
                    ConfiguradorSoftLab.this.tableExames.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorSoftLab.this.tableExames.scrollRectToVisible(ConfiguradorSoftLab.this.tableExames.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSoftLab.this.tableExames.hasFocus() && (row = ConfiguradorSoftLab.this.tableExames.getSelectedRow()) < ConfiguradorSoftLab.this.tableExames.getRowCount() - 1) {
                    ConfiguradorSoftLab.this.tableExames.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorSoftLab.this.tableExames.scrollRectToVisible(ConfiguradorSoftLab.this.tableExames.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modeloExames.getRegistro(this.tableExames.getSelectedRow());
        if (reg != null) {
            ExameSoftLab es = (ExameSoftLab)reg.getValor(OBJETO_EXAME_SOFTLAB);
            TipoDeExameDTO selecionado = es.getTipoExame();
            this.atualizarMateriais(selecionado);
            this.atualizarDadosAdicionais(selecionado);
            this.atualizarInformacaoes(selecionado);
        }
    }

    private void atualizarMateriais(TipoDeExameDTO tipoDeExame) {
        this.comboMaterial.removeAllItems();
        if (!tipoDeExame.getOpcoesDeColeta().isEmpty()) {
            tipoDeExame.getOpcoesDeColeta().forEach(opcaoColeta -> this.comboMaterial.addItem((IdentificacaoSoftLabDTO)opcaoColeta));
        }
        if (tipoDeExame.equals(this.tipoDeExameSalvo)) {
            this.comboMaterial.setSelectedItem(this.tipoDeExameSalvo.getOpcoesDeColeta().get(0));
        }
    }

    private void atualizarDadosAdicionais(TipoDeExameDTO tipoDeExame) {
        this.modeloDadosAdicionais.limpar();
        if (!tipoDeExame.getCamposDeColeta().isEmpty()) {
            for (CampoDeColetaDTO campoDeColeta : tipoDeExame.getCamposDeColeta()) {
                Registro r = new Registro();
                r.setValor("dadoAdicional", campoDeColeta.getDescricao());
                r.setValor(SELECIONADO, Boolean.FALSE);
                r.setValor(OBJ_CAMPODECOLETA, campoDeColeta);
                this.modeloDadosAdicionais.addRegistro(r);
            }
        }
        if (tipoDeExame.equals(this.tipoDeExameSalvo)) {
            for (int i = 0; i < this.modeloDadosAdicionais.getRowCount(); ++i) {
                Registro reg = this.modeloDadosAdicionais.getRegistro(i);
                CampoDeColetaDTO campoSelecionado = (CampoDeColetaDTO)reg.getValor(OBJ_CAMPODECOLETA);
                if (!this.tipoDeExameSalvo.getCamposDeColeta().contains(campoSelecionado)) continue;
                reg.setValor(SELECIONADO, Boolean.TRUE);
            }
        }
    }

    private void atualizarInformacaoes(TipoDeExameDTO tipoDeExame) {
        this.textObrigatorio.setText("");
        StringBuilder mensagem = new StringBuilder();
        if (tipoDeExame.isExigeJejum()) {
            mensagem.append("Exige Jejum");
        }
        if (tipoDeExame.isPermiteComplemento()) {
            if (mensagem.length() > 0) {
                mensagem.append(" / ");
            }
            mensagem.append("Permite complemento");
        }
        this.textObrigatorio.setText(mensagem.toString());
    }

    @Override
    public String getXML() {
        TipoDeExameDTO tipoDeExame = new TipoDeExameDTO();
        Registro registro = this.modeloExames.getRegistro(this.tableExames.getSelectedRow());
        if (registro != null) {
            ExameSoftLab es = (ExameSoftLab)registro.getValor(OBJETO_EXAME_SOFTLAB);
            tipoDeExame = TipoDeExameDTO.fromJson(es.getJson());
            tipoDeExame.setAjuda("");
            ArrayList<IdentificacaoSoftLabDTO> opcoesDeColeta = new ArrayList<IdentificacaoSoftLabDTO>();
            opcoesDeColeta.add((IdentificacaoSoftLabDTO)this.comboMaterial.getSelectedItem());
            tipoDeExame.setOpcoesDeColeta(opcoesDeColeta);
            ArrayList<CampoDeColetaDTO> camposDeColeta = new ArrayList<CampoDeColetaDTO>();
            for (int i = 0; i < this.modeloDadosAdicionais.getRowCount(); ++i) {
                Registro reg = this.modeloDadosAdicionais.getRegistro(i);
                if (!reg.getBoolean(SELECIONADO)) continue;
                CampoDeColetaDTO campoDeColeta = (CampoDeColetaDTO)reg.getValor(OBJ_CAMPODECOLETA);
                camposDeColeta.add(campoDeColeta);
            }
            tipoDeExame.setCamposDeColeta(camposDeColeta);
        }
        return tipoDeExame.toJson();
    }

    @Override
    public void setXML(String json) {
        this.tipoDeExameSalvo = TipoDeExameDTO.fromJson(json);
        if (this.tipoDeExameSalvo != null && !Funcoes.textoVazio(this.tipoDeExameSalvo.getCodigo())) {
            IdentificacaoSoftLabDTO opcaoDeColeta = new IdentificacaoSoftLabDTO(this.tipoDeExameSalvo.getOpcoesDeColeta().get(0));
            ArrayList<CampoDeColetaDTO> camposDeColeta = new ArrayList<CampoDeColetaDTO>();
            if (!this.tipoDeExameSalvo.getCamposDeColeta().isEmpty()) {
                this.tipoDeExameSalvo.getCamposDeColeta().forEach(cc -> camposDeColeta.add(new CampoDeColetaDTO((CampoDeColetaDTO)cc)));
            }
            this.tipoDeExameSalvo.setJsonExameSoftLab(json);
            for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
                ExameSoftLab es;
                TipoDeExameDTO tipoDeExame;
                Registro reg = this.modeloExames.getRegistro(i);
                if (reg == null || !this.tipoDeExameSalvo.equals(tipoDeExame = TipoDeExameDTO.fromJson((es = (ExameSoftLab)reg.getValor(OBJETO_EXAME_SOFTLAB)).getJson()))) continue;
                this.tableExames.setRowSelectionInterval(i, i);
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(i, 0, true));
                this.setMateriais(tipoDeExame, opcaoDeColeta);
                this.setDadosAdicionais(tipoDeExame, camposDeColeta);
            }
        }
    }

    public void setMateriais(TipoDeExameDTO tipoDeExame, IdentificacaoSoftLabDTO opcaoDeColeta) {
        this.atualizarMateriais(tipoDeExame);
        this.comboMaterial.setSelectedItem(opcaoDeColeta);
    }

    public void setDadosAdicionais(TipoDeExameDTO tipoDeExameDTO, List<CampoDeColetaDTO> camposDeColeta) {
        this.atualizarDadosAdicionais(tipoDeExameDTO);
        if (!camposDeColeta.isEmpty()) {
            for (int i = 0; i < this.modeloDadosAdicionais.getRowCount(); ++i) {
                Registro reg = this.modeloDadosAdicionais.getRegistro(i);
                CampoDeColetaDTO campoSelecionado = (CampoDeColetaDTO)reg.getValor(OBJ_CAMPODECOLETA);
                if (!camposDeColeta.contains(campoSelecionado)) continue;
                reg.setValor(SELECIONADO, Boolean.TRUE);
            }
        }
    }

    public static String getDescricaoExameSelecionado(String json) {
        TipoDeExameDTO tipoDeExameDTO = TipoDeExameDTO.fromJson(json);
        return tipoDeExameDTO.getDescricao();
    }

    public static String getCodigoIdentExameLabExterno(String json) {
        if (!Funcoes.textoVazio(json)) {
            TipoDeExameDTO tipoDeExame = TipoDeExameDTO.fromJson(json);
            return tipoDeExame.getCodigo();
        }
        return "";
    }
}

