/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorException;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.EditorTermica;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class ConfiguradorProtocoloSoftLab
extends AbstractConfiguradorProtocolo {
    private static final String TITULO = "Configurador SoftLab";
    private static final int LARGURA_JANELA = 430;
    private static final int ALTURA_JANELA = 270;
    public static final String TAG_LOTE = "lote";
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_ENDERECO_API = "enderecoAPI";
    public static final String TAG_ENVIAR_LOTE_WEBSERVICE = "enviarLoteWebService";
    public static final String TAG_ENVIO_AUTOMATICO = "envioAutomatico";
    public static final String TAG_CONFIGURADOR_CABECALHO_ETIQUETA = "configuradorCabecalho";
    private TTextField textLogin = ComponenteFactory.novoTTextField(200, 3, this);
    private TTextField textSenha = ComponenteFactory.novoTTextField(200, 3, this);
    private TTextField textCaminhoAPI = ComponenteFactory.novoTTextField(200, 3, this);
    private JButton buttonConfigurarCabecalhoEtiqueta = ComponenteFactory.novoJButton("Configurar impress\u00e3o de etiquetas", this);
    private JCheckBox checkEnviaLoteUsandoWebService = new JCheckBox("Enviar lote utilizando WebService");
    private JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    private String xmlCabecalhoEtiqueta = "";

    private ConfiguradorProtocoloSoftLab(Frame pai, String codigoLaboratorio) {
        super(pai, TITULO, codigoLaboratorio);
        this.construirTela();
    }

    private ConfiguradorProtocoloSoftLab(Dialog pai, String codigoLaboratorio) {
        super(pai, TITULO, codigoLaboratorio);
        this.construirTela();
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloSoftLab((Frame)pai, codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloSoftLab((Dialog)pai, codigoLaboratorio);
        }
        return null;
    }

    private void construirTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        Dimension dimensaoText = new Dimension(280, 20);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.insets = new Insets(1, 10, 1, 1);
        this.getPanelCentral().add((Component)new JLabel("Lote:"), cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textLote.setPreferredSize(dimensaoText);
        this.textLote.setMinimumSize(dimensaoText);
        cons.insets = new Insets(1, 1, 1, 10);
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 1;
        cons.insets = new Insets(1, 10, 1, 1);
        this.getPanelCentral().add((Component)new JLabel("Login"), cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textLogin.setPreferredSize(dimensaoText);
        this.textLogin.setMinimumSize(dimensaoText);
        cons.insets = new Insets(1, 1, 1, 10);
        this.getPanelCentral().add((Component)this.textLogin, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 1;
        cons.insets = new Insets(1, 10, 1, 1);
        this.getPanelCentral().add((Component)new JLabel("Senha"), cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textSenha.setPreferredSize(dimensaoText);
        this.textSenha.setMinimumSize(dimensaoText);
        cons.insets = new Insets(1, 1, 1, 10);
        this.getPanelCentral().add((Component)this.textSenha, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.gridwidth = 1;
        cons.insets = new Insets(1, 10, 1, 1);
        this.getPanelCentral().add((Component)new JLabel("Caminho API:"), cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textCaminhoAPI.setPreferredSize(dimensaoText);
        this.textCaminhoAPI.setMinimumSize(dimensaoText);
        cons.insets = new Insets(1, 1, 1, 10);
        this.getPanelCentral().add((Component)this.textCaminhoAPI, cons);
        cons.insets = new Insets(1, 10, 1, 10);
        this.checkEnviaLoteUsandoWebService.setSelected(true);
        this.checkEnviaLoteUsandoWebService.setEnabled(false);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnviaLoteUsandoWebService, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        cons.gridx = 0;
        cons.gridy = 12;
        cons.weightx = 0.5;
        cons.gridwidth = 3;
        cons.insets = new Insets(1, 13, 1, 10);
        this.getPanelCentral().add((Component)this.buttonConfigurarCabecalhoEtiqueta, cons);
        this.adicionarEventos();
        this.setResizable(false);
        this.pack();
        this.setSize(new Dimension(430, 270));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private void adicionarEventos() {
        this.buttonConfigurarCabecalhoEtiqueta.addActionListener(event -> {
            EditorTermica termica = EditorTermica.novaInstancia(Laboratorio.getInstancia(), "Configurando ", true, true);
            if (!Funcoes.textoVazio(this.xmlCabecalhoEtiqueta)) {
                termica.setDocumento(this.xmlCabecalhoEtiqueta);
            }
            termica.setVisible(true);
            if (!Funcoes.textoVazio(termica.getDocumento())) {
                this.xmlCabecalhoEtiqueta = termica.getDocumento();
            }
        });
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textLogin)) {
            Funcoes.mensagem(this, "Informe o Login de acesso do Laborat\u00f3rio para realizar a integra\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textLogin);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenha)) {
            Funcoes.mensagem(this, "Informe a Senha de acesso do Laborat\u00f3rio para realizar a integra\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.textCaminhoAPI)) {
            Funcoes.mensagem(this, "Informe o Link da Integra\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textCaminhoAPI);
            return false;
        }
        return true;
    }

    @Override
    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(Protocolo.SoftLab.getDescricao());
        xml.escrever(TAG_LOTE, this.textLote.getText());
        xml.escrever(TAG_LOGIN, this.textLogin.getText().trim());
        xml.escrever(TAG_SENHA, this.textSenha.getText().trim());
        xml.escrever(TAG_ENDERECO_API, this.textCaminhoAPI.getText().trim());
        xml.escrever(TAG_ENVIAR_LOTE_WEBSERVICE, Boolean.TRUE.toString().toLowerCase());
        String envioAutomatico = this.checkEnvioAutomatico.isSelected() ? Boolean.TRUE.toString().toLowerCase() : Boolean.FALSE.toString().toLowerCase();
        xml.escrever(TAG_ENVIO_AUTOMATICO, envioAutomatico);
        xml.escrever(TAG_CONFIGURADOR_CABECALHO_ETIQUETA, this.xmlCabecalhoEtiqueta);
        try {
            xml.fechar(Protocolo.SoftLab.getDescricao());
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
        return xml.getXML();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (!Funcoes.textoVazio(xml)) {
            String caminhoAPI = StringUtil.getValor(xml, TAG_ENDERECO_API);
            this.textCaminhoAPI.setText(caminhoAPI);
            String login = StringUtil.getValor(xml, TAG_LOGIN);
            this.textLogin.setText(login);
            String senha = StringUtil.getValor(xml, TAG_SENHA);
            this.textSenha.setText(senha);
            String lote = StringUtil.getValor(xml, TAG_LOTE);
            this.textLote.setText(lote);
            boolean envioAutomatico = StringUtil.getValor(xml, TAG_ENVIO_AUTOMATICO).equals(Boolean.TRUE.toString().toLowerCase());
            this.checkEnvioAutomatico.setSelected(envioAutomatico);
            String cabecalhoEtiqueta = StringUtil.getValor(xml, TAG_CONFIGURADOR_CABECALHO_ETIQUETA);
            if (!Funcoes.textoVazio(cabecalhoEtiqueta)) {
                this.xmlCabecalhoEtiqueta = cabecalhoEtiqueta;
            }
        }
    }

    @Override
    public void setNumeroLote(int numeroLote) throws ConfiguradorException {
        this.textLote.setText(String.valueOf(numeroLote));
    }
}

