/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.softlab;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.softlab.AutenticacaoDTO;
import jalis.laboratorio.util.parsers.softlab.TokenDTO;
import jalis.laboratorio.util.parsers.softlab.dto.RespostaDTO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ComunicacaoSoftLab {
    private static final String CONTENT_TYPE = "Content-type";
    private static final int TIMEOUT = 40000;
    private static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "bearer ";
    private String url = "";
    private String login = "";
    private String senha = "";

    private ComunicacaoSoftLab(String url, String login, String senha) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.url = url;
        this.login = login;
        this.senha = senha;
    }

    public static ComunicacaoSoftLab getInstancia(String xmlConfiguracao) {
        String enderecoAPI = StringUtil.getValor(xmlConfiguracao, "enderecoAPI");
        String login = StringUtil.getValor(xmlConfiguracao, "login");
        String senha = StringUtil.getValor(xmlConfiguracao, "senha");
        if (Funcoes.textoVazio(enderecoAPI) || Funcoes.textoVazio(login) || Funcoes.textoVazio(senha)) {
            return null;
        }
        return new ComunicacaoSoftLab(enderecoAPI, login, senha);
    }

    public RespostaDTO getAutenticacao() {
        RespostaDTO respostaDTO = new RespostaDTO();
        try {
            CloseableHttpResponse response = this.autenticar();
            this.debug("Autentica\u00e7\u00e3o respondeu http cod: " + response.getStatusLine().getStatusCode());
            respostaDTO = RespostaDTO.parseHttpResponse(response);
        }
        catch (SocketTimeoutException ste) {
            respostaDTO.setConteudo("Timeout de comunica\u00e7\u00e3o com Softlab. Tentando novamente...");
            this.debug("Timeout de comunica\u00e7\u00e3o com Softlab. Tentando novamente...");
            return respostaDTO;
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            respostaDTO.setConteudo("Falha na comunica\u00e7\u00e3o com SoftLab");
            return respostaDTO;
        }
        return respostaDTO;
    }

    private CloseableHttpResponse autenticar() throws IOException {
        CloseableHttpClient httpClient = this.criarHttpClientComTimeout();
        HttpPost post = this.setPost("/api/Autenticacao/autenticar", AutenticacaoDTO.fromJson(this.login, this.senha), "");
        return httpClient.execute((HttpUriRequest)post);
    }

    public RespostaDTO enviarSolicitacao(String path) throws IOException {
        CloseableHttpClient httpClient = this.criarHttpClientComTimeout();
        HttpGet get = new HttpGet(this.url + path);
        RespostaDTO respostaDTOTokem = this.getAutenticacao();
        if (respostaDTOTokem.getStatusCode() != 200) {
            return respostaDTOTokem;
        }
        get.setHeader(AUTHORIZATION, BEARER + this.getToken(respostaDTOTokem));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
        this.debug("requisicao path " + this.url + path + " respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
        return RespostaDTO.parseHttpResponse(response);
    }

    public RespostaDTO solicitaPedido(String path, String json) throws IOException {
        CloseableHttpClient httpClient = this.criarHttpClientComTimeout();
        RespostaDTO respostaDTOTokem = this.getAutenticacao();
        if (respostaDTOTokem.getStatusCode() != 200) {
            return respostaDTOTokem;
        }
        HttpPost post = this.setPost(path, json, this.getToken(respostaDTOTokem));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        this.debug("solicita\u00e7\u00e3o pedido respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
        return RespostaDTO.parseHttpResponse(response);
    }

    public RespostaDTO excluirPedido(String path, String justificativa) throws IOException {
        RespostaDTO resposta = new RespostaDTO();
        try {
            URL urlDelete = new URL(this.url + path);
            HttpURLConnection connection = (HttpURLConnection)urlDelete.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty(CONTENT_TYPE, "application/json");
            RespostaDTO respostaDTOTokem = this.getAutenticacao();
            if (respostaDTOTokem.getStatusCode() != 200) {
                return respostaDTOTokem;
            }
            connection.setRequestProperty(AUTHORIZATION, BEARER + this.getToken(respostaDTOTokem));
            connection.setDoInput(true);
            connection.setDoOutput(true);
            String requestBody = "\"" + justificativa.replace("\n", " ") + "\"";
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = requestBody.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            StringBuilder response = new StringBuilder();
            if (connection.getResponseCode() != 204) {
                try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = errorReader.readLine()) != null) {
                        response.append(line);
                    }
                }
            }
            resposta.setStatusCode(connection.getResponseCode());
            resposta.setConteudo(response.toString());
            this.debug("exclusao pedido " + this.url + path + " respondeu http c\u00f3d: " + connection.getResponseCode());
            connection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resposta;
    }

    public RespostaDTO solicitarLoteLiberado(String path) throws IOException {
        CloseableHttpClient httpClient = this.criarHttpClientComTimeout();
        HttpGet get = new HttpGet(this.url + path);
        RespostaDTO respostaDTOTokem = this.getAutenticacao();
        if (respostaDTOTokem.getStatusCode() != 200) {
            return respostaDTOTokem;
        }
        get.setHeader(AUTHORIZATION, BEARER + this.getToken(respostaDTOTokem));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
        this.debug("solicitar lote liberacao " + this.url + path + " respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
        return RespostaDTO.parseHttpResponse(response);
    }

    private HttpPost setPost(String path, String json, String token) {
        HttpPost post = new HttpPost(this.url + path);
        post.setHeader("Accept", "application/json");
        post.setHeader(CONTENT_TYPE, "application/json; charset=utf-8");
        if (!Funcoes.textoVazio(token)) {
            post.setHeader(AUTHORIZATION, BEARER + token);
        }
        post.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
        return post;
    }

    public boolean comunicacaoOk() {
        CloseableHttpClient httpClient = this.criarHttpClientComTimeout();
        HttpGet get = new HttpGet(this.url);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            int codigoResposta = response.getStatusLine().getStatusCode();
            if (codigoResposta != 200 && codigoResposta != 204) {
                if (codigoResposta == 404) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Endere\u00e7o do WebService inv\u00e1lido.", 2);
                    return false;
                }
                if (codigoResposta == 401) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o autorizado.", 2);
                    return false;
                }
                if (codigoResposta == 503) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Servi\u00e7o indispon\u00edvel.", 2);
                    return false;
                }
                if (codigoResposta == 500) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com o servidor.", 2);
                    return false;
                }
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com o servidor.\nC\u00f3digo: " + codigoResposta, 2);
                return false;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
            return false;
        }
        return true;
    }

    private CloseableHttpClient criarHttpClientComTimeout() {
        return HttpClientBuilder.create().setDefaultRequestConfig(this.configurarTimeout()).build();
    }

    private RequestConfig configurarTimeout() {
        return RequestConfig.custom().setConnectTimeout(40000).setConnectionRequestTimeout(40000).setSocketTimeout(40000).build();
    }

    private boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    private String getToken(RespostaDTO respostaDTOTokem) {
        return TokenDTO.fromJson(respostaDTOTokem.getConteudo()).getToken();
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println(mensagem);
        }
    }
}

