/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.shift.CampoShift;
import jalis.laboratorio.util.parsers.shift.CamposShiftImportacao;
import jalis.laboratorio.util.parsers.shift.ExameShift;
import jalis.laboratorio.util.parsers.shift.VersaoShift;
import jalis.laboratorio.util.parsers.shift.XmlShift;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ParserImportacaoShift {
    public static final String TAG_EXAME_CODIGO = "codigo";
    public static final String TAG_EXAME_DESCRICAO = "descricao";

    private ParserImportacaoShift() {
    }

    protected static List<ExameShift> carregarExamesShift(File arquivoImportacao, int codigoLabExterno) {
        ArrayList<ExameShift> examesShift = new ArrayList();
        try {
            examesShift = ParserImportacaoShift.converterXlsxParaExamesShift(new FileInputStream(arquivoImportacao), codigoLabExterno);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoShift");
        }
        return examesShift;
    }

    private static List<ExameShift> converterXlsxParaExamesShift(InputStream input, int codigoLabExterno) throws IOException {
        XSSFWorkbook arquivoExcel = new XSSFWorkbook(input);
        XSSFSheet panilha = arquivoExcel.getSheetAt(0);
        ArrayList<ExameShift> listaExamesShift = new ArrayList<ExameShift>();
        ArrayList<VersaoShift> listaVersaoShift = new ArrayList<VersaoShift>();
        ArrayList<CampoShift> listaCamposShift = new ArrayList<CampoShift>();
        for (int i = 0; i <= panilha.getLastRowNum(); ++i) {
            XSSFRow linha = panilha.getRow(i);
            if (linha == null) continue;
            if (linha.getRowNum() == 0) {
                if (ParserImportacaoShift.cabecalhoValido(linha.getLastCellNum(), linha.cellIterator())) continue;
                listaExamesShift.add(null);
                return listaExamesShift;
            }
            ExameShift exameShift = ParserImportacaoShift.converteLinhaParaExameShift(linha.cellIterator());
            exameShift.setCodLabExterno(codigoLabExterno);
            listaExamesShift.add(exameShift);
            VersaoShift versaoShift = ParserImportacaoShift.converteLinhaParaVersaoShift(linha.cellIterator());
            listaVersaoShift.add(versaoShift);
            CampoShift campoShift = ParserImportacaoShift.converteLinhaParaCamposShift(linha.cellIterator());
            listaCamposShift.add(campoShift);
        }
        return ParserImportacaoShift.associaVersaoExame(listaExamesShift, listaVersaoShift, listaCamposShift);
    }

    private static List<ExameShift> associaVersaoExame(List<ExameShift> listaExamesShift, List<VersaoShift> listaVersaoShift, List<CampoShift> listaCamposShift) {
        listaExamesShift = ParserImportacaoShift.removeExamesRepetidos(listaExamesShift);
        listaVersaoShift = ParserImportacaoShift.associaCampoVersao(listaVersaoShift, listaCamposShift);
        for (ExameShift exame : listaExamesShift) {
            List listaVersao = listaVersaoShift.stream().filter(versao -> versao.getCodExame() != null && versao.getCodExame().equals(exame.getCodigo())).collect(Collectors.toList());
            if (listaVersao.isEmpty()) continue;
            for (VersaoShift campo : listaVersao) {
                exame.getVersao().add(campo);
            }
        }
        return listaExamesShift;
    }

    private static List<VersaoShift> associaCampoVersao(List<VersaoShift> listaVersaoShift, List<CampoShift> listaCamposShift) {
        listaVersaoShift = ParserImportacaoShift.removeVersaoRepetidas(listaVersaoShift);
        for (VersaoShift versao2 : listaVersaoShift) {
            List listaCampos = listaCamposShift.stream().filter(campo -> campo.getCodExame() != null && campo.getCodExame().equals(versao2.getCodExame()) && Objects.equals(campo.getVersao(), versao2.getVersao())).collect(Collectors.toList());
            if (listaCampos.isEmpty()) continue;
            for (CampoShift campo2 : listaCampos) {
                versao2.getCampos().add(campo2);
            }
        }
        return listaVersaoShift.stream().filter(versao -> !versao.getCampos().isEmpty()).collect(Collectors.toList());
    }

    private static List<ExameShift> removeExamesRepetidos(List<ExameShift> exameShift) {
        HashSet<String> setExameShift = new HashSet<String>();
        ArrayList<ExameShift> listaSemRepeticao = new ArrayList<ExameShift>();
        for (ExameShift e : exameShift) {
            if (Funcoes.textoVazio(e.getCodigo()) || !setExameShift.add(e.getCodigo())) continue;
            listaSemRepeticao.add(e);
        }
        return listaSemRepeticao;
    }

    private static List<VersaoShift> removeVersaoRepetidas(List<VersaoShift> versaoShift) {
        HashSet<String> setVersaoShift = new HashSet<String>();
        ArrayList<VersaoShift> listaSemRepeticao = new ArrayList<VersaoShift>();
        for (VersaoShift v : versaoShift) {
            if (Funcoes.textoVazio(v.getCodExame()) || v.getVersao() == null || !setVersaoShift.add(v.getCodExame() + v.getVersao())) continue;
            listaSemRepeticao.add(v);
        }
        return listaSemRepeticao;
    }

    private static ExameShift converteLinhaParaExameShift(Iterator<Cell> colunas) {
        ExameShift exameShift = new ExameShift();
        try {
            while (colunas.hasNext()) {
                Cell coluna = colunas.next();
                if (coluna.getColumnIndex() == CamposShiftImportacao.CODIGO_EXAME.getLinha()) {
                    exameShift.setCodigo(ParserImportacaoShift.getValorCelula(coluna));
                    continue;
                }
                if (coluna.getColumnIndex() == CamposShiftImportacao.PROCEDIMENTO.getLinha()) {
                    exameShift.setDescricao(ParserImportacaoShift.getValorCelula(coluna));
                    continue;
                }
                if (coluna.getColumnIndex() == CamposShiftImportacao.MATERIAL.getLinha()) {
                    exameShift.setDescricaoMaterial(ParserImportacaoShift.getValorCelula(coluna));
                    continue;
                }
                if (coluna.getColumnIndex() == CamposShiftImportacao.RECIPIENTE.getLinha()) {
                    exameShift.setRecipiente(ParserImportacaoShift.getValorCelula(coluna));
                    continue;
                }
                if (coluna.getColumnIndex() != CamposShiftImportacao.DATA.getLinha() || coluna.getCellType() != 0) continue;
                exameShift.setData(Funcoes.formataData("dd/MM/yyyy", coluna.getDateCellValue()));
            }
        }
        catch (Exception e) {
            return new ExameShift();
        }
        return exameShift;
    }

    private static VersaoShift converteLinhaParaVersaoShift(Iterator<Cell> colunas) {
        VersaoShift versaoShift = new VersaoShift();
        try {
            while (colunas.hasNext()) {
                Cell coluna = colunas.next();
                if (coluna.getColumnIndex() == CamposShiftImportacao.CODIGO_EXAME.getLinha()) {
                    versaoShift.setCodExame(ParserImportacaoShift.getValorCelula(coluna));
                    continue;
                }
                if (coluna.getColumnIndex() != CamposShiftImportacao.VERSAO.getLinha() || coluna.getCellType() != 0) continue;
                Double versao = coluna.getNumericCellValue();
                versaoShift.setVersao(versao.intValue());
            }
        }
        catch (Exception e) {
            return new VersaoShift();
        }
        return versaoShift;
    }

    private static CampoShift converteLinhaParaCamposShift(Iterator<Cell> colunas) {
        CampoShift campoShift = new CampoShift();
        try {
            while (colunas.hasNext()) {
                Cell coluna = colunas.next();
                if (coluna.getColumnIndex() == CamposShiftImportacao.CODIGO_EXAME.getLinha()) {
                    campoShift.setCodExame(ParserImportacaoShift.getValorCelula(coluna));
                    continue;
                }
                if (coluna.getColumnIndex() == CamposShiftImportacao.VERSAO.getLinha() && coluna.getCellType() == 0) {
                    Double versao = coluna.getNumericCellValue();
                    campoShift.setVersao(versao.intValue());
                    continue;
                }
                if (coluna.getColumnIndex() == CamposShiftImportacao.PARAM_APELIDO_EXPOR.getLinha()) {
                    if (ParserImportacaoShift.getValorCelula(coluna).equalsIgnoreCase("RES.ARQUIVADO.TXT")) {
                        return new CampoShift();
                    }
                    campoShift.setApelido(ParserImportacaoShift.getValorCelula(coluna));
                    continue;
                }
                if (coluna.getColumnIndex() != CamposShiftImportacao.PARAM_DESCRICAO.getLinha()) continue;
                campoShift.setDescricaoApelido(ParserImportacaoShift.getValorCelula(coluna));
            }
        }
        catch (Exception e) {
            return new CampoShift();
        }
        return campoShift;
    }

    private static String getValorCelula(Cell coluna) {
        if (coluna.getCellType() == 0) {
            Double versao = coluna.getNumericCellValue();
            return String.valueOf(versao.intValue());
        }
        if (coluna.getCellType() == 1) {
            return coluna.getStringCellValue();
        }
        return "";
    }

    private static boolean cabecalhoValido(int quantidadeColunas, Iterator<Cell> colunas) {
        Map<Integer, String> cabecalhoPadrao = ParserImportacaoShift.carregarCabecalhoPadrao();
        if (quantidadeColunas != cabecalhoPadrao.size()) {
            return false;
        }
        for (int i = 0; i < quantidadeColunas; ++i) {
            Cell celula = colunas.next();
            if (celula.getStringCellValue().equals(cabecalhoPadrao.get(i).trim())) continue;
            return false;
        }
        return true;
    }

    private static Map<Integer, String> carregarCabecalhoPadrao() {
        HashMap<Integer, String> cabecalhoPadrao = new HashMap<Integer, String>();
        cabecalhoPadrao.put(0, "Recipientes");
        cabecalhoPadrao.put(1, "Mnenomico");
        cabecalhoPadrao.put(2, "Procedimento");
        cabecalhoPadrao.put(3, "Material");
        cabecalhoPadrao.put(4, "Status");
        cabecalhoPadrao.put(5, "Versao");
        cabecalhoPadrao.put(6, "Data");
        cabecalhoPadrao.put(7, "Hora");
        cabecalhoPadrao.put(8, "Padrao");
        cabecalhoPadrao.put(9, "Prazo");
        cabecalhoPadrao.put(10, "M\u00e1scara Descri\u00e7\u00e3o");
        cabecalhoPadrao.put(11, "Par\u00e2metro - Apelido");
        cabecalhoPadrao.put(12, "Par\u00e2metro - Descri\u00e7\u00e3o");
        cabecalhoPadrao.put(13, "Par\u00e2metro - Apelido exportacao");
        cabecalhoPadrao.put(14, "Processo - Apelido");
        cabecalhoPadrao.put(15, "Processo - Descri\u00e7\u00e3o");
        cabecalhoPadrao.put(16, "Processo - M\u00e9todo");
        cabecalhoPadrao.put(17, "Processo - Unidade de medida");
        return cabecalhoPadrao;
    }

    protected static List<ExameShift> pesquisarExamesNoBancoDeDados(int codigoLabExterno) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select shi_codexame, shi_xml, shi_descricaomaterial, shi_descricaoexame ");
        sql.append(" from examesshift ");
        sql.append(" where fil_codigo =  ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo =  ").append(codigoLabExterno);
        Statement st = Conexao.getStatement();
        ArrayList<ExameShift> examesShift = new ArrayList<ExameShift>();
        if (null != st) {
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                ExameShift exame = new ExameShift();
                exame.setCodigo(rs.getString("shi_codexame"));
                exame.setCodLabExterno(codigoLabExterno);
                exame.setDescricao(rs.getString("shi_descricaoexame"));
                exame.setDescricaoMaterial(rs.getString("shi_descricaomaterial"));
                String xml = rs.getString("shi_xml");
                exame.setXml(xml);
                String data = StringUtil.getValor(xml, XmlShift.DATA.getTag());
                exame.setData(data);
                String recipiente = StringUtil.getValor(xml, XmlShift.RECIPIENTE.getTag());
                exame.setRecipiente(recipiente);
                exame.setVersao(ParserImportacaoShift.montaVersao(xml, rs.getString("shi_codexame")));
                examesShift.add(exame);
            }
            Conexao.fecharStatement(st);
        }
        return examesShift;
    }

    private static List<VersaoShift> montaVersao(String xml, String codigoExame) {
        String[] versoes = StringUtil.getValores(xml, XmlShift.VERSAO.getTag());
        ArrayList<VersaoShift> listaVersao = new ArrayList<VersaoShift>();
        for (String v : versoes) {
            VersaoShift versao = new VersaoShift();
            Integer codigoVersao = Integer.parseInt(StringUtil.getValor(v, XmlShift.CODIGO_VERSAO.getTag()));
            versao.setVersao(codigoVersao);
            versao.setCodExame(codigoExame);
            versao.setCampos(ParserImportacaoShift.montaCampos(v, codigoExame, codigoVersao));
            listaVersao.add(versao);
        }
        return listaVersao;
    }

    private static List<CampoShift> montaCampos(String v, String codigoExame, Integer codigoVersao) {
        String[] campos = StringUtil.getValores(v, XmlShift.CAMPOS.getTag());
        ArrayList<CampoShift> listaCampos = new ArrayList<CampoShift>();
        for (String c : campos) {
            CampoShift campo = new CampoShift();
            campo.setApelido(StringUtil.getValor(c, XmlShift.APELIDO.getTag()));
            campo.setCodExame(codigoExame);
            campo.setVersao(codigoVersao);
            campo.setDescricaoApelido(StringUtil.getValor(c, XmlShift.DESCRICAO_APELIDO.getTag()));
            listaCampos.add(campo);
        }
        return listaCampos;
    }

    protected static List<ExameShift> getExamesRelacionados(int codigoLabExterno) {
        Statement st = Conexao.getStatement();
        ArrayList<ExameShift> listaExamesShift = new ArrayList<ExameShift>();
        StringBuilder bui = new StringBuilder();
        if (st != null) {
            try {
                bui.append(" select a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo ");
                bui.append(" FROM examematcoletalabexterno a ");
                bui.append(" left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo ");
                bui.append(" where ");
                bui.append(" b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and ");
                bui.append(" a.lae_codigo = ").append(codigoLabExterno);
                bui.append(" and a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                while (rs.next()) {
                    ExameShift exameShift = new ExameShift();
                    exameShift.setCodigo(rs.getString("exa_codigo"));
                    exameShift.setCodigoMaterial(rs.getString("mco_codigo"));
                    exameShift.setCodLabExterno(rs.getInt("lae_codigo"));
                    exameShift.setXml(rs.getString("ele_xmllabexterno"));
                    if (listaExamesShift.contains(exameShift)) continue;
                    listaExamesShift.add(exameShift);
                }
                rs.close();
                return listaExamesShift;
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + bui.toString(), e.getStackTrace());
            }
        }
        return new ArrayList<ExameShift>();
    }

    public static Registro getExame(String xml, String exameJalis, String materialJalis) {
        Registro exame = new Registro();
        if (!Funcoes.textoVazio(exameJalis) && !Funcoes.textoVazio(materialJalis)) {
            exame.setValor(CamposShiftImportacao.TAG_EXAME_JALIS.getTag(), exameJalis);
            exame.setValor(CamposShiftImportacao.TAG_MATERIAL_JALIS.getTag(), materialJalis);
        }
        String xmlExame = StringUtil.getValor(xml, CamposShiftImportacao.TAG_EXAME.getTag());
        exame.setValor(CamposShiftImportacao.TAG_EXAME_CODIGO.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_EXAME_CODIGO.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_EXAME_DESCRICAO.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_EXAME_DESCRICAO.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_EXAME_DESC_MATERIAL.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_EXAME_DESC_MATERIAL.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_EXAME_RECIPIENTE.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_EXAME_RECIPIENTE.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_EXAME_VERSAO.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_EXAME_VERSAO.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_EXAME_DATA.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_EXAME_DATA.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_DATA.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_DATA.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_DESC_DATA.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_DESC_DATA.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_HORA.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_HORA.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_DESC_HORA.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_DESC_HORA.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_RESPONSAVEL.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_RESPONSAVEL.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_DESC_RESPONSAVEL.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_DESC_RESPONSAVEL.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_APELIDO.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_APELIDO.getTag()));
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_DESC_APELIDO.getTag(), StringUtil.getValor(xmlExame, CamposShiftImportacao.TAG_RESULTADO_DESC_APELIDO.getTag()));
        List<String> campos = StringUtil.getListValores(xmlExame, CamposShiftImportacao.TAG_RESULTADO_CAMPO.getTag());
        ArrayList<Registro> camp = new ArrayList<Registro>();
        for (String campo : campos) {
            Registro r = new Registro();
            r.setValor(CamposShiftImportacao.TAG_RESULTADO_CAMPO_CODIGO.getTag(), StringUtil.getValor(campo, CamposShiftImportacao.TAG_RESULTADO_CAMPO_CODIGO.getTag()));
            r.setValor(CamposShiftImportacao.TAG_RESULTADO_CAMPO_DESCRICAO.getTag(), StringUtil.getValor(campo, CamposShiftImportacao.TAG_RESULTADO_CAMPO_DESCRICAO.getTag()));
            camp.add(r);
        }
        exame.setValor(CamposShiftImportacao.TAG_RESULTADO_CAMPOS.getTag(), camp);
        return exame;
    }
}

