/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.shift.ExameShift;
import jalis.laboratorio.util.parsers.shift.ParserImportacaoShift;
import jalis.laboratorio.util.parsers.shift.XmlShift;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;

public class ImportacaoShift
extends AbstractImportadorLabExterno {
    private static final String TITULO = "Importa\u00e7\u00e3o de exames";
    private static final String DESCRICAO = "Importa\u00e7\u00e3o de exames do Lab. Shift a partir de arquivo XLSX";
    private static final long ACESSO = 904000101L;
    StringBuilder bui = new StringBuilder();

    public ImportacaoShift(int codigoLabExterno) {
        super(TITULO, DESCRICAO, codigoLabExterno, Protocolo.Shift);
        this.getButtonImportar().setText("Importar Exames");
    }

    @Override
    protected boolean importarArquivo() {
        Statement st = Conexao.getStatement();
        this.bui = new StringBuilder();
        boolean retorno = false;
        try {
            File arquivoSelecionado = this.selecionarArquivo();
            if (arquivoSelecionado == null) {
                return false;
            }
            if (!arquivoSelecionado.getName().toUpperCase().endsWith(".XLSX")) {
                this.setTextoInformacoes("Formato do arquivo incompat\u00edvel com a Integra\u00e7\u00e3o do Lab. Shift.");
                return false;
            }
            this.progress.setVisible(true);
            this.bui.append("Importando exames...\n");
            this.setTextoInformacoes(this.bui.toString());
            List<ExameShift> examesShift = ParserImportacaoShift.carregarExamesShift(arquivoSelecionado, this.codigoLabExterno);
            if (examesShift.size() == 1 && examesShift.get(0) == null) {
                this.bui.append("\nArquivo fora do padr\u00e3o Shift!");
                this.setTextoInformacoes(this.bui.toString());
                this.progress.setVisible(false);
                return false;
            }
            List<ExameShift> examesShiftParaImportar = this.validarExamesSemInformacao(examesShift);
            List<ExameShift> examesShiftBanco = ParserImportacaoShift.pesquisarExamesNoBancoDeDados(this.codigoLabExterno);
            if (this.listaVazia(examesShiftParaImportar)) {
                this.bui.append("\nO arquivo n\u00e3o cont\u00eam os dados necess\u00e1rios, verifique se o arquivo n\u00e3o est\u00e1 vazio!");
                this.setTextoInformacoes(this.bui.toString());
                this.progress.setVisible(false);
                return false;
            }
            this.bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
            this.setTextoInformacoes(this.bui.toString());
            if (null != examesShiftBanco && !examesShiftBanco.isEmpty()) {
                this.validarExamesExcluidos(examesShiftParaImportar, examesShiftBanco);
                this.validarExamesAtualizados(examesShiftParaImportar, examesShiftBanco);
            }
            this.progressSetMaximum(examesShiftParaImportar);
            IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, this.codigoLabExterno, 16, new Object[0]);
            for (ExameShift es : examesShiftParaImportar) {
                this.progressSetValue(this.progress);
                IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, this.codigoLabExterno, 16, es.getCodigo(), StringUtil.textoDB(es.getDescricao()), StringUtil.textoDB(es.getDescricaoMaterial()), es.construirXml(true));
            }
            this.atualizaDePara(st, this.codigoLabExterno, examesShiftParaImportar, this.progress);
            Conexao.arquivaSQL();
            this.progress.setVisible(false);
            return true;
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            retorno = false;
            ErrorLogger.mostraMensagem(this, String.format("N\u00e3o foi possivel importar arquivo - Lab. %s %s ", this.protocolo.name(), e.getMessage()), e.getStackTrace());
            this.progress.setVisible(false);
            return retorno;
        }
    }

    private File selecionarArquivo() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLSX do Lab. ".concat(this.protocolo.name()).concat(" (*.xlsx)"), "xlsx"));
        File arquivoSelecionado = null;
        if (chooser.showOpenDialog(this) == 0) {
            arquivoSelecionado = chooser.getSelectedFile();
        }
        return arquivoSelecionado;
    }

    private void validarExamesAtualizados(List<ExameShift> examesShiftParaImportar, List<ExameShift> examesShiftBanco) {
        List<ExameShift> atualizados = examesShiftParaImportar.stream().filter(ei -> !examesShiftBanco.contains(ei)).collect(Collectors.toList());
        this.montaLogExamesAtualizadosExcluidos(atualizados, true);
    }

    private void validarExamesExcluidos(List<ExameShift> examesShiftParaImportar, List<ExameShift> examesShiftBanco) {
        List examesImportar = examesShiftParaImportar.stream().map(eb -> eb.getCodigo()).collect(Collectors.toList());
        List<ExameShift> excluidos = examesShiftBanco.stream().filter(eb -> !examesImportar.contains(eb.getCodigo())).collect(Collectors.toList());
        this.montaLogExamesAtualizadosExcluidos(excluidos, false);
    }

    private void montaLogExamesAtualizadosExcluidos(List<ExameShift> exames, boolean atualizados) {
        String atualizadosExcluidos;
        String string = atualizadosExcluidos = atualizados ? "atualizados" : "excluidos";
        if (!this.listaVazia(exames)) {
            this.bui.append("\n\nOs seguintes exames abaixo foram " + atualizadosExcluidos + ": \n\n");
            this.bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
            this.bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
            this.bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
            exames.stream().forEach(e -> this.bui.append("\n\t|").append(StringUtil.formatarColuna(e.getDescricao(), 50, 'c')).append("|").append(StringUtil.formatarColuna(e.getDescricaoMaterial(), 50, 'c')).append("|"));
            this.bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
            this.setTextoInformacoes(this.bui.toString());
        }
    }

    private boolean listaVazia(List<ExameShift> examesShift) {
        return examesShift == null || examesShift.isEmpty();
    }

    private List<ExameShift> validarExamesSemInformacao(List<ExameShift> examesShiftParaImportar) {
        ArrayList<ExameShift> examesParaImportar = new ArrayList<ExameShift>();
        this.progressSetMaximum(examesShiftParaImportar);
        for (ExameShift exameShift : examesShiftParaImportar) {
            this.progressSetValue(this.progress);
            if (ImportacaoShift.informacaoVazia(exameShift)) {
                this.bui.append("\nO exame " + exameShift.getCodigo() + " n\u00e3o possui todas as informa\u00e7\u00f5es para a importa\u00e7\u00e3o no Jalis.");
                this.setTextoInformacoes(this.bui.toString());
                continue;
            }
            examesParaImportar.add(exameShift);
        }
        this.bui.append(this.listaVazia(examesShiftParaImportar) ? "\n" : "");
        return examesParaImportar;
    }

    private static boolean informacaoVazia(ExameShift exameShift) {
        return Funcoes.textoVazio(exameShift.getCodigo()) || Funcoes.textoVazio(exameShift.getDescricao()) || Funcoes.textoVazio(exameShift.getDescricaoMaterial()) || exameShift.getVersao() == null;
    }

    private void atualizaDePara(Statement st, int codLabExterno, List<ExameShift> examesShiftParaImportar, JProgressBar progress) {
        List<ExameShift> relacionamentoExameAntigo = ParserImportacaoShift.getExamesRelacionados(codLabExterno);
        ArrayList<ExameShift> listaDePara = new ArrayList<ExameShift>();
        try {
            for (ExameShift examesNovos : examesShiftParaImportar) {
                this.progressSetValue(progress);
                for (ExameShift examesAntigos : relacionamentoExameAntigo) {
                    if (!examesNovos.getCodigo().equals(StringUtil.getValor(examesAntigos.getXml(), XmlShift.CODIGO.getTag()))) continue;
                    examesNovos.setXml(examesAntigos.getXml());
                    listaDePara.add(examesNovos);
                }
            }
            this.apagaRelacionamentoDePara(st, examesShiftParaImportar, relacionamentoExameAntigo);
            for (ExameShift exa : listaDePara) {
                Optional<ExameShift> exaAntigoOpt = relacionamentoExameAntigo.stream().filter(ex -> ex.getCodigo().equals(exa.getCodigo())).findAny();
                ExameShift exaAntigo = null;
                if (exaAntigoOpt.isPresent()) {
                    exaAntigo = exaAntigoOpt.get();
                }
                if (exaAntigo == null) continue;
                IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, this.codigoLabExterno, exaAntigo.getCodigo(), Integer.parseInt(exaAntigo.getCodigoMaterial()), exa.getXml().replace("'", ""));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel importar arquivo - Lab. " + this.protocolo.name(), e.getStackTrace(), "ImportacaoShift");
        }
    }

    private void apagaRelacionamentoDePara(Statement st, List<ExameShift> examesShiftParaImportar, List<ExameShift> relacionamentoExameAntigo) {
        List codigo = examesShiftParaImportar.stream().map(ExameShift::getCodigo).collect(Collectors.toList());
        relacionamentoExameAntigo.stream().filter(codExame -> !codigo.contains(StringUtil.getValor(codExame.getXml(), XmlShift.CODIGO.getTag()))).forEach(codExame -> {
            try {
                IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, this.codigoLabExterno, codExame.getCodigo(), Integer.parseInt(codExame.getCodigoMaterial()), null);
            }
            catch (SalvaDadosException | NumberFormatException | SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel importar arquivo - Lab. " + this.protocolo.name(), e.getStackTrace(), "ImportacaoShift");
            }
        });
    }

    private void progressSetMaximum(List<ExameShift> listaExames) {
        if (this.progress != null) {
            this.progress.setMaximum(listaExames.size() * 2);
        }
    }

    private void progressSetValue(JProgressBar progress) {
        if (progress != null) {
            progress.setValue(progress.getValue() + 1);
        }
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }
}

