/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.shift.dto.RespostaShiftExame;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.consultas.ConfiguracaoExameShiftVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.model.vo.triagem.LoteExternoVO;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ImportacaoResultadoShiftDao {
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_RESULTADO = "resultado";
    public static final String TAG_COMETARIO = "comentario";
    public static final String TAG_METODO = "metodo";
    private static final String ASPA = "'";
    private static final String VIRGULA = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requisicaoValida(String codFilial, String codRequisicao) {
        boolean valida;
        Statement st;
        block4: {
            StringBuilder sql = new StringBuilder();
            sql.append(" select req_codigo from requisicao where fil_codigo = ").append(codFilial);
            sql.append(" and req_codigo = ").append(codRequisicao);
            sql.append(" and req_excluida is not null and req_excluida = false ");
            st = Conexao.getStatement();
            valida = false;
            try {
                ResultSet resultado = st.executeQuery(sql.toString());
                if (!resultado.next()) break block4;
                valida = true;
            }
            catch (SQLException e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return valida;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loteValido(String codLote, String codLabExterno) {
        boolean valido;
        Statement st;
        block4: {
            StringBuilder sql = new StringBuilder();
            sql.append(" select lex_codigo from loteexterno ");
            sql.append(" where lex_codigo = ").append(codLote).append(" and lae_codigo =  ").append(codLabExterno);
            sql.append(" and lex_dataestorno is null ");
            st = Conexao.getStatement();
            valido = false;
            try {
                ResultSet resultado = st.executeQuery(sql.toString());
                if (!resultado.next()) break block4;
                valido = true;
            }
            catch (SQLException e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return valido;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoteExternoRequisicaoVO> pesquisarRequisicoesPorLote(String codigoLote, int codigoLabExterno) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select fil_codigo, lex_codigo, req_codigo ");
        sql.append("  from loteexternorequisicao ");
        sql.append("  where lex_codigo = ").append(codigoLote);
        sql.append("  and lae_codigo = ").append(codigoLabExterno);
        Statement st = Conexao.getStatement();
        ArrayList<LoteExternoRequisicaoVO> requisicoesPorLote = new ArrayList<LoteExternoRequisicaoVO>();
        try {
            ResultSet resultado = st.executeQuery(sql.toString());
            while (resultado.next()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(resultado.getInt("fil_codigo"));
                LoteExternoVO loteExterno = new LoteExternoVO();
                loteExterno.setCodigo(resultado.getInt("lex_codigo"));
                RequisicaoVO requisicao = new RequisicaoVO();
                requisicao.setCodigo(resultado.getInt("req_codigo"));
                LoteExternoRequisicaoVO vo = new LoteExternoRequisicaoVO();
                vo.setFilialVO(filial);
                vo.setLoteExternoVO(loteExterno);
                vo.setRequisicaoVO(requisicao);
                requisicoesPorLote.add(vo);
            }
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return requisicoesPorLote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registro localizarExameRequisicao(String codFilial, String codRequisicao, RespostaShiftExame exameShift) {
        Statement st;
        block4: {
            Registro registro;
            StringBuilder sql = new StringBuilder(" select ");
            sql.append(" a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, ");
            sql.append(" b.exa_codigo,b.exr_resposta, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, ");
            sql.append(" a.req_idade, a.req_anomes, b.exr_datamaterial, ");
            sql.append(" d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, null as exameFilho, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, ");
            sql.append(" a.req_guia, b.exr_codautorizacao, b.exr_solicitadotiss, l.lae_configuracao ");
            sql.append(" from requisicao a ");
            sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
            sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo ");
            sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo ");
            sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo ");
            sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo ");
            sql.append(" left join labexterno l on g.fil_codigo = l.fil_codigo and g.lae_codigo = l.lae_codigo ");
            sql.append(" where ");
            sql.append(" a.fil_codigo = ").append(codFilial).append(" and ");
            sql.append(" a.req_codigo = ").append(codRequisicao).append(" and ");
            sql.append(" a.req_excluida = false and b.exr_excluido = false ");
            sql.append(" and b.exa_codigo = '").append(exameShift.getExaCodigo()).append(ASPA);
            sql.append(" and b.mco_codigo = ").append(exameShift.getMcoCodigo());
            st = Conexao.getStatement();
            try {
                ResultSet res = Conexao.executeQuery(st, sql.toString());
                Registro reg = null;
                if (!res.next()) break block4;
                reg = new Registro(res);
                reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(codFilial, res.getString("con_codigo"), res.getString("des_codigo")));
                reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(codFilial, reg.getString("codigo-layout")));
                reg.setValor("codigo_versao", exameShift.getVersao());
                Registro formatacao = new Registro();
                formatacao.setValor("formato", reg.getValor("exr_resultado"));
                formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                reg.setValor("formatacao", formatacao);
                exameShift.setExaCodigo(res.getString("exa_codigo"));
                exameShift.setMcoCodigo(res.getString("mco_codigo"));
                registro = reg;
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return registro;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscarDadosExameAssociado(String codFilial, String codRequisicao, RespostaShiftExame exameShift) {
        Statement st;
        block4: {
            boolean bl;
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT a.exa_codigo as examepai, ");
            sql.append(" e.exa_kodigo as examefilho, ");
            sql.append(" a.mco_codigo, ");
            sql.append(" p.ele_xmllabexterno ");
            sql.append(" FROM examerequisicao a ");
            sql.append(" JOIN examematcoletalabextdesm e ON a.fil_codigo = e.fil_codigo ");
            sql.append(" AND a.exa_codigo = e.exa_codigo ");
            sql.append(" AND a.mco_codigo = e.mco_codigo ");
            sql.append(" JOIN examematcoletalabexterno p ON e.fil_codigo = p.fil_codigo ");
            sql.append(" AND e.exa_kodigo = p.exa_codigo ");
            sql.append(" AND e.mco_kodigo = p.mco_codigo ");
            sql.append(" AND e.lae_codigo = p.lae_codigo ");
            sql.append(" WHERE a.fil_codigo = ").append(codFilial);
            sql.append(" AND a.req_codigo = ").append(codRequisicao);
            sql.append(" AND upper(p.ele_xmllabexterno) ilike '%<").append(TAG_CODIGO).append(">").append(exameShift.getCodigoApoio().toUpperCase()).append("</").append(TAG_CODIGO).append(">%'");
            sql.append(" AND p.ele_xmllabexterno is not null and p.ele_xmllabexterno <> '' ");
            st = Conexao.getStatement();
            try {
                ResultSet resultSet = Conexao.executeQuery(st, sql);
                if (!resultSet.next()) break block4;
                exameShift.setExaCodigo(resultSet.getString("examefilho"));
                exameShift.setMcoCodigo(resultSet.getString("mco_codigo"));
                exameShift.setXmlLabExterno(resultSet.getString("ele_xmllabexterno"));
                bl = true;
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExameDesmembrado> pesquisarExamesDesmembrados(String codFilial, String codRequisicao, String codLabExterno, String exameFilho, String mcoFilho) {
        Statement st;
        ArrayList<ExameDesmembrado> exameDesmembrado;
        block5: {
            exameDesmembrado = new ArrayList<ExameDesmembrado>();
            st = Conexao.getStatement();
            try {
                if (st == null) break block5;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo, a.mco_codigo, p.ele_xmllabexterno, pai.ele_xmllabexterno as xmllabexternopai  ");
                buf.append(" from loteexternoexamerequisicaodesm a ");
                buf.append(" left join examematcoletalabexterno p on a.fil_kodigo = p.fil_codigo and a.exa_kodigo = p.exa_codigo and a.mco_kodigo = p.mco_codigo and a.lae_codigo = p.lae_codigo ");
                buf.append(" left join examematcoletalabexterno pai on a.fil_kodigo = pai.fil_codigo and a.exa_codigo = pai.exa_codigo and a.mco_codigo = pai.mco_codigo and a.lae_codigo = pai.lae_codigo  ");
                buf.append(" where a.fil_kodigo = ").append(codFilial);
                buf.append(" and a.req_codigo  = ").append(codRequisicao);
                buf.append(" and a.exa_kodigo = '").append(exameFilho).append("' ");
                buf.append(" and a.mco_codigo = ").append(mcoFilho);
                buf.append(" and a.lae_codigo = ").append(codLabExterno);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                while (res.next()) {
                    ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"), res.getString("xmllabexternopai"));
                    ex.addFilho(new Exame(exameFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                    exameDesmembrado.add(ex);
                }
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return exameDesmembrado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exameRelacionado(Registro reg, int codigoLabExterno) {
        if (reg != null) {
            Statement st;
            block5: {
                boolean bl;
                String fil = reg.getString("fil_codigo");
                String exa = reg.getString("exa_codigo");
                String mco = reg.getString("mco_codigo");
                StringBuilder sql = new StringBuilder();
                sql.append("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
                sql.append(" where fil_codigo = ").append(fil);
                sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
                sql.append(" and lae_codigo = ").append(codigoLabExterno);
                sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
                st = Conexao.getStatement();
                try {
                    ResultSet rs = st.executeQuery(sql.toString());
                    if (!rs.next() || rs.getInt("lae_codigo") != codigoLabExterno) break block5;
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, TAG_CODIGO);
                    mco = StringUtil.getValor(xml, "desc_material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select shi_xml from examesshift where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(codigoLabExterno);
                    sqlBuilder.append(" and shi_codexame = '").append(exa).append("' and shi_descricaomaterial = '").append(mco).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (!rs.next()) break block5;
                    reg.setValor("shi_xml", rs.getString("shi_xml"));
                    bl = true;
                }
                catch (Exception e) {
                    try {
                        this.anularSQL();
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                return bl;
            }
            Conexao.fecharStatement(st);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registro pesquisarDadosConferenciaAutomatica(int codigoLabExterno) {
        Registro reg;
        Statement st;
        block4: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and lae_codigo = ").append(codigoLabExterno);
            reg = new Registro();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                reg.setValor("conferirAutomatico", rs.getBoolean("lae_conferirautomatico"));
                String codUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
                reg.setValor("codigoUsuarioConferenciaAutomatica", codUsuarioConferenciaAutomatica);
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscaPermissaoDeEnvioEmail(String filial) {
        Statement st;
        boolean retorno;
        block4: {
            retorno = false;
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, "select fil_enviaremail from filiais_postocoleta where fil_codigo = " + filial);
                if (!rs.next()) break block4;
                retorno = rs.getBoolean("fil_enviaremail");
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscaPermissaoDeEnvioSms(String filial) {
        Statement st;
        boolean retorno;
        block4: {
            retorno = false;
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, "select fil_enviarsms from filiais_postocoleta where fil_codigo = " + filial);
                if (!rs.next()) break block4;
                retorno = rs.getBoolean("fil_enviarsms");
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salvarResultadoPDF(ConfiguracaoExameShiftVO configExameRede, String resultadoPDF) {
        Statement st = Conexao.getStatement();
        try {
            String resultado = StringUtil.textoDBEscape(resultadoPDF);
            StringBuilder sql = new StringBuilder();
            String condicaoWhere = this.getCondicaoWhere(configExameRede);
            sql.append(" select 1 as resultado from examerequisicaoresultado");
            sql.append(condicaoWhere);
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            sql.delete(0, sql.length());
            if (rs.next()) {
                sql.append(" update examerequisicaoresultado set");
                sql.append(" ert_resultadopdf = ").append(resultado);
                sql.append(condicaoWhere);
            } else {
                sql.append(" insert into examerequisicaoresultado (fil_codigo, exa_codigo, mco_codigo, req_codigo, ert_resultadopdf) ");
                sql.append(" values (");
                sql.append(configExameRede.getCodigoFilial()).append(VIRGULA);
                sql.append(ASPA.concat(configExameRede.getCodigoExame()).concat(ASPA)).append(VIRGULA);
                sql.append(configExameRede.getCodigoMaterial()).append(VIRGULA);
                sql.append(configExameRede.getCodigoRequisicao()).append(VIRGULA);
                sql.append(resultado).append(" );");
            }
            Conexao.executeUpdate(configExameRede.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private String getCondicaoWhere(ConfiguracaoExameShiftVO configExameRede) {
        StringBuilder where = new StringBuilder(" where ");
        where.append(" fil_codigo = ").append(configExameRede.getCodigoFilial());
        where.append(" and req_codigo = ").append(configExameRede.getCodigoRequisicao());
        where.append(" and exa_codigo = '").append(configExameRede.getCodigoExame()).append(ASPA);
        where.append(" and mco_codigo = ").append(configExameRede.getCodigoMaterial());
        return where.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarExameRequisicao(ConfiguracaoExameShiftVO configExameRede, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update examerequisicao set exr_resultadoempdf = true, ");
        if (!conferirAutomatico && Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" exr_situacao = '").append("L").append("', ");
        }
        sql.append(" exr_datadigita = current_timestamp, ");
        sql.append(" usr_coddigitador = '").append(Variaveis.login).append(ASPA);
        if (conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" ,exr_situacao = '").append("C").append("', ");
            sql.append(" exr_dataassina = current_timestamp, ");
            sql.append(" usr_codassina = '").append(codigoUsuarioConferenciaAutomatica).append(ASPA);
        }
        sql.append(this.getCondicaoWhere(configExameRede));
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(configExameRede.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfiguracaoExameShiftVO> pesquisarExamesDesmembradosNoLote(Registro reg) {
        ArrayList<ConfiguracaoExameShiftVO> desmembrados = new ArrayList<ConfiguracaoExameShiftVO>();
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" ldesm.fil_kodigo, ldesm.req_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo, ler.leq_codigoreqapoio,  exlabext.ele_xmllabexterno ");
        sql.append(" from loteexternoexamerequisicaodesm ldesm ");
        sql.append(" left join loteexternoexamerequisicao leer ");
        sql.append(" on ldesm.fil_kodigo = leer.fil_kodigo ");
        sql.append(" and ldesm.fil_codigo = leer.fil_codigo ");
        sql.append(" and ldesm .lex_codigo = leer.lex_codigo ");
        sql.append(" and ldesm.req_codigo = leer.req_codigo ");
        sql.append(" and ldesm.exa_codigo = leer.exa_codigo ");
        sql.append(" and ldesm.mco_codigo = leer.mco_codigo ");
        sql.append(" left join loteexternorequisicao ler ");
        sql.append(" on leer.fil_kodigo = ler.fil_kodigo ");
        sql.append(" and leer.fil_codigo = ler.fil_codigo ");
        sql.append(" and leer .lex_codigo = ler.lex_codigo ");
        sql.append(" and leer.req_codigo = ler.req_codigo ");
        sql.append(" left join examematcoletalabexterno exlabext ");
        sql.append(" on ldesm.fil_kodigo = exlabext.fil_codigo ");
        sql.append(" and ldesm.exa_kodigo = exlabext.exa_codigo ");
        sql.append(" and ldesm.mco_kodigo  = exlabext.mco_codigo ");
        sql.append(" and ldesm.lae_codigo = exlabext.lae_codigo ");
        sql.append(" where ldesm.fil_kodigo = ").append(reg.getInt("fil_codigo"));
        sql.append(" and ldesm.req_codigo = ").append(reg.getInt("req_codigo"));
        sql.append(" and ldesm.exa_codigo = ").append(StringUtil.textoDBEscape(reg.getString("examePai")));
        sql.append(" and ldesm.mco_codigo = ").append(reg.getInt("mco_codigo"));
        sql.append(" and leer.ler_datahoraestorno  is null and leer.usr_codestorno is null ");
        sql.append(" and ler.leq_dataestorno is null and ler.usr_codestorno  is null ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                ConfiguracaoExameShiftVO confExame = new ConfiguracaoExameShiftVO();
                confExame.setCodigoExame(rs.getString("exa_kodigo"));
                confExame.setCodigoFilial(rs.getString("fil_kodigo"));
                confExame.setCodigoMaterial(rs.getString("mco_kodigo"));
                confExame.setCodigoRequisicao(rs.getString("req_codigo"));
                confExame.setCodPedApoio(rs.getString("leq_codigoreqapoio"));
                confExame.setConfigExameRede(rs.getString("ele_xmllabexterno"));
                desmembrados.add(confExame);
            }
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return desmembrados;
    }

    public void salvarResultadoPDF(ConfiguracaoExameShiftVO configExameRede, String resultadoPDFEmBase64, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica) {
        if (!Funcoes.textoVazio(resultadoPDFEmBase64)) {
            this.salvarResultadoPDF(configExameRede, resultadoPDFEmBase64);
            this.atualizarExameRequisicao(configExameRede, conferirAutomatico, codigoUsuarioConferenciaAutomatica);
        }
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

