/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.shift.ShiftCampos;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.rede.ws.InformaPeriodo;
import jalis.laboratorio.util.parsers.shift.CamposXmlConsultaShift;
import jalis.laboratorio.util.parsers.shift.ComunicacaoShift;
import jalis.laboratorio.util.parsers.shift.ImportacaoResultadoShiftDao;
import jalis.laboratorio.util.parsers.shift.ParserImportacaoShift;
import jalis.laboratorio.util.parsers.shift.dto.RespostaShiftExame;
import jalis.laboratorio.util.parsers.shift.dto.RespostaShiftResultado;
import jalis.laboratorio.util.parsers.shift.dto.RespostaShiftResultadoLab;
import jalis.model.vo.consultas.ConfiguracaoExameShiftVO;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ImportacaoResultadoShift
extends AbstractImportadorResultadoLabExterno {
    boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static long acesso = 904000201L;
    private ModeloGridTable modeloRelatorio;
    private JButton buttonImprimir;
    private transient ImportacaoResultadoShiftDao dao;
    private transient LaboratorioExterno lab;
    InformaPeriodo informa;
    private String idLaboratorio;
    private String senha;
    private String webService;
    private String xml = "";
    private String retorno = "";
    private boolean conferirAutomatico = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    private List<String> listaFilial = new ArrayList<String>();
    private List<String> listaRequisicao = new ArrayList<String>();
    private HashMap<String, String> requisicoesNotificar = new HashMap();
    private Map<String, String> requisicoesEnvioNotificacao = new HashMap<String, String>();
    public static final String CABECALHO = "cabecalho";
    public static final String FORMATACAO = "formatacao";
    public static final String CONFERIR_AUTOMATICO = "conferirAutomatico";
    public static final String COD_USUARIO_CONFERENCIA_AUTOMATICA = "codigoUsuarioConferenciaAutomatica";
    private static final int SITUACAO_FORMATO_OK = 0;
    private static final int SITUACAO_FORMATO_INCORRETO = 1;
    private static final int SITUACAO_FORMATO_VERSAO_NAO_LOCALIZADA = 2;

    public ImportacaoResultadoShift(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. Shift (Webservice)", codigoLabExterno, Protocolo.Shift, new JPanel(new FlowLayout(2)));
        this.buttonImportarWS.setEnabled(true);
        this.buttonImportarWS.setVisible(true);
        this.buttonImportar.setVisible(false);
        this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
        this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
        this.getPanelAdicional().add(this.buttonImprimir);
        this.dao = new ImportacaoResultadoShiftDao();
        this.lab = LaboratorioExterno.getLabExterno(String.valueOf(codigoLabExterno));
    }

    @Override
    protected void importarResultadoWs() {
        this.idLaboratorio = StringUtil.getValor(this.lab.configuracao, "idLaboratorio");
        this.senha = StringUtil.getValor(this.lab.configuracao, "senha");
        this.webService = StringUtil.getValor(this.lab.configuracao, "enderecoWebService");
        if (this.isWebService) {
            InformaPeriodo informaPeriodo = InformaPeriodo.novaInstancia(this.getTopLevelAncestor(), this.codigoLabExterno);
            informaPeriodo.setSize(new Dimension(355, 300));
            informaPeriodo.setVisible(true);
            if (informaPeriodo.isOk()) {
                this.informa = informaPeriodo;
                this.importarResultado();
            }
        }
    }

    @Override
    protected void importarResultado() {
        if (this.textInformacoes != null) {
            this.setTextoInformacoes("\n", false);
        }
        this.setTextoInformacoes("Iniciando a importa\u00e7\u00e3o...", true);
        this.processaResultadosPorPeriodo();
        this.processaResultadoPorRequisicao();
        this.processaResultadoPorLote();
        this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
        this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada!", false);
    }

    private void processaResultadosPorPeriodo() {
        if (this.informa.filtroPeriodoSelecionado()) {
            String horaFinal;
            String dataInicial = Funcoes.formataData("yyyy-MM-dd", this.informa.getDataInicial());
            String dataFinal = Funcoes.formataData("yyyy-MM-dd", this.informa.getDataFinal());
            String horaInicial = !Funcoes.textoVazio(this.informa.getHoraInicial()) ? this.informa.getHoraInicial() : "00:00";
            String string = horaFinal = !Funcoes.textoVazio(this.informa.getHoraFinal()) ? this.informa.getHoraFinal() : "23:59";
            if (this.retornoValido(dataInicial, dataFinal, horaInicial, horaFinal, "")) {
                this.setTextoInformacoes("\nSolicitando os resultados do Per\u00edodo informado...", false);
                this.processaResultados();
            }
        }
    }

    private void processaResultadoPorRequisicao() {
        String codPedido;
        if (this.informa.filtroRequisicaoSelecionado() && this.retornoValido("", "", "", "", codPedido = Funcoes.preencheZero(this.informa.getFiltroFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(this.informa.getFiltroRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()))) {
            this.processaResultados();
        }
    }

    private void processaResultadoPorLote() {
        if (this.informa.filtroLoteSelecionado()) {
            List<LoteExternoRequisicaoVO> requisicoesLote = this.dao.pesquisarRequisicoesPorLote(this.informa.getFiltroLote(), this.codigoLabExterno);
            for (LoteExternoRequisicaoVO req : requisicoesLote) {
                String codPedido = Funcoes.preencheZero(req.getFilialVO().getCodigo(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req.getRequisicaoVO().getCodigo(), ParametrosGerais.getDigitosTuboRequisicao());
                if (!this.retornoValido("", "", "", "", codPedido)) continue;
                this.processaResultados();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processaResultados() {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            this.processarRetorno(st, st2);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoShift");
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
    }

    private String construirMensagemPadraoImportacao(Registro registroExame) {
        if (this.exameDesmembrado(registroExame)) {
            return String.format("%nImportando (%s) %s da Requisi\u00e7\u00e3o %s", registroExame.getString("examePai"), registroExame.getString("exa_codigo"), registroExame.getString("req_codigo"));
        }
        return String.format("%nImportando %s da Requisi\u00e7\u00e3o %s", registroExame.getString("exa_codigo"), registroExame.getString("req_codigo"));
    }

    private void processarRetorno(Statement st, Statement st2) throws Exception {
        this.requisicoesEnvioNotificacao = new HashMap<String, String>();
        List<RespostaShiftResultadoLab> resultadosShift = this.converterResultadosLabParaResultadosShift();
        for (RespostaShiftResultadoLab resultadoShift : resultadosShift) {
            this.setTextoInformacoes(String.format("%n%nSolicitando resultados da Requisi\u00e7\u00e3o %s", resultadoShift.getOrdemServico()), false);
            int qtdeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
            if (resultadoShift.getOrdemServico().length() < qtdeDigitos || resultadoShift.getOrdemServico().length() > qtdeDigitos) {
                this.setTextoInformacoes(String.format("%nRequisi\u00e7\u00e3o n\u00e3o encontrada: %s", resultadoShift.getOrdemServico()), false);
                continue;
            }
            String codigoForaPadrao = resultadoShift.getOrdemServico().substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String codFilial = StringUtil.removeZerosEsquerda(resultadoShift.getOrdemServico().substring(0, ParametrosGerais.getDigitosTuboFilial()));
            String codRequisicao = StringUtil.removeZerosEsquerda(codigoForaPadrao);
            this.processarExames(st, st2, resultadoShift, codFilial, codRequisicao);
        }
        this.enviarNotificacoes(this.requisicoesEnvioNotificacao);
    }

    private void processarExames(Statement st, Statement st2, RespostaShiftResultadoLab resultadoShift, String codFilial, String codRequisicao) throws Exception {
        Registro confAutomatica = this.dao.pesquisarDadosConferenciaAutomatica(this.codigoLabExterno);
        boolean conferirAutomatico = confAutomatica.getBoolean(CONFERIR_AUTOMATICO);
        String codigoUsuarioConferenciaAutomatica = confAutomatica.getString(COD_USUARIO_CONFERENCIA_AUTOMATICA);
        for (RespostaShiftExame exameShift : resultadoShift.getExames()) {
            LinkedList<Registro> listaRegistros = this.processarPaiFilhos(resultadoShift, exameShift);
            for (Registro registroExame : listaRegistros) {
                this.setTextoInformacoes(this.construirMensagemPadraoImportacao(registroExame), false);
                if (this.pararImportacaoExame(resultadoShift, codFilial, codRequisicao, exameShift, registroExame)) {
                    this.requisicoesNotificar.put(Funcoes.getChaveFilReq(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo")), registroExame.getString("req_codigo"));
                    continue;
                }
                String codigoExame = registroExame.nulo("examePai") ? registroExame.getString("exa_codigo") : registroExame.getString("examePai");
                ExameUtil.pegaLayoutIdade(registroExame.getString("fil_codigo"), registroExame.getInt("req_idade"), registroExame.getString("req_anomes"), registroExame.getString("codigo-layout"), codigoExame, registroExame.getInt("mco_codigo"), registroExame.getInt("met_codigo"), "elm_formato", registroExame);
                Registro formatacao = this.formatoPadraoExame(registroExame);
                if (formatacao == null || Funcoes.textoVazio(formatacao.getString("formato"))) {
                    this.setTextoInformacoes(this.construirMensagemErro("Laudo N\u00e3o encontrado"), false);
                    continue;
                }
                int situacaoFormato = this.validaSituacaoVersaoCorreta(formatacao, registroExame, resultadoShift.getExames());
                if (situacaoFormato == 1) {
                    this.setTextoInformacoes(this.construirMensagemErro("Vers\u00e3o incorreta"), false);
                    continue;
                }
                if (situacaoFormato == 2) {
                    this.setTextoInformacoes(this.construirMensagemErro("N\u00e3o localizado modelo para importa\u00e7\u00e3o"), false);
                    continue;
                }
                Registro exameSalvo = ParserImportacaoShift.getExame(registroExame.getString("ele_xmllabexterno"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"));
                Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), registroExame.getString("fil_codigo"), false, false);
                dados.put("codigo", exameSalvo.getString("codigo"));
                dados.put("descricao", exameSalvo.getString("descricao"));
                String resultadoAtual = this.processaResultadoAtual(exameShift, registroExame, dados, this.getVersaoExameLabExterno(formatacao.getString("formato")));
                dados.putAll(RecepcaoUtil.preencheHashDados(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo")));
                Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(registroExame.getString("exa_codigo"), registroExame.getString("fil_codigo"));
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = ExameUtil.getHistoricos(null, registroExame.getString("fil_codigo"));
                }
                Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("pac_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), registroExame.getString("met_codigo"));
                Map<String, Object> resposta = Resultado.getCamposResultado(registroExame.getString("exr_resposta"));
                Resultado res = new Resultado(null, formatacao.getString("formato"), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, resultadoAtual);
                res.atualizarComponentes();
                if (!res.verificarCondicao()) {
                    this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameShift, AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA);
                    this.setTextoInformacoes(this.construirMensagemErro("O resultado n\u00e3o ser\u00e1 CONFERIDO por n\u00e3o atendeer \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame!"), false);
                    continue;
                }
                boolean completo = true;
                if (registroExame.getBoolean("exa_salvaparcial")) {
                    completo = res.resultadoCompleto(true);
                }
                Util.gravaAlteracaoExameRequisicao(st, registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"));
                boolean marcarConferido = false;
                conferirAutomatico = confAutomatica.getBoolean(CONFERIR_AUTOMATICO);
                codigoUsuarioConferenciaAutomatica = confAutomatica.getString(COD_USUARIO_CONFERENCIA_AUTOMATICA);
                if (conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica) && completo) {
                    int verificacao = res.verificarValidacao();
                    boolean bl = marcarConferido = verificacao == 1;
                    if (!marcarConferido && verificacao != 2) {
                        this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameShift, AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA);
                        this.setTextoInformacoes(this.construirMensagemErro("O resultado n\u00e3o ser\u00e1 CONFERIDO por n\u00e3o atendeer \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame!"), false);
                        continue;
                    }
                }
                if (!this.existeRequisicaoLabExterno(registroExame.getInt("fil_codigo"), this.codigoLabExterno, registroExame.getInt("req_codigo"), resultadoShift.getOrdemServicoApoio())) {
                    this.inserirDadosRequisicao(st, this.codigoLabExterno, resultadoShift.getOrdemServicoApoio(), registroExame.getString("fil_codigo"), registroExame.getInt("req_codigo"));
                }
                if (!registroExame.nulo("examePai")) {
                    registroExame.setValor("exa_codigo", registroExame.getString("examePai"));
                }
                String novaSituacao = completo ? "L" : "P";
                String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), registroExame, registroExame, marcarConferido, codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameShift, this.verificaStatus(completo, marcarConferido));
                if (completo) {
                    Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                    Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                    this.atualizarTabelaExamesControle(st, registroExame, res.getResultadoAnterior(dataColeta, horaColeta));
                    this.processaExportarParaWeb(st, st2, registroExame, formatacao, novaSituacao, resultado);
                }
                this.editarRequisicaoExportaFiliais(registroExame);
                DBUtil.setExameSituacaoInterfaceamento(st, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), 8);
                String filialRequisicao = registroExame.getString("fil_codigo") + "-" + registroExame.getString("req_codigo");
                this.requisicoesEnvioNotificacao.put(filialRequisicao, registroExame.getString("req_codigo"));
                this.setTextoInformacoes(" - " + this.verificaStatus((boolean)completo, (boolean)marcarConferido).descricao, false);
                this.requisicoesNotificar.put(Funcoes.getChaveFilReq(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo")), registroExame.getString("req_codigo"));
            }
        }
        ResultadosUtil.enviarNotificacoes(this.requisicoesNotificar, conferirAutomatico, codigoUsuarioConferenciaAutomatica);
    }

    private boolean pararImportacaoExame(RespostaShiftResultadoLab resultadoShift, String codFilial, String codRequisicao, RespostaShiftExame exameShift, Registro registroExame) throws NoSuchAlgorithmException, IOException {
        return this.resultadoLancado(registroExame, codFilial, codRequisicao, exameShift) || this.resultadoImportadoEmPDF(registroExame, exameShift, resultadoShift, exameShift.getResutadoPDF()) || this.possuiErro(registroExame, codFilial, codRequisicao, exameShift);
    }

    private boolean mesmaVersao(String formato, Registro registroExame) {
        String versao = this.getVersaoExameLabExterno(formato);
        return !Funcoes.textoVazio(registroExame.getString("codigo_versao")) && versao.contains(registroExame.getString("codigo_versao")) || versao.equals("0");
    }

    private String getVersaoExameLabExterno(String formato) {
        return StringUtil.getValor(StringUtil.getValor(formato, "exame"), "versaoExameLabExterno");
    }

    private LinkedList<Registro> processarPaiFilhos(RespostaShiftResultadoLab resultadoShift, RespostaShiftExame exameShift) throws NumberFormatException, SQLException {
        Integer[] integerArray;
        boolean agruparMultiguias;
        LinkedList<Registro> listaRetorno = new LinkedList<Registro>();
        String codFilial = StringUtil.removeZerosEsquerda(resultadoShift.getOrdemServico().substring(0, ParametrosGerais.getDigitosTuboFilial()));
        String codigoForaPadrao = resultadoShift.getOrdemServico().substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String codRequisicao = StringUtil.removeZerosEsquerda(codigoForaPadrao);
        Integer[] multiguias = null;
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.lab.agruparMultiguias;
        if (agruparMultiguias) {
            integerArray = RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true);
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = Integer.parseInt(codRequisicao);
        }
        for (Integer multiguia : multiguias = integerArray) {
            Registro exameSeparado = this.dao.localizarExameRequisicao(codFilial, multiguia.toString(), exameShift);
            if (exameSeparado != null) {
                listaRetorno.add(exameSeparado);
                this.listaFilial.add(codFilial);
                this.listaRequisicao.add(codRequisicao);
            }
            if (!this.dao.buscarDadosExameAssociado(codFilial, multiguia.toString(), exameShift)) continue;
            List<ExameDesmembrado> listaExamesPai = this.dao.pesquisarExamesDesmembrados(codFilial, multiguia.toString(), String.valueOf(this.codigoLabExterno), exameShift.getExaCodigo(), exameShift.getMcoCodigo());
            for (ExameDesmembrado pai : listaExamesPai) {
                String codigoJalisTemp = exameShift.getExaCodigo();
                exameShift.setExaCodigo(pai.getCodigoExame());
                exameShift.setMcoCodigo(String.valueOf(pai.getCodigomaterial()));
                Registro reg = this.dao.localizarExameRequisicao(codFilial, multiguia.toString(), exameShift);
                if (reg == null) continue;
                reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                reg.setValor("xmllabexternopai", pai.getXmlLabExterno());
                reg.setValor("examePai", pai.getCodigoExame());
                reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                exameShift.setExaCodigo(codigoJalisTemp);
                listaRetorno.add(reg);
                this.listaFilial.add(codFilial);
                this.listaRequisicao.add(codRequisicao);
            }
        }
        if (listaRetorno.isEmpty()) {
            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o encontrada", false);
            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameShift, AbstractImportadorResultadoLabExterno.Situacao.NAO_LOCALIZADO);
        }
        return listaRetorno;
    }

    private void processaExportarParaWeb(Statement st, Statement st2, Registro registro, Registro formatacao, String novaSituacao, String resultado) throws Exception {
        if (this.exportarBaseWeb(registro.getString("fil_codigo"))) {
            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, registro.getString("fil_codigo"), registro.getString("req_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo"), resultado, false);
            this.exportarParaWeb(st, this.getCodigoBaseWeb(registro.getString("fil_codigo")), novaSituacao, registro, mapa, resultado, formatacao.getString("formatotexto"));
            if (ExportaWeb.isGerarPdfResultado(st2, registro.getString("fil_codigo"))) {
                ExportaWeb.enviarResultadoPDF(st2, registro.getString("fil_codigo"), registro.getString("req_codigo"), this.getCodigoBaseWeb(registro.getString("fil_codigo")));
            }
            ExportaWeb.atualizaPaginaOrdemExameWeb(st2, registro.getString("fil_codigo"), registro.getString("req_codigo"), Variaveis.codigoBaseWeb);
        }
    }

    private String processaResultadoAtual(RespostaShiftExame exameShift, Registro registro, Map<String, Object> dados, String versao) throws ParseException {
        String resultadoAtual = "";
        for (RespostaShiftResultado resultado : exameShift.getResultados()) {
            String exaJalis = registro.getString("examePai");
            if (Funcoes.textoVazio(exaJalis)) {
                resultadoAtual = this.gerarResultadoAtual(exameShift, resultado, dados, false, resultadoAtual, null);
                continue;
            }
            resultadoAtual = this.gerarResultadoAtual(exameShift, resultado, dados, true, resultadoAtual, versao);
        }
        return resultadoAtual;
    }

    private boolean resultadoLancado(Registro registro, String codFilial, String codRequisicao, RespostaShiftExame exameShift) {
        if (this.exameLancado(registro)) {
            this.setTextoInformacoes(String.format("%nExame %s J\u00e1 %s", exameShift.getExaCodigo(), Tipos.tipoSituacaoExame(registro.getString("exr_situacao"))), false);
            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameShift, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO);
            return true;
        }
        return false;
    }

    private boolean possuiErro(Registro registro, String codFilial, String codRequisicao, RespostaShiftExame exameShift) {
        if (registro == null) {
            return true;
        }
        if (!this.exameColetado(registro) && !registro.getString("exr_situacao").equals("P")) {
            this.setTextoInformacoes(this.construirMensagemErro("Material " + registro.getString("mco_codigo") + " n\u00e3o localizado na Requisi\u00e7\u00e3o"), false);
            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameShift, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL);
            return true;
        }
        if (!this.dao.exameRelacionado(registro, this.codigoLabExterno)) {
            this.setTextoInformacoes(this.construirMensagemErro("Exame sem relacionamento"), false);
            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameShift, AbstractImportadorResultadoLabExterno.Situacao.SEM_RELACIONAMENTO);
            return true;
        }
        return false;
    }

    private AbstractImportadorResultadoLabExterno.Situacao verificaStatus(boolean completo, boolean marcarConferido) {
        return completo ? this.marcarConferido(marcarConferido) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE;
    }

    private AbstractImportadorResultadoLabExterno.Situacao marcarConferido(boolean marcarConferido) {
        return marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO;
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude 784");
        }
    }

    private String construirMensagemErro(String erro) {
        return String.format(" - %s", erro);
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && (Funcoes.textoVazio(reg.getString("exr_situacao")) || reg.getString("exr_situacao").equals("P"));
    }

    private List<RespostaShiftResultadoLab> converterResultadosLabParaResultadosShift() {
        ArrayList<RespostaShiftResultadoLab> resultadosLabShift = new ArrayList<RespostaShiftResultadoLab>();
        List<String> resultadosLabRetorno = StringUtil.getListValores(this.retorno, ShiftCampos.RESULTADO_LAB.getTag());
        for (String resultado : resultadosLabRetorno) {
            RespostaShiftResultadoLab resultadoLabShift = new RespostaShiftResultadoLab();
            resultadoLabShift.setOrdemServico(StringUtil.getValor(resultado, ShiftCampos.ORDEM_SERVICO.getTag()));
            resultadoLabShift.setOrdemServicoApoio(StringUtil.getValor(resultado, ShiftCampos.ORDEM_SERVICO_APOIO.getTag()));
            resultadoLabShift.setExames(this.converterExamesRetornoParaExamesShift(resultado));
            resultadosLabShift.add(resultadoLabShift);
        }
        return resultadosLabShift;
    }

    private List<RespostaShiftExame> converterExamesRetornoParaExamesShift(String resultadoShift) {
        ArrayList<RespostaShiftExame> exames = new ArrayList<RespostaShiftExame>();
        List<String> examesRetorno = StringUtil.getListValores(resultadoShift, ShiftCampos.EXAME.getTag());
        for (String exameResultado : examesRetorno) {
            RespostaShiftExame exameShift = new RespostaShiftExame();
            exameShift.setCodigoApoio(StringUtil.getValor(exameResultado, ShiftCampos.EXA_CODIGO_APOIO.getTag()));
            exameShift.setCodigoLISOrigem(StringUtil.getValor(exameResultado, ShiftCampos.EXA_CODIGO_LIS_ORIGEM.getTag()));
            exameShift.setDescMaterial(StringUtil.getValor(exameResultado, ShiftCampos.EXA_DESC_MATERIAL.getTag()));
            exameShift.setVersao(StringUtil.getValor(exameResultado, ShiftCampos.VERSAO.getTag()));
            exameShift.setDescricao(StringUtil.getValor(exameResultado, ShiftCampos.EXA_DESCRICAO.getTag()));
            exameShift.setResutadoPDF(StringUtil.getValor(exameResultado, ShiftCampos.RESULTADO_PDF.getTag()));
            exameShift.setResultados(this.converterResultadosExameParaResultadosShift(exameResultado));
            String liberacao = StringUtil.getValor(exameResultado, ShiftCampos.LIBERACAO.getTag());
            exameShift.setLiberacaoData(StringUtil.getValor(liberacao, ShiftCampos.LIBERACAO_DATA.getTag()));
            exameShift.setLiberacaoHora(StringUtil.getValor(liberacao, ShiftCampos.LIBERACAO_HORA.getTag()));
            exameShift.setLiberacaoNomeResponsavel(StringUtil.getValor(liberacao, ShiftCampos.LIBERACAO_NOME_RESPONSAVEL.getTag()));
            exames.add(exameShift);
        }
        return exames;
    }

    private List<RespostaShiftResultado> converterResultadosExameParaResultadosShift(String exameResultado) {
        ArrayList<RespostaShiftResultado> resultados = new ArrayList<RespostaShiftResultado>();
        List<String> resultadosExamesRetorno = StringUtil.getListValores(exameResultado, ShiftCampos.RESULTADO.getTag());
        for (String resultado : resultadosExamesRetorno) {
            RespostaShiftResultado resultadoShift = new RespostaShiftResultado();
            resultadoShift.setApelido(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_APELIDO.getTag()));
            resultadoShift.setCulturaPositiva(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_CULTURA_POSITIVA.getTag()));
            resultadoShift.setMetodologia(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_METODOLOGIA.getTag()));
            resultadoShift.setNotaLaudo(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_NOTA_LAUDO.getTag()));
            resultadoShift.setTsaRealizado(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_TSA_REALIZADO.getTag()));
            resultadoShift.setUnidadeMedida(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_UNIDADE_MEDIDA.getTag()));
            resultadoShift.setValor(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_VALOR.getTag()));
            resultadoShift.setValorReferencia(StringUtil.getValor(resultado, ShiftCampos.RESULTADO_VALOR_REFERENCIA.getTag()));
            resultados.add(resultadoShift);
        }
        return resultados;
    }

    private String gerarResultadoAtual(RespostaShiftExame exameShift, RespostaShiftResultado resultado, Map<String, Object> dados, boolean isDesmembrado, String resultadoAtual, String versaoDesm) throws ParseException {
        String valorResultado = resultado.getValor();
        String apelido = resultado.getApelido();
        String versoes = Funcoes.textoVazio(versaoDesm) ? exameShift.getVersao() : versaoDesm;
        for (String versao : versoes.split(",")) {
            dados.put(this.padronizarVersao(versao, apelido), valorResultado);
            SimpleDateFormat formatoOriginal = new SimpleDateFormat("yyyy-MM-dd");
            String dataLiberacao = isDesmembrado ? this.padronizarCampoDesmembrado(ShiftCampos.LIBERACAO_DATA.getTag(), exameShift) : ShiftCampos.LIBERACAO_DATA.getTag();
            dados.put(this.padronizarVersao(versao, dataLiberacao), Funcoes.formataData("dd/MM/yyyy", formatoOriginal.parse(exameShift.getLiberacaoData())));
            String horaLiberacao = isDesmembrado ? this.padronizarCampoDesmembrado(ShiftCampos.LIBERACAO_HORA.getTag(), exameShift) : ShiftCampos.LIBERACAO_HORA.getTag();
            dados.put(this.padronizarVersao(versao, horaLiberacao), exameShift.getLiberacaoHora());
            String responsavelLiberacao = isDesmembrado ? this.padronizarCampoDesmembrado(ShiftCampos.LIBERACAO_NOME_RESPONSAVEL.getTag(), exameShift) : ShiftCampos.LIBERACAO_NOME_RESPONSAVEL.getTag();
            dados.put(this.padronizarVersao(versao, responsavelLiberacao), exameShift.getLiberacaoNomeResponsavel());
            String metodologia = this.padronizarCampo(versao, ShiftCampos.RESULTADO_METODOLOGIA.getTag(), apelido);
            metodologia = isDesmembrado ? this.padronizarCampoDesmembrado(metodologia, exameShift) : metodologia;
            dados.put(metodologia, resultado.getMetodologia());
            String unidadeMedida = this.padronizarCampo(versao, ShiftCampos.RESULTADO_UNIDADE_MEDIDA.getTag(), apelido);
            unidadeMedida = isDesmembrado ? this.padronizarCampoDesmembrado(unidadeMedida, exameShift) : unidadeMedida;
            dados.put(unidadeMedida, resultado.getUnidadeMedida());
            String valorReferencia = this.padronizarCampo(versao, ShiftCampos.RESULTADO_VALOR_REFERENCIA.getTag(), apelido);
            valorReferencia = isDesmembrado ? this.padronizarCampoDesmembrado(valorReferencia, exameShift) : valorReferencia;
            dados.put(valorReferencia, resultado.getValorReferencia());
            if (!Funcoes.textoVazio(resultado.getCulturaPositiva())) {
                String culturaPositiva = this.padronizarCampo(versao, ShiftCampos.RESULTADO_CULTURA_POSITIVA.getTag(), apelido);
                culturaPositiva = isDesmembrado ? this.padronizarCampoDesmembrado(culturaPositiva, exameShift) : culturaPositiva;
                dados.put(culturaPositiva, resultado.getCulturaPositiva());
            }
            if (!Funcoes.textoVazio(resultado.getTsaRealizado())) {
                String tsaRealizado = this.padronizarCampo(versao, ShiftCampos.RESULTADO_TSA_REALIZADO.getTag(), apelido);
                tsaRealizado = isDesmembrado ? this.padronizarCampoDesmembrado(tsaRealizado, exameShift) : tsaRealizado;
                dados.put(tsaRealizado, resultado.getTsaRealizado());
            }
            if (!Funcoes.textoVazio(resultado.getNotaLaudo())) {
                String notaLaudo = this.padronizarCampo(versao, ShiftCampos.RESULTADO_NOTA_LAUDO.getTag(), apelido);
                notaLaudo = isDesmembrado ? this.padronizarCampoDesmembrado(notaLaudo, exameShift) : notaLaudo;
                dados.put(notaLaudo, resultado.getNotaLaudo().replace(">", ""));
            }
            resultadoAtual = this.getXmlResultadoAtual(exameShift, resultadoAtual, valorResultado);
            this.adicionaValorExameDesmembrado(dados, resultado, exameShift, isDesmembrado, versao);
        }
        return resultadoAtual;
    }

    private String padronizarVersao(String versao, String campo) {
        return String.format("~%s|%s", versao.trim(), campo);
    }

    private String padronizarCampo(String versao, String campo, String apelido) {
        return this.padronizarVersao(versao, String.format("%s_%s", campo, apelido));
    }

    private String padronizarCampoDesmembrado(String campo, RespostaShiftExame exameShift) {
        return String.format("%s@%s#%s", campo, exameShift.getExaCodigo(), exameShift.getMcoCodigo());
    }

    private String getXmlResultadoAtual(RespostaShiftExame exameShift, String resultadoAtual, String linhaResultado) {
        String tag = exameShift.getExaCodigo();
        tag = tag.toLowerCase();
        resultadoAtual = resultadoAtual + "<" + tag + ">";
        resultadoAtual = resultadoAtual + linhaResultado;
        resultadoAtual = resultadoAtual + "</" + tag + ">";
        return resultadoAtual;
    }

    private void adicionaValorExameDesmembrado(Map<String, Object> dados, RespostaShiftResultado resultado, RespostaShiftExame exameShift, boolean isDesmembrado, String versao) {
        if (isDesmembrado) {
            String chaveResultado = this.padronizarVersao(versao, this.padronizarCampoDesmembrado(resultado.getApelido(), exameShift));
            dados.put(chaveResultado, resultado.getValor());
        }
    }

    private boolean retornoValido(String dataInicial, String dataFinal, String horaInicial, String horaFinal, String codPedido) {
        this.geraXmlConsultaResutados(dataInicial, dataFinal, horaInicial, horaFinal, codPedido);
        ComunicacaoShift comunicacao = new ComunicacaoShift(this.webService);
        try {
            CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)comunicacao.construirSSL()).build();
            HttpUriRequest request = comunicacao.request(this.xml, "http://www.shift.com.br/shift.bs.WSApoio.ExportaResultados");
            CloseableHttpResponse response = client.execute(request);
            if (comunicacao.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                this.retorno = EntityUtils.toString((HttpEntity)entity);
            }
            this.retorno = StringUtil.xmlToTexto(this.retorno).replace("&nbsp;", " ");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void geraXmlConsultaResutados(String dataInicial, String dataFinal, String horaInicial, String horaFinal, String codPedido) {
        XMLStringBuilder xmlBuilder = new XMLStringBuilder(true);
        try {
            xmlBuilder.abrir(CamposXmlConsultaShift.EXPORTARESULTADO.getTag());
            xmlBuilder.escrever(CamposXmlConsultaShift.IDLABORATORIO.getTag(), this.idLaboratorio);
            xmlBuilder.escrever(CamposXmlConsultaShift.SENHA.getTag(), this.senha);
            xmlBuilder.escrever(CamposXmlConsultaShift.DATAINICIAL.getTag(), dataInicial);
            xmlBuilder.escrever(CamposXmlConsultaShift.DATAFINAL.getTag(), dataFinal);
            xmlBuilder.escrever(CamposXmlConsultaShift.HORAINICIAL.getTag(), horaInicial);
            xmlBuilder.escrever(CamposXmlConsultaShift.HORAFINAL.getTag(), horaFinal);
            xmlBuilder.escrever(CamposXmlConsultaShift.CODPEDIDO.getTag(), codPedido);
            xmlBuilder.escrever(CamposXmlConsultaShift.CODAMOSTRA.getTag(), "");
            xmlBuilder.fechar(CamposXmlConsultaShift.EXPORTARESULTADO.getTag());
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
        }
        this.xml = this.geraHeaderXml(xmlBuilder.toString());
    }

    private String geraHeaderXml(String xml) {
        StringBuilder header = new StringBuilder();
        header.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:shif=\"http://www.shift.com.br\">");
        header.append("<soapenv:Body>");
        header.append(xml);
        header.append("</soapenv:Body>");
        header.append("</soapenv:Envelope>");
        return header.toString();
    }

    private void adicionarAoModeloRelatorio(String codFilial, String codRequisicao, RespostaShiftExame exameShift, AbstractImportadorResultadoLabExterno.Situacao situacao) {
        String exa = exameShift.getExaCodigo();
        String mco = exameShift.getMcoCodigo();
        if (!Funcoes.textoVazio(exa) && !Funcoes.textoVazio(mco)) {
            String exames = "";
            Statement st = Conexao.getStatement();
            try {
                ExameDesmembrado pai;
                exames = BDUtil.getCodigoExames(codFilial, codRequisicao, st);
                if (!Funcoes.textoVazio(exames) && !exames.contains(exa) && (pai = this.getExamesDesmembrados(codFilial, codRequisicao, String.valueOf(this.codigoLabExterno), exa, mco)) != null) {
                    exa = pai.getCodigoExame();
                    mco = String.valueOf(pai.getCodigomaterial());
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoShift");
            }
        }
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, codFilial, codRequisicao, exa, Integer.parseInt(mco), situacao.descricao);
    }

    private boolean resultadoImportadoEmPDF(Registro reg, RespostaShiftExame resultadoShift, RespostaShiftResultadoLab resultadosPDF, String resultadoPDF) throws NoSuchAlgorithmException, IOException {
        boolean importouPDF = false;
        if (reg != null) {
            Registro confAutomatica = this.dao.pesquisarDadosConferenciaAutomatica(this.codigoLabExterno);
            String codigoUsuarioConferenciaAutomatica = confAutomatica.getString(COD_USUARIO_CONFERENCIA_AUTOMATICA);
            boolean conferido = confAutomatica.getBoolean(CONFERIR_AUTOMATICO) && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica);
            ComunicacaoShift comunicacao = new ComunicacaoShift();
            if (this.importaEmPDF(reg)) {
                importouPDF = this.exameDesmembrado(reg) ? this.importaDesmembrado(reg, resultadoShift, resultadosPDF, importouPDF, codigoUsuarioConferenciaAutomatica, conferido, comunicacao) : this.importaExame(reg, resultadoShift, resultadoPDF, importouPDF, codigoUsuarioConferenciaAutomatica, conferido, comunicacao);
            }
        }
        return importouPDF;
    }

    private boolean importaExame(Registro reg, RespostaShiftExame resultadoShift, String resultadoPDF, boolean importouPDF, String codigoUsuarioConferenciaAutomatica, boolean conferido, ComunicacaoShift comunicacao) throws IOException, NoSuchAlgorithmException {
        ConfiguracaoExameShiftVO exame = ConfiguracaoExameShiftVO.fromRegistro(reg);
        String resultadoPDFBase64 = comunicacao.baixarResultadoPDF(resultadoPDF);
        if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() > 1000) {
            this.dao.salvarResultadoPDF(exame, resultadoPDFBase64, conferido, codigoUsuarioConferenciaAutomatica);
            this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", exame.getCodigoFilial(), exame.getCodigoRequisicao(), exame.getCodigoExame()), false);
            this.adicionarAoModeloRelatorio(exame.getCodigoFilial(), exame.getCodigoRequisicao(), resultadoShift, conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO);
            importouPDF = true;
        } else if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() < 1000) {
            this.setTextoInformacoes(String.format("%nFalha na importa\u00e7\u00e3o do exame %s em PDF - motivo: %s", exame.getCodigoExame(), resultadoPDFBase64), false);
        }
        return importouPDF;
    }

    private boolean importaDesmembrado(Registro reg, RespostaShiftExame resultadoShift, RespostaShiftResultadoLab resultadosPDF, boolean importouPDF, String codigoUsuarioConferenciaAutomatica, boolean conferido, ComunicacaoShift comunicacao) throws IOException, NoSuchAlgorithmException {
        byte[] resultadosDesmembrados = null;
        List<ConfiguracaoExameShiftVO> desmembrados = this.dao.pesquisarExamesDesmembradosNoLote(reg);
        int resultadosRecebidos = 0;
        for (ConfiguracaoExameShiftVO desm : desmembrados) {
            String resultadoPDFBase64 = "";
            for (RespostaShiftExame pdf : resultadosPDF.getExames()) {
                if (!desm.getCodigoExame().equals(pdf.getExaCodigo())) continue;
                resultadoPDFBase64 = comunicacao.baixarResultadoPDF(pdf.getResutadoPDF());
            }
            if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() > 1000) {
                byte[] resultadoEmBytes = Base64.decodeBase64((String)resultadoPDFBase64);
                resultadosDesmembrados = ResultadosUtil.concatenarPdfs(resultadosDesmembrados, resultadoEmBytes, "Resultado");
                ++resultadosRecebidos;
                continue;
            }
            if (Funcoes.textoVazio(resultadoPDFBase64) || resultadoPDFBase64.length() >= 1000) continue;
            this.setTextoInformacoes(String.format("%nFalha na import\u00e7\u00e3o do exame %s desmembrado em PDF - motivo: %s", desm.getCodigoExame(), resultadoPDFBase64), false);
        }
        if (resultadosRecebidos == desmembrados.size()) {
            Base64 base64 = new Base64();
            String resultadoDesmembradosBase64 = base64.encodeAsString(resultadosDesmembrados);
            ConfiguracaoExameShiftVO examePai = ConfiguracaoExameShiftVO.fromRegistro(reg);
            examePai.setCodigoExame(reg.getString("examePai"));
            this.dao.salvarResultadoPDF(examePai, resultadoDesmembradosBase64, conferido, codigoUsuarioConferenciaAutomatica);
            this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", examePai.getCodigoFilial(), examePai.getCodigoRequisicao(), reg.getString("exameFilho")), false);
            this.adicionarAoModeloRelatorio(examePai.getCodigoFilial(), examePai.getCodigoRequisicao(), resultadoShift, conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO);
            importouPDF = true;
        }
        return importouPDF;
    }

    private Registro formatoPadraoExame(Registro registroExame) {
        Registro formato = new Registro();
        formato.setValor("formato", registroExame.getValor("formatoPadrao"));
        formato.setValor("met_codigo", registroExame.getValor("met_codigo"));
        boolean salvoParcial = registroExame.getString("exr_situacao").equals("P");
        return salvoParcial ? (Registro)registroExame.getValor(FORMATACAO) : formato;
    }

    private boolean importaEmPDF(Registro reg) {
        String nomeColuna = this.exameDesmembrado(reg) ? "xmllabexternopai" : "ele_xmllabexterno";
        return reg.getString(nomeColuna).contains("<formato_pdf>SIM</formato_pdf>") || reg.getString("lae_configuracao").contains("<importarResultadoPdf>true</importarResultadoPdf>");
    }

    private boolean exameDesmembrado(Registro reg) {
        return !Funcoes.textoVazio(reg.getString("examePai")) && !reg.getString("examePai").equals(reg.getString("exa_codigo"));
    }

    private int validaSituacaoVersaoCorreta(Registro formatacao, Registro registroExame, List<RespostaShiftExame> exameShift) {
        boolean mesmaVersao = false;
        if (Funcoes.textoVazio(formatacao.getString("formato"))) {
            return 2;
        }
        mesmaVersao = registroExame.nulo("examePai") ? this.mesmaVersao(formatacao.getString("formato"), registroExame) : this.possuiTodosCamposDesm(formatacao, exameShift);
        if (!mesmaVersao) {
            return 1;
        }
        return 0;
    }

    private boolean possuiTodosCamposDesm(Registro formatacao, List<RespostaShiftExame> exameShift) {
        Set<String> camposModelo = this.buscaCamposModelo(formatacao);
        List<String> camposRespostaShift = this.buscaCampoRespostaShift(exameShift);
        return camposModelo.stream().filter(campo -> !camposRespostaShift.contains(campo)).collect(Collectors.toList()).isEmpty();
    }

    private List<String> buscaCampoRespostaShift(List<RespostaShiftExame> exameShift) {
        ArrayList<String> campoApelido = new ArrayList<String>();
        for (RespostaShiftExame rse : exameShift) {
            for (RespostaShiftResultado rsr : rse.getResultados()) {
                campoApelido.add(rsr.getApelido());
            }
        }
        return campoApelido;
    }

    private Set<String> buscaCamposModelo(Registro formatacao) {
        List<String> camposConfigurados = this.getCamposConfigurados(formatacao);
        camposConfigurados = camposConfigurados.stream().filter(campo -> campo.contains("|") && campo.contains("@")).collect(Collectors.toList());
        HashSet<String> campos = new HashSet<String>();
        for (String campo2 : camposConfigurados) {
            int index = campo2.contains("_") && this.contemCamposFixos(campo2) ? campo2.indexOf("_") : campo2.indexOf("|");
            String apelido = campo2.substring(index + 1, campo2.lastIndexOf("@"));
            if (Arrays.asList("data", "hora", "nomeResponsavel").contains(apelido)) continue;
            campos.add(apelido);
        }
        return campos;
    }

    private boolean contemCamposFixos(String campo) {
        List<String> campos = Arrays.asList("unidadeMedida", "valorReferencia", "metodologia", "culturaPositiva", "tsaRealizado", "notaLaudo");
        return campos.stream().anyMatch(campo::contains);
    }

    private List<String> getCamposConfigurados(Registro formatacao) {
        List<String> camposImportacao = StringUtil.getListValores(formatacao.getString("formato"), "campoImportacao");
        ArrayList<String> campos = new ArrayList<String>();
        for (String campo : camposImportacao) {
            if (Funcoes.textoVazio(campo) || !StringUtil.getValor(campo, "protocolo").equals(Protocolo.Shift.getDescricao())) continue;
            campos.add(StringUtil.getValor(campo, "campo"));
        }
        return campos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarNotificacoes(Map<String, String> hashMapFilialRequisicao) throws Exception {
        if (!hashMapFilialRequisicao.isEmpty() && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica)) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            String filial = "";
            String requisicao = "";
            try {
                for (Map.Entry<String, String> filReq : hashMapFilialRequisicao.entrySet()) {
                    String[] filialRequisicao = filReq.getKey().split("-");
                    if (filialRequisicao.length <= 1) continue;
                    filial = filialRequisicao[0];
                    requisicao = filialRequisicao[1];
                    this.criarLog(st, st2, filial, requisicao);
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private void criarLog(Statement st, Statement st2, String filial, String requisicao) throws Exception {
        if (!SMSUtil.isBloquearSMSExamePronto(filial, requisicao, st)) {
            SMSUtil.criaLogSmsComDadosRequisicao(filial, requisicao, ExportaSMS.TipoSMS.RESULTADO, st, st2);
        }
        if (!EmailUtil.isBloquearEmailExamePronto(filial, requisicao, st)) {
            EmailUtil.criaLogEmail(filial, requisicao, null, EmailUtil.TipoEmail.RESULTADO, true, st);
        }
        if (!PushUtil.isBloquearPushExamePronto(filial, requisicao, st)) {
            PushUtil.criaLogPushComDadosRequisicao(filial, requisicao, TipoPush.RESULTADO, st, st2);
        }
        if (!WhatsAppUtil.isBloquearWhatsappExamePronto(filial, requisicao, st)) {
            WhatsAppUtil.criaLogWhatsappComDadosRequisicao(filial, requisicao, TipoWhatsapp.RESULTADO, st, st2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    public static long getModuloAcesso() {
        return acesso;
    }
}

