/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.shift.CampoShift;
import jalis.laboratorio.util.parsers.shift.VersaoShift;
import jalis.laboratorio.util.parsers.shift.XmlShift;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExameShift {
    private static final String SIM = "SIM";
    private static final String NAO = "NAO";
    private static final String DATA_RESULTADO = "data";
    private static final String DATA_LIBERACAO = "Data da libera\u00e7\u00e3o do exame";
    private static final String HORA_RESULTADO = "hora";
    private static final String HORA_LIBERACAO = "Hora da libera\u00e7\u00e3o do exame";
    private static final String NOME_RESPONSAVEL = "nomeResponsavel";
    private static final String RESPONSAVEL_LIBERACAO = "Respons\u00e1vel pela libera\u00e7\u00e3o do exame";
    private String codigo;
    private String descricao;
    private String codigoMaterial;
    private String descricaoMaterial;
    private String recipiente;
    private String data;
    private Integer codLabExterno;
    private String xml;
    private boolean formatoPDF;
    private List<VersaoShift> versao;

    public ExameShift() {
        this.versao = new ArrayList<VersaoShift>();
    }

    public ExameShift(String xml) {
        this.parseXml(xml);
    }

    public String construirXml(boolean importarResultado) {
        XMLStringBuilder xmlBui = new XMLStringBuilder();
        try {
            xmlBui.abrir(XmlShift.SHIFT.getTag());
            xmlBui.abrir(XmlShift.EXAME.getTag());
            xmlBui.escrever(XmlShift.CODIGO.getTag(), this.codigo);
            xmlBui.escrever(XmlShift.DESCRICAO.getTag(), this.descricao);
            xmlBui.escrever(XmlShift.DESCRICAO_MATERIAL.getTag(), this.descricaoMaterial);
            xmlBui.escrever(XmlShift.RECIPIENTE.getTag(), this.recipiente);
            xmlBui.escrever(XmlShift.DATA.getTag(), this.data);
            if (!importarResultado) {
                xmlBui.escrever(XmlShift.FORMATO_PDF.getTag(), this.formatoPDF ? SIM : NAO);
            }
            xmlBui.abrir(XmlShift.RESULTADO.getTag());
            xmlBui.escrever(XmlShift.DATA.getTag(), DATA_RESULTADO);
            xmlBui.escrever(XmlShift.DESCRICAO_DATA.getTag(), DATA_LIBERACAO);
            xmlBui.escrever(XmlShift.HORA.getTag(), HORA_RESULTADO);
            xmlBui.escrever(XmlShift.DESCRICAO_HORA.getTag(), HORA_LIBERACAO);
            xmlBui.escrever(XmlShift.RESPONSAVEL.getTag(), NOME_RESPONSAVEL);
            xmlBui.escrever(XmlShift.DESCRICAO_RESPONSAVEL.getTag(), RESPONSAVEL_LIBERACAO);
            xmlBui.abrir(XmlShift.VERSOES.getTag());
            this.getXmlVersoes(xmlBui);
            xmlBui.fechar(XmlShift.VERSOES.getTag());
            xmlBui.fechar(XmlShift.RESULTADO.getTag());
            xmlBui.fechar(XmlShift.EXAME.getTag());
            xmlBui.fechar(XmlShift.SHIFT.getTag());
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoShift");
        }
        this.xml = xmlBui.getXML();
        return xmlBui.getXML();
    }

    private void getXmlVersoes(XMLStringBuilder xmlBui) throws XMLStringBuilderException {
        for (VersaoShift v : this.versao) {
            xmlBui.abrir(XmlShift.VERSAO.getTag());
            xmlBui.escrever(XmlShift.CODIGO_VERSAO.getTag(), v.getVersao().toString());
            this.getXmlCampos(xmlBui, v);
            xmlBui.fechar(XmlShift.VERSAO.getTag());
        }
    }

    private void getXmlCampos(XMLStringBuilder xmlBui, VersaoShift v) throws XMLStringBuilderException {
        for (CampoShift campo : v.getCampos()) {
            xmlBui.abrir(XmlShift.CAMPOS.getTag());
            xmlBui.escrever(XmlShift.APELIDO.getTag(), campo.getApelido());
            xmlBui.escrever(XmlShift.DESCRICAO_APELIDO.getTag(), campo.getDescricaoApelido());
            for (Map.Entry<String, String> cf : this.getCamposFixos().entrySet()) {
                xmlBui.abrir(XmlShift.CAMPO.getTag());
                xmlBui.escrever(XmlShift.CODIGO.getTag(), cf.getKey());
                xmlBui.escrever(XmlShift.DESCRICAO.getTag(), cf.getValue() + campo.getApelido());
                xmlBui.fechar(XmlShift.CAMPO.getTag());
            }
            xmlBui.fechar(XmlShift.CAMPOS.getTag());
        }
    }

    private Map<String, String> getCamposFixos() {
        HashMap<String, String> camposFixos = new HashMap<String, String>();
        camposFixos.put("unidadeMedida", "Unidade de medida ");
        camposFixos.put("valorReferencia", "Valor de refer\u00eancia ");
        camposFixos.put("metodologia", "Metodologia ");
        camposFixos.put("culturaPositiva", "Cultura positiva ");
        camposFixos.put("tsaRealizado", "TSA realizado ");
        camposFixos.put("notaLaudo", "Nota laudo ");
        return camposFixos;
    }

    private void parseXml(String xml) {
        if (xml != null) {
            String exame = StringUtil.getValor(xml, XmlShift.EXAME.getTag());
            this.codigo = StringUtil.getValor(exame, XmlShift.CODIGO.getTag());
            this.descricao = StringUtil.getValor(exame, XmlShift.DESCRICAO.getTag());
            this.descricaoMaterial = StringUtil.getValor(exame, XmlShift.DESCRICAO_MATERIAL.getTag());
            this.recipiente = StringUtil.getValor(exame, XmlShift.RECIPIENTE.getTag());
            this.data = StringUtil.getValor(exame, XmlShift.DATA.getTag());
            this.formatoPDF = StringUtil.getValor(exame, XmlShift.FORMATO_PDF.getTag()).equals(SIM);
            String xmlVersao = StringUtil.getValor(exame, XmlShift.VERSOES.getTag());
            ArrayList<VersaoShift> versoesShift = new ArrayList<VersaoShift>();
            for (int i = 0; i < StringUtil.getValores(xmlVersao, XmlShift.VERSAO.getTag()).length; ++i) {
                VersaoShift versaoShift = new VersaoShift();
                versaoShift.setVersao(Integer.valueOf(StringUtil.getValores(xmlVersao, XmlShift.CODIGO_VERSAO.getTag())[i]));
                String xmlCampo = StringUtil.getValores(xmlVersao, XmlShift.VERSAO.getTag())[i];
                ArrayList<CampoShift> camposShift = new ArrayList<CampoShift>();
                for (int j = 0; j < StringUtil.getValores(xmlCampo, XmlShift.CAMPOS.getTag()).length; ++j) {
                    CampoShift campoShift = new CampoShift();
                    campoShift.setApelido(StringUtil.getValores(xmlCampo, XmlShift.APELIDO.getTag())[j]);
                    campoShift.setDescricaoApelido(StringUtil.getValores(xmlCampo, XmlShift.DESCRICAO_APELIDO.getTag())[j]);
                    camposShift.add(campoShift);
                }
                versaoShift.setCampos(camposShift);
                versoesShift.add(versaoShift);
            }
            this.setVersao(versoesShift);
            this.construirXml(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ExameShift> getExames(int filial, int codigoLabExterno) {
        LinkedHashSet<ExameShift> exames = new LinkedHashSet<ExameShift>();
        String sql = "select shi_xml  from examesshift where fil_codigo = ? and lae_codigo = ? order by shi_codexame ";
        PreparedStatement prst = Conexao.getPreparedStatement(sql);
        try {
            prst.setInt(1, filial);
            prst.setInt(2, codigoLabExterno);
            try (ResultSet rs = null;){
                rs = prst.executeQuery();
                while (rs.next()) {
                    exames.add(new ExameShift(rs.getString("shi_xml")));
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameRede");
        }
        finally {
            try {
                prst.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return exames;
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorShift = StringUtil.getValor(xml, XmlShift.SHIFT.getTag());
        return valorShift != null && valorShift.trim().length() > 0 && (valorExame = StringUtil.getValor(valorShift, XmlShift.EXAME.getTag())) != null && valorExame.trim().length() > 0;
    }

    public int hashCode() {
        return Objects.hash(this.codLabExterno, this.codigo, this.codigoMaterial, this.data, this.descricao, this.descricaoMaterial, this.recipiente, this.versao);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExameShift other = (ExameShift)obj;
        return Objects.equals(this.codLabExterno, other.codLabExterno) && Objects.equals(this.codigo, other.codigo) && Objects.equals(this.codigoMaterial, other.codigoMaterial) && Objects.equals(this.data, other.data) && Objects.equals(this.descricao, other.descricao) && Objects.equals(this.descricaoMaterial, other.descricaoMaterial) && Objects.equals(this.recipiente, other.recipiente) && Objects.equals(this.versao, other.versao);
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo.trim();
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao.trim();
    }

    public String getCodigoMaterial() {
        return this.codigoMaterial;
    }

    public void setCodigoMaterial(String codigoMaterial) {
        this.codigoMaterial = codigoMaterial;
    }

    public String getDescricaoMaterial() {
        return this.descricaoMaterial;
    }

    public void setDescricaoMaterial(String descricaoMaterial) {
        this.descricaoMaterial = descricaoMaterial.trim();
    }

    public String getRecipiente() {
        return this.recipiente;
    }

    public void setRecipiente(String recipiente) {
        this.recipiente = recipiente.trim();
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data.trim();
    }

    public Integer getCodLabExterno() {
        return this.codLabExterno;
    }

    public void setCodLabExterno(Integer codLabExterno) {
        this.codLabExterno = codLabExterno;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public boolean isFormatoPDF() {
        return this.formatoPDF;
    }

    public void setFormatoPDF(boolean formatoPDF) {
        this.formatoPDF = formatoPDF;
    }

    public List<VersaoShift> getVersao() {
        return this.versao;
    }

    public void setVersao(List<VersaoShift> versao) {
        this.versao = versao;
    }
}

