/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.shift.ExameShift;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorShift
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String DESC_MAT = "descricaoMaterial";
    private static final String OBJ_EXAME_SHIFT = "objExameShift";
    private static final String RECIPIENTE = "recipiente";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "descricaoMaterial");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 80, 0, 120);
    private JTextField textLocalizar = new JTextField();
    private JLabel codigoRecipiente = new JLabel("");
    private JLabel labelCodigoRecipiente = new JLabel("C\u00f3d. Recipiente: ");
    private JCheckBox checkImportarResultadoPDF = new JCheckBox("Importar resultado no formato PDF");
    private String xmlSelecionado = "";

    public ConfiguradorShift(Frame pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorShift(Dialog pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorShift novaInstancia(Object pai, String codigoLabExterno, String titulo) {
        if (pai instanceof Frame) {
            return new ConfiguradorShift((Frame)pai, codigoLabExterno, titulo);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorShift((Dialog)pai, codigoLabExterno, titulo);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.getPanelCentral().setLayout(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.labelCodigoRecipiente, c);
        ++c.gridx;
        panel.add((Component)this.codigoRecipiente, c);
        ++c.gridx;
        c.insets = new Insets(0, 20, 0, 0);
        panel.add((Component)this.checkImportarResultadoPDF, c);
        this.getPanelCentral().add((Component)panel, "West");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameShift exa = new ExameShift(xml);
            return exa.getCodigo();
        }
        return "";
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            ExameShift exa = new ExameShift(xml);
            return exa.getDescricao();
        }
        return "";
    }

    private void carregarExames() {
        for (ExameShift exame : ExameShift.getExames(Integer.valueOf(Variaveis.filialPadrao), Integer.valueOf(this.getCodigoLabExterno()))) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigo());
            reg.setValor(DESC_EXA, exame.getDescricao());
            reg.setValor(DESC_MAT, exame.getDescricaoMaterial());
            reg.setValor(OBJ_EXAME_SHIFT, exame);
            reg.setValor(RECIPIENTE, exame.getRecipiente());
            this.modExa.addRegistro(reg);
        }
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorShift.this.tableExa.hasFocus() && (row = ConfiguradorShift.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorShift.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorShift.this.tableExa.scrollRectToVisible(ConfiguradorShift.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorShift.this.tableExa.hasFocus() && (row = ConfiguradorShift.this.tableExa.getSelectedRow()) < ConfiguradorShift.this.tableExa.getRowCount() - 1) {
                    ConfiguradorShift.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorShift.this.tableExa.scrollRectToVisible(ConfiguradorShift.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorShift.this.modExa.filtrar(ConfiguradorShift.DESC_EXA, ConfiguradorShift.this.textLocalizar.getText());
                if (ConfiguradorShift.this.modExa.getRowCount() > 0) {
                    ConfiguradorShift.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.codigoRecipiente.setText((String)reg.getValor(RECIPIENTE));
        }
        ExameShift exa = this.getExameSelecionado();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public boolean acaoOk() {
        ExameShift exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    @Override
    public void setXML(String xml) {
        if (ExameShift.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameShift exa = new ExameShift(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !this.isEqualsExames(exa, (ExameShift)reg.getValor(OBJ_EXAME_SHIFT))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                this.checkImportarResultadoPDF.setSelected(exa.isFormatoPDF());
                break;
            }
        }
    }

    private boolean isEqualsExames(ExameShift exame1, ExameShift exame2) {
        return exame1.getCodigo().equals(exame2.getCodigo()) && exame1.getDescricaoMaterial().equals(exame2.getDescricaoMaterial()) && exame1.getRecipiente().equals(exame2.getRecipiente());
    }

    private boolean atualizarXMLSelecionado() {
        ExameShift exa = this.getExameSelecionado();
        if (exa != null) {
            exa.setFormatoPDF(this.checkImportarResultadoPDF.isSelected());
            exa.construirXml(false);
            this.xmlSelecionado = exa.getXml();
            return true;
        }
        return false;
    }

    private ExameShift getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameShift)reg.getValor(OBJ_EXAME_SHIFT);
        }
        return null;
    }
}

