/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.shift.XmlShift;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.EditorTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloShift
extends AbstractConfiguradorProtocolo {
    public static final String NOMELABORATORIO = "Laborat\u00f3rio Shift";
    public static final String TAG_ID_LABORATORIO = "idLaboratorio";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_ENVIAR_UTILIZANDO_WEBSERVICE = "enviarLoteWebservice";
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private TTextField textCodigoLaboratorio = ComponenteFactory.novoTTextField(30, 3, this);
    protected TTextField textSenha = ComponenteFactory.novoTTextField(30, 3, this);
    protected JTextField textEndWebService = new TTextField(100, 3);
    protected JCheckBox checkEnviaLoteUsandoWebService = new JCheckBox("Enviar lote utilizando WebService");
    protected JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    protected JCheckBox checkImportarResultadoPdf = new JCheckBox("Importar resultados no formato PDF");
    protected JButton buttonConfigurarCabecalhoEtiqueta = ComponenteFactory.novoJButton("Configurar impress\u00e3o de etiquetas", this);
    private String xmlCabecalhoEtiqueta = "";

    private ConfiguradorProtocoloShift(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    private ConfiguradorProtocoloShift(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        return pai instanceof Frame ? new ConfiguradorProtocoloShift((Frame)pai, NOMELABORATORIO, codigoLaboratorio) : new ConfiguradorProtocoloShift((Dialog)pai, NOMELABORATORIO, codigoLaboratorio);
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        Dimension dimensionLabels = new Dimension(77, 20);
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", dimensionLabels);
        lblLote.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textLote.setPreferredSize(new Dimension(200, 20));
        this.textLote.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 1;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("ID Laborat\u00f3rio:", dimensionLabels);
        lblCodigo.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblCodigo, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textCodigoLaboratorio.setPreferredSize(new Dimension(200, 20));
        this.textCodigoLaboratorio.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textCodigoLaboratorio, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.gridwidth = 1;
        JLabel lblChave = ComponenteFactory.novoJLabel("Senha:", dimensionLabels);
        lblChave.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textSenha.setPreferredSize(new Dimension(150, 20));
        this.textSenha.setMinimumSize(new Dimension(150, 20));
        this.getPanelCentral().add((Component)this.textSenha, cons);
        cons.gridx = 0;
        cons.gridy = 5;
        cons.gridwidth = 1;
        JLabel lblService = ComponenteFactory.novoJLabel("Web Services:", dimensionLabels);
        this.getPanelCentral().add((Component)lblService, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textEndWebService.setPreferredSize(new Dimension(200, 20));
        this.textEndWebService.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textEndWebService, cons);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnviaLoteUsandoWebService, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        cons.gridx = 0;
        cons.gridy = 8;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkImportarResultadoPdf, cons);
        cons.insets.left = 1;
        cons.insets.right = 1;
        cons.gridx = 0;
        cons.gridy = 11;
        cons.weightx = 0.5;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.buttonConfigurarCabecalhoEtiqueta, cons);
        this.checkEnviaLoteUsandoWebService.setSelected(true);
        this.checkEnviaLoteUsandoWebService.setEnabled(false);
        this.repaint();
        this.revalidate();
        this.pack();
        this.setSize(new Dimension(340, 330));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
        this.adicionarEventos();
    }

    private void adicionarEventos() {
        this.buttonConfigurarCabecalhoEtiqueta.addActionListener(action -> {
            EditorTermica termica = EditorTermica.novaInstancia(Laboratorio.getInstancia(), "Configurando ", true, true);
            if (!Funcoes.textoVazio(this.xmlCabecalhoEtiqueta)) {
                termica.setDocumento(this.xmlCabecalhoEtiqueta);
            }
            termica.setVisible(true);
            if (!Funcoes.textoVazio(termica.getDocumento())) {
                this.xmlCabecalhoEtiqueta = termica.getDocumento();
            }
        });
    }

    @Override
    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(XmlShift.SHIFT.getTag());
        xml.escrever(XmlShift.LOTE.getTag(), this.textLote.getText());
        xml.escrever(XmlShift.ID_LABORATORIO.getTag(), this.textCodigoLaboratorio.getText());
        xml.escrever(XmlShift.SENHA.getTag(), this.textSenha.getText());
        xml.escrever(XmlShift.ENDERECO_WEBSERVICE.getTag(), this.textEndWebService.getText());
        xml.escrever(XmlShift.ENVIAR_LOTE_WEBSERVICE.getTag(), this.checkEnviaLoteUsandoWebService.isSelected() ? TRUE : FALSE);
        xml.escrever(XmlShift.ENVIO_AUTOMATICO.getTag(), this.checkEnvioAutomatico.isSelected() ? TRUE : FALSE);
        xml.escrever(XmlShift.IMPORTAR_RESULTADO_PDF.getTag(), this.checkImportarResultadoPdf.isSelected() ? TRUE : FALSE);
        xml.escrever(XmlShift.CONFIGURADOR_CABECALHO.getTag(), this.xmlCabecalhoEtiqueta);
        try {
            xml.fechar(XmlShift.SHIFT.getTag());
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
        }
        return xml.getXML();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, XmlShift.SHIFT.getTag());
            this.textLote.setText(StringUtil.getValor(xml, XmlShift.LOTE.getTag()));
            this.textCodigoLaboratorio.setText(StringUtil.getValor(xml, XmlShift.ID_LABORATORIO.getTag()));
            this.textSenha.setText(StringUtil.getValor(xml, XmlShift.SENHA.getTag()));
            this.textEndWebService.setText(StringUtil.getValor(xml, XmlShift.ENDERECO_WEBSERVICE.getTag()));
            this.checkEnviaLoteUsandoWebService.setSelected(true);
            this.checkEnvioAutomatico.setSelected(StringUtil.getValor(xml, XmlShift.ENVIO_AUTOMATICO.getTag()).trim().length() > 0 && StringUtil.getBoolean(xml, XmlShift.ENVIO_AUTOMATICO.getTag()));
            this.checkImportarResultadoPdf.setSelected(StringUtil.getValor(xml, XmlShift.IMPORTAR_RESULTADO_PDF.getTag()).trim().length() > 0 && StringUtil.getBoolean(xml, XmlShift.IMPORTAR_RESULTADO_PDF.getTag()));
            this.xmlCabecalhoEtiqueta = StringUtil.getValor(xml, XmlShift.CONFIGURADOR_CABECALHO.getTag());
        }
    }

    public void setXmlConfiguracao(String xml) {
        this.xmlCabecalhoEtiqueta = xml;
    }

    @Override
    public boolean acaoOk() {
        if (this.checkEnviaLoteUsandoWebService.isSelected()) {
            if (Funcoes.textoVazio(this.textCodigoLaboratorio.getText())) {
                Funcoes.mensagem(this, "Informe o ID Laborat\u00f3rio para realizar a integra\u00e7\u00e3o.", 2);
                ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
                return false;
            }
            if (Funcoes.textoVazio(this.textSenha.getText())) {
                Funcoes.mensagem(this, "Informe a Senha do Laborat\u00f3rio.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return false;
            }
            if (Funcoes.textoVazio(this.textEndWebService.getText())) {
                Funcoes.mensagem(this, "Informe o Link de Integra\u00e7\u00e3o.", 2);
                ScreenUtil.requisitarFoco(this.textEndWebService);
                return false;
            }
        }
        return true;
    }
}

