/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class ComunicacaoShift {
    public static final String IMPORTA_PEDIDOS = "http://www.shift.com.br/shift.bs.WSApoio.ImportaPedido";
    public static final String BUSCA_PEDIDOS = "http://www.shift.com.br/shift.bs.WSApoio.ExportaResultados";
    String url = "";

    public ComunicacaoShift() {
    }

    public ComunicacaoShift(String url) {
        this.url = url;
    }

    public boolean conexaoValida(boolean isColetaWeb) {
        try {
            if (!UtilExportadores.comunicacaoOk(this.url, isColetaWeb, Protocolo.Shift.getDescricao()).isImprimiu()) {
                return false;
            }
        }
        catch (Exception e) {
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
            }
            return false;
        }
        return true;
    }

    public boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    public SSLConnectionSocketFactory construirSSL() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        return new SSLConnectionSocketFactory(builder.build());
    }

    public HttpUriRequest request(String xml, String metodo) {
        return RequestBuilder.post((String)this.url.replace("?wsdl", "")).addHeader("Content-Type", "text/xml").addHeader("SOAPAction", metodo).setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
    }

    public String baixarResultadoPDF(String urlDownload) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(SSLContext.getDefault(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        if (urlDownload.endsWith(">")) {
            int index = urlDownload.length();
            urlDownload = urlDownload.substring(0, index - 1);
        }
        HttpGet get = new HttpGet(new String(urlDownload.getBytes(), StandardCharsets.UTF_8));
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        HttpEntity entity = response.getEntity();
        InputStream inputStream = entity.getContent();
        byte[] documentoEmBytes = new byte[8192];
        while ((bytesRead = inputStream.read(documentoEmBytes)) != -1) {
            baos.write(documentoEmBytes, 0, bytesRead);
        }
        Base64 base = new Base64();
        return base.encodeAsString(baos.toByteArray());
    }
}

