/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.shift.CamposImportacaoShift;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class CamposRelacionamentoShiftUtil {
    private CamposRelacionamentoShiftUtil() {
    }

    public static CamposImportacao carregarCamposAutomaticamente(String codigoLabExterno, String codigoExameLabApoio, String codigoExame, Integer materialPai) {
        CamposImportacaoShift campoImportacao = null;
        String xmlExameShift = CamposRelacionamentoShiftUtil.buscaXMLExameLabApoio(codigoLabExterno, codigoExameLabApoio);
        if (!Funcoes.textoVazio(xmlExameShift)) {
            String[] versoes;
            campoImportacao = new CamposImportacaoShift();
            for (String versao : versoes = StringUtil.getValores(xmlExameShift, "versao")) {
                String codigoVersao = StringUtil.getValor(versao, "codigoVersao");
                campoImportacao = new CamposImportacaoShift(xmlExameShift, codigoExameLabApoio, codigoExame, materialPai, codigoVersao);
            }
        }
        return campoImportacao;
    }

    public static Map<String, CamposImportacao> carregarListaCamposImportacaoPorVersao(String codigoLabExterno, String codigoExameLabApoio, Integer materialPai) {
        HashMap<String, CamposImportacao> mapCamposImportacaoVersao = new HashMap<String, CamposImportacao>();
        String xmlExameShift = CamposRelacionamentoShiftUtil.buscaXMLExameLabApoio(codigoLabExterno, codigoExameLabApoio);
        if (!Funcoes.textoVazio(xmlExameShift)) {
            String[] versoes;
            for (String versao : versoes = StringUtil.getValores(xmlExameShift, "versao")) {
                String codigoVersao = StringUtil.getValor(versao, "codigoVersao");
                mapCamposImportacaoVersao.put(codigoVersao, new CamposImportacaoShift(xmlExameShift, codigoExameLabApoio, null, materialPai, codigoVersao));
            }
        }
        return mapCamposImportacaoVersao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buscaXMLExameLabApoio(String codigoLabExterno, String codigoExameLabApoio) {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        ResultSet res = null;
        if (st != null && codigoLabExterno != null && !Funcoes.textoVazio(codigoExameLabApoio)) {
            try {
                String tmp;
                sql.append(" select shi_xml ");
                sql.append("from examesshift ");
                sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao).append(" and ");
                sql.append(" lae_codigo = ").append(codigoLabExterno).append(" and ");
                sql.append(" shi_codexame = '").append(codigoExameLabApoio).append("'");
                res = Conexao.executeQuery(st, sql);
                if (res.next() && !Funcoes.textoVazio(tmp = res.getString("shi_xml"))) {
                    String string = tmp;
                    CamposRelacionamentoShiftUtil.fecharConexao(res, st);
                    return string;
                }
                CamposRelacionamentoShiftUtil.fecharConexao(res, st);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + sql, e.getStackTrace(), "CarregaCamposRelacionamentoShiftUtil");
            }
            finally {
                CamposRelacionamentoShiftUtil.fecharConexao(res, st);
            }
        }
        return null;
    }

    private static void fecharConexao(ResultSet res, Statement st) {
        if (res != null) {
            Conexao.fecharResultSet(res);
        }
        if (st != null) {
            Conexao.fecharStatement(st);
        }
    }
}

