/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.shift;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.LinkedHashMap;

public class CamposImportacaoShift
implements CamposImportacao {
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;
    LinkedHashMap<String, String> linhas = new LinkedHashMap();

    public CamposImportacaoShift() {
    }

    public CamposImportacaoShift(String xmlShift, String codigoExamePai, String codigoExame, Integer codigoMaterialPai, String codigoVersao) {
        String[] linhasVersao;
        this.codigoExamePai = !Funcoes.textoVazio(codigoExame) ? codigoExame : codigoExamePai;
        this.codigoMaterialPai = codigoMaterialPai;
        this.codigoExame = !Funcoes.textoVazio(codigoExame) ? codigoExame : StringUtil.getValor(xmlShift, "codigo");
        this.versao = codigoVersao;
        this.linhas.put("", "Nenhum");
        for (String linha : linhasVersao = StringUtil.getValores(xmlShift, "versao")) {
            String[] linhasCampos;
            String codVersao = StringUtil.getValor(linha, "codigoVersao");
            if (!codigoVersao.equals(codVersao)) continue;
            for (String linhaCamp : linhasCampos = StringUtil.getValores(linha, "campos")) {
                String exame = StringUtil.getValor(linhaCamp, "apelido");
                this.linhas.put(exame, StringUtil.getValor(linhaCamp, "desc_apelido"));
                this.linhas.put("unidadeMedida_" + exame, "Unidade de medida " + exame);
                this.linhas.put("valorReferencia_" + exame, "Valor de refer\u00eancia " + exame);
                this.linhas.put("metodologia_" + exame, "Metodologia " + exame);
                this.linhas.put("culturaPositiva_" + exame, "Cultura positiva " + exame);
                this.linhas.put("tsaRealizado_" + exame, "TSA realizado " + exame);
                this.linhas.put("notaLaudo_" + exame, "Nota laudo " + exame);
            }
            String resultado = StringUtil.getValor(xmlShift, "resultado");
            this.linhas.put(StringUtil.getValor(resultado, "data"), StringUtil.getValor(resultado, "desc_data"));
            this.linhas.put(StringUtil.getValor(resultado, "hora"), StringUtil.getValor(resultado, "desc_hora"));
            this.linhas.put(StringUtil.getValor(resultado, "responsavel"), StringUtil.getValor(resultado, "desc_responsavel"));
        }
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }

    public String toString() {
        return this.getVersao();
    }
}

