/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf.resultado;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.sf.CampoSFranco;
import jalis.laboratorio.util.parsers.sf.ExameSFranco;
import jalis.util.Funcoes;
import java.util.LinkedHashMap;

class CamposImportacaoSFranco
implements CamposImportacao {
    LinkedHashMap<String, String> linhas = new LinkedHashMap();
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CamposImportacaoSFranco(ExameSFranco exame, String codigoExamePai, Integer codigoMaterialPai) {
        this.versao = Funcoes.formataData(exame.getDataLayout());
        this.codigoExame = exame.getCodigo();
        this.codigoMaterialPai = codigoMaterialPai;
        this.linhas.put("", "Nenhum");
        for (CampoSFranco campo : exame.getCampos()) {
            this.linhas.put(campo.getCodigo(), campo.getCodigo());
        }
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }
}

