/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.ParserUtil;
import jalis.laboratorio.util.parsers.sf.CampoSFranco;
import jalis.laboratorio.util.parsers.sf.ExameMatColeta;
import jalis.laboratorio.util.parsers.sf.ExameSFranco;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JProgressBar;

public class ParserImportacaoSFranco {
    private static int pesoParserTxt = 30;
    private static int pesoInsertNovos = 50;
    private static int pesoInsertLigacoes = 20;

    public static Set<ExameSFranco> importarExamesSFranco(String caminhoArquivo, int codigoLabExterno) {
        return ParserImportacaoSFranco.importarExamesSFranco(caminhoArquivo, codigoLabExterno, null);
    }

    public static Set<ExameSFranco> importarExamesSFranco(String caminhoArquivo, int codigoLabExterno, JProgressBar progress) {
        if (progress != null) {
            progress.setMaximum(100);
            progress.setValue(0);
        }
        Statement st = Conexao.getStatement();
        Set<ExameSFranco> exNovos = ParserImportacaoSFranco.getExames(caminhoArquivo, codigoLabExterno, progress);
        Set<ExameSFranco> exAntigos = ExameSFranco.getExames(Integer.valueOf(Variaveis.filialPadrao), codigoLabExterno);
        Set<ExameMatColeta> exMatColRelacionados = ParserImportacaoSFranco.getExMatColetaRelacionados(codigoLabExterno);
        float fatorProg = 0.0f;
        int qtExamesPercorridos = 0;
        if (exNovos.size() > 0) {
            try {
                IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, null, null, null);
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 3, new Object[0]);
                fatorProg = exNovos.size() / pesoInsertNovos;
                qtExamesPercorridos = 1;
                for (ExameSFranco exNovo : exNovos) {
                    IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 3, exNovo.getCodigo(), StringUtil.textoDB(exNovo.getDescricao()), StringUtil.textoDB(exNovo.getXML()));
                    progress.setValue(pesoParserTxt + Math.round((float)qtExamesPercorridos / fatorProg));
                    ++qtExamesPercorridos;
                }
                fatorProg = exMatColRelacionados.size() / pesoInsertLigacoes;
                qtExamesPercorridos = 0;
                for (ExameMatColeta emc : exMatColRelacionados) {
                    ExameSFranco novoExame = ParserImportacaoSFranco.getExameByCodigo(exNovos, emc.getExameSFranco().getCodigo());
                    if (novoExame == null) continue;
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, emc.getCodigoExame(), emc.getCodigoMaterial(), novoExame.getXML());
                    progress.setValue(pesoParserTxt + pesoInsertNovos + Math.round((float)qtExamesPercorridos / fatorProg));
                    ++qtExamesPercorridos;
                }
                Conexao.arquivaSQL();
                exAntigos.removeAll(exNovos);
                return exAntigos;
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImportaExames: 51");
            }
        }
        Conexao.fecharStatement(st);
        return new HashSet<ExameSFranco>();
    }

    private static ExameSFranco getExameByCodigo(Set<ExameSFranco> exames, String codigo) {
        for (ExameSFranco ex : exames) {
            if (!ex.getCodigo().equalsIgnoreCase(codigo)) continue;
            return ex;
        }
        return null;
    }

    private static Set<ExameSFranco> getExames(String caminhoArquivo, int codigoLabExterno, JProgressBar progress) {
        HashSet<ExameSFranco> exames = new HashSet<ExameSFranco>();
        File f = new File(caminhoArquivo);
        float fatorProg = ParserUtil.getNumeroLinhas(f) / pesoParserTxt;
        if (!f.exists()) {
            return null;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(f));
            int linhaAtual = 1;
            ExameSFranco exame = null;
            CampoSFranco campo = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (line.indexOf("02C") != 0 && exame != null && campo != null) {
                    exame.getCampos().add(campo);
                    campo = null;
                }
                if (line.indexOf("02S") != 0 && line.indexOf("02C") != 0 && exame != null) {
                    if (exame.getCampos().size() > 0) {
                        exames.add(exame);
                    }
                    exame = null;
                }
                if (line.indexOf("01SED") == 0 && exame == null) {
                    int tamanhoDescricao = line.length() - 24;
                    exame = new ExameSFranco(line.substring(6, 16).trim(), line.substring(16, 16 + tamanhoDescricao).trim());
                    exame.setDataLayout(Funcoes.stringToDate("yyyyMMdd", line.substring(line.length() - 8, line.length()).trim()));
                } else if (line.indexOf("02S") == 0 && exame != null) {
                    campo = new CampoSFranco(line.substring(3, line.length() - 1).trim(), "");
                } else if (line.indexOf("02C") == 0 && campo != null) {
                    campo.addComentario(line.substring(3, line.length() - 1).replace("\u00ae", "").trim());
                }
                progress.setValue(Math.round((float)linhaAtual / fatorProg));
                ++linhaAtual;
            }
            in.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImportaExames: 182");
        }
        return exames;
    }

    private static Set<ExameMatColeta> getExMatColetaRelacionados(int codigoLabExterno) {
        HashSet<ExameMatColeta> examesRelacionados = new HashSet<ExameMatColeta>();
        StringBuilder sql = new StringBuilder("select exa_codigo, mco_codigo, ele_xmllabexterno from examematcoletalabexterno");
        sql.append(" where fil_codigo = ? and lae_codigo = ? and ele_xmllabexterno <> '' and ele_xmllabexterno is not null");
        PreparedStatement prst = Conexao.getPreparedStatement(sql.toString());
        try {
            prst.setInt(1, Integer.valueOf(Variaveis.filialPadrao));
            prst.setInt(2, codigoLabExterno);
            ResultSet rs = prst.executeQuery();
            while (rs.next()) {
                ExameMatColeta emc = new ExameMatColeta(Integer.valueOf(Variaveis.filialPadrao), rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
                emc.setExameSFranco(new ExameSFranco(rs.getString("ele_xmllabexterno")));
                examesRelacionados.add(emc);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + sql, e.getStackTrace());
            try {
                prst.close();
            }
            catch (Exception exp) {
                ErrorLogger.mostraMensagem(null, exp.getMessage(), exp.getStackTrace());
            }
        }
        return examesRelacionados;
    }
}

