/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.sf.ExameSFranco;
import jalis.laboratorio.util.parsers.sf.ParserImportacaoSFranco;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;

public class ImportacaoSFranco
extends AbstractImportadorLabExterno {
    private JButton buttonImportarCamposResultado = ComponenteFactory.novoJButton("Importar Campos Resultado", 'R', this);

    public ImportacaoSFranco(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. S\u00e9rgio Franco a partir de arquivo TXT", codigoLabExterno, Protocolo.SergioFranco);
        this.getButtonImportar().setText("Importar Exames");
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
        this.buttonImportarCamposResultado.setEnabled(habilitar);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo TXT do Lab. S\u00e9rgio Franco (*.txt)", "txt"));
            if (chooser.showOpenDialog(this) == 0) {
                Thread.sleep(50L);
                StringBuilder bui = new StringBuilder("Importando exames...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Set<ExameSFranco> excluidos = ParserImportacaoSFranco.importarExamesSFranco(chooser.getSelectedFile().getPath(), this.codigoLabExterno, this.progress);
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                retorno = true;
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (excluidos.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (ExameSFranco e : excluidos) {
                        bui.append("\n\t|").append(StringUtil.formatarColuna(e.getDescricao(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getMaterialDescricao(), 50, 'c')).append("|");
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoSergioFranco: 112");
        }
        this.progress.setVisible(false);
        return retorno;
    }
}

