/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ParserUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.sf.ConfiguracaoProtocoloSFranco;
import jalis.laboratorio.util.parsers.sf.ExameSFranco;
import jalis.laboratorio.util.parsers.sf.resultado.Exame;
import jalis.laboratorio.util.parsers.sf.resultado.ExameResultado;
import jalis.laboratorio.util.parsers.sf.resultado.Paciente;
import jalis.laboratorio.util.parsers.sf.resultado.PacienteResultado;
import jalis.laboratorio.util.parsers.sf.resultado.Requisicao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ImportacaoResultadoSFranco
extends AbstractImportadorResultadoLabExterno {
    private static String ULTIMO_SQL = "";
    private static final SimpleDateFormat dataSFranco = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat dataUsuario = new SimpleDateFormat("dd/MM/yyyy");
    private ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);

    public ImportacaoResultadoSFranco(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. S. Franco a partir de arquivo TXT", codigoLabExterno, Protocolo.SergioFranco, new JPanel(new FlowLayout(2)));
        this.getPanelAdicional().add(this.buttonImprimir);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    private ConfiguracaoProtocoloSFranco getConfigSFranco() throws Exception {
        String sql = "select lae_configuracao from labexterno where fil_codigo = ? and lae_codigo = ?";
        PreparedStatement prst = Conexao.getConnection().prepareStatement(sql);
        prst.setInt(1, Integer.valueOf(Variaveis.filialPadrao));
        prst.setInt(2, this.codigoLabExterno);
        ResultSet rs = prst.executeQuery();
        rs.next();
        ConfiguracaoProtocoloSFranco config = new ConfiguracaoProtocoloSFranco(rs.getString("lae_configuracao"));
        prst.close();
        return config;
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        try {
            ConfiguracaoProtocoloSFranco config = this.getConfigSFranco();
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo TXT do Lab. S. Franco (*.txt)", "txt"));
            if (chooser.showOpenDialog(this) == 0) {
                String nomeArquivo = chooser.getSelectedFile().getName();
                if (nomeArquivo.length() > 23 && nomeArquivo.indexOf("LAUDO") == 0 && nomeArquivo.indexOf(".txt") == nomeArquivo.length() - 4 && ParserUtil.getNumeroLinhas(chooser.getSelectedFile()) > 0) {
                    this.setTextoInformacoes("Importa\u00e7\u00e3o iniciada...");
                    this.importarResultados(config, Integer.valueOf(Variaveis.filialPadrao), this.getPacientesResultado(chooser.getSelectedFile()));
                } else {
                    this.setTextoInformacoes("Arquivo inv\u00e1lido, tente novamente.");
                }
            }
            Conexao.arquivaSQL();
            this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSFranco: 69");
        }
        this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada.", false);
        this.progress.setVisible(false);
    }

    private List<PacienteResultado> getPacientesResultado(File arquivo) {
        ArrayList<PacienteResultado> pacientes = new ArrayList<PacienteResultado>();
        if (!arquivo.exists()) {
            return null;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(arquivo));
            PacienteResultado novoPaciente = null;
            ExameResultado novoExame = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (novoExame != null && novoPaciente != null && !line.startsWith("04")) {
                    novoPaciente.addExame(novoExame);
                    novoExame = null;
                }
                if (novoPaciente != null && !line.startsWith("03") && !line.startsWith("04")) {
                    pacientes.add(novoPaciente);
                    novoPaciente = null;
                }
                if (line.startsWith("02")) {
                    String codigoCipString = line.substring(2, 12).trim();
                    if (codigoCipString.isEmpty()) continue;
                    novoPaciente = new PacienteResultado(new BigInteger(codigoCipString));
                    continue;
                }
                if (line.startsWith("03") && novoPaciente != null) {
                    novoExame = new ExameResultado(line.substring(2, 12).trim());
                    novoExame.setDataLayout(Funcoes.stringToDate("yyyyMMdd", line.substring(76, 84)));
                    continue;
                }
                if (!line.startsWith("04") || novoPaciente == null || novoExame == null) continue;
                novoExame.setValorSubexame(line.substring(2, 12).trim(), line.substring(57, 137).trim());
            }
            in.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSFranco: 182");
        }
        return pacientes;
    }

    private void importarResultados(ConfiguracaoProtocoloSFranco config, int codigoFilial, List<PacienteResultado> pacientesResultado) throws Exception {
        this.progress.setValue(0);
        this.progress.setMaximum(pacientesResultado.size());
        this.progress.setVisible(true);
        if (pacientesResultado.isEmpty()) {
            this.setTextoInformacoes("\nNenhum resultado para importar", false);
            return;
        }
        ArrayList<BigInteger> codigosCip = new ArrayList<BigInteger>();
        for (PacienteResultado pacResultado : pacientesResultado) {
            codigosCip.add(pacResultado.getCip());
        }
        Statement st = Conexao.getStatement();
        for (PacienteResultado pacResultado : pacientesResultado) {
            this.progress.setValue(this.progress.getValue() + 1);
            Requisicao requisicao = this.getRequisicao(codigoFilial, this.codigoLabExterno, pacResultado.getCip());
            if (requisicao == null) continue;
            for (Exame exame : requisicao.getExames()) {
                if (exame.isLancado()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.JA_LANCADO);
                    continue;
                }
                if (!Funcoes.textoVazio(exame.getSituacao())) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.SEM_MATERIAL);
                    continue;
                }
                if (!exame.isRelacionado()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.SEM_RELACIONAMENTO);
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + requisicao.getCodigo() + "|" + exame.getCodigo() + " - " + Situacao.SEM_RELACIONAMENTO.descricao, false);
                    continue;
                }
                ExameResultado exameResultado = pacResultado.getExame(exame.getCodigoNoSFranco());
                if (exameResultado == null) continue;
                boolean salvoParcial = exame.getSituacao().equals("P");
                if (!salvoParcial) {
                    this.preencheFormatacao(requisicao, exame);
                }
                Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(String.valueOf(requisicao.getCodigoFilial()), String.valueOf(requisicao.getCodigo()), String.valueOf(requisicao.getPaciente().getCodigo()), exame.getCodigo(), String.valueOf(exame.getCodigoMaterial()), String.valueOf(exame.getCodigoMetodo()));
                Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(exame.getCodigo(), String.valueOf(requisicao.getCodigoFilial()));
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = ExameUtil.getHistoricos(null, String.valueOf(requisicao.getCodigoFilial()));
                }
                Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString(), requisicao.getCodigoFilial().toString(), false, false);
                dados.putAll(exameResultado.getSubexames());
                Resultado resultado = new Resultado(exame.getFormato(), dados, resAnterior, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"));
                resultado.atualizarComponentes();
                if (!resultado.verificarCondicao()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + requisicao.getCodigo() + "|" + exame.getCodigo() + " - " + Situacao.CONDICAO_INSATISFEITA.descricao, false);
                    continue;
                }
                if (!config.isIgnorarVersaoLayout() && !exameResultado.getDataLayout().equals(exame.getDataLayout())) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.VERSAO_INCOMPATIVEL);
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + requisicao.getCodigo() + "|" + exame.getCodigo() + " - " + Situacao.VERSAO_INCOMPATIVEL.descricao, false);
                    continue;
                }
                boolean completo = true;
                if (exame.isSalvaParcial()) {
                    completo = resultado.resultadoCompleto(true);
                }
                String novaSituacao = completo ? "L" : "P";
                String resultadoValor = completo ? resultado.getResultado() : resultado.getResultadoParcial();
                Util.gravaAlteracaoExameRequisicao(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString());
                boolean validacaoCompulsoria = resultado.verificarValidacaoCompulsoria() == 1;
                boolean validacaoResultadoCritico = resultado.verificarValidacaoResultadoCritico() == 1;
                this.salvarExameRequisicao(requisicao, exame, resultadoValor, novaSituacao, validacaoCompulsoria, validacaoResultadoCritico);
                this.adicionarAoModeloRelatorio(requisicao, exame, completo ? Situacao.LANCADO : Situacao.LANCADO_PARCIALMENTE);
                Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? exame.getDataMaterial() : new Date();
                this.atualizarTabelaExamesControle(st, requisicao, exame, resultado.getResultadoAnterior(dataColeta, dataColeta));
                this.atualizarPaginaOrdemExameWeb(st, requisicao);
                this.editarRequisicaoExportaFiliais(requisicao, exame);
                this.atualizarSituacaoExameInterfaceamento(st, requisicao, exame);
                this.setTextoInformacoes("\nResultado recebido para: " + requisicao.getCodigo() + "|" + exame.getCodigo() + " - " + (completo ? Situacao.LANCADO : Situacao.LANCADO_PARCIALMENTE.descricao), false);
                Conexao.arquivaSQL();
                if (!this.isFilialExportaWeb(requisicao.getCodigoFilial())) continue;
                String reqImagemWeb = IntegracaoUtil.formataCodigoRequisicao(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st);
                Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString(), resultadoValor, false);
                this.exportarParaWeb(st, this.getCodigoBaseWeb(requisicao.getCodigoFilial().toString()), novaSituacao, requisicao, exame, mapa, resultadoValor);
                if (!ExportaWeb.isGerarPdfResultado(st, requisicao.getCodigoFilial().toString())) continue;
                ExportaWeb.enviarResultadoPDF(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), this.getCodigoBaseWeb(requisicao.getCodigoFilial().toString()));
            }
        }
        st.close();
    }

    private void salvarExameRequisicao(Requisicao requisicao, Exame exame, String resultado, String situacao, boolean validacaoCompulsoria, boolean validacaoResultadoCritico) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("update examerequisicao set");
        bui.append(" exr_resultado = '").append(StringUtil.textoDB(resultado)).append("'");
        bui.append(", exr_compulsorio = ").append(validacaoCompulsoria);
        bui.append(", exr_situacao = '").append(situacao).append("'");
        bui.append(", exr_datadigita = current_timestamp, usr_coddigitador = '").append(Variaveis.login).append("'");
        bui.append(", met_codigo = ").append(exame.getCodigoMetodo());
        bui.append(validacaoResultadoCritico ? " ,exr_dataresultadocritico = current_timestamp " : " ,exr_dataresultadocritico = null ");
        bui.append(" where fil_codigo = ").append(requisicao.getCodigoFilial());
        bui.append(" and req_codigo = ").append(requisicao.getCodigo());
        bui.append(" and exa_codigo = '").append(exame.getCodigo()).append("'");
        bui.append(" and mco_codigo = ").append(exame.getCodigoMaterial());
        DBUtil.gravaLogSituacaoExameRequisicao(st, String.valueOf(requisicao.getCodigoFilial()), String.valueOf(requisicao.getCodigo()), exame.getCodigo(), String.valueOf(exame.getCodigoMaterial()), situacao, false);
        Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, bui.toString());
        st.close();
    }

    private void exportarParaWeb(Statement st, String codigoBaseWeb, String situacao, Requisicao requisicao, Exame exame, Map mapa, String resultadoOriginal) throws Exception {
        if (mapa != null && !Funcoes.textoVazio(codigoBaseWeb)) {
            boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, requisicao.getCodigoFilial().toString());
            ArrayList<String> chave = new ArrayList<String>();
            chave.add("codigoRequisicao");
            chave.add(IntegracaoUtil.formataCodigoRequisicao(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st));
            chave.add("codigoBase");
            chave.add(codigoBaseWeb);
            chave.add("codigoExameRequisicao");
            chave.add(exame.getCodigo());
            chave.add("materialExameRequisicao");
            chave.add(exame.getCodigoMaterial().toString());
            ArrayList<String> temp = new ArrayList<String>(chave);
            String laudo = mapa.get("laudo") != null ? StringUtil.textoDB((String)mapa.get("laudo")) : "";
            String exportaTexto = mapa.get("laudo") != null ? exame.getFormatoTexto() : "";
            temp.add("dataEnvioExameRequisicao");
            temp.add("current_timestamp");
            temp.add("situacaoExameRequisicao");
            temp.add(situacao);
            if (!resultadoPdf) {
                temp.add("resultadoExameRequisicao");
                temp.add(laudo);
                temp.add("resultadoTextoExameRequisicao");
                temp.add(ResultadosUtil.geraResultadoTextoParaWeb(resultadoOriginal, exportaTexto));
            }
            DBUtil.insereExportaWeb(requisicao.getCodigoFilial().toString(), st, "requisicaoexame", "A", true, temp.toArray(new String[temp.size()]));
            Map imagens = (Map)mapa.get("imagens");
            if (imagens != null && !imagens.isEmpty()) {
                DBUtil.insereExportaWeb(requisicao.getCodigoFilial().toString(), st, "requisicaoexameimagem", "D", chave.toArray(new String[chave.size()]));
                temp.clear();
                for (Integer indice : imagens.keySet()) {
                    temp.addAll(chave);
                    temp.add("codigoImagemExame");
                    temp.add(indice.toString());
                    temp.add("imagemExame");
                    temp.add((String)imagens.get(indice));
                    DBUtil.insereExportaWeb(requisicao.getCodigoFilial().toString(), st, "requisicaoexameimagem", "I", false, temp.toArray(new String[temp.size()]));
                    temp.clear();
                }
            }
        }
    }

    private Requisicao getRequisicao(int codigoFilial, int codigoLabExterno, BigInteger cip) throws SQLException {
        Requisicao requisicao = null;
        StringBuilder sql = new StringBuilder("select b.fil_codigo, b.req_codigo, b.con_codigo, b.des_codigo");
        sql.append(", c.pac_codigo, c.pac_nome, c.pac_idade, c.pac_anomes");
        sql.append(" from loteexternorequisicao a");
        sql.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
        sql.append(" left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo");
        sql.append(" left join requisicaolabexterno d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.lae_codigo = d.lae_codigo");
        sql.append(" where a.fil_codigo = ? and a.lae_codigo = ? and d.rle_codigo = ? and b.req_excluida = false ");
        PreparedStatement prst = Conexao.getPreparedStatement(sql.toString());
        prst.setInt(1, codigoFilial);
        prst.setInt(2, codigoLabExterno);
        prst.setBigDecimal(3, new BigDecimal(cip));
        ResultSet rs = prst.executeQuery();
        if (rs.next()) {
            Paciente paciente = new Paciente(rs.getInt("pac_codigo"));
            paciente.setNome(rs.getString("pac_nome"));
            paciente.setIdade(rs.getInt("pac_idade"));
            paciente.setTipoIdade(rs.getString("pac_anomes"));
            requisicao = new Requisicao(rs.getInt("fil_codigo"), rs.getInt("req_codigo"), paciente);
            requisicao.setCip(cip);
            requisicao.setCodigoConvenio(rs.getInt("con_codigo"));
            requisicao.setCodigoDestino(rs.getString("des_codigo"));
            sql.delete(0, sql.length());
            sql.append("select a.exa_codigo, a.mco_codigo, a.exr_situacao, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, d.met_codigo");
            sql.append(", a.exr_datamaterial, b.exa_salvaparcial, d.ele_xmllabexterno");
            sql.append(" from examerequisicao a");
            sql.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo");
            sql.append(" left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo");
            sql.append(" left join examematcoletalabexterno d on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and c.mco_codigo = d.mco_codigo and d.lae_codigo = ").append(codigoLabExterno);
            sql.append(" where a.fil_codigo = ? and a.req_codigo = ? and d.lae_codigo = ? and a.exr_excluido = false and d.ele_xmllabexterno <> '' and d.ele_xmllabexterno is not null ");
            PreparedStatement prst2 = Conexao.getPreparedStatement(sql.toString());
            prst2.setInt(1, requisicao.getCodigoFilial());
            prst2.setInt(2, requisicao.getCodigo());
            prst2.setInt(3, codigoLabExterno);
            ResultSet rs2 = prst2.executeQuery();
            while (rs2.next()) {
                Exame exame = new Exame(rs2.getString("exa_codigo"));
                String xmlExame = rs2.getString("ele_xmllabexterno");
                if (xmlExame != null && xmlExame.trim().length() > 0) {
                    ExameSFranco exameSFranco = new ExameSFranco(rs2.getString("ele_xmllabexterno"));
                    exame.setCodigoNoSFranco(exameSFranco.getCodigo());
                    exame.setDataLayout(exameSFranco.getDataLayout());
                }
                exame.setCodigoMaterial(rs2.getInt("mco_codigo"));
                exame.setCodigoMetodo(rs2.getInt("met_codigo"));
                exame.setSituacao(rs2.getString("exr_situacao"));
                exame.setSalvaParcial(rs2.getBoolean("exa_salvaparcial"));
                exame.setFormato(rs2.getString("exr_resultado"));
                exame.setDataMaterial(rs2.getDate("exr_datamaterial"));
                String codigoLayout = ExameUtil.getCodigoLayout(requisicao.getCodigoFilial().toString(), requisicao.getCodigoConvenio().toString(), requisicao.getCodigoDestino());
                exame.setCodigoLayout(Integer.valueOf(codigoLayout));
                requisicao.getExames().add(exame);
            }
            prst2.close();
        }
        prst.close();
        return requisicao;
    }

    private void preencheFormatacao(Requisicao requisicao, Exame exame) {
        Statement st = Conexao.getStatement();
        if (st != null && exame.getCodigoLayout() != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  c.met_codigo, \n");
                bui.append("  b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao \n");
                bui.append("from examematcoleta a \n");
                bui.append("left join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo \n");
                bui.append("left join examematcoletalabexterno c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.lae_codigo = ").append(this.codigoLabExterno);
                bui.append("where \n");
                bui.append("  a.fil_codigo = ").append(requisicao.getCodigoFilial()).append(" and \n");
                bui.append("  a.exa_codigo = '").append(exame.getCodigo()).append("' and \n");
                bui.append("  a.mco_codigo = ").append(exame.getCodigoMaterial()).append(" and \n");
                bui.append("  c.lae_codigo = ").append(this.codigoLabExterno);
                ULTIMO_SQL = bui.toString();
                ResultSet rs = Conexao.executeQuery(st, ULTIMO_SQL);
                int linha = 0;
                while (rs.next()) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("ela_padrao");
                    boolean interValido = exame.getCodigoLayout().intValue() == rs.getInt("lay_codigo") && this.pertenceAoIntervalo(rs, requisicao.getPaciente());
                    boolean bl = idadeZero = exame.getCodigoLayout().intValue() == rs.getInt("lay_codigo") && rs.getInt("ela_idadeini") == 0 && rs.getInt("ela_idadefim") == 0;
                    if ((!padrao || linha != 0) && !idadeZero && !interValido) continue;
                    linha = rs.getRow();
                    if (!interValido) continue;
                    break;
                }
                if (linha > 0) {
                    rs.first();
                    while (rs.getRow() < linha && rs.next()) {
                    }
                    bui.setLength(0);
                    bui.append("select \n");
                    bui.append("  a.elm_formato, a.elm_exportartexto, b.met_codigo \n");
                    bui.append("from examelayoutmetodo a \n");
                    bui.append("left join metodologia b \n");
                    bui.append("  on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo \n");
                    bui.append("where \n");
                    bui.append("  a.fil_codigo = ").append(requisicao.getCodigoFilial()).append(" and \n");
                    bui.append("  a.exa_codigo = '").append(exame.getCodigo()).append("' and \n");
                    bui.append("  a.mco_codigo = ").append(exame.getCodigoMaterial()).append(" and \n");
                    bui.append("  a.lay_codigo = ").append(rs.getString("lay_codigo")).append(" and \n");
                    bui.append("  a.ela_idadeini = ").append(rs.getString("ela_idadeini")).append(" and \n");
                    bui.append("  a.ela_idadefim = ").append(rs.getString("ela_idadefim")).append(" and \n");
                    bui.append("  a.ela_idadeinitipo = '").append(rs.getString("ela_idadeinitipo")).append("' and \n");
                    bui.append("  a.ela_idadefimtipo = '").append(rs.getString("ela_idadefimtipo")).append("' and \n");
                    bui.append("  b.met_codigo = ").append(rs.getString("met_codigo"));
                    ULTIMO_SQL = bui.toString();
                    rs = Conexao.executeQuery(st, ULTIMO_SQL);
                    if (rs.next()) {
                        exame.setFormatoTexto(rs.getString("elm_exportartexto"));
                        exame.setFormato(rs.getString("elm_formato"));
                        exame.setCodigoMetodo(rs.getInt("met_codigo"));
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoSFranco: 1241");
            }
        }
    }

    private boolean pertenceAoIntervalo(ResultSet res, Paciente paciente) throws SQLException {
        int idadePac = paciente.getIdade() * this.diasTipo(paciente.getTipoIdade());
        int ini = res.getInt("ela_idadeini") * this.diasTipo(res.getString("ela_idadeinitipo"));
        int fim = res.getInt("ela_idadefim") * this.diasTipo(res.getString("ela_idadefimtipo"));
        return ini <= idadePac && idadePac <= fim;
    }

    private void atualizarPaginaOrdemExameWeb(Statement st, Requisicao requisicao) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), Variaveis.codigoBaseWeb);
    }

    private void editarRequisicaoExportaFiliais(Requisicao requisicao, Exame exame) {
        try {
            ExportaFiliais.gravaRequisicao(requisicao.getCodigoFilial(), requisicao.getCodigo().intValue(), exame.getCodigo(), exame.getCodigoMaterial(), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSFranco (1506)");
        }
    }

    private void atualizarTabelaExamesControle(Statement st, Requisicao requisicao, Exame exame, String resAnterior) throws SQLException {
        Registro reg = new Registro();
        reg.setValor("fil_codigo", requisicao.getCodigoFilial().toString());
        reg.setValor("pac_codigo", requisicao.getPaciente().getCodigo().toString());
        reg.setValor("exa_codigo", exame.getCodigo());
        reg.setValor("mco_codigo", exame.getCodigoMaterial());
        reg.setValor("req_codigo", requisicao.getCodigo().toString());
        reg.setValor("exc_resultado", resAnterior);
        reg.setValor("exr_datamaterial", exame.getDataMaterial());
        super.atualizarTabelaExamesControle(st, reg, resAnterior);
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Requisicao requisicao, Exame exame) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString(), 8);
    }

    private boolean isFilialExportaWeb(int codigoFilial) throws SQLException {
        try {
            Statement st = Conexao.getStatement();
            FilialService filService = new FilialService();
            FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, String.valueOf(codigoFilial));
            if (this.carregouVO(filialVO)) {
                return this.isExportarBaseWeb(filialVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoFranco: 261");
        }
        return false;
    }

    private boolean carregouVO(FilialVO filialVO) {
        return filialVO != null;
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    private void adicionarAoModeloRelatorio(Requisicao requisicao, Exame exame, Situacao situacao) {
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, String.valueOf(requisicao.getCodigoFilial()), String.valueOf(requisicao.getCodigo()), exame.getCodigo(), exame.getCodigoMaterial(), situacao.descricao);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        SEM_COD_EXM_LAB("XML sem campo CodExmLab"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_MATERIAL("Sem material"),
        NENHUM_CAMPO_RELACIONADO("Nenhum campo relacionado");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

