/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.sf.CampoSFranco;
import jalis.laboratorio.util.parsers.sf.MaterialSFranco;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ExameSFranco {
    public static final String TAG_SFRANCO = "sfranco";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_DESCRICAO = "descricao";
    public static final String TAG_DATA_LAYOUT = "data-layout";
    public static final String TAG_CAMPOS = "campos";
    private String codigo;
    private String descricao;
    private Date dataLayout;
    private List<CampoSFranco> campos = new ArrayList<CampoSFranco>();
    private MaterialSFranco materialPadrao = MaterialSFranco.Miscelania;

    public ExameSFranco(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public ExameSFranco(String xml) {
        this.setXML(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXmlSalvo(int filial, int codigoLabExterno, String codigo) {
        String xml = "";
        String sql = "select sgf_xml from examessergiofranco franco where fil_codigo = ? and lae_codigo = ? and sgf_codigo = ?";
        PreparedStatement prst = Conexao.getPreparedStatement(sql);
        try {
            prst.setInt(1, filial);
            prst.setInt(2, codigoLabExterno);
            prst.setString(3, codigo);
            ResultSet rs = prst.executeQuery();
            if (rs.next()) {
                xml = rs.getString("sgf_xml");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameSFranco: 53");
        }
        finally {
            try {
                prst.close();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameSFranco: 64");
            }
        }
        return xml;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getMaterialCodigo() {
        if (!Funcoes.textoVazio(this.codigo)) {
            String codigoMaterial = this.codigo.substring(this.codigo.length() - 2);
            return MaterialSFranco.existeCodigo(codigoMaterial) ? codigoMaterial : this.materialPadrao.getCodigo();
        }
        return null;
    }

    public String getMaterialDescricao() {
        if (!Funcoes.textoVazio(this.getMaterialCodigo())) {
            return MaterialSFranco.getDescricaoByCodigo(this.getMaterialCodigo());
        }
        return null;
    }

    public Date getDataLayout() {
        return this.dataLayout;
    }

    public void setDataLayout(Date dataLayout) {
        this.dataLayout = dataLayout;
    }

    public List<CampoSFranco> getCampos() {
        return this.campos;
    }

    public void setCampos(List<CampoSFranco> campos) {
        this.campos = campos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ExameSFranco> getExames(int filial, int codigoLabExterno) {
        LinkedHashSet<ExameSFranco> exames = new LinkedHashSet<ExameSFranco>();
        String sql = "select sgf_xml from examessergiofranco where fil_codigo = ? and lae_codigo = ? order by sgf_codigo";
        PreparedStatement prst = Conexao.getPreparedStatement(sql);
        try {
            prst.setInt(1, filial);
            prst.setInt(2, codigoLabExterno);
            ResultSet rs = prst.executeQuery();
            while (rs.next()) {
                exames.add(new ExameSFranco(rs.getString("sgf_xml")));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameSFranco: 53");
        }
        finally {
            try {
                prst.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return exames;
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_SFRANCO);
            xml.abrir(TAG_EXAME);
            xml.escrever(TAG_CODIGO, this.getCodigo());
            xml.escrever(TAG_DESCRICAO, this.getDescricao());
            xml.escrever(TAG_DATA_LAYOUT, Funcoes.formataData(this.getDataLayout()));
            xml.abrir(TAG_CAMPOS);
            for (CampoSFranco campo : this.campos) {
                campo.escreveXml(xml);
            }
            xml.fechar(TAG_CAMPOS);
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_SFRANCO);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameSFranco: 180");
        }
        return xml.getXML();
    }

    private void setXML(String xml) {
        String exame = StringUtil.getValor(xml, TAG_EXAME);
        this.codigo = StringUtil.getValor(exame, TAG_CODIGO);
        this.descricao = StringUtil.getValor(exame, TAG_DESCRICAO);
        if (StringUtil.getValor(exame, TAG_DATA_LAYOUT) != null && !StringUtil.getValor(exame, TAG_DATA_LAYOUT).trim().isEmpty()) {
            this.dataLayout = Funcoes.stringToDate(StringUtil.getValor(exame, TAG_DATA_LAYOUT));
        }
        for (String xmlCampo : StringUtil.getValores(StringUtil.getValor(xml, TAG_CAMPOS), "campo", true)) {
            this.campos.add(new CampoSFranco(xmlCampo));
        }
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorSf = StringUtil.getValor(xml, TAG_SFRANCO);
        return valorSf != null && valorSf.trim().length() > 0 && (valorExame = StringUtil.getValor(valorSf, TAG_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExameSFranco) {
            ExameSFranco outroExame = (ExameSFranco)obj;
            return outroExame.getCodigo().equalsIgnoreCase(this.codigo);
        }
        return false;
    }

    public int hashCode() {
        return this.codigo.hashCode();
    }
}

