/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.sf.ExameSFranco;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorSFranco
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String MATERIAL = "material";
    private static final String OBJ_EXAME_SFRANCO = "objExameAlvaro";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 100, 0, 70);
    private JTextField textLocalizar = new JTextField();
    private String xmlSelecionado = "";

    public ConfiguradorSFranco(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio S\u00e9rgio Franco", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorSFranco(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio S\u00e9rgio Franco", codigoLabExterno);
        this.iniciar();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameSFranco.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameSFranco exa = new ExameSFranco(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.equals(reg.getValor(OBJ_EXAME_SFRANCO))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            ExameSFranco exa = new ExameSFranco(xml);
            return exa.getDescricao();
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            ExameSFranco exa = new ExameSFranco(xml);
            return exa.getMaterialCodigo() + "|" + exa.getCodigo() + "|1";
        }
        return "";
    }

    public static ConfiguradorSFranco novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorSFranco((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorSFranco((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorSFranco.this.modExa.filtrar(ConfiguradorSFranco.DESC_EXA, ConfiguradorSFranco.this.textLocalizar.getText());
                if (ConfiguradorSFranco.this.modExa.getRowCount() > 0) {
                    ConfiguradorSFranco.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSFranco.this.tableExa.hasFocus() && (row = ConfiguradorSFranco.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorSFranco.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorSFranco.this.tableExa.scrollRectToVisible(ConfiguradorSFranco.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSFranco.this.tableExa.hasFocus() && (row = ConfiguradorSFranco.this.tableExa.getSelectedRow()) < ConfiguradorSFranco.this.tableExa.getRowCount() - 1) {
                    ConfiguradorSFranco.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorSFranco.this.tableExa.scrollRectToVisible(ConfiguradorSFranco.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (ExameSFranco exame : ExameSFranco.getExames(Integer.valueOf(Variaveis.filialPadrao), Integer.valueOf(this.getCodigoLabExterno()))) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigo());
            reg.setValor(DESC_EXA, exame.getDescricao());
            reg.setValor(MATERIAL, exame.getMaterialDescricao());
            reg.setValor(OBJ_EXAME_SFRANCO, exame);
            this.modExa.addRegistro(reg);
        }
    }

    @Override
    public boolean acaoOk() {
        ExameSFranco exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        ExameSFranco exa = this.getExameSelecionado();
        if (exa != null) {
            this.xmlSelecionado = exa.getXML();
            return true;
        }
        return false;
    }

    private ExameSFranco getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameSFranco)reg.getValor(OBJ_EXAME_SFRANCO);
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
    }
}

