/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorException;
import jalis.laboratorio.util.parsers.sf.ConfiguracaoProtocoloSFranco;
import jalis.laboratorio.util.parsers.sf.GridBagConstCustom;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class ConfiguradorProtocoloSFranco
extends AbstractConfiguradorProtocolo {
    private TTextField textFaixaInicio = new TTextField(10, 1);
    private TTextField textFaixaFinal = new TTextField(10, 1);
    private JLabel labelCipAtual = new JLabel();
    private JCheckBox checkUsaEtiquetaOffline = new JCheckBox("Usa etiqueta offline");
    private JCheckBox checkIgnorarVersao = new JCheckBox("Ignorar vers\u00e3o do layout");
    private ConfiguracaoProtocoloSFranco config = new ConfiguracaoProtocoloSFranco("");

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloSFranco((Frame)pai, "Laborat\u00f3rio S\u00e9rgio Franco", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloSFranco((Dialog)pai, "Laborat\u00f3rio S\u00e9rgio Franco", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloSFranco(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloSFranco(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        return this.config.getXML();
    }

    @Override
    public int getNumeroLote() {
        return this.config.getLoteAtual() > 0 ? this.config.getLoteAtual() : 0;
    }

    @Override
    public void setNumeroLote(int numeroLote) throws ConfiguradorException {
        if (numeroLote <= this.config.getLoteAtual()) {
            throw new ConfiguradorException("O n\u00famero de lote especificado n\u00e3o pode ser menor ou igual ao n\u00famero do lote atual");
        }
        this.config.setLoteAtual(numeroLote);
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        this.config.setXML(xml);
        this.textCodigo.setText(String.valueOf(this.config.getCodigoNoSFranco()));
        this.textLote.setText(String.valueOf(this.config.getLoteAtual()));
        this.textFaixaInicio.setText(String.valueOf(this.config.getFaixaCipInicio()));
        this.textFaixaFinal.setText(String.valueOf(this.config.getFaixaCipFinal()));
        this.labelCipAtual.setText(String.valueOf(this.config.getCipAtual()));
        this.checkUsaEtiquetaOffline.setSelected(this.config.isUsaEtiqueta());
        this.checkIgnorarVersao.setSelected(this.config.isIgnorarVersaoLayout());
    }

    @Override
    public boolean acaoOk() {
        BigInteger cipInicio = new BigInteger(this.textFaixaInicio.getText());
        BigInteger cipFinal = new BigInteger(this.textFaixaFinal.getText());
        if (!super.acaoOk()) {
            return false;
        }
        if (Funcoes.textoVazio(this.textFaixaInicio) || Funcoes.textoVazio(this.textFaixaFinal)) {
            Funcoes.mensagem(this, "Todos os valores devem ser preenchidos", 1);
            return false;
        }
        if (cipInicio.compareTo(cipFinal) > 0 || this.config.getCipAtual().compareTo(cipFinal) > 0) {
            Funcoes.mensagem(this, "Faixa CIP inv\u00e1lida", 1);
            return false;
        }
        this.config.setCodigoNoSFranco(Integer.valueOf(this.textCodigo.getText()));
        this.config.setLoteAtual(Integer.valueOf(this.textLote.getText()));
        this.config.setFaixaCipInicio(cipInicio);
        this.config.setFaixaCipFinal(cipFinal);
        this.config.setUsaEtiqueta(true);
        this.config.setIgnorarVersaoLayout(this.checkIgnorarVersao.isSelected());
        return true;
    }

    private void iniciar() {
        this.textCodigo = new TTextField(4, 1);
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        this.labelCipAtual.setPreferredSize(new Dimension(0, 20));
        GridBagConstCustom cons = new GridBagConstCustom(0, 0, 1, 1, 0.0, 0.0);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("C\u00f3digo no S. Franco:", new Dimension(140, 20)), cons);
        cons = new GridBagConstCustom(1, 0, 0, 1, 0.6, 0.0);
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons = new GridBagConstCustom(0, 1, 1, 1, 0.0, 0.0);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Lote Atual:", new Dimension(140, 20)), cons);
        cons = new GridBagConstCustom(1, 1, 0, 1, 0.6, 0.0);
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons = new GridBagConstCustom(0, 2, 1, 1, 0.0, 0.0);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Faixa CIP:", new Dimension(140, 20)), cons);
        cons = new GridBagConstCustom(1, 2, 1, 1, 0.1, 0.0);
        this.getPanelCentral().add((Component)this.textFaixaInicio, cons);
        cons = new GridBagConstCustom(2, 2, 1, 1, 0.0, 0.0);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("a", new Dimension(10, 20)), cons);
        cons = new GridBagConstCustom(3, 2, 1, 1, 0.1, 0.0);
        this.getPanelCentral().add((Component)this.textFaixaFinal, cons);
        cons = new GridBagConstCustom(0, 3, 1, 1, 0.0, 0.0);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("CIP atual:", new Dimension(140, 20)), cons);
        cons = new GridBagConstCustom(1, 3, 0, 1, 0.6, 0.0);
        this.getPanelCentral().add((Component)this.labelCipAtual, cons);
        cons = new GridBagConstCustom(1, 4, 0, 1, 0.6, 0.0);
        this.getPanelCentral().add((Component)this.checkIgnorarVersao, cons);
        this.labelCipAtual.setBorder(new TitledBorder(""));
        this.labelCipAtual.setHorizontalAlignment(4);
        this.pack();
        this.setSize(new Dimension(400, 220));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCodigo);
    }
}

